/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.resourceuse;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.mservice.resourceuse.AbstractResourceUseAction;
import kd.macc.cad.mservice.resourceuse.ResourceUseArgs;

public class ResourceUseSourceBillAction
extends AbstractResourceUseAction {
    private static final Log logger = LogFactory.getLog(ResourceUseSourceBillAction.class);

    @Override
    protected void doExecute() {
        Map<String, List<DynamicObject>> sourceBillMap = this.getResourceUseContext().getSourceBillMap();
        Map<Long, DynamicObject> costObjectMap = this.getResourceUseContext().getCostObjectMap();
        ResourceUseArgs resourceUseArgs = this.getResourceUseContext().getResourceUseArgs();
        Long acctOrgId = resourceUseArgs.getAcctOrgId();
        List<Long> manuOrgs = resourceUseArgs.getManuOrgs();
        String appNum = resourceUseArgs.getAppNum();
        List<Long> mftOrderEntryIds = resourceUseArgs.getMftOrderEntryIds();
        Set<Long> sourceIds = this.getResourceUseContext().getSourceIds();
        Set<Long> costCenterIdSet = this.getResourceUseContext().getCostCenterIdSet();
        DynamicObjectCollection oldBillList = this.getResourceBills(mftOrderEntryIds, sourceIds, acctOrgId, manuOrgs, costCenterIdSet, appNum);
        this.getResourceUseContext().setOldBillList(oldBillList);
        logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6-\u5df2\u7ecf\u5b58\u5728\u7684\u5bf9\u8c61\u5217\u8868\u6570\u76ee" + oldBillList.size());
        this.getResourceUseContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u751f\u6210\u8d44\u6e90\u8017\u7528\u5f52\u96c6\u5355", (String)"ResourceUseSourceBillAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        List<DynamicObject> importBillList = this.getResourceUseBill(sourceBillMap, costObjectMap, appNum);
        this.getResourceUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u751f\u6210\u8d44\u6e90\u8017\u7528\u5f52\u96c6\u5355\u201c%s\u201d\u6761\u3002", (String)"ResourceUseSourceBillAction_5", (String)"macc-cad-mservice", (Object[])new Object[0]), importBillList == null ? 0 : importBillList.size()));
        if (importBillList == null || importBillList.isEmpty()) {
            logger.info("\u3010\u5de5\u5e8f\u6c47\u62a5\u5355\u3011\u3001\u3010\u6c47\u62a5\u8d44\u6e90\u8c03\u6574\u5355\u3011\u3001\u3010\u5de5\u5355\u6c47\u62a5\u5355\u3011\u548c\u3010\u59d4\u5916\u5de5\u5e8f\u6c47\u62a5\u5355\u3011\u672a\u751f\u6210\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6\u5355\u3002");
            return;
        }
        logger.info("\u8d44\u6e90\u8017\u7528\u91cf\u5f52\u96c6-\u5373\u5c06\u5bfc\u5165\u7684\u5bf9\u8c61\u6761\u6570\uff1a{}", (Object)importBillList.size());
        this.getResourceUseContext().getImportBillList().addAll(importBillList);
    }

    private List<DynamicObject> getResourceUseBill(Map<String, List<DynamicObject>> sourceBillMap, Map<Long, DynamicObject> costObjectMap, String appNum) {
        ArrayList<DynamicObject> sourceBillList = new ArrayList<DynamicObject>();
        String userId = RequestContext.get().getUserId();
        Date currDate = TimeServiceHelper.now();
        ArrayList sourceBills = Lists.newArrayListWithCapacity((int)32);
        for (Map.Entry<String, List<DynamicObject>> stringListEntry : sourceBillMap.entrySet()) {
            sourceBills.addAll((Collection)stringListEntry.getValue());
        }
        Map idCostCenterMap = CostCenterHelper.getCostCenterBySource((Long)this.getResourceUseContext().getResourceUseArgs().getAcctOrgId(), (List)sourceBills, (String)appNum);
        HashMap<String, DynamicObject> oldBillMap = new HashMap<String, DynamicObject>(16);
        DynamicObject[] oldBills = this.getResourceUseContext().getOldBills();
        for (DynamicObject resourceBill : oldBills) {
            if (CadEmptyUtils.isEmpty((Long)resourceBill.getLong("srcbillid"))) continue;
            oldBillMap.put(resourceBill.getString("billno") + "@" + resourceBill.getString("srcbillid"), resourceBill);
        }
        for (Map.Entry entry : sourceBillMap.entrySet()) {
            List reportBills = (List)entry.getValue();
            DynamicObject reportBillSE = (DynamicObject)reportBills.get(0);
            DynamicObject costObject = costObjectMap.get(reportBillSE.getLong("probillentryid"));
            if (costObject == null) {
                logger.info("\u5206\u5f55:{}\u672a\u627e\u5230\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (Object)reportBillSE.getLong("probillentryid"));
                continue;
            }
            Long costCenterId = (Long)idCostCenterMap.get(reportBillSE.getLong("id"));
            if (CadEmptyUtils.isEmpty((Long)costCenterId)) {
                logger.info("\u901a\u8fc7\u6e90\u5355\u627e\u6210\u672c\u4e2d\u5fc3\u5931\u8d25!\u8bf7\u68c0\u67e5");
                continue;
            }
            for (DynamicObject reportBill : reportBills) {
                DynamicObject resourceUse = BusinessDataServiceHelper.newDynamicObject((String)"sca_resourceuse");
                String billNo = reportBill.getString("billno") + "-" + reportBill.getString("seq") + "-" + reportBill.getString("subseq");
                resourceUse.set("srcbillid", reportBill.get("id"));
                resourceUse.set("billno", (Object)billNo);
                resourceUse.set("manuorg", (Object)reportBill.getLong("manuorg"));
                resourceUse.set("bizdate", reportBill.get("bizdate"));
                resourceUse.set("bookdate", reportBill.get("bookdate"));
                resourceUse.set("org", (Object)costObject.getLong("org"));
                resourceUse.set("costcenter", (Object)costCenterId);
                resourceUse.set("resource", reportBill.get("entryresource"));
                resourceUse.set("source", (Object)SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue());
                resourceUse.set("pricedate", (Object)DateUtils.getPriceDate((Date)reportBill.getDate("auditdate"), (Date)reportBill.getDate("bookdate")));
                String remark = reportBill.getString("remark");
                if (remark == null || "".equals(remark)) {
                    remark = " ";
                }
                resourceUse.set("remark", (Object)remark);
                resourceUse.set("appnum", (Object)appNum);
                resourceUse.set("billstatus", (Object)"C");
                resourceUse.set("creator", (Object)userId);
                resourceUse.set("createtime", (Object)currDate);
                resourceUse.set("modifier", (Object)userId);
                resourceUse.set("modifytime", (Object)currDate);
                resourceUse.set("srcbilltype", (Object)reportBill.getString("billtype"));
                DynamicObjectCollection entryEntity = resourceUse.getDynamicObjectCollection("entryentity");
                DynamicObject addNew = new DynamicObject();
                String key = billNo + "@" + reportBill.get("id");
                if (oldBillMap.containsKey(key)) {
                    entryEntity = ((DynamicObject)oldBillMap.get(key)).getDynamicObjectCollection("entryentity");
                    addNew = (DynamicObject)entryEntity.get(0);
                    addNew.set("workhour", reportBill.get("subentryunit"));
                    addNew.set("facthour", (Object)reportBill.getBigDecimal("subentrysumqty"));
                    addNew.set("factuse", reportBill.get("entrycompletqty"));
                    addNew.set("factbatch", (Object)"");
                    addNew.set("costobject", costObject.get("id"));
                    addNew.set("opra", reportBill.get("opra"));
                    addNew.set("material", costObject.get("material"));
                    addNew.set("auxpty", costObject.get("auxpty"));
                    addNew.set("version", costObject.get("bomversion"));
                    resourceUse.getDynamicObjectCollection("entryentity").add((Object)addNew);
                } else {
                    addNew = entryEntity.addNew();
                    addNew.set("workhour", reportBill.get("subentryunit"));
                    addNew.set("facthour", (Object)reportBill.getBigDecimal("subentrysumqty"));
                    addNew.set("factuse", reportBill.get("entrycompletqty"));
                    addNew.set("factbatch", (Object)"");
                    addNew.set("costobject", costObject.get("id"));
                    addNew.set("opra", reportBill.get("opra"));
                    addNew.set("material", costObject.get("material"));
                    addNew.set("auxpty", costObject.get("auxpty"));
                    addNew.set("version", costObject.get("bomversion"));
                }
                resourceUse.set("auditor", (Object)userId);
                resourceUse.set("auditdate", (Object)currDate);
                sourceBillList.add(resourceUse);
            }
        }
        return sourceBillList;
    }

    private DynamicObjectCollection getResourceBills(List<Long> mftorderentryids, Set<Long> sourceIds, Long acctOrgId, List<Long> manuOrgs, Set<Long> costCenterIds, String appNum) {
        String fields = "id,srcbillid,bizdate,bookdate,billno,manuorg,resource,org,costcenter,createtime,creator,pricedate,entryentity.id AS entryid,entryentity.costobject AS costobject,entryentity.workhour AS workhour,entryentity.facthour AS facthour,entryentity.factuse AS factuse";
        QFilter commonQF = SysParamHelper.getImportTimeScope((Long)acctOrgId, (String)"bookdate", (String)appNum);
        if (acctOrgId != null) {
            commonQF.and("org", "=", (Object)acctOrgId);
        }
        if (costCenterIds != null && !costCenterIds.isEmpty()) {
            commonQF.and("costcenter", "in", costCenterIds);
        } else {
            commonQF.and("costcenter", "=", (Object)-1L);
        }
        if (!CadEmptyUtils.isEmpty(manuOrgs)) {
            commonQF.and("manuorg", "in", manuOrgs);
        }
        commonQF.and(new QFilter("source", "=", (Object)SysParamEnum.COMPTYPE_SYS_OBJECTRULE.getValue()));
        if (CadEmptyUtils.isEmpty(mftorderentryids)) {
            commonQF.and(new QFilter("srcbillid", ">", (Object)0L));
        } else {
            commonQF.and("entryentity.costobject.probill", "in", mftorderentryids);
        }
        commonQF.and("appnum", "=", (Object)appNum);
        logger.info("\u67e5\u8be2\u5df2\u6709\u7684\u5f52\u96c6\u5355\u53c2\u6570" + commonQF.toString());
        DynamicObjectCollection resUesBills = QueryServiceHelper.query((String)"sca_resourceuse", (String)fields, (QFilter[])new QFilter[]{commonQF});
        String fields2 = "id,srcbillid,bizdate,bookdate,billno,manuorg,resource,org,costcenter,createtime,creator,pricedate,entryentity,entryentity.id,entryentity.workhour,entryentity.facthour,entryentity.factuse,entryentity.factbatch,entryentity.costobject,entryentity.opra,entryentity.material,entryentity.auxpty,entryentity.version";
        DynamicObject[] oldBills = BusinessDataServiceHelper.load((String)"sca_resourceuse", (String)fields2, (QFilter[])new QFilter[]{commonQF});
        this.getResourceUseContext().setOldBills(oldBills);
        return resUesBills;
    }
}

