/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.resourceuse;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.resourceuse.AbstractResourceUseAction;
import org.apache.commons.collections4.CollectionUtils;

public class ScaResourceWriteCostChangeConfigAction
extends AbstractResourceUseAction {
    @Override
    protected void doExecute() {
        Set<Long> needDelIdSet;
        this.getResourceUseContext().getCollectReport().logReportDetail(ResManager.loadKDString((String)"\u5199\u6210\u672c\u53d8\u66f4\u8bb0\u5f55", (String)"ScaResourceWriteCostChangeConfigAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        this.refreshProgress(ResManager.loadKDString((String)"\u5199\u6210\u672c\u53d8\u66f4\u8bb0\u5f55", (String)"ScaResourceWriteCostChangeConfigAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 6, 7, false);
        int changeCount = 0;
        List<DynamicObject> resourceBills = this.getResourceUseContext().getImportBillList();
        if (CollectionUtils.isNotEmpty(resourceBills)) {
            changeCount += this.writeToCostChangeRecords(resourceBills, false);
        }
        if (!(needDelIdSet = this.getResourceUseContext().getNeedDelIdSet()).isEmpty()) {
            List partitions = Lists.partition(new ArrayList<Long>(needDelIdSet), (int)20000);
            for (List partition : partitions) {
                Object[] delResourceBills = BusinessDataServiceHelper.load((Object[])partition.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sca_resourceuse"));
                ArrayList<DynamicObject> delResourceList = new ArrayList<DynamicObject>(delResourceBills.length);
                CollectionUtils.addAll(delResourceList, (Object[])delResourceBills);
                if (CadEmptyUtils.isEmpty((Object[])delResourceBills)) continue;
                changeCount += this.writeToCostChangeRecords(delResourceList, true);
            }
        }
        this.getResourceUseContext().getCollectReport().logCheckDesc(String.format(ResManager.loadKDString((String)"\u5199\u6210\u672c\u53d8\u66f4\u8bb0\u5f55%s\u6761\u3002", (String)"ScaResourceWriteCostChangeConfigAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), changeCount));
    }

    private int writeToCostChangeRecords(List<DynamicObject> costChangedBills, Boolean isDeleted) {
        ArrayList<DynamicObject> costChangedRecs = new ArrayList<DynamicObject>(10);
        ArrayList<Long> srcbillIds = new ArrayList<Long>(10);
        ArrayList<Long> exitCostObject = new ArrayList<Long>(10);
        for (DynamicObject costChangedBill : costChangedBills) {
            DynamicObject entryEntity = (DynamicObject)costChangedBill.getDynamicObjectCollection("entryentity").get(0);
            Long costObjectId = entryEntity.get("costobject") instanceof DynamicObject ? entryEntity.getLong("costobject.id") : entryEntity.getLong("costobject");
            exitCostObject.add(costObjectId);
            srcbillIds.add(costChangedBill.getLong("srcbillid"));
        }
        List<Long> settlChangeRecords = this.getChangeRecordBySettled(srcbillIds);
        List settlCostObjects = CostObjectHelper.getSettlCostObject(exitCostObject);
        for (DynamicObject changeBill : costChangedBills) {
            DynamicObject entryEntity = (DynamicObject)changeBill.getDynamicObjectCollection("entryentity").get(0);
            Long costObjectId = entryEntity.get("costobject") instanceof DynamicObject ? entryEntity.getLong("costobject.id") : entryEntity.getLong("costobject");
            if (!settlCostObjects.contains(costObjectId) || isDeleted.booleanValue() && !settlChangeRecords.contains(changeBill.getLong("srcbillid"))) continue;
            DynamicObject costChange = this.getCostChange(changeBill);
            String key = changeBill.getString("billno") + "-" + changeBill.get("srcbillid");
            String changeText = this.getResourceUseContext().getCostChangeContentMap().get(key);
            costChange.set("changecontext", (Object)changeText);
            costChange.set("costobject", (Object)costObjectId);
            costChangedRecs.add(costChange);
        }
        SaveServiceHelper.save((DynamicObject[])costChangedRecs.toArray(new DynamicObject[0]));
        return costChangedRecs.size();
    }

    private DynamicObject getCostChange(DynamicObject newBill) {
        DynamicObject costChange = BusinessDataServiceHelper.newDynamicObject((String)"sca_costchangerecord");
        costChange.set("org", newBill.get("org"));
        costChange.set("costcenter", newBill.get("costcenter"));
        costChange.set("sourcebill", (Object)newBill.getLong("srcbillid"));
        costChange.set("businessbill", (Object)"sca_resourceuse");
        costChange.set("creator", (Object)RequestContext.get().getUserId());
        costChange.set("createtime", (Object)TimeServiceHelper.now());
        costChange.set("sourcebiztime", newBill.get("bookdate"));
        return costChange;
    }
}

