/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.startCostAccount;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.mservice.api.StartCostAccountService;

public class StartCostAccountServiceImpl
implements StartCostAccountService {
    private static Log LOG = LogFactory.getLog(StartCostAccountServiceImpl.class);
    public static final String ENTITY_SELECT_FIELDS = "billno,org,entryentity.startperiod.begindate as begindate,entryentity.startperiod.enddate as enddate, entryentity.isenabled as isenabled, entryentity.isinit as isinit";
    public static final int ORG_LIST_MAX_SIZE = 500;
    public static final int STATUS_INIT_END = 0;
    public static final int STATUS_INIT_ENABLE = 1;
    public static final String ENABLE = "1";
    public static final String RESPONSE_FIELD_STATUS = "status";
    public static final String RESPONSE_FIELD_ORG_ID = "orgId";
    public static final String RESPONSE_FIELD_EAR_DATE = "earliestBeginDate";

    public List<Map<String, Object>> queryStartCostAccountInfoList(List<Long> orgIdList, String orgViewType) {
        if (CollectionUtils.isEmpty(orgIdList) || StringUtils.isBlank((String)orgViewType)) {
            LOG.error("queryStartCostAccountInfoList param is invalid.orgIdList={}, orgViewType={}", orgIdList, (Object)orgViewType);
            return new ArrayList<Map<String, Object>>();
        }
        orgIdList = orgIdList.size() > 500 ? orgIdList.subList(0, 499) : orgIdList;
        HashMap<Long, List<Long>> orgIdToAccountOrgIdMap = new HashMap<Long, List<Long>>();
        ArrayList<Long> allAccountOrgId = new ArrayList<Long>();
        this.getAccountOrgByOrgId(orgIdList, orgViewType, orgIdToAccountOrgIdMap, allAccountOrgId);
        Map<Long, List<DynamicObject>> accountOrgIdToCollectionMap = this.queryStartStdCostAccountBatch(allAccountOrgId);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : orgIdToAccountOrgIdMap.entrySet()) {
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            objectMap.put(RESPONSE_FIELD_ORG_ID, entry.getKey());
            List accountOrgIdListTemp = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)accountOrgIdListTemp)) {
                objectMap.put(RESPONSE_FIELD_EAR_DATE, null);
                objectMap.put(RESPONSE_FIELD_STATUS, null);
                result.add(objectMap);
                continue;
            }
            if (kd.bos.orm.util.CollectionUtils.isEmpty(accountOrgIdToCollectionMap)) {
                objectMap.put(RESPONSE_FIELD_EAR_DATE, null);
                objectMap.put(RESPONSE_FIELD_STATUS, null);
                result.add(objectMap);
                continue;
            }
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            for (Long accountOrgId : accountOrgIdListTemp) {
                List<DynamicObject> dynamicObjectList = accountOrgIdToCollectionMap.get(accountOrgId);
                if (CollectionUtils.isEmpty(dynamicObjectList)) continue;
                dynamicObjectCollection.addAll(dynamicObjectList);
            }
            this.getEarLiestDateAndStatusStrategy(objectMap, dynamicObjectCollection);
            result.add(objectMap);
        }
        return result;
    }

    private void getAccountOrgByOrgId(List<Long> orgIdList, String orgViewType, Map<Long, List<Long>> orgIdToAccountOrgIdMap, List<Long> allAccountOrgId) {
        for (Long orgId : orgIdList) {
            if (CadEmptyUtils.isEmpty((Long)orgId)) {
                LOG.info("queryStartCostAccountInfoList param is invalid.orgId={}, orgViewType={}", (Object)orgId, (Object)orgViewType);
                continue;
            }
            OrgRelationParam param = new OrgRelationParam();
            param.setOrgId(orgId.longValue());
            param.setFromViewType("10");
            param.setToViewType(orgViewType);
            param.setDirectViewType("fromorg");
            param.setIncludeSelf(true);
            List accountOrgIdList = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
            orgIdToAccountOrgIdMap.put(orgId, accountOrgIdList);
            if (CollectionUtils.isEmpty((Collection)accountOrgIdList)) continue;
            allAccountOrgId.addAll(accountOrgIdList);
        }
    }

    private Map<Long, List<DynamicObject>> queryStartStdCostAccountBatch(List<Long> accountOrgIdList) {
        if (CollectionUtils.isEmpty(accountOrgIdList)) {
            LOG.info("queryStartCostAccountInfoList#queryStartStdCostAccountBatch accountOrgIdList is empty.");
            return new HashMap<Long, List<DynamicObject>>();
        }
        QFilter qFilter = new QFilter("org", "in", accountOrgIdList);
        QFilter enableFilter = new QFilter("entryentity.isenabled", "=", (Object)ENABLE);
        qFilter.and(enableFilter);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"sca_startstdcost", (String)ENTITY_SELECT_FIELDS, (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            LOG.info("queryStartCostAccountInfoList#queryStartStdCostAccountBatch dynamicObjectCollection is empty.accountOrgIdList={}", accountOrgIdList);
            return new HashMap<Long, List<DynamicObject>>();
        }
        Map<Long, List<DynamicObject>> accountOrgIdToCollectionMap = dynamicObjectCollection.stream().collect(Collectors.groupingBy(account -> account.getLong("org")));
        return accountOrgIdToCollectionMap;
    }

    private void getEarLiestDateAndStatusStrategy(Map<String, Object> objectMap, DynamicObjectCollection dynamicObjectCollection) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            objectMap.put(RESPONSE_FIELD_EAR_DATE, null);
            objectMap.put(RESPONSE_FIELD_STATUS, null);
            return;
        }
        boolean hasInitEndFlag = false;
        Date earliestBeginDate = null;
        for (DynamicObject dy : dynamicObjectCollection) {
            Date beginDate = dy.getDate("begindate");
            Date date = earliestBeginDate = earliestBeginDate == null ? beginDate : this.compareDate(earliestBeginDate, beginDate);
            if (!dy.getBoolean("isinit")) continue;
            hasInitEndFlag = true;
        }
        objectMap.put(RESPONSE_FIELD_EAR_DATE, earliestBeginDate == null ? null : DateUtils.parseShortDate((String)DateUtils.formatDate(earliestBeginDate, null)));
        objectMap.put(RESPONSE_FIELD_STATUS, hasInitEndFlag ? 0 : 1);
    }

    private Date compareDate(Date preDate, Date currDate) {
        if (preDate == null || currDate == null) {
            return preDate;
        }
        return preDate.before(currDate) ? preDate : currDate;
    }
}

