/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.workqty;

import kd.bos.dataentity.resource.ResManager;
import kd.macc.cad.common.dto.ProgressParamDto;
import kd.macc.cad.common.helper.ProgressHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.workqty.IWorkQtyAction;
import kd.macc.cad.mservice.workqty.WorkQtyContext;

public abstract class AbstractWorkQtyAction
implements IWorkQtyAction {
    private WorkQtyContext workQtyContext;

    protected abstract void doExecute();

    @Override
    public void setContext(WorkQtyContext workQtyContext) {
        this.workQtyContext = workQtyContext;
    }

    public WorkQtyContext getWorkQtyContext() {
        return this.workQtyContext;
    }

    @Override
    public void execute() {
        if (this.workQtyContext.isContinueExecute()) {
            this.doExecute();
        }
    }

    protected void refreshProgress(String opContent, int nowComplete, int total, Boolean isAddNum) {
        WorkQtyContext workQtyContext = this.getWorkQtyContext();
        String progressId = workQtyContext.getWorkQtyArgs().getProgressId();
        ProgressParamDto paramDto = ProgressHelper.getProgressParam((String)progressId);
        if (paramDto == null) {
            return;
        }
        paramDto.setOpContent(opContent);
        if (isAddNum.booleanValue()) {
            Integer complete = paramDto.getComplete();
            paramDto.setComplete(Integer.valueOf(complete + nowComplete));
        } else {
            paramDto.setComplete(Integer.valueOf(nowComplete));
        }
        if (!CadEmptyUtils.isEmpty((Integer)total)) {
            paramDto.setTotal(Integer.valueOf(total));
        }
        paramDto.setUnit(ResManager.loadKDString((String)"\u6b65", (String)"AbstractWorkQtyAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]));
        paramDto.setDurationTimes(Integer.valueOf(0));
        if (nowComplete == -1) {
            paramDto.setComplete(paramDto.getTotal());
        }
        ProgressHelper.setProgressParam((String)progressId, (ProgressParamDto)paramDto);
    }
}

