/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.workqty;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.workqty.AbstractWorkQtyAction;
import kd.macc.cad.mservice.workqty.WorkQtyArgs;

public class WorkQtyImportDataConfigAction
extends AbstractWorkQtyAction {
    private static final Log logger = LogFactory.getLog(WorkQtyImportDataConfigAction.class);
    private static final String ENTRY_QTY_FIELD = "entryqty";
    private static String selectFields = "id,org,manuorg,costcenter,workactivity,costdriver,entryentity.entryqty";

    @Override
    protected void doExecute() {
        this.refreshProgress(ResManager.loadKDString((String)"\u4f5c\u4e1a\u6570\u91cf\u8f6c\u6362\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"WorkQtyImportDataConfigAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 7, 14, false);
        WorkQtyArgs workQtyArgs = this.getWorkQtyContext().getWorkQtyArgs();
        long orgId = workQtyArgs.getAcctOrgId();
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        String appNum = workQtyArgs.getAppNum();
        List<Long> costCenterIds = workQtyArgs.getCostCenterIds();
        HashMap<String, List> saveWorkQtyBillsMap = new HashMap<String, List>(16);
        Map<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBillsMap = this.getWorkQtyContext().getConfigSrcAndTargetBillsMap();
        Map<Long, Map<String, String>> collConfigMappingMap = this.getWorkQtyContext().getCollConfigMappingMap();
        HashSet<String> targetFieldSet = new HashSet<String>(16);
        HashSet<String> otherFieldSet = new HashSet<String>(16);
        for (Map<String, String> collConfigs : collConfigMappingMap.values()) {
            Set<String> collConfigKeys = collConfigs.keySet();
            for (String configKey : collConfigKeys) {
                targetFieldSet.add(configKey);
                if (selectFields.contains(configKey)) continue;
                otherFieldSet.add(configKey);
            }
        }
        if (!CadEmptyUtils.isEmpty(otherFieldSet)) {
            StringBuffer otherFields = new StringBuffer();
            otherFieldSet.forEach(s -> otherFields.append(",").append((String)s));
            selectFields = selectFields + otherFields;
        }
        HashMap costDriverMap = new HashMap(16);
        QFilter qFilter = new QFilter("isrelatedwork", "=", (Object)Boolean.TRUE);
        qFilter.and("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
        DataSet costDriverInfo = QueryServiceHelper.queryDataSet((String)"getCostDriverInfo", (String)"cad_costdriver", (String)"id,workactivity", (QFilter[])qFilter.toArray(), null);
        costDriverInfo.forEach(s -> costDriverMap.put(s.getLong("workactivity"), s.getLong("id")));
        QFilter qf = new QFilter("org", "=", (Object)orgId);
        qf.and("appnum", "=", (Object)appNum);
        qf.and("costcenter", "in", costCenterIds);
        qf.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection existWorkQtyBills = QueryServiceHelper.query((String)"sca_workqtycollec", (String)selectFields, (QFilter[])new QFilter[]{qf});
        HashMap<String, DynamicObject> existWorkQtyMap = new HashMap<String, DynamicObject>(16);
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)existWorkQtyBills)) {
            existWorkQtyBills.forEach(s -> {
                String dimensionBillKey = String.format("%s@%s@%s@%s@%s", orgId, s.get("manuorg"), s.get("costcenter"), s.get("workactivity"), s.get("costdriver"));
                existWorkQtyMap.put(dimensionBillKey, (DynamicObject)s);
            });
        }
        HashMap<String, Boolean> mergerBillSource = new HashMap<String, Boolean>(16);
        for (Map.Entry<DynamicObject, Map<DynamicObject, DynamicObject>> configSrcAndTargetBill : configSrcAndTargetBillsMap.entrySet()) {
            DynamicObject config = configSrcAndTargetBill.getKey();
            long configId = config.getLong("id");
            workQtyArgs.getCollectConfigIds().add(configId);
            boolean isMergeSource = config.getBoolean("ismergesource");
            Map<DynamicObject, DynamicObject> srcAndTargetBillsMap = configSrcAndTargetBill.getValue();
            for (Map.Entry<DynamicObject, DynamicObject> srcAndTargetBills : srcAndTargetBillsMap.entrySet()) {
                long costDriverId;
                long workActivityId;
                DynamicObject workQtyBill = srcAndTargetBills.getValue();
                long manuOrgId = workQtyBill.get("manuorg") == null ? 0L : workQtyBill.getLong("manuorg.id");
                long costCenterId = workQtyBill.get("costcenter") == null ? 0L : workQtyBill.getLong("costcenter.id");
                long l = workActivityId = workQtyBill.get("workactivity") == null ? 0L : workQtyBill.getLong("workactivity.id");
                if (workQtyBill.get("costdriver") == null) {
                    costDriverId = (Long)costDriverMap.get(workActivityId);
                    workQtyBill.set("costdriver_id", (Object)costDriverId);
                } else {
                    costDriverId = workQtyBill.getLong("costdriver.id");
                }
                workQtyBill.set("org", (Object)org);
                String mergeBillKey = String.format("%s@%s@%s@%s@%s@%s", orgId, manuOrgId, costCenterId, workActivityId, costDriverId, configId);
                saveWorkQtyBillsMap.computeIfAbsent(mergeBillKey, s -> new ArrayList()).add(workQtyBill);
                mergerBillSource.put(mergeBillKey, isMergeSource);
            }
        }
        ArrayList<DynamicObject> saveWorkQtyBillList = new ArrayList<DynamicObject>();
        for (Map.Entry saveWorkQtyBillEntry : saveWorkQtyBillsMap.entrySet()) {
            String mergeKey = (String)saveWorkQtyBillEntry.getKey();
            List saveWorkQtyBills = (List)saveWorkQtyBillEntry.getValue();
            logger.info("\u5f00\u59cb\u5904\u7406\u5408\u5355,\u5408\u5355\u7ef4\u5ea6:{}, \u5355\u636e\u6570\u91cf:{}", (Object)mergeKey, (Object)saveWorkQtyBills.size());
            this.createBills(mergeKey, mergerBillSource, targetFieldSet, existWorkQtyMap, saveWorkQtyBills, saveWorkQtyBillList);
        }
        this.getWorkQtyContext().getWorkQtyCollectBills().addAll(saveWorkQtyBillList);
        this.refreshProgress(ResManager.loadKDString((String)"\u4f5c\u4e1a\u6570\u91cf\u8f6c\u6362\u5b8c\u6210\u3002", (String)"WorkQtyImportDataConfigAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), 9, 14, false);
    }

    private void createBills(String mergeKey, Map<String, Boolean> mergerBillSource, Set<String> targetFieldSet, Map<String, DynamicObject> existDiyCostDriverMap, List<DynamicObject> saveWorkQtyBills, List<DynamicObject> saveWorkQtyBillList) {
        DynamicObject workQtyBill = saveWorkQtyBills.get(0);
        BigDecimal qty = BigDecimal.ZERO;
        DynamicObjectCollection saveEntryEntity = workQtyBill.getDynamicObjectCollection("entryentity");
        boolean isFirstRow = true;
        boolean isMergeBillSource = mergerBillSource.get(mergeKey);
        HashMap<String, DynamicObject> mergeEntryEntity = new HashMap<String, DynamicObject>(16);
        String mergeEntryKey = "";
        for (DynamicObject saveWorkQtyBill : saveWorkQtyBills) {
            DynamicObject entry;
            DynamicObjectCollection entryEntity = saveWorkQtyBill.getDynamicObjectCollection("entryentity");
            DynamicObject targetEntry = null;
            if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
                targetEntry = (DynamicObject)entryEntity.get(0);
            }
            if (isMergeBillSource) {
                Long dimensionKey = 0L;
                if (targetEntry != null) {
                    dimensionKey = targetEntry.getLong("benefcostcenter.id");
                }
                mergeEntryKey = mergeKey + "@" + dimensionKey;
                if (isFirstRow) {
                    entry = (DynamicObject)saveEntryEntity.get(0);
                    this.setEntryFieldValue(entry, targetEntry, targetFieldSet);
                    qty = qty.add(entry.getBigDecimal(ENTRY_QTY_FIELD));
                } else if (mergeEntryEntity.get(mergeEntryKey) != null) {
                    entry = (DynamicObject)mergeEntryEntity.get(mergeEntryKey);
                    BigDecimal entryQty = entry.getBigDecimal(ENTRY_QTY_FIELD);
                    if (targetEntry != null) {
                        entryQty = entryQty.add(targetEntry.getBigDecimal(ENTRY_QTY_FIELD));
                        qty = qty.add(targetEntry.getBigDecimal(ENTRY_QTY_FIELD));
                    }
                    entry.set(ENTRY_QTY_FIELD, (Object)entryQty);
                } else {
                    entry = saveEntryEntity.addNew();
                    this.setEntryFieldValue(entry, targetEntry, targetFieldSet);
                    qty = qty.add(entry.getBigDecimal(ENTRY_QTY_FIELD));
                }
                mergeEntryEntity.put(mergeEntryKey, entry);
            } else {
                entry = isFirstRow ? (DynamicObject)saveEntryEntity.get(0) : saveEntryEntity.addNew();
                this.setEntryFieldValue(entry, targetEntry, targetFieldSet);
                qty = qty.add(entry.getBigDecimal(ENTRY_QTY_FIELD));
            }
            isFirstRow = false;
        }
        workQtyBill.set("qty", (Object)qty);
        saveWorkQtyBillList.add(workQtyBill);
    }

    private void setEntryFieldValue(DynamicObject entry, DynamicObject targetEntry, Set<String> targetFieldSet) {
        if (targetEntry != null && !CadEmptyUtils.isEmpty((DynamicObject)targetEntry)) {
            for (String costField : targetFieldSet) {
                if (CadEmptyUtils.isEmpty((String)costField) || !costField.contains(".")) continue;
                String entryField = costField.split("\\.")[1];
                entry.set(entryField, targetEntry.get(entryField));
            }
        }
    }
}

