/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.mservice.workqty;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.macc.cad.common.helper.OperationResultHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.mservice.workqty.AbstractWorkQtyAction;
import kd.macc.cad.mservice.workqty.WorkQtyArgs;

public class WorkQtySaveAction
extends AbstractWorkQtyAction {
    private static final Log logger = LogFactory.getLog(WorkQtySaveAction.class);

    @Override
    protected void doExecute() {
        this.refreshProgress(ResManager.loadKDString((String)"\u4f5c\u4e1a\u6570\u91cf\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"WorkQtySaveAction_0", (String)"macc-cad-mservice", (Object[])new Object[0]), 11, 14, false);
        List<DynamicObject> workQtyBills = this.getWorkQtyContext().getWorkQtyCollectBills();
        WorkQtyArgs workQtyArgs = this.getWorkQtyContext().getWorkQtyArgs();
        Set<Long> collectConfigIds = workQtyArgs.getCollectConfigIds();
        if (CadEmptyUtils.isEmpty(workQtyBills)) {
            this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"WorkQtySaveAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
            return;
        }
        boolean isCostDriverEmpty = false;
        for (DynamicObject workBill : workQtyBills) {
            Object costDriver = workBill.get("costdriver");
            if (costDriver instanceof Long && CadEmptyUtils.isEmpty((Long)Long.parseLong(String.valueOf(costDriver)))) {
                isCostDriverEmpty = true;
            } else if (costDriver instanceof DynamicObject && CadEmptyUtils.isEmpty((DynamicObject)((DynamicObject)costDriver))) {
                isCostDriverEmpty = true;
            }
            if (!isCostDriverEmpty) continue;
            Map<String, String> resultInfo = this.getWorkQtyContext().getResultInfo();
            resultInfo.put("type", "error");
            resultInfo.put("msg", ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u5b58\u5728\u6210\u672c\u52a8\u56e0\u4e3a\u7a7a\u7684\u5355\u636e", (String)"WorkQtySaveAction_2", (String)"macc-cad-mservice", (Object[])new Object[0]));
            this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"WorkQtySaveAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
            return;
        }
        logger.info("\u4f5c\u4e1a\u6570\u91cf\u5185\u90e8\u7cfb\u7edf\u5f15\u5165-\u5f15\u5165\u7684\u5f52\u96c6\u5355\u6570\u91cf\uff1a{}", (Object)workQtyBills.size());
        try (TXHandle txHandle = TX.required();){
            int batchSize;
            int saveSize;
            if (!CadEmptyUtils.isEmpty(collectConfigIds)) {
                QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
                qFilter.and("org", "=", (Object)workQtyArgs.getAcctOrgId());
                qFilter.and("costcenter", "in", workQtyArgs.getCostCenterIds());
                qFilter.and("collconfig", "in", collectConfigIds);
                qFilter.and(SysParamHelper.getImportTimeScope((Long)workQtyArgs.getAcctOrgId(), (String)"bizdate", (String)workQtyArgs.getAppNum()));
                int deleteSize = DeleteServiceHelper.delete((String)"sca_workqtycollec", (QFilter[])qFilter.toArray());
                this.getWorkQtyContext().setDelNum(deleteSize);
            }
            if ((saveSize = workQtyBills.size()) <= (batchSize = 300) * 3) {
                this.save(workQtyBills);
            } else {
                int batchCount = saveSize / batchSize + 1;
                for (int i = 0; i < batchCount; ++i) {
                    int startCount = i * batchSize;
                    int endCount = (i + 1) * batchSize;
                    if (i == batchCount - 1) {
                        endCount = saveSize;
                    }
                    List<DynamicObject> batchBillList = workQtyBills.subList(startCount, endCount);
                    this.save(batchBillList);
                }
            }
        }
        this.getWorkQtyContext().setAddNum(workQtyBills.size());
        this.refreshProgress(ResManager.loadKDString((String)"\u64cd\u4f5c\u5b8c\u6210\uff0c\u5f52\u96c6\u7ed3\u675f\u3002", (String)"WorkQtySaveAction_1", (String)"macc-cad-mservice", (Object[])new Object[0]), -1, 0, false);
    }

    private void save(List<DynamicObject> workQtyBills) {
        OperationResult operateResult = OperationServiceHelper.executeOperate((String)"save", (String)"sca_workqtycollec", (DynamicObject[])workQtyBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!operateResult.isSuccess()) {
            String errorInfo = OperationResultHelper.errorMsgHandle((OperationResult)operateResult);
            logger.error("\u4fdd\u5b58\u5931\u8d25\u3002" + errorInfo);
            throw new KDBizException(errorInfo);
        }
    }
}

