/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.autocalc;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.macc.cad.common.helper.InFilterHelper;
import kd.macc.cad.common.helper.MaterialGroupHelper;
import kd.macc.cad.common.helper.MaterialRangeImportHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.CadListUtils;

public class CalcRangeFormPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final Log LOG = LogFactory.getLog(CalcRangeFormPlugin.class);
    private static final String BUTTON_OK = "btnok";
    private static final String ITEM_MATERIAL = "material";
    private static final String ITEM_MATERIAL_GROUP_STANDARD = "materialgroupstandard";
    private static final String ITEM_MATERIAL_GROUP = "materialGroup";
    private static final String ATTR_OUT_SOURCING = "10040";
    private static final String MATERIAL_GROUP_BATCH_SIZE = "materialGroupBatchSize";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button confirm = (Button)this.getView().getControl(BUTTON_OK);
        confirm.addClickListener((ClickListener)this);
        MulBasedataEdit materialgroup = (MulBasedataEdit)this.getControl("materialgroup");
        materialgroup.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            DynamicObject materialgrpstdObj = (DynamicObject)this.getModel().getValue(ITEM_MATERIAL_GROUP_STANDARD);
            if (materialgrpstdObj == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"CalcRangeFormPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.setCustomParam("groupStandard", materialgrpstdObj.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        MulBasedataEdit materialMul = (MulBasedataEdit)this.getControl(ITEM_MATERIAL);
        materialMul.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = listShowParameter.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            Long manuOrg = this.getManaOrg();
            filters.add(new QFilter("createorg", "=", (Object)manuOrg));
            filters.add(new QFilter("materialattr", "!=", (Object)ATTR_OUT_SOURCING));
            List<Long> groupFilterMaterIdList = this.queryFilterMaterialIdByGroup();
            if (!CollectionUtils.isEmpty(groupFilterMaterIdList)) {
                QFilter materialIdFilter = InFilterHelper.getQFilterByBachSize((String)"masterid", new ArrayList<Long>(groupFilterMaterIdList), (String)"not in", (int)20000);
                filters.add(materialIdFilter);
            }
            filterParameter.getQFilters().addAll(filters);
        });
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BUTTON_OK.equals(key)) {
            long importStartTime = System.currentTimeMillis();
            DynamicObjectCollection materialRangeCollection = (DynamicObjectCollection)this.getModel().getValue(ITEM_MATERIAL);
            DynamicObject materialGroupStandard = (DynamicObject)this.getModel().getValue(ITEM_MATERIAL_GROUP_STANDARD);
            DynamicObjectCollection materialGroupCollection = (DynamicObjectCollection)this.getModel().getValue(ITEM_MATERIAL_GROUP);
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)materialRangeCollection) && (CadEmptyUtils.isEmpty((DynamicObject)materialGroupStandard) || CadEmptyUtils.isEmpty((DynamicObjectCollection)materialGroupCollection))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u5206\u7c7b\u548c\u7269\u6599\u8303\u56f4\u9009\u62e9\u5176\u4e2d\u4e00\u4e2a\u3002", (String)"CalcRangeFormPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            LOG.info("manual import calculation  material start");
            Long manuOrg = this.getManaOrg();
            List bomMaterialIdList = MaterialRangeImportHelper.getBomMaterialIdList((Long)manuOrg);
            int rangeNum = 0;
            int groupNum = 0;
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)materialGroupCollection)) {
                if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)materialRangeCollection)) {
                    rangeNum = this.saveAndUpdateRangeMaterialBatch(bomMaterialIdList, materialRangeCollection, manuOrg);
                }
                LOG.info("manual import calculation  material update rangeNum,costTime={}", (Object)rangeNum, (Object)(System.currentTimeMillis() - importStartTime));
            } else {
                if (!CadEmptyUtils.isEmpty((DynamicObject)materialGroupStandard) && !CadEmptyUtils.isEmpty((DynamicObjectCollection)materialGroupCollection)) {
                    Long materialGroupStandardId = materialGroupStandard.getLong("id");
                    List<Long> materialGroupIdList = this.getMaterialGroupList(materialGroupCollection);
                    List<Map<String, Object>> materialRangeList = this.getMaterialRangeByFilter(materialRangeCollection, bomMaterialIdList);
                    groupNum = this.saveAndUpdateGroupMaterialBatch(bomMaterialIdList, manuOrg, materialGroupStandardId, materialGroupIdList, materialRangeList);
                }
                LOG.info("manual import calculation  material update groupNum,costTime={}", (Object)groupNum, (Object)(System.currentTimeMillis() - importStartTime));
            }
            int total = groupNum + rangeNum;
            LOG.info("manual import calculation  material update total={},groupNum={}, rangeNum={}, costTime={}", new Object[]{total, groupNum, rangeNum, System.currentTimeMillis() - importStartTime});
            HashMap<String, Integer> returnData = new HashMap<String, Integer>();
            returnData.put("total", total);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }

    private int saveAndUpdateGroupMaterialBatch(List<Long> bomMaterialIdList, Long manuOrg, Long materialGroupStandardId, List<Long> materialGroupIdList, List<Map<String, Object>> materialRangeList) {
        int materialGroupBatchSize = Integer.parseInt(CadBgParamUtils.getCadBgParamForString((String)MATERIAL_GROUP_BATCH_SIZE, (String)"5"));
        List splitGroupList = CadListUtils.splitLists(new ArrayList<Long>(materialGroupIdList), (int)materialGroupBatchSize);
        int total = 0;
        for (List groupList : splitGroupList) {
            List groupIdList = groupList;
            List produceMaterialBatchList = MaterialRangeImportHelper.queryMaterialProduceListByParam((Long)materialGroupStandardId, (List)groupIdList, (Long)manuOrg, bomMaterialIdList);
            if (CadEmptyUtils.isEmpty((List)produceMaterialBatchList)) {
                LOG.info("MaterialRangeImportHelper#queryMaterialProduceListByParam is empty,manuOrg={},groupIdList={}", (Object)manuOrg, (Object)groupIdList);
                continue;
            }
            List<Map<String, Object>> produceMaterialBatchFilterList = new ArrayList();
            if (!CadEmptyUtils.isEmpty(materialRangeList)) {
                HashMap produceMaterialBatchMap = new HashMap();
                produceMaterialBatchList.forEach(item -> produceMaterialBatchMap.put((Long)item.get("id"), item));
                for (Map<String, Object> materialRange : materialRangeList) {
                    if (!produceMaterialBatchMap.containsKey(materialRange.get("id"))) continue;
                    produceMaterialBatchFilterList.add(materialRange);
                }
            } else {
                produceMaterialBatchFilterList = produceMaterialBatchList;
            }
            int updateNum = MaterialRangeImportHelper.saveAndUpdateMaterialRange(produceMaterialBatchFilterList, (Long)manuOrg);
            total += updateNum;
        }
        return total;
    }

    private int saveAndUpdateRangeMaterialBatch(List<Long> bomMaterialIdList, DynamicObjectCollection materialRangeCollection, Long manuOrg) {
        List<Map<String, Object>> materialRangeList = this.getMaterialRangeByFilter(materialRangeCollection, bomMaterialIdList);
        int updateNum = MaterialRangeImportHelper.saveAndUpdateMaterialRange(materialRangeList, (Long)manuOrg);
        return updateNum;
    }

    private List<Map<String, Object>> getMaterialRangeByFilter(DynamicObjectCollection materialRangeCollection, List<Long> bomMaterialIdList) {
        ArrayList<Map<String, Object>> materialRangeList = new ArrayList<Map<String, Object>>();
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)materialRangeCollection) || CadEmptyUtils.isEmpty(bomMaterialIdList)) {
            return materialRangeList;
        }
        for (DynamicObject dynamicObject : materialRangeCollection) {
            Long materialId;
            DynamicObject materialDynamicObject;
            DynamicObject baseDataDynamicObject = dynamicObject.getDynamicObject("fbasedataid");
            if (CadEmptyUtils.isEmpty((DynamicObject)baseDataDynamicObject) || CadEmptyUtils.isEmpty((DynamicObject)(materialDynamicObject = (DynamicObject)baseDataDynamicObject.get("masterid"))) || CadEmptyUtils.isEmpty((Long)materialDynamicObject.getLong("id")) || !bomMaterialIdList.contains(materialId = Long.valueOf(materialDynamicObject.getLong("id")))) continue;
            HashMap<String, Object> material = new HashMap<String, Object>(3);
            material.put("id", materialId);
            material.put("materialattr", baseDataDynamicObject.getString("materialattr"));
            material.put("createorg", baseDataDynamicObject.getLong("createorg.id"));
            materialRangeList.add(material);
        }
        return materialRangeList;
    }

    private Map<Long, Map<String, Object>> getTotalMaterialProduceList(Map<Long, Map<String, Object>> materialRangeMap, Map<Long, Map<String, Object>> groupMaterialMap) {
        LOG.info("getTotalMaterialProduceList materialRangeMap size={}, groupMaterialMap size={}", (Object)materialRangeMap.size(), (Object)groupMaterialMap.size());
        HashMap<Long, Map<String, Object>> totalMaterialMap = new HashMap<Long, Map<String, Object>>();
        if (!CadEmptyUtils.isEmpty(groupMaterialMap)) {
            totalMaterialMap.putAll(groupMaterialMap);
        }
        if (!CadEmptyUtils.isEmpty(materialRangeMap)) {
            totalMaterialMap.putAll(materialRangeMap);
        }
        LOG.info("getTotalMaterialProduceList material totalMaterialMap size={}", (Object)totalMaterialMap.size());
        return totalMaterialMap;
    }

    private List<Long> getMaterialGroupList(DynamicObjectCollection dynamicObjectCollection) {
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return new ArrayList<Long>();
        }
        ArrayList<Long> materialGroupList = new ArrayList<Long>();
        dynamicObjectCollection.forEach(item -> {
            DynamicObject dynamicObject = item.getDynamicObject("fbasedataid");
            if (!CadEmptyUtils.isEmpty((DynamicObject)dynamicObject)) {
                materialGroupList.add(dynamicObject.getLong("id"));
            }
        });
        return materialGroupList;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(ITEM_MATERIAL_GROUP_STANDARD, (Object)730148448254487552L);
    }

    private Long getManaOrg() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String manuOrg = (String)formShowParameter.getCustomParam("manuorg");
        if (CadEmptyUtils.isEmpty((String)manuOrg)) {
            return 0L;
        }
        return Long.parseLong(manuOrg);
    }

    private List<Long> queryFilterMaterialIdByGroup() {
        ArrayList<Long> defaultFilterGroupIdList = new ArrayList<Long>();
        defaultFilterGroupIdList.add(1703587904586090496L);
        defaultFilterGroupIdList.add(1675236224446617600L);
        List materialIdList = MaterialGroupHelper.queryMaterialIdList((Long)730148448254487552L, defaultFilterGroupIdList);
        return materialIdList;
    }
}

