/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.autocalc;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MaterialAutoCalcRangeListPlugin
extends AbstractListPlugin {
    private static final Log LOG = LogFactory.getLog(MaterialAutoCalcRangeListPlugin.class);
    private static final String MANUORG_ORG_ID = "manuorg.id";
    private static final String MANUORG_ORG_NAME = "manuorg.name";
    private static final String MANUORG = "manuorg";
    private static final int QUERY_MATERIAL_BATCH_SIZE = 1;
    private static final int CONFIG_SELF_CONTROL = 2;
    private static final String ATTR_PUR_MAT = "10040";
    private static final String CHECK_SELF_CONTROL_SWITCH = "checkSelfControlSwitch";
    private static final String CHECK_SELF_CONTROL_SWITCH_OPEN = "1";
    private static final String ITEM_CALCULATION = "calculation";
    private static final String ITEM_IMPORT = "import";
    private static final String ITEM_CALC_ID = "4730fc9f000025ae";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Object filterValue = args.getFilterValue(MANUORG_ORG_ID);
        if (filterValue != null) {
            this.getPageCache().put(MANUORG, String.valueOf(filterValue));
        } else {
            this.getPageCache().put(MANUORG, "");
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        switch (evt.getItemKey()) {
            case "calculation": {
                ArrayList<Long> idList = new ArrayList<Long>();
                rows.forEach(item -> idList.add((Long)item.getPrimaryKeyValue()));
                int size = this.queryMaterialConfigMatSize(idList);
                if (size <= 1000) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u914d\u7f6e\u4ef6\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc71000\u3002", (String)"MaterialAutoCalcRangeListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        switch (evt.getItemKey()) {
            case "import": {
                if (CadEmptyUtils.isEmpty((String)this.getView().getPageCache().get(MANUORG))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\uff0c\u7136\u540e\u70b9\u51fb\u201c\u5bfc\u5165\u201d\u3002", (String)"MaterialAutoCalcRangeListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.checkPerm("cad_autocalcmatrange", "47156aff000000ac")) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u81ea\u52a8\u5377\u7b97\u7269\u6599\u8303\u56f4\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MaterialAutoCalcRangeListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("cad_autorange");
                fsp.setCaption(ResManager.loadKDString((String)"\u7269\u6599\u5377\u7b97\u8303\u56f4", (String)"MaterialAutoCalcRangeListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                fsp.setCustomParam("entity", (Object)"cad_autorange");
                fsp.setCustomParam(MANUORG, (Object)this.getPageCache().get(MANUORG));
                fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "importAutoCalcRangeCallBack"));
                fsp.getOpenStyle().setShowType(ShowType.Floating);
                this.getView().showLoading(new LocaleString());
                this.getView().showForm(fsp);
                break;
            }
            case "calculation": {
                if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)rows)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5377\u7b97\u7684\u6570\u636e\u3002", (String)"MaterialAutoCalcRangeListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (CadEmptyUtils.isEmpty((String)this.getPageCache().get(MANUORG)) || CadEmptyUtils.isEmpty((Long)Long.parseLong(this.getPageCache().get(MANUORG)))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u751f\u4ea7\u65e5\u671f\u201d\u3002", (String)"MaterialAutoCalcRangeListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!this.checkPerm("cad_stdcalcnew", ITEM_CALC_ID)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u6807\u51c6\u6210\u672c\u5377\u7b97\u754c\u9762\u201d\u7684\u201c\u5f00\u542f\u5377\u7b97\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MaterialAutoCalcRangeListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList<Long> idList = new ArrayList<Long>();
                rows.forEach(item -> idList.add((Long)item.getPrimaryKeyValue()));
                this.getView().showLoading(new LocaleString());
                int success = this.calculation(idList, Long.parseLong(this.getPageCache().get(MANUORG)));
                this.getView().hideLoading();
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5377\u7b97\u6210\u529f%1$s\u6761\u6570\u636e\u3002", (String)"MaterialAutoCalcRangeListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]), success));
                billList.refresh();
            }
        }
    }

    public int queryMaterialConfigMatSize(List<Long> idList) {
        QFilter qFilter = new QFilter("id", "in", idList);
        qFilter.and(new QFilter("configmat", "=", (Object)true));
        DataSet dataSetDb = QueryServiceHelper.queryDataSet((String)MaterialAutoCalcRangeListPlugin.class.getName(), (String)"cad_autocalcmatrange", (String)"id", (QFilter[])qFilter.toArray(), null);
        if (dataSetDb == null || dataSetDb.isEmpty()) {
            return 0;
        }
        int size = 0;
        for (Row row : dataSetDb) {
            ++size;
        }
        return size;
    }

    private int calculation(List<Long> idList, Long produceOrgId) {
        int successCount = (Integer)DispatchServiceHelper.invokeBizService((String)"macc", (String)"sca", (String)"MaterialRangeCalcService", (String)"doMaterialRangeCalculate", (Object[])new Object[]{idList, produceOrgId});
        return successCount;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        BillList billList = (BillList)this.getControl("billlistap");
        switch (e.getActionId()) {
            case "importAutoCalcRangeCallBack": {
                this.getView().hideLoading();
                HashMap returnData = (HashMap)e.getReturnData();
                if (returnData == null) {
                    return;
                }
                Integer total = (Integer)returnData.get("total");
                LOG.info("manual import calculation  material total={}", (Object)total);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5bfc\u5165\u6570\u636ex\u6761\u3002", (String)"MaterialAutoCalcRangeListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]), total));
                billList.refresh();
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.updateProOrgComboItem(args);
    }

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    private void updateProOrgComboItem(FilterContainerInitArgs args) {
        CommonFilterColumn filterColumn = (CommonFilterColumn)args.getFilterColumn(MANUORG_ORG_NAME);
        if (filterColumn == null) {
            return;
        }
        List oldComboItems = filterColumn.getComboItems();
        oldComboItems.clear();
        long orgId = RequestContext.get().getOrgId();
        String cacheKey = "combo_item_manuorg-" + orgId;
        List newComboItems = this.getCacheComboItems(cacheKey);
        if (CadEmptyUtils.isEmpty(newComboItems)) {
            newComboItems = ImportServiceHelper.getPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            this.setCacheComboItems(cacheKey, newComboItems);
        }
        if (CadEmptyUtils.isEmpty(newComboItems)) {
            return;
        }
        filterColumn.setComboItems(newComboItems);
        String manuOrg = newComboItems.get(0).getValue();
        if (StringUtils.isNotEmpty((String)manuOrg)) {
            this.getPageCache().put(MANUORG, manuOrg);
            filterColumn.setDefaultValue(manuOrg);
            return;
        }
        this.getPageCache().put(MANUORG, "");
        filterColumn.setDefaultValue("");
    }

    private boolean checkPerm(String entityNum, String itemId) {
        String appId = this.getView().getFormShowParameter().getAppId();
        return PermissionServiceHelper.hasSpecificPerm((long)RequestContext.getOrCreate().getCurrUserId(), (String)appId, (String)entityNum, (String)itemId);
    }

    private void setCacheComboItems(String key, List<ComboItem> newComboItems) {
        this.getPageCache().put(key, SerializationUtils.toJsonString(newComboItems));
    }

    private List<ComboItem> getCacheComboItems(String key) {
        String cache = this.getPageCache().get(key);
        if (StringUtils.isEmpty((String)cache)) {
            return new ArrayList<ComboItem>();
        }
        List list = (List)SerializationUtils.fromJsonString((String)cache, List.class);
        if (CadEmptyUtils.isEmpty((List)list)) {
            return new ArrayList<ComboItem>();
        }
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        for (Map map : list) {
            ComboItem item = new ComboItem();
            Map captionMap = (Map)map.get("caption");
            item.setCaption(new LocaleString((String)captionMap.values().toArray()[0]));
            item.setValue((String)map.get("value"));
            comboItems.add(item);
        }
        return comboItems;
    }
}

