/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.CostCenterHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PeriodHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.base.BaseManuorgListPlugin;

public abstract class BaseListPlugin
extends BaseManuorgListPlugin {
    private static final Log logger = LogFactory.getLog(BaseListPlugin.class);
    protected FilterContainerInitArgs filterContainerInitArgs = null;
    protected String ORG_FIELD = "org";

    protected List<ComboItem> getORGComboItemList() {
        return OrgHelper.getOrgComboItems((String)this.getBillEntityId(), (String)this.getAppId());
    }

    @Override
    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    protected List<ComboItem> getCostCenterComboItemListBy(String orgId) {
        QFilter filter = null;
        if (!StringUtils.isEmpty((String)orgId) && !"0".equals(orgId)) {
            filter = new QFilter("accountorg", "=", (Object)Long.valueOf(orgId));
        } else {
            List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId())).getHasPermOrgs();
            List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
            filter = new QFilter("accountorg", "in", (Object)orgIds);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter orgdutyFilter = new QFilter("orgduty", "=", (Object)4L);
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{filter, enableFilter, orgdutyFilter});
        if (CollectionUtils.isEmpty((Collection)ccs)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    protected List<ComboItem> getCostCenterComboItemListBy(String orgId, List<Long> orgdutys) {
        QFilter filter = null;
        if (!StringUtils.isEmpty((String)orgId) && !"0".equals(orgId)) {
            filter = new QFilter("accountorg", "=", (Object)Long.valueOf(orgId));
        } else {
            List permOrgIds = PermissionServiceHelper.getUserHasPermOrgs((long)Long.parseLong(RequestContext.get().getUserId())).getHasPermOrgs();
            List orgIds = OrgUnitServiceHelper.filterOrgDuty((List)permOrgIds, (String)"10");
            filter = new QFilter("accountorg", "in", (Object)orgIds);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter orgdutyFilter = CadEmptyUtils.isEmpty(orgdutys) ? null : new QFilter("orgduty", "in", orgdutys);
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{filter, enableFilter, orgdutyFilter});
        if (CollectionUtils.isEmpty((Collection)ccs)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    protected List<Long> getCostAccounts(List<Object> orgId) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (orgId == null) {
            return result;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (Object org : orgId) {
            orgIds.add(Long.valueOf(org.toString()));
        }
        String fields = "entryentity.costaccount.id id";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            appId = "sca";
        }
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appId);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, enable, appNumQF};
        DynamicObjectCollection startStdCosts = QueryServiceHelper.query((String)"sca_startstdcost", (String)fields, (QFilter[])filters, null);
        for (DynamicObject startStdCost : startStdCosts) {
            result.add(startStdCost.getLong("id"));
        }
        return result;
    }

    protected List<ComboItem> getCostAccountComboItemListBy(List<Object> orgId) {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>(16);
        if (orgId == null) {
            return acctItems;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(16);
        for (Object org : orgId) {
            orgIds.add(Long.valueOf(org.toString()));
        }
        String fields = "entryentity.costaccount.id id,entryentity.costaccount.name name,entryentity.costaccount.ismainaccount ismainaccount,entryentity.costaccount.number number";
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter isEnabledFilter = new QFilter("entryentity.isenabled", "=", (Object)Boolean.TRUE);
        QFilter enable = new QFilter("entryentity.costaccount.enable", "=", (Object)Boolean.TRUE);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId())) {
            appId = "sca";
        }
        QFilter appNumQF = new QFilter("appnum", "=", (Object)appId);
        QFilter[] filters = new QFilter[]{orgFilter, isEnabledFilter, enable, appNumQF};
        DataSet dataSet = null;
        try {
            dataSet = QueryServiceHelper.queryDataSet((String)"BaseListPlugin_getCostAccountComboItemListBy", (String)"sca_startstdcost", (String)fields, (QFilter[])filters, null);
            if (dataSet.isEmpty()) {
                return acctItems;
            }
            ComboItem defaultItem = null;
            DataSet resultDataSet = dataSet.orderBy(new String[]{"number asc"});
            for (Row row : resultDataSet) {
                Boolean isMainAccount = row.getBoolean("ismainaccount");
                if (isMainAccount.booleanValue()) {
                    defaultItem = new ComboItem();
                    defaultItem.setCaption(new LocaleString(row.getString("name")));
                    defaultItem.setValue(row.getString("id"));
                    continue;
                }
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(row.getString("name")));
                item.setValue(row.getString("id"));
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
            if (defaultItem != null) {
                acctItems.add(0, defaultItem);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6210\u672c\u8d26\u7c3f\u5f02\u5e38\uff1a", (Throwable)e);
        }
        return acctItems;
    }

    protected Long getPeriodBy(String costAccountId) {
        QFilter filter = null;
        filter = !StringUtils.isEmpty((String)costAccountId) ? new QFilter("entry.costaccount", "=", (Object)Long.valueOf(costAccountId)) : new QFilter("entry.costaccount", "=", (Object)-1L);
        QFilter enableFilter = new QFilter("entry.isenabled", "=", (Object)Boolean.TRUE);
        DynamicObject period = QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"entry.currentperiod.id pid", (QFilter[])new QFilter[]{filter, enableFilter});
        return period == null ? null : Long.valueOf(period.getLong("pid"));
    }

    protected List<ComboItem> getPeriodComboItemListBy(Long costAccountId) {
        QFilter enableFilter;
        QFilter filter = null;
        filter = !CadEmptyUtils.isEmpty((Long)costAccountId) ? new QFilter("entry.costaccount", "=", (Object)costAccountId) : new QFilter("entry.costaccount", "=", (Object)-1L);
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"cal_sysctrlentity", (String)"entry.currentperiod.id pid,entry.currentperiod.name pname", (QFilter[])new QFilter[]{filter, enableFilter = new QFilter("entry.isenabled", "=", (Object)Boolean.TRUE)});
        if (CollectionUtils.isEmpty((Collection)ccs)) {
            return null;
        }
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            String name = cc.getString("pname");
            if (StringUtils.isNotEmpty((String)name)) {
                item.setCaption(new LocaleString(name));
                item.setValue(cc.getString("pid"));
                if (!acctItems.contains(item)) {
                    acctItems.add(item);
                }
            }
        });
        return acctItems;
    }

    protected List<ComboItem> getPeriodComboItemsByLast(Long costAccountId) {
        ArrayList<ComboItem> periodComboItems = new ArrayList<ComboItem>();
        DynamicObject curPeriodAndEnAblePeriod = PeriodHelper.getCurrentPeriodAndEnAblePeriod((Long)costAccountId);
        if (curPeriodAndEnAblePeriod == null) {
            return periodComboItems;
        }
        DynamicObject currentperiod = curPeriodAndEnAblePeriod.getDynamicObject("currentperiod");
        if (currentperiod == null) {
            return periodComboItems;
        }
        Long startperiodId = 0L;
        DynamicObject startperiod = curPeriodAndEnAblePeriod.getDynamicObject("startperiod");
        if (startperiod != null) {
            startperiodId = startperiod.getLong("id");
        }
        this.addCombItem(periodComboItems, null, currentperiod);
        if (Long.compare(startperiodId, currentperiod.getLong("id")) == 0) {
            return periodComboItems;
        }
        DynamicObject prePeriod = PeriodHelper.getPreviousPeriod((Object)currentperiod.getPkValue());
        if (prePeriod == null) {
            return periodComboItems;
        }
        this.addCombItem(periodComboItems, null, prePeriod);
        if (Long.compare(startperiodId, prePeriod.getLong("id")) == 0) {
            return periodComboItems;
        }
        DynamicObject prePrePeriod = PeriodHelper.getPreviousPeriod((Object)prePeriod.getPkValue());
        if (prePrePeriod == null) {
            return periodComboItems;
        }
        this.addCombItem(periodComboItems, null, prePrePeriod);
        return periodComboItems;
    }

    private void addCombItem(List<ComboItem> periodComboItems, String caption, DynamicObject period) {
        if (null == period) {
            return;
        }
        ComboItem item = new ComboItem();
        String periodId = period.getString("id");
        if (StringUtils.isEmpty((String)caption)) {
            item.setCaption(new LocaleString(period.getString("name")));
        } else {
            item.setCaption(new LocaleString(caption));
        }
        item.setValue(periodId);
        periodComboItems.add(item);
    }

    protected List<ComboItem> getCostCenterComboItemListByManuOrg(String orgId, String manuOrgId) {
        QFilter filter;
        if (!StringUtils.isEmpty((String)orgId) && !"0".equals(orgId)) {
            ArrayList<Long> manuOrgList = new ArrayList<Long>();
            if (!CadEmptyUtils.isEmpty((String)manuOrgId)) {
                manuOrgList.add(Long.parseLong(manuOrgId));
            }
            filter = CostCenterHelper.getCostCenterByMultFactoryForList((long)Long.parseLong(orgId), manuOrgList, (String)this.getAppId(), (String)this.getBillEntityId());
        } else {
            List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getAppId());
            filter = new QFilter("accountorg", "in", (Object)orgIds);
        }
        String entityId = this.getBillEntityId();
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        if (!"sca_mfgfeeallocstdnew".equals(entityId) && !"sca_diycostdriver".equals(entityId)) {
            filter.and("orgduty", "=", (Object)4L);
        }
        DynamicObjectCollection ccs = QueryServiceHelper.query((String)"bos_costcenter", (String)"id,name", (QFilter[])new QFilter[]{filter, enableFilter});
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        if (CollectionUtils.isEmpty((Collection)ccs)) {
            return acctItems;
        }
        ccs.forEach(cc -> {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(cc.getString("name")));
            item.setValue(cc.getString("id"));
            if (!acctItems.contains(item)) {
                acctItems.add(item);
            }
        });
        return acctItems;
    }

    protected String getAppId() {
        return this.getView().getFormShowParameter().getAppId();
    }
}

