/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.base;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ClickEventHelper;
import kd.macc.cad.common.helper.CostAccountHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.base.BaseListPlugin;

public abstract class BaseOrgAndCostAccountListPlugin
extends BaseListPlugin {
    protected static final Log logger = LogFactory.getLog(BaseOrgAndCostAccountListPlugin.class);
    protected Boolean isCostAccountDef = Boolean.FALSE;
    protected static final String ACCTORG = "org";
    private volatile boolean orgClick = false;
    private List<ComboItem> comboItems;

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        this.initClickEvent(args);
        this.filterContainerInit(args, null);
    }

    private void initClickEvent(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        Iterator var3 = filterColumns.iterator();
        String org = this.getPageCache().get(this.ORG_FIELD);
        while (var3.hasNext()) {
            FilterColumn filterColumn = (FilterColumn)var3.next();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List selectValue = (List)ClickEventHelper.getSelectValue(commonFilterColumn.getClass(), (Object)commonFilterColumn);
            boolean selNotNull = selectValue != null && selectValue.size() > 0;
            String defaultValue = "";
            if (selNotNull) {
                defaultValue = selectValue.get(0);
            }
            if (!fieldName.startsWith("org.") || org == null || "".equals(org)) continue;
            List list = (List)SerializationUtils.fromJsonString((String)org, List.class);
            String oldOrgId = (String)list.get(0);
            if (!defaultValue.equals(oldOrgId)) {
                this.orgClick = true;
                continue;
            }
            this.orgClick = false;
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("costaccount")) {
            List<Object> orgIdList = this.getOrgCache();
            if (orgIdList == null) {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            } else {
                List<Long> costAccounts = this.getCostAccounts(orgIdList);
                QFilter idQf = new QFilter("id", "in", costAccounts);
                args.getQfilters().add(idQf);
            }
        } else if (fieldName.startsWith(String.format("%s.", this.ORG_FIELD))) {
            List<ComboItem> acctOrgs = this.getORGComboItemList();
            if (CadEmptyUtils.isEmpty(acctOrgs)) {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        } else if (fieldName.startsWith("period")) {
            String costAccoutId = this.getPageCache().get("costaccount");
            if (!CadEmptyUtils.isEmpty((String)costAccoutId)) {
                DynamicObject sysCtrlEntity = this.getPeriodSetDynamicObject(Long.valueOf(costAccoutId));
                if (sysCtrlEntity != null) {
                    Long startPeriod = sysCtrlEntity.getLong("startperiod");
                    QFilter idQf = new QFilter("id", ">=", (Object)startPeriod);
                    idQf.and("periodtype", "=", (Object)sysCtrlEntity.getLong("periodtype"));
                    args.getQfilters().add(new QFilter("isadjustperiod", "=", (Object)false));
                    args.getQfilters().add(idQf);
                }
            } else {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        } else if (fieldName.startsWith("manuorg")) {
            List<Object> orgIdList = this.getOrgCache();
            if (!CadEmptyUtils.isEmpty(orgIdList)) {
                Long orgId = Long.valueOf(String.valueOf(orgIdList.get(0)));
                List userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
                args.getQfilters().add(new QFilter("id", "in", (Object)userHasPermProOrgsByAccOrg));
            } else {
                args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
            }
        }
    }

    private DynamicObject getPeriodSetDynamicObject(Long costaccountId) {
        QFilter costaccountFilter = new QFilter("entry.costaccount", "=", (Object)costaccountId);
        return QueryServiceHelper.queryOne((String)"cal_sysctrlentity", (String)"id,entry.startperiod startperiod,entry.currentperiod currentperiod,entry.calpolicy.periodtype periodtype", (QFilter[])new QFilter[]{costaccountFilter});
    }

    private void filterContainerInit(FilterContainerInitArgs args, String initName) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List<Object> orgIdList = this.getOrgCache();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (kd.bos.util.StringUtils.isNotEmpty((String)initName) && !fieldName.contains(initName)) continue;
            if (fieldName.startsWith(String.format("%s.", this.ORG_FIELD))) {
                this.resetOrg(commonFilterColumn, orgIdList);
                continue;
            }
            if (fieldName.startsWith("costaccount.")) {
                this.resetCostAccount(commonFilterColumn, orgIdList);
                continue;
            }
            if (fieldName.startsWith("manuorg.")) {
                if (orgIdList == null) continue;
                this.resetManuorg(commonFilterColumn, orgIdList);
                continue;
            }
            if (!fieldName.startsWith("period.")) continue;
            String costAccoutId = this.getPageCache().get("costaccount");
            this.resetPeriod(commonFilterColumn, costAccoutId);
        }
    }

    private void resetManuorg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        if (orgIdList.get(0) != null) {
            List comboItems;
            Long orgId = Long.valueOf(String.valueOf(orgIdList.get(0)));
            String costAccoutId = this.getPageCache().get("costaccount");
            boolean enableMulFactory = false;
            if (costAccoutId != null && !"".equals(costAccoutId)) {
                enableMulFactory = CostAccountHelper.isEnableMulFactory((Long)Long.valueOf(costAccoutId));
            }
            if (enableMulFactory && !CollectionUtils.isEmpty((Collection)(comboItems = ImportServiceHelper.getPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())))) {
                commonFilterColumn.setComboItems(comboItems);
                ComboItem item = (ComboItem)comboItems.get(0);
                String defVal = ACCTORG.equals(this.ORG_FIELD) ? "" : item.getValue();
                commonFilterColumn.setDefaultValue(defVal);
                this.getPageCache().put("manuorg", defVal);
            }
        }
    }

    protected void resetOrg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        String org;
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        List<ComboItem> acctOrgs = this.getORGComboItemList();
        if (CadEmptyUtils.isEmpty(acctOrgs)) {
            return;
        }
        String defOrgId = null;
        commonFilterColumn.setComboItems(acctOrgs);
        ComboItem item = acctOrgs.get(0);
        String defVal = item.getValue();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String source = (String)formShowParameter.getCustomParam("source");
        if ("HyperLink".equals(source) && !CadEmptyUtils.isEmpty((String)(org = formShowParameter.getCustomParam(ACCTORG) + ""))) {
            defVal = org;
        }
        String string = defOrgId = kd.bos.util.StringUtils.isEmpty((String)(defOrgId = this.getCustomParam(ACCTORG))) ? defVal : defOrgId;
        if (CadEmptyUtils.isEmpty(orgIdList)) {
            orgIdList = Collections.singletonList(defOrgId);
        }
        commonFilterColumn.setDefaultValues(orgIdList);
        String costaccount = this.getPageCache().get("costaccount");
        this.putOrgCache(orgIdList);
        if (!CadEmptyUtils.isEmpty((String)costaccount)) {
            List<ComboItem> accountItems = this.getCostAccountComboItemListBy(orgIdList);
            for (ComboItem cbitem : accountItems) {
                if (!cbitem.getValue().equals(costaccount)) continue;
                this.getPageCache().put("costaccount", costaccount);
                break;
            }
        }
    }

    protected void resetCostAccount(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        String costaccount;
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        List<ComboItem> comboItems = this.getCostAccountComboItemListBy(orgIdList);
        if (CollectionUtils.isEmpty(comboItems)) {
            this.getPageCache().remove("costaccount");
            commonFilterColumn.setDefaultValue("0");
            return;
        }
        commonFilterColumn.setComboItems(comboItems);
        ComboItem item = comboItems.get(0);
        String defVal = this.getCustomParam("costaccount");
        if (CadEmptyUtils.isEmpty((String)defVal)) {
            String costaccount2 = this.getPageCache().get("costaccount");
            for (ComboItem cbitem : comboItems) {
                if (!cbitem.getValue().equals(costaccount2)) continue;
                defVal = costaccount2;
                break;
            }
            if (CadEmptyUtils.isEmpty((String)defVal)) {
                defVal = item.getValue();
            }
        }
        defVal = this.isCostAccountDef != false ? "" : defVal;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String source = (String)formShowParameter.getCustomParam("source");
        if ("HyperLink".equals(source) && !CadEmptyUtils.isEmpty((String)(costaccount = formShowParameter.getCustomParam("costaccount") + "")) && !"null".equals(costaccount)) {
            defVal = costaccount;
        }
        commonFilterColumn.setDefaultValue(defVal);
        this.getPageCache().put("costaccount", defVal);
    }

    protected void resetPeriod(CommonFilterColumn commonFilterColumn, String costAccoutId) {
        List listcomitem = commonFilterColumn.getComboItems();
        listcomitem.clear();
        Long costAccout = 0L;
        if (kd.bos.util.StringUtils.isNotEmpty((String)costAccoutId)) {
            costAccout = Long.parseLong(costAccoutId);
        }
        this.comboItems = this.getPeriodComboItemsByLast(costAccout);
        if (CollectionUtils.isEmpty(this.comboItems)) {
            return;
        }
        this.dealSelectVal(this.comboItems, commonFilterColumn);
        commonFilterColumn.setComboItems(this.comboItems);
        String defVal = this.comboItems.get(0).getValue();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        boolean linkQuery = false;
        try {
            LinkQueryPkIdCollection linkQueryPkIdCollection = ((ListShowParameter)formShowParameter).getLinkQueryPkIdCollection();
            linkQuery = !CadEmptyUtils.isEmpty((List)linkQueryPkIdCollection);
        }
        catch (Exception e) {
            logger.error("getLinkQueryPkIdCollection error -> {}", (Object)e.getMessage());
        }
        if (linkQuery) {
            defVal = "";
        } else {
            String period;
            String source = (String)formShowParameter.getCustomParam("source");
            if ("HyperLink".equals(source) && !CadEmptyUtils.isEmpty((String)(period = formShowParameter.getCustomParam("period") + "")) && !"null".equals(period)) {
                defVal = period;
            }
        }
        commonFilterColumn.setDefaultValue(defVal);
        this.getPageCache().put("period", defVal);
    }

    private void dealSelectVal(List<ComboItem> listcomitem, CommonFilterColumn commonFilterColumn) {
        Map valuemap = null;
        try {
            Field field = ReflectionUtils.findField(commonFilterColumn.getClass(), (String)"commonFilters");
            AccessibleObject.setAccessible(new AccessibleObject[]{field}, Boolean.TRUE);
            valuemap = (Map)field.get(commonFilterColumn);
        }
        catch (Exception var4) {
            logger.error("\u53cd\u5c04\u83b7\u53d6\u5c5e\u6027\u5931\u8d25", (Throwable)var4);
        }
        if (valuemap == null || !valuemap.containsKey(commonFilterColumn.getFieldName())) {
            return;
        }
        List obj = (List)valuemap.get(commonFilterColumn.getFieldName());
        if (CadEmptyUtils.isEmpty((List)obj) && obj.get(0) == null) {
            return;
        }
        try {
            DynamicObject periodDyn;
            Long periodId = Long.valueOf(obj.get(0).toString());
            boolean contain = false;
            for (ComboItem item : listcomitem) {
                if (!item.getValue().equals(String.valueOf(periodId))) continue;
                contain = true;
            }
            if (!contain && (periodDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period")) != null) {
                ComboItem item;
                item = new ComboItem();
                item.setCaption(new LocaleString(periodDyn.getString("name")));
                item.setValue(periodDyn.getString("id"));
                listcomitem.add(item);
            }
        }
        catch (Exception ex) {
            logger.info("\u5904\u7406\u51fa\u9519", (Object)ex);
        }
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        Map filterValues;
        List customfilter;
        super.filterContainerSearchClick(e);
        if (this.orgClick) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"costaccount.id");
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"period.id");
        }
        if (!CadEmptyUtils.isEmpty((Map)e.getCurrentCommonFilter()) && "costaccount.id".equals(((List)e.getCurrentCommonFilter().get("FieldName")).get(0))) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"period.id");
        }
        if ((customfilter = (List)(filterValues = e.getSearchClickEvent().getFilterValues()).get("customfilter")) == null || customfilter.isEmpty()) {
            return;
        }
        Map nowPeriodMap = Maps.newHashMapWithExpectedSize((int)16);
        String orgIdStr = "";
        for (int i = 0; i < customfilter.size(); ++i) {
            String val;
            List vals;
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            if (String.format("%s.id", this.ORG_FIELD).equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (CadEmptyUtils.isEmpty((List)vals)) continue;
                orgIdStr = (String)vals.get(0);
                List hasPermAccountOrgIds = OrgHelper.getHasPermAccountOrgIds((String)this.getBillEntityId(), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
                if (CadEmptyUtils.isEmpty((String)orgIdStr) || !hasPermAccountOrgIds.contains(Long.parseLong(orgIdStr))) {
                    this.getPageCache().put(this.ORG_FIELD, SerializationUtils.toJsonString(new ArrayList()));
                    this.getPageCache().put("costaccount", "");
                    ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"org.id");
                    this.filterContainerInit(this.filterContainerInitArgs, null);
                    continue;
                }
                this.putOrgCache(vals);
                this.filterContainerInit(this.filterContainerInitArgs);
                continue;
            }
            if ("costaccount.id".equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                val = String.valueOf(vals.get(0));
                this.getPageCache().put("costaccount", val);
                this.filterContainerInit(this.filterContainerInitArgs, "period");
                this.filterContainerInit(this.filterContainerInitArgs, "manuorg");
                continue;
            }
            if ("manuorg.id".equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) continue;
                this.getPageCache().put("manuorg", JSON.toJSONString((Object)vals));
                continue;
            }
            if (!"period.id".equals(String.valueOf(names.get(0))) || (vals = (List)map.get("Value")) == null || vals.isEmpty()) continue;
            nowPeriodMap = map;
            val = String.valueOf(vals.get(0));
            this.getPageCache().put("period", val);
        }
        this.setPeriodValue(nowPeriodMap);
    }

    private void setPeriodValue(Map<String, List<Object>> nowPeriodMap) {
        if (CadEmptyUtils.isEmpty(nowPeriodMap)) {
            return;
        }
        if (CadEmptyUtils.isEmpty(this.comboItems)) {
            List<Object> value = nowPeriodMap.get("Value");
            if (!CadEmptyUtils.isEmpty(value)) {
                value.clear();
                value.add("");
                this.getPageCache().put("period", "");
            }
        } else {
            List<Object> values = nowPeriodMap.get("Value");
            if (!CadEmptyUtils.isEmpty(values)) {
                Set collect = this.comboItems.stream().map(o -> o.getValue()).collect(Collectors.toSet());
                if ("".equals(values.get(0))) {
                    this.getView().getPageCache().put("period", "");
                } else if (!collect.contains(values.get(0))) {
                    values.clear();
                    values.add(this.comboItems.get(0).getValue());
                    this.getView().getPageCache().put("period", this.comboItems.get(0).getValue());
                }
            }
        }
    }

    protected void putOrgCache(List<Object> vals) {
        this.getPageCache().put(this.ORG_FIELD, SerializationUtils.toJsonString(vals));
        this.getPageCache().put("costaccount", "");
    }

    protected List<Object> getOrgCache() {
        String orgId = this.getPageCache().get(this.ORG_FIELD);
        if (kd.bos.util.StringUtils.isNotEmpty((String)orgId)) {
            return (List)SerializationUtils.fromJsonString((String)orgId, List.class);
        }
        return null;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter bsp = e.getParameter();
        String acctOrg = this.getPageCache().get(this.ORG_FIELD);
        String costCenter = this.getPageCache().get("costaccount");
        String manuorg = this.getPageCache().get("manuorg");
        bsp.setCustomParam(this.ORG_FIELD, (Object)acctOrg);
        bsp.setCustomParam("costaccount", (Object)costCenter);
        bsp.setCustomParam("manuorg", (Object)manuorg);
    }

    protected QFilter getManuOrgQFilter() {
        String orgId;
        boolean enableMultiFactory;
        List<Object> orgCache;
        QFilter manuOrgQf = null;
        String manuOrgId = this.getPageCache().get("manuorg");
        if (StringUtils.isEmpty((CharSequence)manuOrgId) && (orgCache = this.getOrgCache()) != null && (enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(orgId = String.valueOf(orgCache.get(0))))) && !StringUtils.isEmpty((CharSequence)orgId)) {
            List userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.valueOf(orgId), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (!CadEmptyUtils.isEmpty((List)userHasPermProOrgsByAccOrg)) {
                userHasPermProOrgsByAccOrg.add(0L);
                manuOrgQf = new QFilter("manuorg", "in", (Object)userHasPermProOrgsByAccOrg);
            } else {
                manuOrgQf = new QFilter("manuorg", "=", (Object)0L);
            }
        }
        return manuOrgQf;
    }

    @Override
    protected String getCustomParam(String key) {
        try {
            Object pageOrg = this.getView().getFormShowParameter().getCustomParam(key);
            if (pageOrg != null && !CadEmptyUtils.isEmpty((String)pageOrg.toString())) {
                return String.valueOf(pageOrg);
            }
        }
        catch (Exception ex) {
            logger.error("\u8f6c\u6362\u62a5\u9519\uff1a", (Throwable)ex);
        }
        return null;
    }
}

