/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.base;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.ClickEventHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class BaseOrgAndManuAndExpdateListPlugin
extends AbstractListPlugin {
    private static final String ORG = "org";
    private static final String MANUORG = "manuorg";
    private volatile boolean orgClick = false;
    protected FilterContainerInitArgs filterContainerInitArgs = null;

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.initClickEvent(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List<Object> orgIdList = this.getOrgCache();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.startsWith(String.format("%s.", ORG))) {
                this.resetOrg(commonFilterColumn, orgIdList);
            }
            if (!fieldName.startsWith("manuorg.")) continue;
            this.resetManuorg(commonFilterColumn, orgIdList);
        }
    }

    private void initClickEvent(FilterContainerInitArgs args) {
        List filterColumns = args.getFilterContainerInitEvent().getCommonFilterColumns();
        for (FilterColumn filterColumn : filterColumns) {
            String org;
            List<Object> list;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            List selectValue = (List)ClickEventHelper.getSelectValue(commonFilterColumn.getClass(), (Object)commonFilterColumn);
            boolean selNotNull = selectValue != null && selectValue.size() > 0;
            String defaultValue = "";
            if (selNotNull) {
                defaultValue = selectValue.get(0);
            }
            if (!fieldName.startsWith("org.") || (list = this.getOrgCache()) == null || (org = list.get(0).toString()) == null || "".equals(org)) continue;
            if (!defaultValue.equals(org)) {
                this.orgClick = true;
                continue;
            }
            this.orgClick = false;
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        Map filterValues;
        List customFilter;
        super.filterContainerSearchClick(e);
        if (this.orgClick) {
            ClickEventHelper.deleteCustomFilter((FilterContainerSearchClickArgs)e, (String)"manuorg.id");
            this.getPageCache().put(MANUORG, null);
        }
        if ((customFilter = (List)(filterValues = e.getSearchClickEvent().getFilterValues()).get("customfilter")) == null || customFilter.isEmpty()) {
            return;
        }
        for (int i = 0; i < customFilter.size(); ++i) {
            List vals;
            Map map = (Map)customFilter.get(i);
            List names = (List)map.get("FieldName");
            if (String.format("%s.id", ORG).equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (CadEmptyUtils.isEmpty((List)vals)) continue;
                this.putOrgCache(vals);
                this.filterContainerInit(this.filterContainerInitArgs);
            }
            if (!"manuorg.id".equals(String.valueOf(names.get(0))) || (vals = (List)map.get("Value")) == null || vals.isEmpty()) continue;
            this.getPageCache().put(MANUORG, String.valueOf(vals.get(0)));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "new": {
                this.checkParamIsSelect(e);
            }
        }
    }

    private void checkParamIsSelect(BeforeDoOperationEventArgs e) {
        List<Object> orgCache = this.getOrgCache();
        if (CadEmptyUtils.isEmpty(orgCache)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"BaseOrgAndManuAndExpdateListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    protected void putOrgCache(List<Object> vals) {
        this.getPageCache().put(ORG, SerializationUtils.toJsonString(vals));
    }

    protected List<Object> getOrgCache() {
        String orgId = this.getPageCache().get(ORG);
        if (StringUtils.isNotEmpty((String)orgId)) {
            return (List)SerializationUtils.fromJsonString((String)orgId, List.class);
        }
        return null;
    }

    public void resetManuorg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        Long orgId;
        List comboItems;
        List listComItem = commonFilterColumn.getComboItems();
        listComItem.clear();
        if (!CollectionUtils.isEmpty(orgIdList) && !CollectionUtils.isEmpty((Collection)(comboItems = ImportServiceHelper.getPermProOrgsByAccOrg((Long)(orgId = Long.valueOf(String.valueOf(orgIdList.get(0)))), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())))) {
            commonFilterColumn.setComboItems(comboItems);
        }
    }

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    protected void resetOrg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        List listComItem = commonFilterColumn.getComboItems();
        listComItem.clear();
        List acctOrgs = OrgHelper.getMultiOrgComboItems((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
            return;
        }
        commonFilterColumn.setComboItems(acctOrgs);
        ComboItem item = (ComboItem)acctOrgs.get(0);
        String defOrgId = item.getValue();
        if (CadEmptyUtils.isEmpty(orgIdList)) {
            orgIdList = Collections.singletonList(defOrgId);
        }
        commonFilterColumn.setDefaultValues(orgIdList);
        this.putOrgCache(orgIdList);
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        Map<String, Date> dateMap = this.removeDateFilter(filters);
        this.setEffectDateFilter(filters, dateMap);
    }

    protected Map<String, Date> removeDateFilter(List<QFilter> filters) {
        HashMap<String, Date> result = new HashMap<String, Date>(8);
        Iterator<QFilter> iter = filters.iterator();
        while (iter.hasNext()) {
            QFilter filter = iter.next();
            if (!"expdate".equals(filter.getProperty())) continue;
            Date startDate = (Date)filter.getValue();
            Date endDate = (Date)((QFilter.QFilterNest)filter.getNests(true).get(0)).getFilter().getValue();
            result.put("startDate", startDate);
            result.put("endDate", endDate);
            iter.remove();
        }
        return result;
    }

    protected void setEffectDateFilter(List<QFilter> filters, Map<String, Date> dateMap) {
        if (dateMap.isEmpty()) {
            return;
        }
        Date startDate = dateMap.get("startDate");
        Date endDate = DateUtils.getLastSecond((Date)dateMap.get("endDate"), (int)1);
        QFilter dateFilter1 = new QFilter("effectdate", "<", (Object)startDate).and(new QFilter("expdate", ">=", (Object)startDate));
        QFilter dateFilter2 = new QFilter("effectdate", "<=", (Object)startDate).and(new QFilter("expdate", ">", (Object)startDate));
        QFilter dateFilter3 = new QFilter("effectdate", ">=", (Object)startDate).and(new QFilter("effectdate", "<", (Object)endDate));
        QFilter dateFilter4 = new QFilter("effectdate", ">", (Object)startDate).and(new QFilter("effectdate", "<=", (Object)endDate));
        filters.add(dateFilter1.or(dateFilter2).or(dateFilter3).or(dateFilter4));
    }
}

