/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.base;

import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.base.PermitItemEnum;

public class PermissionBillPlugin
extends AbstractBillPlugIn {
    protected String orgKey = "org.id";
    protected String manuOrgKey = "manuorg.id";

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    protected String getBillEntityName() {
        return this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String appId = this.getView().getFormShowParameter().getAppId();
        String orgId = this.getModel().getDataEntity().getString(this.getOrgKey());
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)this.getBillEntityId());
        IDataEntityProperty manuorg = entityType.findProperty("manuorg");
        String manuOrgId = "";
        if (manuorg != null) {
            manuOrgId = this.getModel().getDataEntity().getString(this.getManuOrgKey());
        }
        switch (operateKey) {
            case "new": {
                this.checkSpecificPermission(appId, orgId, manuOrgId, PermitItemEnum.ITEM_NEW, args);
                break;
            }
            case "copy": {
                this.checkSpecificPermission(appId, orgId, manuOrgId, PermitItemEnum.ITEM_COPY, args);
                break;
            }
            case "save": {
                this.checkSpecificPermission(appId, orgId, manuOrgId, PermitItemEnum.ITEM_SAVE, args);
                break;
            }
            case "modify": {
                this.checkSpecificPermission(appId, orgId, manuOrgId, PermitItemEnum.ITEM_MODIFY, args);
                break;
            }
            case "delete": {
                this.checkSpecificPermission(appId, orgId, manuOrgId, PermitItemEnum.ITEM_DELETE, args);
                break;
            }
            case "submit": {
                this.checkSpecificPermission(appId, orgId, manuOrgId, PermitItemEnum.ITEM_SUBMIT, args);
                break;
            }
            case "unsubmit": {
                this.checkSpecificPermission(appId, orgId, manuOrgId, PermitItemEnum.ITEM_UNSUBMIT, args);
                break;
            }
            case "audit": {
                this.checkSpecificPermission(appId, orgId, manuOrgId, PermitItemEnum.ITEM_AUDIT, args);
                break;
            }
            case "unaudit": {
                this.checkSpecificPermission(appId, orgId, manuOrgId, PermitItemEnum.ITEM_UNAUDIT, args);
                break;
            }
        }
    }

    protected void checkSpecificPermission(String appId, String orgId, String manuOrgId, PermitItemEnum permitItem, BeforeDoOperationEventArgs args) {
        if (!CadEmptyUtils.isEmpty((String)orgId) && !PermissionHelper.checkPermission((String)appId, (long)Long.parseLong(orgId), (String)this.getBillEntityId(), (String)permitItem.getKey())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PermissionBillPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getBillEntityName(), PermitItemEnum.getDesc(permitItem.getKey())));
            args.setCancel(true);
            return;
        }
        if (!CadEmptyUtils.isEmpty((String)manuOrgId) && !PermissionHelper.checkPermission((String)appId, (long)Long.parseLong(manuOrgId), (String)this.getBillEntityId(), (String)permitItem.getKey())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u751f\u4ea7\u7ec4\u7ec7\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PermissionBillPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getBillEntityName(), PermitItemEnum.getDesc(permitItem.getKey())));
            args.setCancel(true);
        }
    }

    public String getManuOrgKey() {
        return this.manuOrgKey;
    }

    public String getOrgKey() {
        return this.orgKey;
    }
}

