/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.base;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.base.PermitItemEnum;

public class PermissionListPlugin
extends AbstractListPlugin {
    private static final String manuOrgCacheKey = "manuorg";
    private static final String orgCacheKey = "org";
    private String listKey = "[";
    private int listMinLen = 2;
    private boolean continueOp = true;

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    protected String getBillEntityName() {
        return ((IListView)this.getView()).getFormShowParameter().getCaption().replaceAll(ResManager.loadKDString((String)"\u5217\u8868", (String)"PermissionListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), "");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        String appId = this.getView().getFormShowParameter().getAppId();
        String orgId = this.getPageCache().get(this.getOrgCacheKey());
        orgId = this.arrayToStr(orgId);
        switch (operateKey) {
            case "new": {
                this.checkSpecificPermission(appId, orgId, PermitItemEnum.ITEM_NEW, args);
                break;
            }
            case "copy": {
                this.checkSpecificPermission(appId, orgId, PermitItemEnum.ITEM_COPY, args);
                break;
            }
            case "modify": {
                this.checkSpecificPermission(appId, orgId, PermitItemEnum.ITEM_MODIFY, args);
                break;
            }
            case "delete": {
                this.checkSpecificPermission(appId, orgId, PermitItemEnum.ITEM_DELETE, args);
                break;
            }
            case "submit": {
                this.checkSpecificPermission(appId, orgId, PermitItemEnum.ITEM_SUBMIT, args);
                break;
            }
            case "unsubmit": {
                this.checkSpecificPermission(appId, orgId, PermitItemEnum.ITEM_UNSUBMIT, args);
                break;
            }
            case "audit": {
                this.checkSpecificPermission(appId, orgId, PermitItemEnum.ITEM_AUDIT, args);
                break;
            }
            case "unaudit": {
                this.checkSpecificPermission(appId, orgId, PermitItemEnum.ITEM_UNAUDIT, args);
                break;
            }
            default: {
                this.checkSpecificPermission(appId, orgId, PermitItemEnum.ITEM_VIEW, args);
            }
        }
    }

    protected void checkSpecificPermission(String appId, String orgId, PermitItemEnum permitItem, BeforeDoOperationEventArgs args) {
        if (!CadEmptyUtils.isEmpty((String)orgId) && !PermissionHelper.checkPermission((String)appId, (long)Long.parseLong(orgId), (String)this.getBillEntityId(), (String)permitItem.getKey())) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u65e0\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u6743\u9650\u3002", (String)"PermissionListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getBillEntityName(), PermitItemEnum.getDesc(permitItem.getKey())));
            this.continueOp = false;
            args.setCancel(true);
        }
    }

    private String arrayToStr(String serialStr) {
        if (StringUtils.isNotNull((String)serialStr) && serialStr.startsWith(this.listKey) && serialStr.length() > this.listMinLen) {
            List list = (List)SerializationUtils.fromJsonString((String)serialStr, List.class);
            serialStr = (String)list.get(0);
        }
        return serialStr;
    }

    public String getManuOrgCacheKey() {
        return manuOrgCacheKey;
    }

    public String getOrgCacheKey() {
        return orgCacheKey;
    }

    public boolean continueOperate() {
        return this.continueOp;
    }
}

