/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CalcRuleEditPlugin
extends AbstractBillPlugIn {
    private static Map<String, LocaleString> passYearValueAndCaption = new HashMap<String, LocaleString>(){
        {
            this.put("1", new LocaleString(ResManager.loadKDString((String)"\u672c\u5e74", (String)"CalcRuleEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("2", new LocaleString(ResManager.loadKDString((String)"\u4e0a\u5e74", (String)"CalcRuleEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("3", new LocaleString(ResManager.loadKDString((String)"\u4e0a\u4e0a\u5e74", (String)"CalcRuleEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        }
    };
    private static Map<String, LocaleString> futureYearValueAndCaption = new HashMap<String, LocaleString>(){
        {
            this.put("1", new LocaleString(ResManager.loadKDString((String)"\u672c\u5e74", (String)"CalcRuleEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("21", new LocaleString(ResManager.loadKDString((String)"\u4e0b\u5e74", (String)"CalcRuleEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("22", new LocaleString(ResManager.loadKDString((String)"\u4e0b\u4e0b\u5e74", (String)"CalcRuleEditPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        }
    };
    private static Map<String, LocaleString> passPeriodValueAndCaption = new HashMap<String, LocaleString>(){
        {
            this.put("1", new LocaleString(ResManager.loadKDString((String)"1 \u671f", (String)"CalcRuleEditPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("2", new LocaleString(ResManager.loadKDString((String)"2 \u671f", (String)"CalcRuleEditPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("3", new LocaleString(ResManager.loadKDString((String)"3 \u671f", (String)"CalcRuleEditPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("4", new LocaleString(ResManager.loadKDString((String)"4 \u671f", (String)"CalcRuleEditPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("5", new LocaleString(ResManager.loadKDString((String)"5 \u671f", (String)"CalcRuleEditPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("6", new LocaleString(ResManager.loadKDString((String)"6 \u671f", (String)"CalcRuleEditPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("7", new LocaleString(ResManager.loadKDString((String)"7 \u671f", (String)"CalcRuleEditPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("8", new LocaleString(ResManager.loadKDString((String)"8 \u671f", (String)"CalcRuleEditPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("9", new LocaleString(ResManager.loadKDString((String)"9 \u671f", (String)"CalcRuleEditPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("10", new LocaleString(ResManager.loadKDString((String)"10 \u671f", (String)"CalcRuleEditPlugin_18", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("11", new LocaleString(ResManager.loadKDString((String)"11 \u671f", (String)"CalcRuleEditPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("12", new LocaleString(ResManager.loadKDString((String)"12 \u671f", (String)"CalcRuleEditPlugin_20", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("13", new LocaleString(ResManager.loadKDString((String)"\u4e0a \u671f", (String)"CalcRuleEditPlugin_21", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("14", new LocaleString(ResManager.loadKDString((String)"\u672c \u671f", (String)"CalcRuleEditPlugin_22", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        }
    };
    private static Map<String, LocaleString> futurePeriodValueAndCaption = new HashMap<String, LocaleString>(){
        {
            this.put("1", new LocaleString(ResManager.loadKDString((String)"1 \u671f", (String)"CalcRuleEditPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("2", new LocaleString(ResManager.loadKDString((String)"2 \u671f", (String)"CalcRuleEditPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("3", new LocaleString(ResManager.loadKDString((String)"3 \u671f", (String)"CalcRuleEditPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("4", new LocaleString(ResManager.loadKDString((String)"4 \u671f", (String)"CalcRuleEditPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("5", new LocaleString(ResManager.loadKDString((String)"5 \u671f", (String)"CalcRuleEditPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("6", new LocaleString(ResManager.loadKDString((String)"6 \u671f", (String)"CalcRuleEditPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("7", new LocaleString(ResManager.loadKDString((String)"7 \u671f", (String)"CalcRuleEditPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("8", new LocaleString(ResManager.loadKDString((String)"8 \u671f", (String)"CalcRuleEditPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("9", new LocaleString(ResManager.loadKDString((String)"9 \u671f", (String)"CalcRuleEditPlugin_17", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("10", new LocaleString(ResManager.loadKDString((String)"10 \u671f", (String)"CalcRuleEditPlugin_18", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("11", new LocaleString(ResManager.loadKDString((String)"11 \u671f", (String)"CalcRuleEditPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            this.put("12", new LocaleString(ResManager.loadKDString((String)"12 \u671f", (String)"CalcRuleEditPlugin_20", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        }
    };

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.getControl("sourcebillfieldset") != null) {
            this.addClickListeners(new String[]{"sourcebillfieldset"});
        }
        ArrayList<Long> existElements = new ArrayList<Long>(10);
        ArrayList<Long> existPriceTypes = new ArrayList<Long>(10);
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(Boolean.TRUE.booleanValue()).getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            long element = dynamicObject.getLong("element.id");
            long priceType = dynamicObject.getLong("pricelisttype.id");
            if (!CadEmptyUtils.isEmpty((Long)element)) {
                existElements.add(element);
            }
            if (CadEmptyUtils.isEmpty((Long)priceType)) continue;
            existPriceTypes.add(priceType);
        }
        BasedataEdit element = (BasedataEdit)this.getControl("element");
        element.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            filterParameter.getQFilters().add(new QFilter("id", "not in", (Object)existElements));
        });
        BasedataEdit priceType = (BasedataEdit)this.getControl("pricelisttype");
        priceType.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            filterParameter.getQFilters().add(new QFilter("id", "not in", (Object)existPriceTypes));
        });
        BasedataEdit sourcebilll = (BasedataEdit)this.getControl("sourcebilll");
        sourcebilll.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            ArrayList<String> entityNumbers = new ArrayList<String>(10);
            entityNumbers.add("pm_purpricelist");
            entityNumbers.add("pm_purorderbill");
            entityNumbers.add("conm_purcontract");
            entityNumbers.add("cad_mfgfeeallocco");
            entityNumbers.add("cal_bal");
            QFilter entityFilter = new QFilter("number", "in", entityNumbers);
            qFilters.add(entityFilter);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("bindbill".equals(name)) {
            this.visibleField();
        } else if ("sourcebilll".equals(name)) {
            String sourcebilll = this.getModel().getDataEntity().getString("sourcebilll.id");
            if ("pm_purpricelist".equals(sourcebilll)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"advconap"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
                this.clearEntyEntity();
            }
            if ("cal_bal".equals(sourcebilll)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"manualspecified"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"matrange", "matcalcprop", "retroperiod"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"matrange", "matcalcprop", "retroperiod"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"manualspecified"});
            }
            this.changeTimeSelectComboItems(((DynamicObject)newValue).getString("id"));
        }
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manualspecified"});
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.enableField();
        this.visibleField();
        String billType = this.getModel().getValue("sourcebilll_id").toString();
        if (!CadEmptyUtils.isEmpty((String)billType)) {
            this.changeTimeSelectComboItems(billType);
        }
    }

    public void changeTimeSelectComboItems(String sourceBillType) {
        ComboEdit startYearComboEdit = (ComboEdit)this.getControl("startyears");
        ComboEdit endYearComboEdit = (ComboEdit)this.getControl("endyears");
        ComboEdit startMonthComboEdit = (ComboEdit)this.getControl("startpricetime");
        ComboEdit endMonthComboEdit = (ComboEdit)this.getControl("endpricetime");
        if ("cad_resourcplanrate".equals(sourceBillType)) {
            List<ComboItem> yearComboItems = this.getYearComboItems(futureYearValueAndCaption, true);
            startYearComboEdit.setComboItems(yearComboItems);
            endYearComboEdit.setComboItems(yearComboItems);
            List<ComboItem> periodComboItems = this.getYearComboItems(futurePeriodValueAndCaption, true);
            startMonthComboEdit.setComboItems(periodComboItems);
            endMonthComboEdit.setComboItems(periodComboItems);
        } else {
            List<ComboItem> items = this.getYearComboItems(passYearValueAndCaption, true);
            startYearComboEdit.setComboItems(items);
            endYearComboEdit.setComboItems(items);
            List<ComboItem> periodComboItems = this.getYearComboItems(passPeriodValueAndCaption, true);
            startMonthComboEdit.setComboItems(periodComboItems);
            endMonthComboEdit.setComboItems(periodComboItems);
        }
    }

    public List<ComboItem> getYearComboItems(Map<String, LocaleString> map, boolean asc) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(10);
        for (Map.Entry<String, LocaleString> entry : map.entrySet()) {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(entry.getValue());
            comboItem.setValue(entry.getKey());
            items.add(comboItem);
        }
        if (asc) {
            return items.stream().sorted(Comparator.comparing(x -> Integer.parseInt(x.getValue()))).collect(Collectors.toList());
        }
        return items.stream().sorted(Comparator.comparing(x -> Integer.parseInt(x.getValue())).reversed()).collect(Collectors.toList());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (c.getKey().equalsIgnoreCase("sourcebillfieldset")) {
            this.showCondition();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getActionId().equalsIgnoreCase("sourcebillfieldset")) {
            this.receiveCondition((String)e.getReturnData(), "ENTRYENTITY", "sourcebillfieldsetjson_tag", "sourcebillfieldset");
        }
    }

    private void visibleField() {
        String bindBill = this.getModel().getDataEntity().getString("bindbill");
        String sourcebilll = this.getModel().getDataEntity().getString("sourcebilll.id");
        Long id = this.getModel().getDataEntity().getLong("id");
        if ("B".equals(bindBill)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"pricetype", "manualspecified"});
            if ("cad_resourcplanrate".equals(sourcebilll)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"startyears", "endyears", "startpricetime", "endpricetime"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"startyears", "endyears", "startpricetime", "endpricetime"});
            }
            this.getModel().setValue("pricetype", null);
            this.getModel().setValue("manualspecified", null);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"pricetype", "manualspecified"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"startyears", "endyears", "startpricetime", "endpricetime"});
            this.getModel().setValue("startyears", null);
            this.getModel().setValue("endyears", null);
            this.getModel().setValue("startpricetime", null);
            this.getModel().setValue("endpricetime", null);
        }
        if ("A".equals(bindBill) && !id.equals(PriceRuleConstants.PUR_MANUALLY_ID) && !id.equals(PriceRuleConstants.PUR_STDCOST_ID)) {
            if ("conm_purcontract".equals(sourcebilll) || "pm_purorderbill".equals(sourcebilll) || "cal_bal".equals(sourcebilll)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
                this.clearEntyEntity();
            } else if ("pm_purpricelist".equals(sourcebilll)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"sourcebillfieldset"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"advconap"});
            this.clearEntyEntity();
        }
        if ("C".equals(bindBill)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"source"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"source"});
            this.getModel().setValue("source", null);
        }
        BasedataEdit sourceEdit = (BasedataEdit)this.getControl("source");
        sourceEdit.setMustInput("C".equals(bindBill));
        this.getView().updateView("source");
        ArrayList<Long> orderAndContract = new ArrayList<Long>(10);
        orderAndContract.add(PriceRuleConstants.PUR_RATE_ID);
        orderAndContract.add(PriceRuleConstants.OUTRES_RATE_ID);
        orderAndContract.add(PriceRuleConstants.OUTPRI_RATE_ID);
        orderAndContract.add(PriceRuleConstants.PUR_CONTRACT_ID);
        orderAndContract.add(PriceRuleConstants.OUTRES_CONTRACT_ID);
        orderAndContract.add(PriceRuleConstants.OUTPRI_CONTRACT_ID);
        if ("aca".equals(this.getView().getFormShowParameter().getAppId()) || !orderAndContract.contains(id)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"manualspecified"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"manualspecified"});
        }
        if ("conm_purcontract".equals(sourcebilll) || "pm_purorderbill".equals(sourcebilll)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"quoteday"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"quoteday"});
        }
        if ("conm_purcontract".equals(sourcebilll) || "pm_purorderbill".equals(sourcebilll) || "pm_purpricelist".equals(sourcebilll)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"isrelatedtransaction"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"isrelatedtransaction"});
        }
        if ("cal_bal".equals(sourcebilll)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"matrange", "matcalcprop", "retroperiod"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"matrange", "matcalcprop", "retroperiod"});
        }
        this.getModel().setDataChanged(false);
    }

    private void clearEntyEntity() {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        entryentity.clear();
    }

    private void enableField() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"number", "name", "startyears", "endyears", "startpricetime", "endpricetime", "bindbill", "preset", "remark", "plugin"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"fs_baseinfo"});
            this.getView().updateView("fs_baseinfo");
        } else {
            boolean preset = this.getModel().getDataEntity().getBoolean("preset");
            HashSet numbers = Sets.newHashSet((Object[])new String[]{"10001", "10002", "10003", "10004", "10009"});
            if (preset) {
                String number = this.getModel().getDataEntity().getString("number");
                if (numbers.contains(number)) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"fs_baseinfo"});
                } else if ("10006".equals(number)) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "name", "bindbill", "preset", "remark", "plugin"});
                } else {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "name", "startyears", "endyears", "startpricetime", "endpricetime", "bindbill", "preset", "remark", "plugin"});
                }
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"sourcebilll"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String billType = this.getModel().getValue("sourcebilll_id").toString();
        String operateKey = operate.getOperateKey();
        if ("save".equals(operateKey) && "B".equals(this.getModel().getDataEntity().getString("bindbill"))) {
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            if (CadEmptyUtils.isEmpty((String)dynamicObject.getString("startyears")) || CadEmptyUtils.isEmpty((String)dynamicObject.getString("endyears")) || CadEmptyUtils.isEmpty((String)dynamicObject.getString("startpricetime")) || CadEmptyUtils.isEmpty((String)dynamicObject.getString("endpricetime"))) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u5e74\u5ea6\u3001\u7ed3\u675f\u5e74\u5ea6\u3001\u8d77\u59cb\u53d6\u4ef7\u65f6\u95f4\u53ca\u7ed3\u675f\u53d6\u4ef7\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalcRuleEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            } else {
                int endPriceTime;
                int startPriceTime;
                int startYears = Integer.parseInt(this.getModel().getDataEntity().getString("startyears"));
                int endYears = Integer.parseInt(this.getModel().getDataEntity().getString("endyears"));
                if ("cad_resourcplanrate".equals(billType)) {
                    if (endYears < startYears) {
                        e.setCancel(true);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7ed3\u675f\u5e74\u5ea6\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u5e74\u5ea6\u3002", (String)"CalcRuleEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                        return;
                    }
                } else if (endYears > startYears) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7ed3\u675f\u5e74\u5ea6\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u5e74\u5ea6\u3002", (String)"CalcRuleEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (endYears == startYears && (startPriceTime = Integer.parseInt(this.getModel().getDataEntity().getString("startpricetime"))) > (endPriceTime = Integer.parseInt(this.getModel().getDataEntity().getString("endpricetime")))) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u7ed3\u675f\u53d6\u4ef7\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u8d77\u59cb\u53d6\u4ef7\u65f6\u95f4\u3002", (String)"CalcRuleEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void showCondition() {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject sourcebilll = (DynamicObject)this.getModel().getDataEntity().get("sourcebilll");
        if (sourcebilll == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53d6\u4ef7\u6765\u6e90\u5355\u636e\u3002", (String)"CalcRuleEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        String number = sourcebilll.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        String conditionJson = (String)this.getModel().getValue("sourcebillfieldsetjson_tag", row);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType);
        TreeNode treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        String flsNodes = SerializationUtils.toJsonString((Object)treeNode);
        this.showConditionForm(conditionJson, dataEntityType.getName(), flsNodes, "sourcebillfieldset");
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msbd_pricecondition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String exprTran = condition.getExprDesc();
            if (StringUtils.isBlank((CharSequence)entryEntityKey)) {
                this.getModel().setValue(conditionFldKey, (Object)conditionJson);
                this.getModel().setValue(descFldKey, (Object)exprTran);
            } else {
                int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
                this.getModel().setValue(conditionFldKey, (Object)conditionJson, row);
                this.getModel().setValue(descFldKey, (Object)exprTran, row);
            }
        }
    }
}

