/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CalcRulePlanEditPlugin
extends AbstractBillPlugIn {
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initF7Filter();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        DynamicObjectCollection dynamicObjects;
        int seq;
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("purnewentry".equals(operateKey) || "purdeleteentry".equals(operateKey) || "purinsertentry".equals(operateKey) || "purmoveentryup".equals(operateKey) || "purmoveentrydown".equals(operateKey)) {
            DynamicObjectCollection purPricesEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("purpricesentry");
            for (DynamicObject purObj : purPricesEntry) {
                seq = purObj.getInt("seq");
                this.getModel().setValue("purlevel", (Object)seq, seq - 1);
            }
        }
        if ("selnewentry".equals(operateKey) || "seldeleteentry".equals(operateKey) || "selinsertentry".equals(operateKey) || "selmoveentryup".equals(operateKey) || "selmoveentrydown".equals(operateKey)) {
            dynamicObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection("selfresourceentry");
            for (DynamicObject obj : dynamicObjects) {
                seq = obj.getInt("seq");
                this.getModel().setValue("sereslevel", (Object)seq, seq - 1);
            }
        }
        if ("outrenewentry".equals(operateKey) || "outredeleteentry".equals(operateKey) || "outreinsertentry".equals(operateKey) || "outremoveentryup".equals(operateKey) || "outremoveentrydown".equals(operateKey)) {
            dynamicObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection("outresourceentry");
            for (DynamicObject obj : dynamicObjects) {
                seq = obj.getInt("seq");
                this.getModel().setValue("outreslevel", (Object)seq, seq - 1);
            }
        }
        if ("outprinewentry".equals(operateKey) || "outprideleteentry".equals(operateKey) || "outpriinsertentry".equals(operateKey) || "outprimoveentryup".equals(operateKey) || "outprimoveentrydown".equals(operateKey)) {
            dynamicObjects = this.getModel().getDataEntity(true).getDynamicObjectCollection("outpriceentry");
            for (DynamicObject obj : dynamicObjects) {
                seq = obj.getInt("seq");
                this.getModel().setValue("outprilevel", (Object)seq, seq - 1);
            }
        }
        if ("save".equals(operateKey)) {
            String invalid;
            if (e.getOperationResult().isSuccess() && (invalid = this.getPageCache().get("invalid")) != null) {
                MainEntityType rulePlan = EntityMetadataCache.getDataEntityType((String)"cad_calcruleplan");
                DynamicObject rulePlanObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(invalid), (DynamicObjectType)rulePlan);
                if (rulePlanObj != null) {
                    rulePlanObj.set("default", (Object)false);
                    SaveServiceHelper.update((DynamicObject)rulePlanObj);
                }
            }
            this.getPageCache().remove("invalid");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("purrule".equals(name) || "seresrule".equals(name) || "outresrule".equals(name) || "outprirule".equals(name)) {
            String entry;
            String string = "purrule".equals(name) ? "purpricesentry" : ("seresrule".equals(name) ? "selfresourceentry" : (entry = "outresrule".equals(name) ? "outresourceentry" : "outpriceentry"));
            String level = "purrule".equals(name) ? "purlevel" : ("seresrule".equals(name) ? "sereslevel" : ("outresrule".equals(name) ? "outreslevel" : "outprilevel"));
            DynamicObjectCollection purPricesEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(entry);
            for (DynamicObject purObj : purPricesEntry) {
                int seq = purObj.getInt("seq");
                this.getModel().setValue(level, (Object)seq, seq - 1);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        String costType;
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && !CadEmptyUtils.isEmpty((String)(costType = parentView.getPageCache().get("costtype")))) {
            this.getModel().setValue("costtype", (Object)Long.parseLong(costType));
        }
        this.enableField();
    }

    private void enableField() {
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"preset"});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"costtype", "number", "name", "remark"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"fieldmap", "fieldmap1", "fieldmap2", "fieldmap3"});
        } else {
            Boolean preset = this.getModel().getDataEntity().getBoolean("preset");
            if (preset.booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"costtype", "number", "name", "remark", "preset"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"fieldmap", "fieldmap1", "fieldmap2", "fieldmap3"});
            }
        }
    }

    private void initF7Filter() {
        String appId = this.getView().getFormShowParameter().getAppId();
        BasedataEdit costTypeInput = (BasedataEdit)this.getControl("costtype");
        costTypeInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject[] costTypes = CostTypeHelper.getCostType((int)1);
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (DynamicObject costType : costTypes) {
                ids.add(costType.getLong("id"));
            }
            if (!ids.isEmpty()) {
                qFilters.add(new QFilter("id", "in", ids));
            }
        });
        BasedataEdit purRule = (BasedataEdit)this.getControl("purrule");
        purRule.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("purpricesentry");
            HashSet<Long> ids = new HashSet<Long>(10);
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObject obj = dynamicObject.getDynamicObject("purrule");
                if (obj == null) continue;
                ids.add(obj.getLong("id"));
            }
            if ("aca".equals(appId)) {
                ids.add(PriceRuleConstants.PUR_STDCOST_ID);
            }
            if (!ids.isEmpty()) {
                filters.add(new QFilter("id", "not in", ids));
            }
            filters.add(new QFilter("bindbill", "=", (Object)"A"));
        });
        BasedataEdit seResRule = (BasedataEdit)this.getControl("seresrule");
        seResRule.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("selfresourceentry");
            HashSet<Long> ids = new HashSet<Long>(10);
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObject obj = dynamicObject.getDynamicObject("seresrule");
                if (obj == null) continue;
                ids.add(obj.getLong("id"));
            }
            if ("aca".equals(appId)) {
                ids.add(PriceRuleConstants.SELFRES_STDCOST_ID);
            }
            if (!ids.isEmpty()) {
                filters.add(new QFilter("id", "not in", ids));
            }
            filters.add(new QFilter("bindbill", "=", (Object)"B"));
        });
        BasedataEdit outResRule = (BasedataEdit)this.getControl("outresrule");
        outResRule.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("outresourceentry");
            HashSet<Long> ids = new HashSet<Long>(10);
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObject obj = dynamicObject.getDynamicObject("outresrule");
                if (obj == null) continue;
                ids.add(obj.getLong("id"));
            }
            if ("aca".equals(appId)) {
                ids.add(PriceRuleConstants.OUTRES_STDCOST_ID);
            }
            if (!ids.isEmpty()) {
                filters.add(new QFilter("id", "not in", ids));
            }
            filters.add(new QFilter("bindbill", "=", (Object)"C"));
        });
        BasedataEdit outPriRule = (BasedataEdit)this.getControl("outprirule");
        outPriRule.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("outpriceentry");
            HashSet<Long> ids = new HashSet<Long>(10);
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObject obj = dynamicObject.getDynamicObject("outprirule");
                if (obj == null) continue;
                ids.add(obj.getLong("id"));
            }
            if ("aca".equals(appId)) {
                ids.add(PriceRuleConstants.OUTPRI_STDCOST_ID);
            }
            if (!CadEmptyUtils.isEmpty(ids)) {
                filters.add(new QFilter("id", "not in", ids));
            }
            filters.add(new QFilter("bindbill", "=", (Object)"D"));
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String opKey = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(opKey)) {
            if (this.getPageCache().get("confirmCopy") == null) {
                long costType = this.getModel().getDataEntity().getLong("costtype.id");
                boolean flag = this.getModel().getDataEntity().getBoolean("default");
                if (!CadEmptyUtils.isEmpty((Long)costType) && flag) {
                    QFilter filter = new QFilter("costtype", "=", (Object)costType);
                    filter.and("default", "=", (Object)true);
                    filter.and("id", "!=", (Object)this.getModel().getDataEntity().getLong("id"));
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_calcruleplan", (String)"id,name,number", (QFilter[])new QFilter[]{filter});
                    if (dynamicObject != null) {
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmCopy", (IFormPlugin)this);
                        String confirmTip = ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u7c7b\u578b\u4e0b\u5df2\u7ecf\u6709\u9ed8\u8ba4\u65b9\u6848\uff0c\u662f\u5426\u5c06\u5f53\u524d\u9009\u4e2d\u65b9\u6848\u8bbe\u4e3a\u9ed8\u8ba4\u65b9\u6848\uff1f", (String)"CalcRulePlanEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                        this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                        e.setCancel(true);
                        this.getPageCache().put("confirmCopy", "true");
                        this.getPageCache().put("invalid", dynamicObject.getString("id"));
                        return;
                    }
                }
            }
            this.getPageCache().remove("confirmCopy");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "confirmCopy": {
                if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                    this.getView().invokeOperation("save", OperateOption.create());
                    break;
                }
                this.getPageCache().remove("confirmCopy");
                this.getPageCache().remove("invalid");
            }
        }
    }
}

