/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CenterManuOrgEditPlugin
extends AbstractBillPlugIn {
    private static final String KEY_REFRESH = "refresh";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initFilter();
    }

    private void initFilter() {
        BasedataEdit costCenterInput = (BasedataEdit)this.getControl("costcenter");
        costCenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter orgQf = new QFilter("accountorg", "=", (Object)org.getLong("id"));
            qFilters.add(orgQf);
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
            HashSet<Long> centerIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : dynamicObjects) {
                centerIds.add(dynamicObject.getLong("costcenter.id"));
            }
            if (!centerIds.isEmpty()) {
                QFilter existSelectFilter = new QFilter("id", "not in", centerIds);
                qFilters.add(existSelectFilter);
            }
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)dynamicObject)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CenterManuOrgEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long org = dynamicObject.getLong("id");
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)org, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            filters.add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "audit": {
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                break;
            }
            case "unaudit": {
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "unaudit": {
                this.checkUnAudit(args);
                break;
            }
            case "delete": {
                this.checkDelete(args);
            }
        }
    }

    private void checkDelete(BeforeDoOperationEventArgs e) {
        Date effectdate = this.getModel().getDataEntity().getDate("effectdate");
        if (effectdate != null) {
            String tips = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c%s\u5355\u636e\u5df2\u7ecf\u586b\u5145\u4e86\u751f\u6548\u65f6\u95f4/\u5931\u6548\u65f6\u95f4\uff0c\u9700\u8981\u901a\u8fc7\u53cd\u5ba1\u6838\u8d70\u53d8\u66f4\u6d41\u7a0b\u4fee\u6539\u6570\u636e\u3002", (String)"CenterManuOrgEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getModel().getDataEntity().getString("billno"));
            this.getView().showTipNotification(tips);
            e.setCancel(true);
        }
    }

    private void checkUnAudit(BeforeDoOperationEventArgs e) {
        QFilter qFilter = new QFilter("id", "=", (Object)this.getModel().getDataEntity().getLong("id"));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_centermanuorg", (String)"id,billno,expdate", (QFilter[])qFilter.toArray());
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!dynamicObject.getDate("expdate").before(new Date())) continue;
            String tips = String.format(ResManager.loadKDString((String)"%s\uff1a\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u6570\u636e\u5df2\u7ecf\u5931\u6548\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"CenterManuOrgEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]), dynamicObject.getString("billno"));
            this.getView().showTipNotification(tips);
            e.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initBillDefaultValue();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Date effectdate = this.getModel().getDataEntity().getDate("effectdate");
        if (effectdate != null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"billno"});
        }
    }

    private void initBillDefaultValue() {
        String appId;
        String manuorg;
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getView().getParentView().getPageCache();
        String orgs = pageCache.get("org");
        if (!CadEmptyUtils.isEmpty((String)orgs)) {
            List orgList = (List)SerializationUtils.fromJsonString((String)orgs, List.class);
            model.setValue("org", orgList.get(0));
        }
        if (!CadEmptyUtils.isEmpty((String)(manuorg = pageCache.get("manuorg")))) {
            model.setValue("manuorg", (Object)manuorg);
        }
        if (!CadEmptyUtils.isEmpty((String)(appId = this.getView().getFormShowParameter().getAppId()))) {
            model.setValue("appnum", (Object)appId);
        }
    }

    private List<QFilter> getInputQFilters(BeforeF7SelectEvent evt) {
        ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        return filterParameter.getQFilters();
    }
}

