/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.base.BaseOrgAndManuAndExpdateListPlugin;

public class CenterManuOrgListPlugin
extends BaseOrgAndManuAndExpdateListPlugin {
    @Override
    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter manuOrgQFilter = this.getManuOrgQFilter();
        if (manuOrgQFilter != null) {
            e.getQFilters().add(manuOrgQFilter);
        }
        e.setOrderBy("billno asc,effectdate desc");
    }

    protected QFilter getManuOrgQFilter() {
        String orgId;
        boolean enableMultiFactory;
        List<Object> orgIdList;
        QFilter manuOrgQf = null;
        String manuOrgId = this.getPageCache().get("manuorg");
        if (StringUtils.isEmpty((CharSequence)manuOrgId) && (orgIdList = this.getOrgCache()) != null && (enableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)Long.parseLong(orgId = String.valueOf(orgIdList.get(0)))))) {
            List userHasPermProOrgsByAccOrg = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)Long.valueOf(orgId), (String)this.getBillEntityId());
            if (!CadEmptyUtils.isEmpty((List)userHasPermProOrgsByAccOrg)) {
                userHasPermProOrgsByAccOrg.add(0L);
                manuOrgQf = new QFilter("manuorg", "in", (Object)userHasPermProOrgsByAccOrg);
            } else {
                manuOrgQf = new QFilter("manuorg", "=", (Object)0L);
            }
        }
        return manuOrgQf;
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "updatestand": {
                HashSet<Long> ids = new HashSet<Long>();
                ListSelectedRowCollection listSelectedData = e.getListSelectedData();
                for (ListSelectedRow listSelectedDatum : listSelectedData) {
                    ids.add(Long.parseLong(String.valueOf(listSelectedDatum.getPrimaryKeyValue())));
                }
                this.updateAllocStandData(ids);
                break;
            }
            case "unaudit": {
                this.checkUnAudit(e);
                break;
            }
            case "delete": {
                this.checkDelete(e);
            }
        }
    }

    private void checkDelete(BeforeDoOperationEventArgs e) {
        HashSet<Long> ids = new HashSet<Long>();
        ListSelectedRowCollection listSelectedData = e.getListSelectedData();
        for (ListSelectedRow listSelectedDatum : listSelectedData) {
            ids.add(Long.parseLong(String.valueOf(listSelectedDatum.getPrimaryKeyValue())));
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        qFilter.and("billstatus", "=", (Object)"A");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_centermanuorg", (String)"effectdate,billno", (QFilter[])qFilter.toArray());
        for (DynamicObject dynamicObject : dynamicObjects) {
            Date effectdate = dynamicObject.getDate("effectdate");
            if (effectdate == null) continue;
            String tips = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002%s\u5355\u636e\u5df2\u7ecf\u586b\u5145\u4e86\u751f\u6548\u65f6\u95f4/\u5931\u6548\u65f6\u95f4\uff0c\u9700\u8981\u901a\u8fc7\u53cd\u5ba1\u6838\u8d70\u53d8\u66f4\u6d41\u7a0b\u4fee\u6539\u6570\u636e\u3002", (String)"CenterManuOrgListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), dynamicObject.getString("billno"));
            this.getView().showTipNotification(tips);
            e.setCancel(true);
        }
    }

    private void checkUnAudit(BeforeDoOperationEventArgs e) {
        HashSet<Long> ids = new HashSet<Long>();
        ListSelectedRowCollection listSelectedData = e.getListSelectedData();
        for (ListSelectedRow listSelectedDatum : listSelectedData) {
            ids.add(Long.parseLong(String.valueOf(listSelectedDatum.getPrimaryKeyValue())));
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_centermanuorg", (String)"id,billno,expdate", (QFilter[])qFilter.toArray());
        for (DynamicObject dynamicObject : dynamicObjects) {
            if (!dynamicObject.getDate("expdate").before(new Date())) continue;
            String tips = String.format(ResManager.loadKDString((String)"%s\uff1a\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u6570\u636e\u5df2\u7ecf\u5931\u6548\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"CenterManuOrgListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]), dynamicObject.getString("billno"));
            this.getView().showTipNotification(tips);
            e.setCancel(true);
        }
    }

    private void updateAllocStandData(Set<Long> ids) {
        Date nowTime = new Date();
        QFilter qFilter = new QFilter("id", "in", ids);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("effectdate", "<=", (Object)nowTime);
        qFilter.and("expdate", ">=", (Object)nowTime);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_centermanuorg", (String)"id,manuorg,entryentity.costcenter costcenterid", (QFilter[])qFilter.toArray());
        HashMap<Long, Long> centerAndManuMap = new HashMap<Long, Long>(20);
        HashSet<Long> centerIds = new HashSet<Long>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            Long costCenterId = dynamicObject.getLong("costcenterid");
            Long manuorgId = dynamicObject.getLong("manuorg");
            centerIds.add(costCenterId);
            centerAndManuMap.put(costCenterId, manuorgId);
        }
        HashSet<String> entitySet = new HashSet<String>();
        entitySet.add("sca_workqtycollec");
        entitySet.add("sca_diycostdriver");
        entitySet.add("cad_mfgfeebill");
        entitySet.add("cad_nonprodalloc");
        entitySet.add("cad_basicalloc");
        entitySet.add("cad_auxprodalloc");
        entitySet.add("sca_mfgfeeallocstdnew");
        entitySet.add("sca_overheadallotcost");
        Long orgId = Long.parseLong(String.valueOf(this.getOrgCache().get(0)));
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("costcenter", "in", centerIds);
        for (String entityNumber : entitySet) {
            DynamicObjectCollection resultObjs = QueryServiceHelper.query((String)entityNumber, (String)"id,manuorg,costcenter", (QFilter[])filter.toArray());
            ArrayList paramsList = new ArrayList(20);
            for (DynamicObject resultObj : resultObjs) {
                Long manuId = (Long)centerAndManuMap.get(resultObj.getLong("costcenter"));
                if (manuId == null) continue;
                SqlParameter[] params = new SqlParameter[]{new SqlParameter("fmanuorgid", -5, (Object)manuId), new SqlParameter("fid", -5, (Object)resultObj.getLong("id"))};
                paramsList.add(params);
            }
            if (paramsList.isEmpty()) continue;
            MainEntityType mt = EntityMetadataCache.getDataEntityType((String)entityNumber);
            this.doExecuteBatch(paramsList, mt);
        }
        QFilter mfgFeeFilter = new QFilter("org", "=", (Object)orgId);
        mfgFeeFilter.and("benefcostcenter", "in", centerIds);
        DynamicObjectCollection mfgFeeObjects = QueryServiceHelper.query((String)"cad_mfgfeeallocco", (String)"id,manuorg,benefcostcenter", (QFilter[])mfgFeeFilter.toArray());
        ArrayList<SqlParameter[]> mfgFeeParams = new ArrayList<SqlParameter[]>(20);
        for (DynamicObject dynamicObject : mfgFeeObjects) {
            Long manuId = (Long)centerAndManuMap.get(dynamicObject.getLong("benefcostcenter"));
            if (manuId == null) continue;
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("fmanuorgid", -5, (Object)manuId), new SqlParameter("fid", -5, (Object)dynamicObject.getLong("id"))};
            mfgFeeParams.add(params);
        }
        if (!mfgFeeParams.isEmpty()) {
            MainEntityType mt = EntityMetadataCache.getDataEntityType((String)"cad_mfgfeeallocco");
            DB.executeBatch((DBRoute)new DBRoute("cal"), (String)String.format("update %s set fmanuorgid= ? where fid= ?", mt.getAlias()), mfgFeeParams);
        }
    }

    private void doExecuteBatch(List<Object[]> paramsList, MainEntityType mt) {
        DB.executeBatch((DBRoute)new DBRoute("cal"), (String)String.format("update %s set fmanuorgid= ? where fid= ?", mt.getAlias()), paramsList);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String fieldName = e.getFieldName();
        if (fieldName.startsWith("org")) {
            List orgEnableMultiFactoryIds = OrgHelper.getOrgEnableMultiFactory((List)OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId()));
            e.getQfilters().add(new QFilter("id", "in", (Object)orgEnableMultiFactoryIds));
        }
    }
}

