/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CheckItemEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CheckItemEdit.class);
    private static final String CHECKMODE = "checkmode";
    private static final String BIZOBJECT = "bizobject";
    private static final String CUSTOMFILTERTEXT = "customfiltertext";
    private static final String CUSTOMFILTER_TAG = "customfilter_tag";
    private static final String PLUGIN = "plugin";
    private static final String[] scaBizAppIds = new String[]{"sca", "cad", "cal", "calx"};
    private static final String[] acaBizAppIds = new String[]{"aca", "cad", "cal", "calx"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CUSTOMFILTERTEXT});
        this.addF7Listener(this, BIZOBJECT);
    }

    private void addF7Listener(BeforeF7SelectListener form, String ... f7Name) {
        for (String str : f7Name) {
            BasedataEdit f7Control = (BasedataEdit)this.getView().getControl(str);
            if (null == f7Control) continue;
            f7Control.addBeforeF7SelectListener(form);
        }
    }

    public void afterBindData(EventObject e) {
        String formId;
        Boolean isPreset;
        if (this.getModel().getValue(CHECKMODE) != null) {
            this.setFieldsView((String)this.getModel().getValue(CHECKMODE));
        }
        if ((isPreset = (Boolean)this.getModel().getValue("ispreset")).booleanValue()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "name", CHECKMODE, BIZOBJECT, CUSTOMFILTERTEXT, "description", "errorlog", "opsuggestion", PLUGIN, "ispreset"});
        }
        if (!"bos_list".equals(formId = this.getView().getParentView().getFormShowParameter().getFormId())) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "name", CHECKMODE, BIZOBJECT, CUSTOMFILTERTEXT, "description", "errorlog", "opsuggestion", PLUGIN, "ispreset"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_save"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        String entityId = "cad_checkitem";
        DynamicObject dataInfo = this.getModel().getDataEntity();
        String number = CodeRuleServiceHelper.getNumber((String)entityId, (DynamicObject)dataInfo, null);
        if (!CadEmptyUtils.isEmpty((String)number)) {
            this.getModel().setValue("number", (Object)number);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (CUSTOMFILTERTEXT.equals(key)) {
            this.doFilterClick(evt);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (CHECKMODE.equals(key)) {
            this.getModel().setValue(PLUGIN, null);
            this.getModel().setValue(BIZOBJECT, null);
            this.getModel().setValue(CUSTOMFILTERTEXT, null);
            this.getModel().setValue(CUSTOMFILTER_TAG, null);
            this.setFieldsView(this.getModel().getDataEntity().getString(CHECKMODE));
        } else if (BIZOBJECT.equals(key)) {
            this.getModel().setValue(CUSTOMFILTERTEXT, null);
            this.getModel().setValue(CUSTOMFILTER_TAG, null);
        } else if (CUSTOMFILTERTEXT.equals(key)) {
            this.getModel().beginInit();
            Object object = this.getModel().getValue(CUSTOMFILTERTEXT);
            if (null == object || object.equals("")) {
                this.getModel().setValue(CUSTOMFILTER_TAG, null);
            }
            this.getModel().endInit();
        }
    }

    private void setFieldsView(String checkMode) {
        switch (checkMode) {
            case "A": {
                this.getView().setVisible(Boolean.FALSE, new String[]{BIZOBJECT});
                this.getView().setVisible(Boolean.FALSE, new String[]{CUSTOMFILTERTEXT});
                this.getView().setVisible(Boolean.TRUE, new String[]{PLUGIN});
                TextEdit plugin = (TextEdit)this.getControl(PLUGIN);
                plugin.setMustInput(true);
                break;
            }
            case "B": {
                this.getView().setVisible(Boolean.TRUE, new String[]{BIZOBJECT});
                this.getView().setVisible(Boolean.TRUE, new String[]{CUSTOMFILTERTEXT});
                this.getView().setVisible(Boolean.FALSE, new String[]{PLUGIN});
                break;
            }
        }
    }

    private void doFilterClick(EventObject evt) {
        DynamicObject entityObject = (DynamicObject)this.getModel().getValue(BIZOBJECT);
        if (entityObject == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9002\u7528\u5bf9\u8c61\u3002", (String)"CheckItemEdit_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
        String entityObjectId = String.valueOf(entityObject.getPkValue());
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityObjectId);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainEntityType);
        parameter.setIncludePKField(true);
        TreeNode nodes = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        String nodesJson = SerializationUtils.toJsonString((Object)nodes);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cad_condition");
        showParameter.setShowTitle(Boolean.FALSE.booleanValue());
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.getCustomParams().put("entityNumber", entityObjectId);
        String conditionJson = (String)this.getModel().getValue(CUSTOMFILTER_TAG);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CUSTOMFILTERTEXT));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key = closedCallBackEvent.getActionId();
        String returnData = (String)closedCallBackEvent.getReturnData();
        if (returnData != null && CUSTOMFILTERTEXT.equals(key)) {
            if (StringUtils.isBlank((String)returnData)) {
                this.getModel().setValue(CUSTOMFILTER_TAG, (Object)"");
                this.getModel().setValue(CUSTOMFILTERTEXT, (Object)"");
            } else {
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)returnData, CRCondition.class);
                this.getModel().setValue(CUSTOMFILTER_TAG, (Object)returnData);
                this.getModel().setValue(CUSTOMFILTERTEXT, (Object)condition.getExprTran());
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        String appNum = this.getView().getFormShowParameter().getAppId();
        if (BIZOBJECT.equals(key)) {
            QFilter filter = new QFilter("bizappid.number", "in", (Object)("sca".equals(appNum) ? scaBizAppIds : acaBizAppIds));
            filter.and(new QFilter("modeltype", "in", (Object)new String[]{"BillFormModel", "BaseFormModel"}));
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().setFilter(filter);
        }
    }
}

