/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ConfigBillLogListPlugin
extends AbstractListPlugin {
    private static final String ORG = "org";
    protected FilterContainerInitArgs filterContainerInitArgs = null;

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        List qFilters = e.getQFilters();
        QFilter filter = new QFilter("appnum", "=", (Object)appId);
        qFilters.add(filter);
        if (this.getView().getFormShowParameter() instanceof ListShowParameter && this.getView().getFormShowParameter() != null) {
            String billNo = (String)this.getView().getFormShowParameter().getCustomParam("billno");
            Object org = this.getView().getFormShowParameter().getCustomParam(ORG);
            Long orgId = org == null ? 0L : Long.parseLong(org.toString());
            if (!CadEmptyUtils.isEmpty((String)billNo)) {
                QFilter orgFilter = new QFilter(ORG, "=", (Object)orgId);
                QFilter numFilter = new QFilter("billno", "=", (Object)billNo);
                qFilters.add(orgFilter);
                qFilters.add(numFilter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean hasViewPermission;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("modify".equals(operateKey) && !(hasViewPermission = PermissionServiceHelper.hasViewPermission((long)RequestContext.get().getCurrUserId(), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()), (String)this.getBillEntityId()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u914d\u7f6e\u65b9\u6848\u53d8\u66f4\u65e5\u5fd7\u201d\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\u3002", (String)"ConfigBillLogListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List<Object> orgIdList = this.getOrgCache();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith(String.format("%s.", ORG))) continue;
            this.resetOrg(commonFilterColumn, orgIdList);
        }
        super.filterContainerInit(args);
    }

    protected List<Object> getOrgCache() {
        String orgId = this.getPageCache().get(ORG);
        if (StringUtils.isNotEmpty((String)orgId)) {
            return (List)SerializationUtils.fromJsonString((String)orgId, List.class);
        }
        return null;
    }

    protected void resetOrg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        Object org = this.getView().getFormShowParameter().getCustomParam(ORG);
        List listComItem = commonFilterColumn.getComboItems();
        listComItem.clear();
        List acctOrgs = OrgHelper.getOrgComboItems((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
            return;
        }
        commonFilterColumn.setComboItems(acctOrgs);
        ComboItem item = (ComboItem)acctOrgs.get(0);
        String defOrgId = item.getValue();
        orgIdList = CadEmptyUtils.isEmpty(orgIdList) ? (org == null ? Collections.singletonList(defOrgId) : Collections.singletonList(String.valueOf(org))) : Collections.singletonList(defOrgId);
        commonFilterColumn.setDefaultValues(orgIdList);
        this.putOrgCache(orgIdList);
    }

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    protected void putOrgCache(List<Object> vals) {
        this.getPageCache().put(ORG, SerializationUtils.toJsonString(vals));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        for (ListSelectedRow row : rows) {
            billList.setCellFieldValue("oprate", row.getRowKey(), (Object)ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"ConfigBillLogListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }
}

