/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.macc.cad.business.strategy.FilterStrategy;
import kd.macc.cad.business.strategy.IColsSelectStrategy;
import kd.macc.cad.business.strategy.MetaHelper;
import kd.macc.cad.business.strategy.SelectParams;

public class CosVolCalcDimensionEditPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"fieldname"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("fieldname".equals(key)) {
            this.clickFieldName();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        JSONArray data;
        super.closedCallBack(e);
        IDataModel model = this.getModel();
        model.beginInit();
        String closeKey = e.getActionId();
        int entryIndex = model.getEntryCurrentRowIndex("entryentity");
        if ("fieldNameCol".equals(closeKey) && (data = this.parseReturnData(e)) != null && !data.isEmpty()) {
            JSONObject info = data.getJSONObject(0);
            String field = info.getString("id");
            String fieldName = info.getString("text");
            model.setValue("fieldname", (Object)fieldName, entryIndex);
            model.setValue("field", (Object)field, entryIndex);
            this.getView().updateView("fieldname", entryIndex);
            this.getView().updateView("field", entryIndex);
        }
        model.endInit();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        model.beginInit();
        String name = e.getProperty().getName();
        if ("fieldname".equals(name)) {
            int entryIndex = model.getEntryCurrentRowIndex("entryentity");
            model.setValue("fieldname", null, entryIndex);
            model.setValue("field", null, entryIndex);
            this.getView().updateView("fieldname", entryIndex);
            this.getView().updateView("field", entryIndex);
        }
        if ("dimension".equals(name)) {
            String dimensionName = this.getDimensionName();
            model.setValue("name", (Object)dimensionName);
            this.getView().updateView("name");
        }
        model.endInit();
    }

    private String getDimensionName() {
        StringJoiner joiner = new StringJoiner("\uff1b");
        List<String> dimension = this.getDimensions(this.getModel().getDataEntity().getString("dimension"));
        if (dimension.isEmpty()) {
            return null;
        }
        Map<String, String> dimensionsMap = this.getDimensionsMap();
        for (String key : dimension) {
            joiner.add(dimensionsMap.get(key));
        }
        return joiner.toString();
    }

    private Map<String, String> getDimensionsMap() {
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("configuredcode", ResManager.loadKDString((String)"\u914d\u7f6e\u53f7", (String)"CosVolCalcDimensionEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        map.put("tracknumber", ResManager.loadKDString((String)"\u8ddf\u8e2a\u53f7", (String)"CosVolCalcDimensionEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        map.put("assist", ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"CosVolCalcDimensionEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        map.put("lot", ResManager.loadKDString((String)"\u6279\u53f7", (String)"CosVolCalcDimensionEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        map.put("project", ResManager.loadKDString((String)"\u9879\u76ee\u53f7", (String)"CosVolCalcDimensionEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        return map;
    }

    private List<String> getDimensions(String dimension) {
        String[] split;
        ArrayList<String> list = new ArrayList<String>(10);
        if (dimension == null) {
            return list;
        }
        dimension = dimension.substring(1, dimension.length() - 1);
        for (String item : split = dimension.split(",")) {
            list.add(item);
        }
        return list;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    private void clickFieldName() {
        SelectParams params = new SelectParams();
        MetaHelper metaHelper = new MetaHelper(this.buildTargetObjSelectStrategy("field", "entryentity"), "cad_keycol");
        metaHelper.setSecondDevelop(true);
        String jsonTree = metaHelper.buildTree2JSON();
        params.setJsonTree(jsonTree);
        FormShowParameter fp = this.readyColsTreePage(params, new CloseCallBack((IFormPlugin)this, "fieldNameCol"));
        fp.setCaption(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5377\u7b97\u7ef4\u5ea6\u6570\u636e\u8868\u4e2d\u7684\u201c\u4e8c\u5f00\u201d\u5b57\u6bb5\u3002", (String)"CosVolCalcDimensionEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().showForm(fp);
    }

    protected IColsSelectStrategy buildTargetObjSelectStrategy(String field, String entity) {
        ArrayList<String> existCols = new ArrayList<String>(16);
        DynamicObjectCollection fieldMap = this.getModel().getEntryEntity(entity);
        for (DynamicObject colMap : fieldMap) {
            String selectField = colMap.getString(field);
            if (!StringUtils.isNotEmpty((CharSequence)selectField)) continue;
            String[] splitKey = selectField.split("\\.");
            if (splitKey.length > 1) {
                selectField = splitKey[splitKey.length - 1];
            }
            existCols.add(selectField);
        }
        return new FilterStrategy(existCols);
    }

    protected FormShowParameter readyColsTreePage(SelectParams params, CloseCallBack callBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cad_colstree_select");
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(callBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    protected JSONArray parseReturnData(ClosedCallBackEvent evt) {
        Object data = evt.getReturnData();
        try {
            return JSON.parseArray((String)((String)data));
        }
        catch (Exception var3) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u6570\u636e\u89e3\u6790\u5931\u8d25\uff1a%1$s\uff0c \u53c2\u6570\uff1a%2$s", (String)"CosVolCalcDimensionEditPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]), var3.getMessage(), data));
        }
    }
}

