/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.macc.cad.business.strategy.FilterStrategy;
import kd.macc.cad.business.strategy.IColsSelectStrategy;
import kd.macc.cad.business.strategy.MetaHelper;
import kd.macc.cad.business.strategy.SelectParams;
import kd.macc.cad.business.strategy.SimpleStrategy;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostCalcDimensionEditPlugin
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"fieldname", "field"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.EDIT.equals((Object)status)) {
            boolean preset = this.getModel().getDataEntity().getBoolean("preset");
            if (preset) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "name", "level", "calcrule"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save"});
            }
            if ("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"level"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save"});
            }
        }
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"number", "name", "level", "calcrule"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("fieldname".equals(propertyName)) {
            ChangeData[] data = e.getChangeSet();
            for (int index = 0; index < data.length; ++index) {
                ChangeData changeData = data[index];
                Object newValue = changeData.getNewValue();
                if (newValue != null && !StringUtils.isBlank((Object)newValue)) continue;
                int rowIndex = changeData.getRowIndex();
                this.getModel().setValue("field", null, rowIndex);
                this.getView().updateView("field", rowIndex);
            }
            this.setRuleMustInput();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            this.setRuleMustInput();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("fieldname".equals(key)) {
            this.clickCostBillField();
        }
    }

    private void clickCostBillField() {
        IDataModel model = this.getModel();
        String caption = ResManager.loadKDString((String)"\u6210\u672c\u6838\u7b97\u5bf9\u8c61", (String)"CostCalcDimensionEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        this.showColsTreePage(this.getView(), "cad_costobject", this.buildTargetObjSelectStrategy("field", "entryentity"), new CloseCallBack((IFormPlugin)this, "fieldNameCol"), caption);
    }

    private void showColsTreePage(IFormView view, String entityNumber, IColsSelectStrategy strategy, CloseCallBack closeBack, String caption) {
        IColsSelectStrategy selectStrategy = strategy;
        if (strategy == null) {
            selectStrategy = new SimpleStrategy();
        }
        SelectParams params = new SelectParams();
        MetaHelper metaHelper = new MetaHelper(selectStrategy, entityNumber);
        metaHelper.setSecondDevelop(true);
        String jsonTree = metaHelper.buildTree2JSON();
        params.setJsonTree(jsonTree);
        FormShowParameter fp = this.readyColsTreePage(params, closeBack);
        if (StringUtils.isNotEmpty((CharSequence)caption)) {
            fp.setCaption(caption);
        }
        view.showForm(fp);
    }

    private FormShowParameter readyColsTreePage(SelectParams params, CloseCallBack callBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cad_colstree_select");
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(callBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    private IColsSelectStrategy buildTargetObjSelectStrategy(String field, String entity) {
        ArrayList<String> existCols = new ArrayList<String>(16);
        DynamicObjectCollection fieldMap = this.getModel().getEntryEntity(entity);
        for (DynamicObject colMap : fieldMap) {
            String selectField = colMap.getString(field);
            if (!StringUtils.isNotEmpty((CharSequence)selectField)) continue;
            String[] splitKey = selectField.split("\\.");
            if (splitKey.length > 1) {
                selectField = splitKey[splitKey.length - 1];
            }
            existCols.add(selectField);
        }
        return new FilterStrategy(existCols);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        model.beginInit();
        String closeKey = e.getActionId();
        int fieldMapIndex = model.getEntryCurrentRowIndex("entryentity");
        JSONArray data = this.parseReturnData(e);
        if (data == null || data.size() <= 0) {
            return;
        }
        JSONObject info = data.getJSONObject(0);
        if ("fieldNameCol".equals(closeKey)) {
            String costField = info.getString("id");
            model.setValue("fieldname", (Object)info.getString("text"), fieldMapIndex);
            model.setValue("field", (Object)costField, fieldMapIndex);
            this.getView().updateView("fieldname", fieldMapIndex);
            this.getView().updateView("field", fieldMapIndex);
            this.setRuleMustInput();
        }
        model.endInit();
    }

    private void setRuleMustInput() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        boolean mustInput = true;
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            for (DynamicObject entry : entryEntity) {
                String fieldName = entry.getString("fieldname");
                if (!StringUtils.isNotBlank((CharSequence)fieldName)) continue;
                mustInput = false;
                break;
            }
        }
        ComboEdit calcRule = (ComboEdit)this.getControl("calcrule");
        calcRule.setMustInput(mustInput);
    }

    private JSONArray parseReturnData(ClosedCallBackEvent evt) {
        Object data = evt.getReturnData();
        try {
            return JSON.parseArray((String)((String)data));
        }
        catch (Exception var3) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7684\u6570\u636e\u89e3\u6790\u5931\u8d25\uff1a%1$s\uff0c \u53c2\u6570\uff1a%2$s\u3002", (String)"CostCalcDimensionEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]), var3.getMessage(), data));
        }
    }
}

