/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.algox.function.TimeUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import org.apache.commons.lang3.StringUtils;

public class CostCenterGroupEditPlugin
extends AbstractBillPlugIn {
    private static final String KEY_REFRESH = "refresh";
    private static final String CONFIRM_BACK = "confirmSave";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initFilter();
    }

    private void initFilter() {
        BasedataEdit costCenterInput = (BasedataEdit)this.getControl("costcenter");
        costCenterInput.addBeforeF7SelectListener(evt -> {
            DynamicObject object = this.getModel().getDataEntity().getDynamicObject("org");
            List<QFilter> qFilters = this.getInputQFilters(evt);
            if (CadEmptyUtils.isEmpty((DynamicObject)object)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostCenterGroupEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long orgId = object.getLong("id");
            if (OrgHelper.isOrgEnableMultiFactory((Long)orgId)) {
                ArrayList<Long> manuOrgList = new ArrayList<Long>();
                DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("manuorg");
                if (CadEmptyUtils.isEmpty((DynamicObject)dynamicObject)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u751f\u4ea7\u65e5\u671f\u201d\u3002", (String)"CostCenterGroupEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                manuOrgList.add(dynamicObject.getLong("id"));
                Set costCenterIds = OrgHelper.getCenterIdsByManuOrgIds((Long)orgId, manuOrgList, (String)this.getView().getFormShowParameter().getAppId());
                if (costCenterIds.isEmpty()) {
                    qFilters.add(new QFilter("id", "=", (Object)-1));
                } else {
                    qFilters.add(new QFilter("id", "in", (Object)costCenterIds));
                }
            } else {
                QFilter orgQf = new QFilter("accountorg", "=", (Object)orgId);
                qFilters.add(orgQf);
            }
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
            HashSet<Long> centerIds = new HashSet<Long>();
            for (DynamicObject dynamicObject : dynamicObjects) {
                centerIds.add(dynamicObject.getLong("costcenter.id"));
            }
            if (!centerIds.isEmpty()) {
                QFilter existSelectFilter = new QFilter("id", "not in", centerIds);
                qFilters.add(existSelectFilter);
            }
        });
        BasedataEdit manuOrg = (BasedataEdit)this.getControl("manuorg");
        manuOrg.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostCenterGroupEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long orgId = org.getLong("id");
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getUserHasPermProOrgsByAccOrg((Long)orgId, (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            filters.add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        });
    }

    protected String getBillEntityId() {
        return this.getView().getModel().getDataEntityType().getName();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "audit": {
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
                break;
            }
            case "unaudit": {
                OperationResult operationResult = e.getOperationResult();
                if (operationResult.isSuccess()) {
                    DynamicObject[] dataEntities;
                    List successPkIds = operationResult.getSuccessPkIds();
                    boolean enableEffect = this.isEnableEffect();
                    if (!enableEffect) {
                        return;
                    }
                    Date nowTime = new Date();
                    ArrayList<DynamicObject> saveDataLIst = new ArrayList<DynamicObject>(successPkIds.size());
                    HashSet<Long> ids = new HashSet<Long>(16);
                    HashMap<String, Long> billIdMap = new HashMap<String, Long>(16);
                    for (DynamicObject dataEntity : dataEntities = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costcentergroup"))) {
                        DynamicObject newDataEntity = (DynamicObject)OrmUtils.clone((Object)dataEntity, (IDataEntityType)dataEntity.getDataEntityType(), (boolean)true, (boolean)true);
                        String number = dataEntity.getString("number") + "-" + DateUtils.formatDate((Date)new Date(), (String)"MMddHHmmss");
                        newDataEntity.set("number", (Object)number);
                        newDataEntity.set("expdate", (Object)nowTime);
                        newDataEntity.set("status", (Object)"C");
                        saveDataLIst.add(newDataEntity);
                        dataEntity.set("effectdate", (Object)nowTime);
                        dataEntity.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
                        billIdMap.put(number, dataEntity.getLong("id"));
                        ids.add(dataEntity.getLong("id"));
                    }
                    if (dataEntities != null) {
                        SaveServiceHelper.update((DynamicObject[])dataEntities);
                    }
                    QFilter qFilter = new QFilter("id", "in", ids);
                    DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"id,auditor,auditdate", (QFilter[])qFilter.toArray());
                    HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(20);
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        map.put(dynamicObject.getLong("id"), dynamicObject);
                    }
                    if (saveDataLIst.size() > 0) {
                        for (DynamicObject dynamicObject : saveDataLIst) {
                            DynamicObject oldBill = (DynamicObject)map.get(billIdMap.get(dynamicObject.getString("number")));
                            if (oldBill == null) continue;
                            dynamicObject.set("auditor", (Object)oldBill.getLong("auditor"));
                            dynamicObject.set("auditor_id", (Object)oldBill.getLong("auditor"));
                            dynamicObject.set("auditdate", (Object)oldBill.getDate("auditdate"));
                        }
                        SaveServiceHelper.save((DynamicObject[])saveDataLIst.toArray(new DynamicObject[0]));
                    }
                }
                this.getView().invokeOperation(KEY_REFRESH, OperateOption.create());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "save": {
                RefObject afterConfirm = new RefObject();
                if (operate.getOption().tryGetVariableValue(CONFIRM_BACK, afterConfirm)) break;
                this.checkCenterGroupIsExist(args);
                break;
            }
            case "unaudit": {
                this.checkUnAudit(args);
                break;
            }
            case "delete": {
                this.checkDelete(args);
            }
        }
    }

    private boolean isEnableEffect() {
        if (AppIdHelper.isSCA((IFormView)this.getView())) {
            return true;
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        boolean enableEffect = false;
        if (!CadEmptyUtils.isEmpty((DynamicObject)org)) {
            enableEffect = SysParamHelper.getEnableEffectByOrg((Long)org.getLong("id"), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()), (String)"cad_costcentergroup");
        }
        return enableEffect;
    }

    private void checkDelete(BeforeDoOperationEventArgs e) {
        Date effectdate;
        boolean enableEffect = this.isEnableEffect();
        if (enableEffect && (effectdate = this.getModel().getDataEntity().getDate("effectdate")) != null) {
            String tips = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002%s\u5355\u636e\u5df2\u7ecf\u586b\u5145\u4e86\u751f\u6548\u65f6\u95f4/\u5931\u6548\u65f6\u95f4\uff0c\u9700\u8981\u901a\u8fc7\u53cd\u5ba1\u6838\u8d70\u53d8\u66f4\u6d41\u7a0b\u4fee\u6539\u6570\u636e\u3002", (String)"CostCenterGroupEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getModel().getDataEntity().getString("number"));
            this.getView().showTipNotification(tips);
            e.setCancel(true);
        }
    }

    private void checkUnAudit(BeforeDoOperationEventArgs e) {
        boolean enableEffect = this.isEnableEffect();
        if (enableEffect) {
            QFilter qFilter = new QFilter("id", "=", (Object)this.getModel().getDataEntity().getLong("id"));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"id,number,expdate", (QFilter[])qFilter.toArray());
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!dynamicObject.getDate("expdate").before(new Date())) continue;
                String tips = String.format(ResManager.loadKDString((String)"%s\uff1a\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u6570\u636e\u5df2\u7ecf\u5931\u6548\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"CostCenterGroupEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]), dynamicObject.getString("number"));
                this.getView().showTipNotification(tips);
                e.setCancel(true);
            }
        }
    }

    private void checkCenterGroupIsExist(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        HashSet<Long> centerIds = new HashSet<Long>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            centerIds.add(dynamicObject.getLong("costcenter.id"));
        }
        Date nowTime = new Date();
        QFilter qFilter = new QFilter("entryentity.costcenter", "in", centerIds);
        qFilter.and("org", "=", (Object)this.getModel().getDataEntity().getLong("org.id"));
        qFilter.and("enable", "=", (Object)true);
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("effectdate", "<=", (Object)nowTime);
        qFilter.and("expdate", ">=", (Object)nowTime);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"id,number,entryentity.costcenter", (QFilter[])qFilter.toArray());
        if (!collection.isEmpty()) {
            HashMap<Long, List> map = new HashMap<Long, List>();
            for (DynamicObject dynamicObject : collection) {
                map.computeIfAbsent(dynamicObject.getLong("id"), s -> new ArrayList()).add(dynamicObject);
            }
            for (Map.Entry entry : map.entrySet()) {
                if (((List)entry.getValue()).size() != centerIds.size()) continue;
                String number = ((DynamicObject)((List)entry.getValue()).get(0)).getString("number");
                String tip = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u4e2d\u5fc3\u7ec4\u5408\u5728\u6210\u672c\u4e2d\u5fc3\u7ec4\u7f16\u7801\u201c%s\u201d\u4e2d\u5df2\u7ecf\u7ef4\u62a4\u4e86\u6210\u672c\u4e2d\u5fc3\u7ec4\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58\uff1f", (String)"CostCenterGroupEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]), number);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_BACK, (IFormPlugin)this);
                this.getView().showConfirm(tip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() == MessageBoxResult.Yes && StringUtils.equals((CharSequence)CONFIRM_BACK, (CharSequence)e.getCallBackId())) {
            OperateOption operationOption = OperateOption.create();
            operationOption.setVariableValue(CONFIRM_BACK, "true");
            this.getView().invokeOperation("save", operationOption);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initBillDefaultValue();
        Date effectdate = this.getModel().getDataEntity().getDate("effectdate");
        if (effectdate != null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
    }

    private void initBillDefaultValue() {
        IPageCache pageCache;
        String orgs;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        IDataModel model = this.getModel();
        if (OperationStatus.ADDNEW.equals((Object)status) && !CadEmptyUtils.isEmpty((String)(orgs = (pageCache = this.getView().getParentView().getPageCache()).get("org")))) {
            List orgList = (List)SerializationUtils.fromJsonString((String)orgs, List.class);
            Long orgId = Long.parseLong(String.valueOf(orgList.get(0)));
            model.setValue("org", (Object)orgId);
            boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)orgId);
            if (orgEnableMultiFactory) {
                this.setVisibleAndMust(true);
                String manuorg = pageCache.get("manuorg");
                if (!CadEmptyUtils.isEmpty((String)manuorg)) {
                    model.setValue("manuorg", (Object)manuorg);
                }
            } else {
                this.setVisibleAndMust(false);
                model.setValue("manuorg", (Object)0L);
            }
        }
        if (OperationStatus.EDIT.equals((Object)status)) {
            long org = this.getModel().getDataEntity().getLong("org.id");
            boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)org);
            if (orgEnableMultiFactory) {
                this.setVisibleAndMust(true);
            } else {
                this.setVisibleAndMust(false);
                model.setValue("manuorg", (Object)0L);
            }
        }
    }

    private List<QFilter> getInputQFilters(BeforeF7SelectEvent evt) {
        ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        return filterParameter.getQFilters();
    }

    private void setVisibleAndMust(boolean flag) {
        BasedataEdit wareHouse = (BasedataEdit)this.getControl("manuorg");
        wareHouse.setMustInput(flag);
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{"manuorg"});
    }
}

