/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.function.TimeUtils;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.SysParamHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;
import kd.macc.cad.formplugin.base.BaseManuorgListPlugin;

public class CostCenterGroupListPlugin
extends BaseManuorgListPlugin {
    private static final String ORG = "org";
    private static final String MANUORG = "manuorg";
    protected FilterContainerInitArgs filterContainerInitArgs = null;

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List<Object> orgIdList = this.getOrgCache();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.startsWith(String.format("%s.", ORG))) {
                this.resetOrg(commonFilterColumn, orgIdList);
            }
            if (!fieldName.startsWith("manuorg.")) continue;
            this.resetManuorg(commonFilterColumn, orgIdList);
        }
        super.filterContainerInit(args);
    }

    @Override
    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        Map filterValues = e.getSearchClickEvent().getFilterValues();
        List customFilter = (List)filterValues.get("customfilter");
        if (customFilter == null || customFilter.isEmpty()) {
            return;
        }
        for (int i = 0; i < customFilter.size(); ++i) {
            List vals;
            Map map = (Map)customFilter.get(i);
            List names = (List)map.get("FieldName");
            if (String.format("%s.id", ORG).equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (CadEmptyUtils.isEmpty((List)vals)) continue;
                this.putOrgCache(vals);
                this.filterContainerInit(this.filterContainerInitArgs);
            }
            if (!"manuorg.id".equals(String.valueOf(names.get(0))) || (vals = (List)map.get("Value")) == null || vals.isEmpty()) continue;
            this.getPageCache().put(MANUORG, String.valueOf(vals.get(0)));
        }
        super.filterContainerSearchClick(e);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "new": {
                this.checkParamIsSelect(e);
                break;
            }
            case "unaudit": {
                this.checkUnAudit(e);
                break;
            }
            case "delete": {
                this.checkDelete(e);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        OperationResult operationResult;
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("unaudit".equals(operateKey) && (operationResult = e.getOperationResult()).isSuccess()) {
            DynamicObject[] dataEntities;
            List successPkIds = operationResult.getSuccessPkIds();
            boolean enableEffect = this.isEnableEffect();
            if (!enableEffect) {
                return;
            }
            Date nowTime = new Date();
            ArrayList<DynamicObject> saveDataLIst = new ArrayList<DynamicObject>(successPkIds.size());
            HashSet<Long> ids = new HashSet<Long>(16);
            HashMap<String, Long> billIdMap = new HashMap<String, Long>(16);
            for (DynamicObject dataEntity : dataEntities = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cad_costcentergroup"))) {
                DynamicObject newDataEntity = (DynamicObject)OrmUtils.clone((Object)dataEntity, (IDataEntityType)dataEntity.getDataEntityType(), (boolean)true, (boolean)true);
                String number = dataEntity.getString("number") + "-" + DateUtils.formatDate((Date)new Date(), (String)"MMddHHmmss");
                newDataEntity.set("number", (Object)number);
                newDataEntity.set("expdate", (Object)nowTime);
                newDataEntity.set("status", (Object)"C");
                saveDataLIst.add(newDataEntity);
                dataEntity.set("effectdate", (Object)nowTime);
                dataEntity.set("expdate", (Object)TimeUtils.getDeFaultExpDate());
                billIdMap.put(number, dataEntity.getLong("id"));
                ids.add(dataEntity.getLong("id"));
            }
            if (dataEntities != null) {
                SaveServiceHelper.update((DynamicObject[])dataEntities);
            }
            QFilter qFilter = new QFilter("id", "in", ids);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"id,auditor,auditdate", (QFilter[])qFilter.toArray());
            HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(20);
            for (DynamicObject dynamicObject : dynamicObjects) {
                map.put(dynamicObject.getLong("id"), dynamicObject);
            }
            if (saveDataLIst.size() > 0) {
                for (DynamicObject dynamicObject : saveDataLIst) {
                    DynamicObject oldBill = (DynamicObject)map.get(billIdMap.get(dynamicObject.getString("number")));
                    if (oldBill == null) continue;
                    dynamicObject.set("auditor", (Object)oldBill.getLong("auditor"));
                    dynamicObject.set("auditor_id", (Object)oldBill.getLong("auditor"));
                    dynamicObject.set("auditdate", (Object)oldBill.getDate("auditdate"));
                }
                SaveServiceHelper.save((DynamicObject[])saveDataLIst.toArray(new DynamicObject[0]));
            }
        }
    }

    private boolean isEnableEffect() {
        if (AppIdHelper.isSCA((IFormView)this.getView())) {
            return true;
        }
        List<Object> orgCache = this.getOrgCache();
        boolean enableEffect = false;
        if (!CadEmptyUtils.isEmpty(orgCache)) {
            enableEffect = SysParamHelper.getEnableEffectByOrg((Long)Long.parseLong(String.valueOf(orgCache.get(0))), (String)AppIdHelper.getCurAppNum((IFormView)this.getView()), (String)"cad_costcentergroup");
        }
        return enableEffect;
    }

    private void checkDelete(BeforeDoOperationEventArgs e) {
        boolean enableEffect = this.isEnableEffect();
        if (enableEffect) {
            HashSet<Long> ids = new HashSet<Long>();
            ListSelectedRowCollection listSelectedData = e.getListSelectedData();
            for (ListSelectedRow listSelectedDatum : listSelectedData) {
                ids.add(Long.parseLong(String.valueOf(listSelectedDatum.getPrimaryKeyValue())));
            }
            QFilter qFilter = new QFilter("id", "in", ids);
            qFilter.and("status", "=", (Object)"A");
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"effectdate,number", (QFilter[])qFilter.toArray());
            for (DynamicObject dynamicObject : dynamicObjects) {
                Date effectdate = dynamicObject.getDate("effectdate");
                if (effectdate == null) continue;
                String tips = String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c%s\u5355\u636e\u5df2\u7ecf\u586b\u5145\u4e86\u751f\u6548\u65f6\u95f4/\u5931\u6548\u65f6\u95f4\uff0c\u9700\u8981\u901a\u8fc7\u53cd\u5ba1\u6838\u8d70\u53d8\u66f4\u6d41\u7a0b\u4fee\u6539\u6570\u636e\u3002", (String)"CostCenterGroupListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), dynamicObject.getString("number"));
                this.getView().showTipNotification(tips);
                e.setCancel(true);
            }
        }
    }

    private void checkUnAudit(BeforeDoOperationEventArgs e) {
        boolean enableEffect = this.isEnableEffect();
        if (enableEffect) {
            HashSet<Long> ids = new HashSet<Long>();
            ListSelectedRowCollection listSelectedData = e.getListSelectedData();
            for (ListSelectedRow listSelectedDatum : listSelectedData) {
                ids.add(Long.parseLong(String.valueOf(listSelectedDatum.getPrimaryKeyValue())));
            }
            QFilter qFilter = new QFilter("id", "in", ids);
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"cad_costcentergroup", (String)"id,number,expdate", (QFilter[])qFilter.toArray());
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (!dynamicObject.getDate("expdate").before(new Date())) continue;
                String tips = String.format(ResManager.loadKDString((String)"%s\uff1a\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u6570\u636e\u5df2\u7ecf\u5931\u6548\uff0c\u65e0\u6cd5\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"CostCenterGroupListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]), dynamicObject.getString("number"));
                this.getView().showTipNotification(tips);
                e.setCancel(true);
            }
        }
    }

    private void checkParamIsSelect(BeforeDoOperationEventArgs e) {
        List<Object> orgCache = this.getOrgCache();
        if (CadEmptyUtils.isEmpty(orgCache)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostCenterGroupListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    protected void putOrgCache(List<Object> vals) {
        this.getPageCache().put(ORG, SerializationUtils.toJsonString(vals));
    }

    protected List<Object> getOrgCache() {
        String orgId = this.getPageCache().get(ORG);
        if (StringUtils.isNotEmpty((String)orgId)) {
            return (List)SerializationUtils.fromJsonString((String)orgId, List.class);
        }
        return null;
    }

    public void resetManuorg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        Long orgId;
        List comboItems;
        List listComItem = commonFilterColumn.getComboItems();
        listComItem.clear();
        if (!CollectionUtils.isEmpty(orgIdList) && !CollectionUtils.isEmpty((Collection)(comboItems = ImportServiceHelper.getPermProOrgsByAccOrg((Long)(orgId = Long.valueOf(String.valueOf(orgIdList.get(0)))), (String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())))) {
            commonFilterColumn.setComboItems(comboItems);
        }
    }

    @Override
    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    protected void resetOrg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        List listComItem = commonFilterColumn.getComboItems();
        listComItem.clear();
        List acctOrgs = OrgHelper.getOrgComboItems((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
            return;
        }
        commonFilterColumn.setComboItems(acctOrgs);
        ComboItem item = (ComboItem)acctOrgs.get(0);
        String defOrgId = item.getValue();
        if (CadEmptyUtils.isEmpty(orgIdList)) {
            orgIdList = Collections.singletonList(defOrgId);
        }
        commonFilterColumn.setDefaultValues(orgIdList);
        this.putOrgCache(orgIdList);
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        Map<String, Date> dateMap = this.removeDateFilter(filters);
        this.setEffectDateFilter(filters, dateMap);
        e.setOrderBy("number asc,effectdate desc");
    }

    protected Map<String, Date> removeDateFilter(List<QFilter> filters) {
        HashMap<String, Date> result = new HashMap<String, Date>(8);
        Iterator<QFilter> iter = filters.iterator();
        while (iter.hasNext()) {
            QFilter filter = iter.next();
            if (!"expdate".equals(filter.getProperty())) continue;
            Date startDate = (Date)filter.getValue();
            Date endDate = (Date)((QFilter.QFilterNest)filter.getNests(true).get(0)).getFilter().getValue();
            result.put("startDate", startDate);
            result.put("endDate", endDate);
            iter.remove();
        }
        return result;
    }

    protected void setEffectDateFilter(List<QFilter> filters, Map<String, Date> dateMap) {
        if (dateMap.isEmpty()) {
            return;
        }
        Date startDate = dateMap.get("startDate");
        Date endDate = DateUtils.getLastSecond((Date)dateMap.get("endDate"), (int)1);
        QFilter dateFilter1 = new QFilter("effectdate", "<", (Object)startDate).and(new QFilter("expdate", ">=", (Object)startDate));
        QFilter dateFilter2 = new QFilter("effectdate", "<=", (Object)startDate).and(new QFilter("expdate", ">", (Object)startDate));
        QFilter dateFilter3 = new QFilter("effectdate", ">=", (Object)startDate).and(new QFilter("effectdate", "<", (Object)endDate));
        QFilter dateFilter4 = new QFilter("effectdate", ">", (Object)startDate).and(new QFilter("effectdate", "<=", (Object)endDate));
        filters.add(dateFilter1.or(dateFilter2).or(dateFilter3).or(dateFilter4));
    }
}

