/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.LongProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.business.config.service.CommonCollConfigService;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.business.strategy.IColsSelectStrategy;
import kd.macc.cad.business.strategy.MetaHelper;
import kd.macc.cad.business.strategy.SimpleStrategy;
import kd.macc.cad.common.constants.CostDimensionConstant;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.MultiLangUtils;
import kd.macc.cad.formplugin.basedata.CostCollectConfigBaseEditPlugin;

public class CostCollectConfigEditPlugin
extends CostCollectConfigBaseEditPlugin {
    private static final String amortAssgrpEntity = "sca_amortassgrp";

    public void initialize() {
        super.initialize();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        HashMap<String, Object> returnData = new HashMap<String, Object>();
        returnData.put("usestatus", this.getModel().getValue("usestatus"));
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object parentViewType = params.get("parentview");
        if ("costconfigbill".equals(parentViewType)) {
            returnData.put("indexinconfigplan", params.get("indexinconfigplan"));
            this.getView().returnDataToParent(returnData);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"costfieldname", "sourcefieldname", "costobjname", "srcbillname", "srcfieldid", "formuladesc", "showassgrp"});
        this.initF7Filter();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("costfieldname".equals(key)) {
            this.clickCostBillField();
        }
        if ("sourcefieldname".equals(key)) {
            this.clickSourceBillField();
        }
        if ("costobjname".equals(key)) {
            this.clickCostObjNameField();
        }
        if ("srcbillname".equals(key)) {
            this.clickSrcBillNameField();
        }
        if ("srcfieldid".equals(key)) {
            this.clickSrcFieldId();
        }
        if ("formuladesc".equals(key)) {
            this.clickFormula();
        }
        if ("showassgrp".equals(key)) {
            this.showAssgrpValue();
        }
    }

    private void showAssgrpValue() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId(amortAssgrpEntity);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        IDataModel model = this.getModel();
        long orgId = (Long)model.getValue("org_id");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", orgId);
        StringJoiner accountViewIds = new StringJoiner(",");
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)model.getValue("accountviews");
        for (DynamicObject dynamicObject : dynamicObjects) {
            accountViewIds.add(dynamicObject.getDynamicObject("fbasedataid").getString("id"));
        }
        map.put("accountId", accountViewIds.toString());
        map.put("assgrp", this.getModel().getValue("assgrp"));
        map.put("assgrpcondition", this.getModel().getValue("assgrpcondition"));
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, amortAssgrpEntity));
        this.getView().showForm(parameter);
    }

    private void clickFormula() {
        IDataModel model = this.getModel();
        DynamicObject sourceBill = (DynamicObject)model.getValue("sourcebill");
        if (sourceBill == null) {
            String tips = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5355\u636e\u3002", (String)"CostCollectConfigEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
        } else {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)sourceBill.getString("number"));
            SimpleStrategy selectStrategy = new SimpleStrategy();
            MetaHelper metaHelper = new MetaHelper((IColsSelectStrategy)selectStrategy, sourceBill.getString("number"));
            metaHelper.setFormulaCall(true);
            String jsonTree = metaHelper.buildTree2JSON();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getCustomParams().put("formula", "");
            showParameter.getCustomParams().put("entitynumber", dataEntityType.getName());
            showParameter.getCustomParams().put("treenodes", jsonTree);
            showParameter.setFormId("cad_calcformula");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "formulaCB"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        switch (proName = e.getProperty().getName()) {
            case "costbill": {
                this.setCostAccountVisible();
                break;
            }
            case "sourcebill": {
                this.sourceBillChange();
                this.costDimensionChange();
                this.specialField();
                this.setVouCherFieldVisible();
                this.setPayableBillFieldVisible();
                this.getModel().setValue("accountbook", null);
                this.getModel().setValue("accountviews", null);
                this.cleanAssgrp();
                break;
            }
            case "costcalcdimension": {
                this.costDimensionChange();
                break;
            }
            case "costfieldname": 
            case "sourcefieldname": {
                this.clearCostOrSourceField(e, proName);
                break;
            }
            case "srcbillname": 
            case "costobjname": {
                this.clearCostObjField(e, proName);
                break;
            }
            case "matchcostobj": {
                this.srcFiledVisible();
                break;
            }
            case "autogenerateobj": {
                this.autoGenCosObjChange();
                break;
            }
            case "selectvalue": {
                this.sourceTypeChange(e);
                break;
            }
            case "costdriver": 
            case "workactivity": {
                this.setMaterialGroupStdVisible();
                break;
            }
            case "accountbook": {
                this.getModel().setValue("accountviews", null);
                this.cleanAssgrp();
                break;
            }
            case "accountviews": {
                this.cleanAssgrp();
                break;
            }
            case "showassgrp": {
                if (!CadEmptyUtils.isEmpty((String)((String)this.getModel().getValue(proName)))) break;
                this.getModel().setValue("assgrp", null);
                this.getModel().setValue("assgrpcondition", null);
            }
        }
    }

    private void cleanAssgrp() {
        this.getModel().setValue("showassgrp", null);
        this.getModel().setValue("assgrp", null);
        this.getModel().setValue("assgrpcondition", null);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object parentViewType = params.get("parentview");
        if ("save".equals(key)) {
            this.dataRangeSave();
        }
        if ("mapdeleteentry".equals(key)) {
            this.mapEntryFieldDelCheck(e);
        }
        if ("ruledeleteentry".equals(key)) {
            this.ruleDeleteEntryCheck(e);
        }
        if ("disable_custom".equals(key) || "enable_custom".equals(key)) {
            Object oldUseStatus = this.getModel().getValue("usestatus");
            int status = "disable_custom".equals(key) ? 0 : 1;
            boolean needExecute = true;
            if (oldUseStatus != null && status == Integer.parseInt(oldUseStatus.toString())) {
                needExecute = false;
            }
            if (needExecute) {
                FormOperate operate = (FormOperate)e.getSource();
                operate.getOption().setVariableValue("use_status", status + "");
                operate.getOption().setVariableValue("need_execute", "1");
                operate.getOption().setVariableValue("id", this.getModel().getValue("id").toString());
                if (parentViewType != null) {
                    if ("costconfigbill".equals(parentViewType.toString())) {
                        operate.getOption().setVariableValue("parent_view_type", "costconfigbill");
                    } else if ("costconfiglist".equals(parentViewType.toString())) {
                        operate.getOption().setVariableValue("parent_view_type", "costconfiglist");
                    }
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object type = params.get("type");
        Object parentViewType = params.get("parentview");
        if (type != null) {
            if ("save".equals(operateKey) && "ADDNEW".equals(type.toString()) && operationResult.isSuccess()) {
                params.remove("type");
                Long id = this.getModel().getDataEntity().getLong("id");
                String sourceBillId = this.getModel().getDataEntity().getString("sourcebill.id");
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    IDataModel model = parentView.getModel();
                    int row = model.createNewEntryRow("configinfoentity");
                    model.setValue("costconfig", (Object)id, row);
                    model.setValue("sourcebill", (Object)sourceBillId, row);
                    model.setValue("usestatus", (Object)"1", row);
                    parentView.setEnable(Boolean.valueOf(false), new String[]{"number", "org", "costbill", "calmethod", "costcalcdimension"});
                } else {
                    Map customParams = this.getView().getFormShowParameter().getCustomParams();
                    if (customParams.get("configPlanId") != null) {
                        long configPlanId = Long.parseLong(String.valueOf(customParams.get("configPlanId")));
                        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_costconfigplan");
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)configPlanId, (DynamicObjectType)mainEntityType);
                        DynamicObjectCollection configInfoEntity = dynamicObject.getDynamicObjectCollection("configinfoentity");
                        DynamicObject config = configInfoEntity.addNew();
                        config.set("costconfig", (Object)id);
                        config.set("sourcebill", (Object)sourceBillId);
                        config.set("usestatus", (Object)"1");
                        config.set("seq", (Object)configInfoEntity.size());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    }
                }
                if (e.getOperationResult() != null && e.getOperationResult().isSuccess()) {
                    this.getView().invokeOperation("close", OperateOption.create());
                }
            }
            if (("disable_custom".equals(operateKey) || "enable_custom".equals(operateKey)) && "EDIT".equals(type.toString())) {
                int status;
                Object oldUseStatus = this.getModel().getValue("usestatus");
                String executeTip = "";
                String unExecuteTip = "";
                if ("disable_custom".equals(operateKey)) {
                    status = 0;
                    executeTip = ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f", (String)"CostCollectConfigEditPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    unExecuteTip = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u7981\u7528\u72b6\u6001", (String)"CostCollectConfigEditPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                } else {
                    status = 1;
                    executeTip = ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f", (String)"CostCollectConfigEditPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    unExecuteTip = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u542f\u7528\u72b6\u6001", (String)"CostCollectConfigEditPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                }
                boolean needExecute = true;
                if (oldUseStatus != null && status == Integer.parseInt(oldUseStatus.toString())) {
                    needExecute = false;
                }
                if (needExecute) {
                    this.getModel().setValue("usestatus", (Object)status);
                    this.getModel().setDataChanged(false);
                    this.getView().showSuccessNotification(executeTip);
                } else {
                    this.getView().showTipNotification(unExecuteTip);
                }
            }
        }
        if ("querylog".equals(operateKey)) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("cad_configbilllog");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            showParameter.getCustomParams().put("org", this.getModel().getDataEntity().getLong("org.id"));
            showParameter.getCustomParams().put("billno", this.getModel().getDataEntity().getString("number"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initOrgAndHideObjRule();
        this.filterDataRange();
        this.srcFiledVisible();
        this.initFieldEnable();
        this.autoGenCosObjChange();
        this.specialField();
    }

    private void setSecondDevelopDimen() {
        DynamicObject dimension = (DynamicObject)this.getModel().getValue("costcalcdimension");
        if (dimension != null) {
            DynamicObjectCollection costCalcDimension = dimension.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : costCalcDimension) {
                costObjNameMap.put(dynamicObject.getString("field"), CostCollectConfigEditPlugin.createMap(dynamicObject.getString("field"), dynamicObject.getString("fieldname")));
            }
        }
    }

    private void setCostAccountVisible() {
        Object costAccount;
        String costBill = this.getModel().getDataEntity().getString("costbill.id");
        boolean isCostDriver = "sca_diycostdriver".equals(costBill);
        boolean isWorkActivity = "sca_workqtycollec".equals(costBill);
        boolean isPlanResource = "cad_planresource".equals(costBill);
        boolean isCostAccountVisible = "cad_mfgfeebill".equals(costBill) || isCostDriver || isPlanResource;
        this.getView().setVisible(Boolean.valueOf(isCostAccountVisible), new String[]{"costaccount"});
        this.getView().setVisible(Boolean.valueOf("eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()))), new String[]{"advcontoolbarap2"});
        if (!isCostAccountVisible && (costAccount = this.getModel().getDataEntity().get("costaccount")) != null) {
            this.getModel().setValue("costaccount", null);
        }
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("costdriver");
        basedataEdit.setMustInput(isCostDriver || isWorkActivity);
        BasedataEdit workActivityEdit = (BasedataEdit)this.getControl("workactivity");
        workActivityEdit.setMustInput(isWorkActivity);
        this.getView().setVisible(Boolean.valueOf(isCostDriver || isWorkActivity), new String[]{"costdriver"});
        this.getView().setVisible(Boolean.valueOf(isWorkActivity), new String[]{"workactivity"});
        this.getView().setVisible(Boolean.valueOf(isCostDriver || isWorkActivity), new String[]{"ismergesource"});
    }

    private void setMaterialGroupStdVisible() {
        DynamicObject costDriver = (DynamicObject)this.getModel().getValue("costdriver");
        boolean isVisible = costDriver == null ? false : "MATERIALGROUP".equals(costDriver.getString("allocclass"));
        BasedataEdit groupStdEdit = (BasedataEdit)this.getControl("materialgroupstd");
        groupStdEdit.setMustInput(isVisible);
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"materialgroupstd"});
    }

    public void afterBindData(EventObject e) {
        OperationStatus status;
        super.afterBindData(e);
        this.setSecondDevelopDimen();
        this.setCostAccountVisible();
        this.setMaterialGroupStdVisible();
        this.setVouCherFieldVisible();
        this.setPayableBillFieldVisible();
        this.setDisableEnable();
        this.setStatus();
        String filter = (String)this.getModel().getDataEntity().get("filter_tag");
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            filterGrid.SetValue(filterCondition);
        }
        if (OperationStatus.ADDNEW.equals((Object)(status = this.getView().getFormShowParameter().getStatus()))) {
            String costBill = this.getModel().getDataEntity().getString("costbill.id");
            String sourceBill = this.getModel().getDataEntity().getString("sourcebill.id");
            String calMethod = this.getModel().getDataEntity().getString("calmethod");
            Long calcDimension = this.getModel().getDataEntity().getLong("costcalcdimension.id");
            String presetSourceFilter = "";
            presetSourceFilter = "eca".equals(this.getView().getFormShowParameter().getAppId()) && CostObjectEnum.BIZTYPE_CU.getValue().equals(calMethod) ? CommonCollConfigService.getPresetSourceFilter((String)costBill, (String)sourceBill, (String)CostObjectEnum.BIZTYPE_SW.getValue(), (Long)CostDimensionConstant.SW_ID, (String)this.getView().getFormShowParameter().getAppId()) : (CostObjectEnum.BIZTYPE_CU.getValue().equals(calMethod) || "sca_resourceuse".equals(costBill) ? CommonCollConfigService.getPresetSourceFilter((String)costBill, (String)sourceBill, (String)CostObjectEnum.BIZTYPE_RO.getValue(), (Long)CostDimensionConstant.RO_ID, (String)this.getView().getFormShowParameter().getAppId()) : CommonCollConfigService.getPresetSourceFilter((String)costBill, (String)sourceBill, (String)calMethod, (Long)calcDimension, (String)this.getView().getFormShowParameter().getAppId()));
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            if (StringUtils.isNotBlank((CharSequence)presetSourceFilter)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)presetSourceFilter, FilterCondition.class);
                filterGrid.SetValue(filterCondition);
            } else {
                FilterCondition filterCondition = new FilterCondition();
                if (this.isVouCherBill()) {
                    SimpleFilterRow fRow = new SimpleFilterRow();
                    fRow.setFieldName("ispost");
                    fRow.setCompareType("105");
                    fRow.setLogic("0");
                    FilterValue filterValue = new FilterValue();
                    filterValue.setValue((Object)"1");
                    fRow.setValue(Collections.singletonList(filterValue));
                    filterCondition.addFilterRow(fRow);
                    SimpleFilterRow sRow = new SimpleFilterRow();
                    sRow.setFieldName("sourcesys.number");
                    sRow.setCompareType("34");
                    sRow.setLogic("0");
                    ArrayList<FilterValue> value = new ArrayList<FilterValue>();
                    FilterValue cadFilterValue = new FilterValue();
                    cadFilterValue.setValue((Object)"cad");
                    value.add(cadFilterValue);
                    FilterValue scaFilterValue = new FilterValue();
                    scaFilterValue.setValue((Object)"sca");
                    value.add(scaFilterValue);
                    FilterValue acaFilterValue = new FilterValue();
                    acaFilterValue.setValue((Object)"aca");
                    value.add(acaFilterValue);
                    FilterValue ecaFilterValue = new FilterValue();
                    ecaFilterValue.setValue((Object)"eca");
                    value.add(ecaFilterValue);
                    sRow.setValue(value);
                    filterCondition.addFilterRow(sRow);
                } else if (this.isPayableBill()) {
                    SimpleFilterRow fRow = new SimpleFilterRow();
                    fRow.setFieldName("billstatus");
                    fRow.setCompareType("105");
                    fRow.setLogic("0");
                    FilterValue filterValue = new FilterValue();
                    filterValue.setValue((Object)"C");
                    fRow.setValue(Collections.singletonList(filterValue));
                    filterCondition.addFilterRow(fRow);
                    SimpleFilterRow dRow = new SimpleFilterRow();
                    dRow.setFieldName("biztype.domain");
                    dRow.setCompareType("105");
                    dRow.setLogic("0");
                    FilterValue doFilterValue = new FilterValue();
                    doFilterValue.setValue((Object)"5");
                    dRow.setValue(Collections.singletonList(doFilterValue));
                    filterCondition.addFilterRow(dRow);
                }
                filterGrid.SetValue(filterCondition);
            }
            this.getModel().setValue("appnum", (Object)this.getView().getFormShowParameter().getAppId());
        }
        if (this.getModel().getDataEntity().getString("costbill") != null && CostConfigService.configBillIsRef((String)this.getModel().getDataEntity().getString("costbill.id"), Collections.singleton(this.getModel().getDataEntity().getLong("id")))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"number"});
        }
        this.fillAssgrp();
    }

    private void setStatus() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("preset")) {
            int enable = (Integer)customParams.get("usestatus");
            this.getModel().setValue("usestatus", (Object)enable);
            this.getModel().setDataChanged(false);
        }
    }

    private void setDisableEnable() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("preset")) {
            boolean enable = (Boolean)customParams.get("preset");
            this.getView().setEnable(Boolean.valueOf(!enable), new String[]{"bar_disable_custom"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_disable_custom"});
        }
    }

    private void fillAssgrp() {
        String assgrp = (String)this.getModel().getValue("assgrp");
        if (StringUtils.isEmpty((CharSequence)assgrp)) {
            return;
        }
        Map assgrpMap = (Map)SerializationUtils.fromJsonString((String)assgrp, Map.class);
        if (CadEmptyUtils.isEmpty((Map)assgrpMap)) {
            return;
        }
        String assgrpCondition = (String)this.getModel().getValue("assgrpcondition");
        Map assgrpConditionMap = CadEmptyUtils.isEmpty((String)assgrpCondition) ? new HashMap(8) : (Map)SerializationUtils.fromJsonString((String)assgrpCondition, Map.class);
        StringBuilder sb = new StringBuilder();
        Map<String, String> asstactTypeMap = this.getAsstactTypeMap(assgrpMap);
        for (Map.Entry entrySet : assgrpMap.entrySet()) {
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (String value : (List)entrySet.getValue()) {
                ids.add(Long.parseLong(value));
            }
            String valuesourceStr = asstactTypeMap.get(entrySet.getKey());
            if (valuesourceStr == null) continue;
            String[] valuesourceArr = valuesourceStr.split("@");
            DynamicObjectCollection valueCollec = QueryServiceHelper.query((String)valuesourceArr[0], (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)valueCollec)) continue;
            String condition = (String)assgrpConditionMap.get(entrySet.getKey());
            if (CadEmptyUtils.isEmpty((String)condition)) {
                condition = ":";
            }
            sb.append(valuesourceArr[1]).append(" ").append(condition).append(" ");
            for (int i = 0; i < valueCollec.size(); ++i) {
                if (i + 1 < valueCollec.size()) {
                    sb.append(((DynamicObject)valueCollec.get(i)).getString("name")).append(',');
                    continue;
                }
                sb.append(((DynamicObject)valueCollec.get(i)).getString("name")).append(';');
            }
        }
        this.getModel().setValue("showassgrp", (Object)sb.toString());
        this.getModel().setDataChanged(false);
    }

    private Map<String, String> getAsstactTypeMap(Map<String, List<String>> assgrpMap) {
        Set<String> srcAssgrpNumSet = assgrpMap.keySet();
        DynamicObjectCollection asstactTypes = QueryServiceHelper.query((String)"bd_asstacttype", (String)"id, flexfield,valuetype,name, valuesource.number AS valuesourceNum, valuesource.name AS valuesourceName", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", srcAssgrpNumSet)});
        HashMap<String, String> asstactTypeMap = new HashMap<String, String>();
        for (DynamicObject asstactType : asstactTypes) {
            String valueType = asstactType.getString("valuetype");
            String valueSourceNum = asstactType.getString("valuesourceNum");
            String valueSourceName = asstactType.getString("valuesourceName");
            if ("1".equals(valueType)) {
                asstactTypeMap.put(asstactType.getString("flexfield"), valueSourceNum + "@" + valueSourceName);
            }
            if (!"2".equals(valueType)) continue;
            asstactTypeMap.put(asstactType.getString("flexfield"), "bos_assistantdata_detail@" + asstactType.getString("name"));
        }
        return asstactTypeMap;
    }

    private void setVouCherFieldVisible() {
        boolean isVouCherBill = this.isVouCherBill();
        this.getView().setVisible(Boolean.valueOf(isVouCherBill), new String[]{"accountbook", "bookstype", "accountviews", "showassgrp", "expenseitemamt"});
        BasedataEdit bookEdit = (BasedataEdit)this.getControl("accountbook");
        bookEdit.setMustInput(isVouCherBill);
        BasedataEdit accountEdit = (BasedataEdit)this.getControl("accountviews");
        accountEdit.setMustInput(isVouCherBill);
        MulComboEdit expenseItemAmtEdit = (MulComboEdit)this.getControl("expenseitemamt");
        expenseItemAmtEdit.setMustInput(isVouCherBill);
    }

    private void setPayableBillFieldVisible() {
        boolean payableBill = this.isPayableBill();
        this.getView().setVisible(Boolean.valueOf(payableBill), new String[]{"srcdatatype"});
        ComboEdit srcDataType = (ComboEdit)this.getControl("srcdatatype");
        srcDataType.setMustInput(payableBill);
    }

    private boolean isVouCherBill() {
        String costBill = this.getModel().getDataEntity().getString("costbill.id");
        String sourceBill = this.getModel().getDataEntity().getString("sourcebill.id");
        return "cad_mfgfeebill".equals(costBill) && "gl_voucher".equals(sourceBill);
    }

    private boolean isPayableBill() {
        String costBill = this.getModel().getDataEntity().getString("costbill.id");
        String sourceBill = this.getModel().getDataEntity().getString("sourcebill.id");
        return "cad_mfgfeebill".equals(costBill) && ("ap_finapbill".equals(sourceBill) || "ap_busbill".equals(sourceBill));
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        IDataModel model = this.getModel();
        model.beginInit();
        String closeKey = e.getActionId();
        int fieldMapIndex = model.getEntryCurrentRowIndex("fieldmapentity");
        int costInfoIndex = model.getEntryCurrentRowIndex("costruleinfoentity");
        if ("formulaCB".equals(closeKey)) {
            CRCondition formula;
            Object returnData = e.getReturnData();
            if (returnData != null && (formula = (CRCondition)SerializationUtils.fromJsonString((String)returnData.toString(), CRCondition.class)) != null) {
                this.getModel().setValue("formula", (Object)returnData.toString(), fieldMapIndex);
                this.getModel().setValue("formuladesc", (Object)formula.getExprDesc(), fieldMapIndex);
                this.getView().updateView("formula", fieldMapIndex);
                this.getView().updateView("formuladesc", fieldMapIndex);
            }
        } else if (amortAssgrpEntity.equals(closeKey)) {
            if (e.getReturnData() == null) {
                return;
            }
            Map resultMap = (Map)e.getReturnData();
            if (resultMap.get("value") != null) {
                String expression = (String)resultMap.get("express");
                String strObj = (String)resultMap.get("value");
                if (expression.length() > 100) {
                    expression = expression.substring(0, 100) + "...";
                }
                this.getModel().setValue("showassgrp", (Object)expression);
                this.getView().updateView("showassgrp");
                DynamicObject assgrpCollec = DynamicObjectHelper.fromDynamicString((String)strObj, (MainEntityType)EntityMetadataCache.getDataEntityType((String)amortAssgrpEntity));
                if (assgrpCollec != null) {
                    HashMap<String, List> srcAssgrpMap = new HashMap<String, List>(16);
                    HashMap<String, String> assgrpConditionMap = new HashMap<String, String>(16);
                    DynamicObjectCollection assgrpRows = assgrpCollec.getDynamicObjectCollection("entryentity");
                    for (DynamicObject assgrpRow : assgrpRows) {
                        DynamicObject assgrp = assgrpRow.getDynamicObject("fieldname");
                        DynamicObjectCollection assgrpValues = assgrpRow.getDynamicObjectCollection("value");
                        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)assgrpValues)) continue;
                        String condition = assgrpRow.getString("condition");
                        String assgrpFlexField = assgrp.getString("flexfield");
                        assgrpConditionMap.put(assgrpFlexField, condition);
                        for (int i = 0; i < assgrpValues.size(); ++i) {
                            srcAssgrpMap.computeIfAbsent(assgrpFlexField, s -> new ArrayList()).add(((DynamicObject)assgrpValues.get(i)).getString("fbasedataid_id"));
                        }
                    }
                    String jsonString = SerializationUtils.toJsonString(srcAssgrpMap);
                    this.getModel().setValue("assgrpcondition", (Object)SerializationUtils.toJsonString(assgrpConditionMap));
                    this.getModel().setValue("assgrp", (Object)jsonString);
                }
            }
        } else {
            JSONArray data = this.parseReturnData(e);
            if (data != null && data.size() > 0) {
                JSONObject info = data.getJSONObject(0);
                if (!data.isEmpty()) {
                    String costField;
                    if ("costFieldNameCol".equals(closeKey)) {
                        costField = info.getString("id");
                        model.setValue("costfieldname", (Object)info.getString("text"), fieldMapIndex);
                        model.setValue("costfield", (Object)costField, fieldMapIndex);
                        model.setValue("sourcefieldname", null, fieldMapIndex);
                        model.setValue("sourcefield", null, fieldMapIndex);
                        this.initFieldBySelValue("0", fieldMapIndex);
                        this.getView().updateView("costfieldname", fieldMapIndex);
                        this.getView().updateView("costfield", fieldMapIndex);
                        this.getView().updateView("selectvalue", fieldMapIndex);
                        this.getView().updateView("sourcefieldname", fieldMapIndex);
                        this.getView().updateView("sourcefield", fieldMapIndex);
                    }
                    if ("billFieldNameCol".equals(closeKey)) {
                        costField = (String)this.getModel().getValue("costfield");
                        if ("costcenter".equals(costField)) {
                            String sourceFieldName = (String)this.getModel().getValue("sourcefieldname");
                            String sourceField = (String)this.getModel().getValue("sourcefield");
                            if (sourceField.split(",").length >= 4) {
                                String tips = ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u7684\u53d6\u503c\u6765\u6e90\u4e3a\u6e90\u5355\u5b57\u6bb5\uff0c\u6700\u591a\u53ea\u80fd\u5339\u914d4\u4e2a\u6765\u6e90\u3002", (String)"CostCollectConfigEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                                this.getView().showTipNotification(tips);
                                return;
                            }
                            if (!CadEmptyUtils.isEmpty((String)sourceFieldName)) {
                                model.setValue("sourcefieldname", (Object)(sourceFieldName + "," + info.getString("text")), fieldMapIndex);
                            } else {
                                model.setValue("sourcefieldname", (Object)info.getString("text"), fieldMapIndex);
                            }
                            if (!CadEmptyUtils.isEmpty((String)sourceField)) {
                                model.setValue("sourcefield", (Object)(sourceField + "," + info.getString("id")), fieldMapIndex);
                            } else {
                                model.setValue("sourcefield", (Object)info.getString("id"), fieldMapIndex);
                            }
                        } else {
                            model.setValue("sourcefieldname", (Object)info.getString("text"), fieldMapIndex);
                            model.setValue("sourcefield", (Object)info.getString("id"), fieldMapIndex);
                        }
                        this.getView().updateView("sourcefieldname", fieldMapIndex);
                        this.getView().updateView("sourcefield", fieldMapIndex);
                    }
                    if ("costObjFieldNameCol".equals(closeKey)) {
                        model.setValue("costobjname", (Object)info.getString("text"), costInfoIndex);
                        model.setValue("costobjfield", (Object)info.getString("id"), costInfoIndex);
                        this.getView().updateView("costobjname", costInfoIndex);
                        this.getView().updateView("costobjfield", costInfoIndex);
                    }
                    if ("srcFieldNameCol".equals(closeKey)) {
                        model.setValue("srcbillname", (Object)info.getString("text"), costInfoIndex);
                        model.setValue("srcbillfield", (Object)info.getString("id"), costInfoIndex);
                        this.getView().updateView("srcbillname", costInfoIndex);
                        this.getView().updateView("srcbillfield", costInfoIndex);
                    }
                    if ("srcFieldIdNameCol".equals(closeKey)) {
                        model.setValue("srcfieldid", (Object)info.getString("id"));
                        this.getView().updateView("srcfieldid");
                    }
                }
            }
            model.endInit();
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        Object costBill = model.getValue("costbill");
        Object sourceBill = model.getValue("sourcebill");
        String langName = RequestContext.get().getLang().name();
        String sourceBillNumber = sourceBill instanceof DynamicObject ? ((DynamicObject)sourceBill).getString("number") : "";
        String costBillNumber = costBill instanceof DynamicObject ? ((DynamicObject)costBill).getString("number") : "";
        MainEntityType sourceBillDt = "".equals(sourceBillNumber) ? null : EntityMetadataCache.getDataEntityType((String)sourceBillNumber);
        MainEntityType targetObjDt = "".equals(costBillNumber) ? null : EntityMetadataCache.getDataEntityType((String)costBillNumber);
        int count = model.getEntryRowCount("fieldmapentity");
        for (int i = 0; i < count; ++i) {
            this.bindColNames(i, langName, sourceBillDt, targetObjDt);
        }
        model.setDataChanged(false);
    }

    private void bindColNames(int index, String langName, MainEntityType sourceBillDt, MainEntityType targetObjDt) {
        IDataModel model = this.getModel();
        String targetValue = String.valueOf(model.getValue("costfield", index));
        String sourceValue = String.valueOf(model.getValue("sourcefield", index));
        if (sourceBillDt != null && !"zh_CN".equals(langName) && StringUtils.isNotBlank((CharSequence)sourceValue)) {
            String sourceColName = MultiLangUtils.getEntityKeyWithLang((String)langName, (MainEntityType)sourceBillDt, (String)sourceValue);
            model.setValue("sourcefieldname", (Object)sourceColName, index);
        }
        if (targetObjDt != null && !"zh_CN".equals(langName) && StringUtils.isNotBlank((CharSequence)targetValue)) {
            String targetColName = MultiLangUtils.getEntityKeyWithLang((String)langName, (MainEntityType)targetObjDt, (String)targetValue);
            model.setValue("costfieldname", (Object)targetColName, index);
        }
    }

    private void sourceTypeChange(PropertyChangedArgs e) {
        String tips;
        this.getModel().beginInit();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        String oldVal = changeData.getOldValue().toString();
        String newVal = changeData.getNewValue().toString();
        int index = this.getModel().getEntryCurrentRowIndex("fieldmapentity");
        String costBillNum = this.getModel().getDataEntity().getString("costbill.id");
        String costField = (String)this.getModel().getValue("costfield", index);
        IDataEntityProperty property = this.getFieldType(costBillNum, costField);
        if (!(!"1".equals(newVal) || "isoutsource".equals(costField) || "isrework".equals(costField) || property instanceof DecimalProp || property instanceof LongProp)) {
            this.getModel().setValue("selectvalue", (Object)oldVal, index);
            this.getView().updateView("selectvalue", index);
            if (this.getPageCache().get("selValueChange") == null) {
                tips = ResManager.loadKDString((String)"\u53d6\u503c\u4e3a\u8ba1\u7b97\u516c\u5f0f\u65f6\u4ec5\u652f\u6301\u6210\u672c\u5355\u636e\u5b57\u6bb5\u4e3a\u59d4\u5916\u6216\u8fd4\u5de5\u6216\u6570\u503c\u7c7b\u578b\u7684\u914d\u7f6e\u3002", (String)"CostCollectConfigEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                this.getPageCache().put("selValueChange", "true");
            } else {
                this.getPageCache().remove("selValueChange");
            }
        }
        if ("2".equals(newVal)) {
            if (property instanceof BasedataProp) {
                ItemClassTypeEdit selectDimTypeFields = (ItemClassTypeEdit)this.getControl("sourcetype");
                ArrayList<String> entityIds = new ArrayList<String>(5);
                ArrayList<ComboItem> list = new ArrayList<ComboItem>(5);
                BasedataProp basedataProp = (BasedataProp)property;
                String baseEntityId = basedataProp.getBaseEntityId();
                this.getModel().setValue("sourcetype", (Object)baseEntityId, index);
                ComboItem comboItem = new ComboItem();
                comboItem.setId(baseEntityId);
                comboItem.setValue(baseEntityId);
                comboItem.setCaption(basedataProp.getDisplayName());
                list.add(comboItem);
                entityIds.add(baseEntityId);
                selectDimTypeFields.setComboItems(list);
                ItemClassTypeProp prop = (ItemClassTypeProp)selectDimTypeFields.getProperty();
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
                prop.setItemType((DynamicObjectType)mainType);
                prop.setBaseEntityIds(entityIds);
            } else {
                this.getModel().setValue("selectvalue", (Object)oldVal, index);
                this.getView().updateView("selectvalue", index);
                if (this.getPageCache().get("selValueChange") == null) {
                    tips = ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u5355\u636e\u5b57\u6bb5\u4e0d\u652f\u6301\u53d6\u503c=\u56fa\u5b9a\u503c\u7c7b\u578b\u7684\u914d\u7f6e\u3002", (String)"CostCollectConfigEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(tips);
                    this.getPageCache().put("selValueChange", "true");
                } else {
                    this.getPageCache().remove("selValueChange");
                }
            }
        }
        String selectVal = (String)this.getModel().getValue("selectvalue", index);
        this.initFieldBySelValue(selectVal, index);
        IFormView view = this.getView();
        view.updateView("sourcefieldname", index);
        view.updateView("sourcefield", index);
        view.updateView("formuladesc", index);
        view.updateView("formula", index);
        view.updateView("sourcedata", index);
        this.getModel().endInit();
    }

    private IDataEntityProperty getFieldType(String costBillNum, String costField) {
        String[] split = costField.split("\\.");
        costField = split.length == 1 ? split[0] : split[split.length - 1];
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)costBillNum);
        return mainEntityType.findProperty(costField);
    }

    private void autoGenCosObjChange() {
        boolean autoGenerateObj = this.getModel().getDataEntity().getBoolean("autogenerateobj");
        if (autoGenerateObj) {
            this.getModel().setValue("matchcostobj", (Object)false);
            this.getModel().setValue("srcfieldid", null);
        }
    }

    protected void initF7Filter() {
        BasedataEdit costAccountInput = (BasedataEdit)this.getControl("costaccount");
        costAccountInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnabledCostAccountIdsFilter((Long)org.getLong("id"), (String)this.getView().getFormShowParameter().getAppId());
            qFilters.add(enabledCostAccountIdsFilter);
        });
        BasedataEdit costBill = (BasedataEdit)this.getControl("costbill");
        costBill.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            HashSet<String> numbers = new HashSet<String>();
            if (this.isCosObjConfig()) {
                numbers.add("cad_costobject");
            } else {
                numbers.add("cad_factnedoutputbill");
                numbers.add("cad_plannedoutputbill");
                numbers.add("aca_matusecollect");
                numbers.add("sca_resourceuse");
            }
            QFilter numberFilter = new QFilter("number", "in", numbers);
            qFilters.add(numberFilter);
        });
        BasedataEdit costCalcDimension = (BasedataEdit)this.getControl("costcalcdimension");
        costCalcDimension.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            QFilter filter = new QFilter("preset", "=", (Object)false);
            filter.and("enable", "=", (Object)true);
            qFilters.add(filter);
        });
        BasedataEdit sourcedata = (BasedataEdit)this.getControl("sourcedata");
        sourcedata.addBeforeF7SelectListener(evt -> {
            int index = this.getModel().getEntryCurrentRowIndex("fieldmapentity");
            String sourceType = (String)this.getModel().getValue("sourcetype", index);
            if ("er_expenseitemedit".equals(sourceType)) {
                ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                QFilter filter = new QFilter("isleaf", "=", (Object)true);
                qFilters.add(filter);
            }
        });
        BasedataEdit costDriverInput = (BasedataEdit)this.getControl("costdriver");
        costDriverInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qList = filterParameter.getQFilters();
            qList.add(new QFilter("enable", "=", (Object)Character.valueOf('1')));
            qList.add(new QFilter("issys", "=", (Object)Boolean.FALSE));
            String costBillId = this.getModel().getDataEntity().getString("costbill.id");
            if ("sca_workqtycollec".equals(costBillId)) {
                qList.add(new QFilter("isrelatedwork", "=", (Object)Boolean.TRUE));
                DynamicObject workActivity = this.getModel().getDataEntity().getDynamicObject("workactivity");
                if (workActivity != null) {
                    qList.add(new QFilter("workactivity", "=", (Object)workActivity.getLong("id")));
                }
            } else {
                qList.add(new QFilter("isrelatedwork", "=", (Object)Boolean.FALSE));
            }
            qList.add(new QFilter("islinkresource", "=", (Object)Boolean.FALSE));
            qList.add(new QFilter("iscomplexcd", "=", (Object)Boolean.FALSE));
            String appnum = this.getView().getFormShowParameter().getAppId();
            qList.add(new QFilter("appnum", "=", (Object)appnum));
            if (!"aca".equals(appnum)) {
                qList.add(new QFilter("allocclass", "!=", (Object)"MATERIALGROUP"));
            }
        });
        BasedataEdit workActivityInput = (BasedataEdit)this.getControl("workactivity");
        workActivityInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qf = filterParameter.getQFilters();
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (org == null) {
                qf.add(new QFilter("createorg", "=", (Object)-1L));
                return;
            }
            QFilter orgQf = BaseDataServiceHelper.getBaseDataFilter((String)"cad_costdriver", (Long)org.getLong("id"));
            QFilter allocClassQf = new QFilter("allocclass", "=", (Object)"COSTCENTER");
            QFilter isrelatedworkQf = new QFilter("isrelatedwork", "=", (Object)Boolean.TRUE);
            QFilter appQf = AppIdHelper.getAppIdFilter((IFormView)this.getView());
            DynamicObject costDriver = this.getModel().getDataEntity().getDynamicObject("costdriver");
            if (costDriver != null) {
                orgQf.and(new QFilter("id", "=", (Object)costDriver.getLong("id")));
            }
            DynamicObjectCollection costDrivers = QueryServiceHelper.query((String)"cad_costdriver", (String)"id, workactivity", (QFilter[])new QFilter[]{allocClassQf, isrelatedworkQf, orgQf, appQf});
            HashSet workActivityIdsForCostCenterLv = new HashSet(16);
            costDrivers.forEach(e -> workActivityIdsForCostCenterLv.add(e.getLong("workactivity")));
            qf.add(new QFilter("id", "in", workActivityIdsForCostCenterLv));
        });
        BasedataEdit accountBook = (BasedataEdit)this.getControl("accountbook");
        accountBook.addBeforeF7SelectListener(evt -> {
            DynamicObject costAccount = this.getModel().getDataEntity().getDynamicObject("costaccount");
            if (CadEmptyUtils.isEmpty((DynamicObject)costAccount)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6210\u672c\u8d26\u8584\u3002", (String)"CostCollectConfigEditPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Long costId = costAccount.getLong("id");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)costId, (String)"cal_bd_costaccount");
            String fields = "id,number,bookstype.accounttype as accounttype";
            QFilter orgQF = new QFilter("accountingsys", "=", dynamicObject.get("calsystem.id"));
            QFilter costaccountQF = new QFilter("b_entry.b_relatebook.fbasedataid", "in", (Object)costId);
            QFilter[] qf = new QFilter[]{orgQF, costaccountQF};
            DynamicObjectCollection accountBooks = QueryServiceHelper.query((String)"gl_accountbook", (String)fields, (QFilter[])qf, (String)"number asc");
            HashSet<Long> ids = new HashSet<Long>(5);
            for (DynamicObject book : accountBooks) {
                ids.add(book.getLong("id"));
            }
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            if (CadEmptyUtils.isEmpty(ids)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter filter = new QFilter("id", "in", ids);
            qFilters.add(filter);
        });
        BasedataEdit accountsTableInput = (BasedataEdit)this.getControl("accountviews");
        accountsTableInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qf = filterParameter.getQFilters();
            qf.add(new QFilter("status", "=", (Object)"C"));
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qf.add(new QFilter("id", "=", (Object)-1));
                return;
            }
            DynamicObject accountbook = (DynamicObject)this.getModel().getValue("accountbook");
            if (CadEmptyUtils.isEmpty((DynamicObject)accountbook)) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5bf9\u5e94\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"CostCollectConfigEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Date date = new Date();
            QFilter dateFilter = new QFilter("startdate", "<=", (Object)date);
            dateFilter.and("enddate", ">", (Object)date);
            qf.add(dateFilter);
            qf.add(new QFilter("accounttable", "=", accountbook.get("accounttable.id")));
        });
    }

    protected void initOrgAndHideObjRule() {
        String appId = AppIdHelper.getCurAppNum((IFormView)this.getView());
        List comboItem = CostObjectHelper.getCalMthodComboItem((String)appId);
        ComboEdit ruleEdit = (ComboEdit)this.getControl("calmethod");
        ruleEdit.setComboItems(comboItem);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "org", "costaccount", "costbill", "calmethod", "costcalcdimension"});
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getModel().setValue("org", customParams.get("orgId"));
            this.getModel().setValue("costaccount", customParams.get("costAccountId"));
            this.getModel().setValue("costbill", customParams.get("costBillId"));
            this.getModel().setValue("calmethod", customParams.get("calMethod"));
            this.getModel().setValue("costcalcdimension", customParams.get("dimensionId"));
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"sourcebill"});
        }
        if (this.isCosObjConfig()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"costobjectrule"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"costobjectruleinfo"});
            this.getModel().setValue("costbill", (Object)"cad_costobject");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"costbill"});
        }
    }

    private void ruleDeleteEntryCheck(BeforeDoOperationEventArgs e) {
        Set<String> objFieldSet = this.getObjInfoMustInu();
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("costruleinfoentity");
        String fieldName = (String)model.getValue("costobjname", index);
        String prop = (String)model.getValue("costobjfield", index);
        boolean isEca = "eca".equals(AppIdHelper.getCurAppNum((IFormView)this.getView()));
        if (objFieldSet.contains(prop) && !isEca) {
            String tips = String.format(ResManager.loadKDString((String)"%s\u4e3a\u5fc5\u5f55\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"CostCollectConfigEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]), fieldName);
            this.getView().showTipNotification(tips);
            e.setCancel(true);
        }
    }

    private void srcFiledVisible() {
        OperationStatus status;
        boolean matchCostObj = this.getModel().getDataEntity().getBoolean("matchcostobj");
        this.getView().setVisible(Boolean.valueOf(matchCostObj), new String[]{"srcfieldid"});
        if (matchCostObj) {
            this.getModel().setValue("autogenerateobj", (Object)false);
        } else {
            this.getModel().setValue("srcfieldid", null);
        }
        Boolean preset = (Boolean)this.getModel().getValue("preset");
        if (preset.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"querylog"});
        }
        if (OperationStatus.ADDNEW.equals((Object)(status = this.getView().getFormShowParameter().getStatus()))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"querylog"});
        }
    }

    private void dimensionEnable() {
        String calMethod = this.getModel().getDataEntity().getString("calmethod");
        if (CostObjectEnum.BIZTYPE_CU.getValue().equals(calMethod)) {
            this.getModel().setValue("costcalcdimension", null);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"costcalcdimension"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"costcalcdimension"});
            if (CostObjectEnum.BIZTYPE_RO.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.RO_ID);
            } else if (CostObjectEnum.BIZTYPE_SO.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.SO_ID);
            } else if (CostObjectEnum.BIZTYPE_PZ.getValue().equals(calMethod) || CostObjectEnum.BIZTYPE_FL.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.PZ_FL_ID);
            } else if (CostObjectEnum.BIZTYPE_SW.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.SW_ID);
            } else if (CostObjectEnum.BIZTYPE_SP.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.SP_ID);
            }
        }
        this.getView().updateView("costcalcdimension");
    }
}

