/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CostCollectConfigListPlugin
extends AbstractListPlugin {
    private static final String ORG = "org";
    protected FilterContainerInitArgs filterContainerInitArgs = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        qFilters.add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        e.setOrderBy("number asc");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List<Object> orgIdList = this.getOrgCache();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith(String.format("%s.", ORG))) continue;
            this.resetOrg(commonFilterColumn, orgIdList);
        }
        super.filterContainerInit(args);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        Map filterValues = e.getSearchClickEvent().getFilterValues();
        List customFilter = (List)filterValues.get("customfilter");
        if (customFilter == null || customFilter.isEmpty()) {
            return;
        }
        for (int i = 0; i < customFilter.size(); ++i) {
            List vals;
            Map map = (Map)customFilter.get(i);
            List names = (List)map.get("FieldName");
            if (!String.format("%s.id", ORG).equals(String.valueOf(names.get(0))) || CadEmptyUtils.isEmpty((List)(vals = (List)map.get("Value")))) continue;
            this.putOrgCache(vals);
            this.filterContainerInit(this.filterContainerInitArgs);
        }
        super.filterContainerSearchClick(e);
    }

    protected void resetOrg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        List listComItem = commonFilterColumn.getComboItems();
        listComItem.clear();
        List acctOrgs = OrgHelper.getOrgComboItems((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
            return;
        }
        commonFilterColumn.setComboItems(acctOrgs);
        ComboItem item = (ComboItem)acctOrgs.get(0);
        String defOrgId = item.getValue();
        if (CadEmptyUtils.isEmpty(orgIdList)) {
            orgIdList = Collections.singletonList(defOrgId);
        }
        commonFilterColumn.setDefaultValues(orgIdList);
        this.putOrgCache(orgIdList);
    }

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    protected void putOrgCache(List<Object> vals) {
        this.getPageCache().put(ORG, SerializationUtils.toJsonString(vals));
    }

    protected List<Object> getOrgCache() {
        String orgId = this.getPageCache().get(ORG);
        if (StringUtils.isNotEmpty((String)orgId)) {
            return (List)SerializationUtils.fromJsonString((String)orgId, List.class);
        }
        return null;
    }
}

