/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.constants.CostDimensionConstant;
import kd.macc.cad.common.enums.BgParamEnum;
import kd.macc.cad.common.enums.CostObjectEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.cad.common.helper.StartCostHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.cad.formplugin.base.PermitItemEnum;

public class CostConfigPlanEditPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final String ENTRY = "configinfoentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.initF7Filter();
    }

    public void initialize() {
        super.initialize();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initFieldEnable();
    }

    public void afterBindData(EventObject e) {
        IPageCache pageCache;
        super.afterBindData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        this.getModel().setValue("appnum", (Object)appId);
        this.getModel().setDataChanged(Boolean.FALSE.booleanValue());
        this.setCostAccountVisible();
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (pageCache = parentView.getPageCache()).get("iscopy") != null) {
            this.billCopy();
            pageCache.remove("iscopy");
        }
    }

    private void setCostAccountVisible() {
        String costBill = this.getModel().getDataEntity().getString("costbill.id");
        boolean isCostAccountVisible = "cad_mfgfeebill".equals(costBill) || "sca_diycostdriver".equals(costBill) || "cad_planfeebill".equals(costBill) || "cad_plancostdriver".equals(costBill) || "cad_planresource".equals(costBill);
        this.getView().setVisible(Boolean.valueOf(isCostAccountVisible), new String[]{"costaccount"});
        if (!isCostAccountVisible) {
            Object costAccount = this.getModel().getDataEntity().get("costaccount");
            if (costAccount != null) {
                this.getModel().setValue("costaccount", null);
            }
        } else {
            OperationStatus status = this.getView().getFormShowParameter().getStatus();
            if (OperationStatus.ADDNEW.equals((Object)status)) {
                QFilter enabledCostAccountIdsFilter;
                List costAccountIds;
                Object costAccount = this.getModel().getDataEntity().get("costaccount");
                DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
                if (org != null && costAccount == null && !CadEmptyUtils.isEmpty((List)(costAccountIds = QueryServiceHelper.queryPrimaryKeys((String)"cal_bd_costaccount", (QFilter[])(enabledCostAccountIdsFilter = StartCostHelper.getEnableQfilterByOrg((Long)org.getLong("id"), null, (String)this.getView().getFormShowParameter().getAppId())).toArray(), null, (int)-1))) && costAccountIds.size() == 1) {
                    this.getModel().setValue("costaccount", costAccountIds.get(0));
                }
            }
        }
    }

    private void billCopy() {
        this.expirePresetConfig();
        long selOrgId = this.getListSelOrg();
        this.getModel().setValue("org", (Object)selOrgId);
        this.getModel().setValue("preset", (Object)false);
        this.getModel().setValue("remark", null);
        int entryRowCount = this.getModel().getEntryRowCount(ENTRY);
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject costConfig = (DynamicObject)this.getModel().getValue("costconfig", i);
            if (costConfig == null || CadEmptyUtils.isEmpty((Long)costConfig.getLong("id"))) continue;
            Long id = CostConfigService.copyConfigBill((long)selOrgId, (long)costConfig.getLong("id"));
            this.getModel().setValue("costconfig", (Object)id, i);
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"sourcebill"});
        }
        this.getView().invokeOperation("save", OperateOption.create());
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save", "bar_disable", "config", "bar_delete"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "org", "costaccount", "costbill", "calmethod", "costcalcdimension", "preset"});
        this.getView().setEnable(Boolean.valueOf(true), new String[]{ENTRY, "advconbaritemap", "advconbaritemap1", "advconbaritemap2", "advconbaritemap3"});
    }

    private void expirePresetConfig() {
        long listSelOrg = this.getListSelOrg();
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        boolean preset = this.getModel().getDataEntity().getBoolean("preset");
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        if (listSelOrg == rootOrgId && orgId == rootOrgId && preset) {
            QFilter filter = new QFilter("org", "=", (Object)rootOrgId);
            filter.and("preset", "=", (Object)true);
            filter.and("costbill", "=", (Object)this.getModel().getDataEntity().getString("costbill.id"));
            filter.and("calmethod", "=", (Object)this.getModel().getDataEntity().getString("calmethod"));
            filter.and("costcalcdimension", "=", (Object)this.getModel().getDataEntity().getLong("costcalcdimension.id"));
            filter.and("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_costconfigplan", (String)"id", (QFilter[])new QFilter[]{filter});
            if (dynamicObject != null) {
                long id = dynamicObject.getLong("id");
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_costconfigplan");
                DynamicObject result = BusinessDataServiceHelper.loadSingle((Object)id, (DynamicObjectType)mainEntityType);
                result.set("org", (Object)0L);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{result});
            }
        }
    }

    private Long getListSelOrg() {
        IPageCache pageCache;
        String orgId;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && (orgId = (pageCache = parentView.getPageCache()).get("org")) != null) {
            List list = (List)SerializationUtils.fromJsonString((String)orgId, List.class);
            return Long.parseLong(list.get(0).toString());
        }
        return 0L;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String proName;
        super.propertyChanged(e);
        switch (proName = e.getProperty().getName()) {
            case "calmethod": {
                this.dimensionEnable();
                break;
            }
            case "costbill": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (newValue != null) {
                    DynamicObject entityDy = (DynamicObject)newValue;
                    String number = entityDy.getString("number");
                    boolean enable = "cad_mfgfeebill".equals(number) || "sca_resourceuse".equals(number) || "sca_diycostdriver".equals(number) || "sca_workqtycollec".equals(number) || "cad_planfeebill".equals(number) || "cad_planresource".equals(number) || "cad_planwork".equals(number) || "cad_plancostdriver".equals(number);
                    this.getView().setEnable(Boolean.valueOf(enable), new String[]{"calmethod"});
                }
                this.setCostAccountVisible();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        IDataModel model = this.getModel();
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "config": {
                this.openPageCostConfigBill(e);
                break;
            }
            case "deleteentry": {
                CostConfigService.deleteEntry((IDataModel)model, (IFormView)this.getView(), (BeforeDoOperationEventArgs)e);
                break;
            }
            case "delete": {
                long id = this.getModel().getDataEntity().getLong("id");
                if (CadEmptyUtils.isEmpty((Long)id)) break;
                HashSet<Long> ids = new HashSet<Long>();
                ids.add(id);
                CostConfigService.delCostConfigByPlanBillIds((BeforeDoOperationEventArgs)e, (Long)this.getListSelOrg(), ids, (IFormView)this.getView());
                break;
            }
            case "copy": {
                Long listSelOrg = this.getListSelOrg();
                if (CadEmptyUtils.isEmpty((Long)listSelOrg)) {
                    return;
                }
                boolean permission = PermissionHelper.checkPermission((String)this.getView().getFormShowParameter().getAppId(), (long)listSelOrg, (String)this.getBillEntityId(), (String)PermitItemEnum.ITEM_NEW.getKey());
                if (!permission) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u590d\u5236\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostConfigPlanEditPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getBillEntityName()));
                    e.setCancel(true);
                    return;
                }
                long orgId = this.getModel().getDataEntity().getLong("org.id");
                if (orgId == 0L) {
                    String tips = ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"CostConfigPlanEditPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(tips);
                    e.setCancel(true);
                    return;
                }
                if (listSelOrg == orgId) {
                    String tips = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0b\u5df2\u6709\u914d\u7f6e\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"CostConfigPlanEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(tips);
                    e.setCancel(true);
                    return;
                }
                if (this.getPageCache().get("confirmCopy") == null) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmCopy", (IFormPlugin)this);
                    String confirmTip = ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5c06\u5728\u5728\u5f53\u524d\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u521b\u5efa\u65b0\u65b9\u6848\uff0c\u73b0\u6709\u65b9\u6848\u5c06\u4e0d\u518d\u9002\u7528\u4e8e\u5f53\u524d\u7ec4\u7ec7\uff0c\u786e\u8ba4\u590d\u5236\u5417\uff1f", (String)"CostConfigPlanEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    e.setCancel(true);
                    this.getPageCache().put("confirmCopy", "true");
                    return;
                }
                this.getPageCache().remove("confirmCopy");
                break;
            }
            case "configenable": 
            case "configdisable": {
                int[] selectRows = this.getSelectEntryRowIndex();
                if (selectRows == null || selectRows.length == 0) {
                    String tips = ResManager.loadKDString((String)"\u914d\u7f6e\u5355\u542f\u7528/\u7981\u7528\u524d\u8bf7\u5148\u9009\u62e9\u884c\u53f7\u3002", (String)"CostConfigPlanEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(tips);
                    e.setCancel(true);
                    return;
                }
                for (int i = 0; i < selectRows.length; ++i) {
                    if ("configenable".equals(operateKey)) {
                        this.getModel().setValue("usestatus", (Object)"1", selectRows[i]);
                        continue;
                    }
                    this.getModel().setValue("usestatus", (Object)"0", selectRows[i]);
                }
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "confirmCopy": {
                if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                    this.getView().invokeOperation("copy", OperateOption.create());
                    break;
                }
                this.getPageCache().remove("confirmCopy");
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp;
        Object costBill;
        super.afterCreateNewData(e);
        DynamicObjectCollection configInfoEntity = this.getModel().getDataEntity().getDynamicObjectCollection(ENTRY);
        if (configInfoEntity != null && configInfoEntity.size() > 0) {
            configInfoEntity.forEach(obj -> obj.set("oprate", (Object)ResManager.loadKDString((String)"\u8054\u67e5\u53d8\u66f4\u65e5\u5fd7", (String)"CostConfigPlanEditPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0])));
        }
        if ((costBill = (fsp = this.getView().getFormShowParameter()).getCustomParam("costbill")) != null && !CadEmptyUtils.isEmpty((String)String.valueOf(costBill))) {
            this.getModel().setValue("costBill", costBill);
        }
    }

    private int[] getSelectEntryRowIndex() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY);
        return entryGrid.getSelectRows();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("copy".equals(operateKey)) {
            this.billCopy();
        }
        if ("save".equals(operateKey) && e.getOperationResult().isSuccess()) {
            CostConfigService.realDeleteEntry((IFormView)this.getView());
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_new", "bar_delete"});
        }
    }

    private void openPageCostConfigBill(BeforeDoOperationEventArgs e) {
        Object costAccount;
        IDataModel model = this.getModel();
        long orgId = model.getDataEntity().getLong("org.id");
        if (CadEmptyUtils.isEmpty((Long)orgId)) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostConfigPlanEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            e.setCancel(true);
            return;
        }
        String costBillId = model.getDataEntity().getString("costbill.id");
        if (CadEmptyUtils.isEmpty((String)costBillId)) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u5355\u636e\u3002", (String)"CostConfigPlanEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            e.setCancel(true);
            return;
        }
        if (("cad_mfgfeebill".equals(costBillId) || "cad_planresource".equals(costBillId)) && (costAccount = model.getDataEntity().get("costaccount")) == null) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8d26\u7c3f\u3002", (String)"CostConfigPlanEditPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            e.setCancel(true);
            return;
        }
        String calMethod = model.getDataEntity().getString("calmethod");
        if (CadEmptyUtils.isEmpty((String)calMethod)) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u8ba1\u7b97\u65b9\u6cd5\u3002", (String)"CostConfigPlanEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            e.setCancel(true);
            return;
        }
        Long dimensionId = model.getDataEntity().getLong("costcalcdimension.id");
        if (CadEmptyUtils.isEmpty((Long)dimensionId)) {
            String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"CostConfigPlanEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            e.setCancel(true);
            return;
        }
        long costAccountId = model.getDataEntity().getLong("costaccount.id");
        OperationResult result = this.getView().invokeOperation("save", OperateOption.create());
        if (result.isSuccess()) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setFormId("cad_costcollectconfig");
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.getCustomParams().put("orgId", orgId);
            billShowParameter.getCustomParams().put("costAccountId", costAccountId);
            billShowParameter.getCustomParams().put("costBillId", costBillId);
            billShowParameter.getCustomParams().put("calMethod", calMethod);
            billShowParameter.getCustomParams().put("dimensionId", dimensionId);
            billShowParameter.getCustomParams().put("type", "ADDNEW");
            billShowParameter.setStatus(OperationStatus.ADDNEW);
            billShowParameter.getCustomParams().put("configPlanId", this.getModel().getDataEntity().getLong("id"));
            billShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "configSaveCallBack"));
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Map returnData;
        super.closedCallBack(e);
        if ("configSaveCallBack".equals(e.getActionId())) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
        } else if ("change_usestatus".equals(e.getActionId()) && !CadEmptyUtils.isEmpty((Map)(returnData = (Map)e.getReturnData()))) {
            String status = returnData.get("usestatus").toString();
            int indexInConfigPlan = (Integer)returnData.get("indexinconfigplan");
            this.getModel().setValue("usestatus", (Object)status, indexInConfigPlan);
            this.getModel().setDataChanged(false);
        }
    }

    private void initFieldEnable() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.initCostDimension(status);
        this.initBillTitle(status);
        this.initEnable(status);
        this.setOperateColumn(status);
    }

    private void setOperateColumn(OperationStatus status) {
        Boolean preset = (Boolean)this.getModel().getValue("preset");
        if (preset.booleanValue() && !status.equals((Object)OperationStatus.ADDNEW)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"operate"});
            return;
        }
        int count = this.getModel().getEntryRowCount(ENTRY);
        for (int i = 0; i < count; ++i) {
            this.getModel().setValue("operate", (Object)ResManager.loadKDString((String)"\u8054\u67e5\u53d8\u66f4\u65e5\u5fd7", (String)"CostConfigPlanEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]), i);
        }
    }

    private void initEnable(OperationStatus status) {
        Boolean isLock;
        Long listSelOrg = this.getListSelOrg();
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        if (!status.equals((Object)OperationStatus.ADDNEW) && (this.getModel().getDataEntity().getBoolean("preset") || listSelOrg != orgId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_disable", "bar_delete"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"fs_baseinfo"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{ENTRY, "advconbaritemap", "advconbaritemap1", "advconbaritemap2", "advconbaritemap3"});
        }
        if (!status.equals((Object)OperationStatus.EDIT) || orgId == listSelOrg) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_copy"});
        }
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_new", "bar_delete"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_save", "bar_disable", "config"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"fs_baseinfo"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{ENTRY, "advconbaritemap", "advconbaritemap1", "advconbaritemap2", "advconbaritemap3"});
        }
        Boolean bl = isLock = this.getView().getFormShowParameter().getCustomParam("isLock") == null ? Boolean.FALSE : (Boolean)this.getView().getFormShowParameter().getCustomParam("isLock");
        if (isLock.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save", "bar_delete"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"advconbaritemap", "advconbaritemap1", "advconbaritemap2", "advconbaritemap3"});
        }
    }

    private void initBillTitle(OperationStatus status) {
        if (OperationStatus.EDIT.equals((Object)status)) {
            int count = this.getModel().getEntryRowCount(ENTRY);
            if (count > 0) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"number", "org", "costaccount", "costbill", "calmethod", "costcalcdimension"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"fs_baseinfo"});
            }
        }
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getModel().setValue("org", (Object)this.getListSelOrg());
            this.getView().setEnable(Boolean.TRUE, new String[]{"number", "costaccount", "costbill", "costcalcdimension"});
        }
    }

    private void initCostDimension(OperationStatus status) {
        String appId = AppIdHelper.getCurAppNum((IFormView)this.getView());
        List comboItems = CostObjectHelper.getCalMthodComboItem((String)appId);
        ComboEdit calMethodComboEdit = (ComboEdit)this.getControl("calmethod");
        calMethodComboEdit.setComboItems(comboItems);
        String calMethod = this.getModel().getDataEntity().getString("calmethod");
        if (!CostObjectEnum.BIZTYPE_CU.getValue().equals(calMethod)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"costcalcdimension"});
        }
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            if (CostObjectEnum.BIZTYPE_RO.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.RO_ID);
            } else if (CostObjectEnum.BIZTYPE_SO.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.SO_ID);
            } else if (CostObjectEnum.BIZTYPE_PZ.getValue().equals(calMethod) || CostObjectEnum.BIZTYPE_FL.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.PZ_FL_ID);
            } else if (CostObjectEnum.BIZTYPE_SW.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.SW_ID);
            } else if (CostObjectEnum.BIZTYPE_SP.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.SP_ID);
            }
            this.getView().updateView("costcalcdimension");
        }
    }

    protected void initF7Filter() {
        String appNum = this.getView().getFormShowParameter().getAppId();
        BasedataEdit costAccountInput = (BasedataEdit)this.getControl("costaccount");
        costAccountInput.addBeforeF7SelectListener(evt -> {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            if (CadEmptyUtils.isEmpty((DynamicObject)org)) {
                qFilters.add(new QFilter("id", "=", (Object)-1L));
                return;
            }
            QFilter enabledCostAccountIdsFilter = StartCostHelper.getEnableQfilterByOrg((Long)org.getLong("id"), null, (String)this.getView().getFormShowParameter().getAppId());
            qFilters.add(enabledCostAccountIdsFilter);
        });
        BasedataEdit costBill = (BasedataEdit)this.getControl("costbill");
        costBill.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            HashSet<String> numbers = new HashSet<String>(10);
            if ("eca".equals(appNum)) {
                numbers.add("cad_costobject");
                numbers.add("aca_matalloc");
                numbers.add("cad_mfgfeebill");
                numbers.add("eca_workhoursfee");
                numbers.add("sca_diycostdriver");
            } else {
                numbers.add("cad_costobject");
                numbers.add("cad_factnedoutputbill");
                numbers.add("cad_plannedoutputbill");
                numbers.add("sca_resourceuse");
                numbers.add("cad_mfgfeebill");
                numbers.add("sca_diycostdriver");
                numbers.add("sca_workqtycollec");
                if ("aca".equals(appNum)) {
                    if (CadBgParamUtils.getBgParamBoolean((BgParamEnum)BgParamEnum.DIRECT_MAT_ALLOC).booleanValue()) {
                        numbers.add("aca_matalloc");
                    } else {
                        numbers.add("aca_matusecollect");
                    }
                }
                if ("sca".equals(appNum)) {
                    numbers.add("sca_matusecollect");
                    numbers.add("cad_planfeebill");
                    numbers.add("cad_planresource");
                    numbers.add("cad_planwork");
                    numbers.add("cad_plancostdriver");
                }
            }
            QFilter numberFilter = new QFilter("number", "in", numbers);
            qFilters.add(numberFilter);
        });
        BasedataEdit costCalcDimension = (BasedataEdit)this.getControl("costcalcdimension");
        costCalcDimension.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            QFilter filter = new QFilter("preset", "=", (Object)false);
            filter.and("enable", "=", (Object)true);
            qFilters.add(filter);
        });
        BasedataEdit costConfig = (BasedataEdit)this.getControl("costconfig");
        costConfig.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            QFilter filter = new QFilter("preset", "=", (Object)false);
            filter.and("enable", "=", (Object)true);
            qFilters.add(filter);
        });
    }

    private void dimensionEnable() {
        String calMethod = this.getModel().getDataEntity().getString("calmethod");
        if (CostObjectEnum.BIZTYPE_CU.getValue().equals(calMethod)) {
            this.getModel().setValue("costcalcdimension", null);
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"costcalcdimension"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"costcalcdimension"});
            if (CostObjectEnum.BIZTYPE_RO.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.RO_ID);
            } else if (CostObjectEnum.BIZTYPE_SO.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.SO_ID);
            } else if (CostObjectEnum.BIZTYPE_PZ.getValue().equals(calMethod) || CostObjectEnum.BIZTYPE_FL.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.PZ_FL_ID);
            } else if (CostObjectEnum.BIZTYPE_SW.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.SW_ID);
            } else if (CostObjectEnum.BIZTYPE_SP.getValue().equals(calMethod)) {
                this.getModel().setValue("costcalcdimension", (Object)CostDimensionConstant.SP_ID);
            }
        }
        this.getView().updateView("costcalcdimension");
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        String fieldName = e.getFieldName();
        if ("costconfig".equals(fieldName)) {
            long configId = ((DynamicObject)this.getModel().getEntryEntity(ENTRY).get(e.getRowIndex())).getDynamicObject("costconfig").getLong("id");
            int usestatus = ((DynamicObject)this.getModel().getEntryEntity(ENTRY).get(e.getRowIndex())).getInt("usestatus");
            if (!CadEmptyUtils.isEmpty((Long)configId)) {
                Long listSelOrg = this.getListSelOrg();
                BillShowParameter formShowParameter = new BillShowParameter();
                formShowParameter.setFormId("cad_costcollectconfig");
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setPkId((Object)configId);
                formShowParameter.setCustomParam("parentview", (Object)"costconfigbill");
                formShowParameter.setCustomParam("type", (Object)"EDIT");
                formShowParameter.setCustomParam("indexinconfigplan", (Object)e.getRowIndex());
                formShowParameter.setCustomParam("usestatus", (Object)usestatus);
                formShowParameter.setCustomParam("preset", this.getModel().getValue("preset"));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "change_usestatus"));
                if (listSelOrg == orgId) {
                    formShowParameter.setStatus(OperationStatus.EDIT);
                } else {
                    formShowParameter.setStatus(OperationStatus.VIEW);
                }
                this.getView().showForm((FormShowParameter)formShowParameter);
            }
        }
        if ("operate".equals(fieldName)) {
            DynamicObject costconfig = ((DynamicObject)this.getModel().getEntryEntity(ENTRY).get(e.getRowIndex())).getDynamicObject("costconfig");
            if (costconfig == null) {
                return;
            }
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId("cad_configbilllog");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowFilter(false);
            showParameter.setShowQuickFilter(false);
            showParameter.getCustomParams().put("org", orgId);
            showParameter.getCustomParams().put("billno", costconfig.getString("number"));
            this.getView().showForm((FormShowParameter)showParameter);
            String opType = ResManager.loadKDString((String)"\u8054\u67e5\u53d8\u66f4\u65e5\u5fd7", (String)"CostConfigPlanEditPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            String checkType = ResManager.loadKDString((String)"\u914d\u7f6e\u65b9\u6848\u53d8\u66f4\u65e5\u5fd7", (String)"CostConfigPlanEditPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_configbilllog", (String)this.getView().getFormShowParameter().getAppId());
        }
    }

    private String getBillEntityId() {
        return this.getModel().getDataEntityType().getName();
    }

    private String getBillEntityName() {
        return this.getView().getFormShowParameter().getFormName();
    }
}

