/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.business.config.service.CostConfigService;
import kd.macc.cad.common.enums.BgParamEnum;
import kd.macc.cad.common.enums.SysParamEnum;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostObjectHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.base.PermitItemEnum;

public class CostConfigPlanListPlugin
extends AbstractListPlugin {
    private static final String ORG = "org";
    protected FilterContainerInitArgs filterContainerInitArgs = null;

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        QFilter filter;
        DynamicObject dynamicObject;
        Object entryPrimaryKeyValue;
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        BillListHyperLinkClickEvent clickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = clickEvent.getCurrentRow();
        String fieldName = args.getFieldName();
        if ("number".equals(fieldName)) {
            Boolean isLock = PermissionHelper.isLock((String)currentRow.getPrimaryKeyValue().toString(), (String)"default_netctrl", (String)"cad_costconfigplan");
            BillShowParameter bill = new BillShowParameter();
            bill.setFormId("cad_costconfigplan");
            bill.setCustomParam("isLock", (Object)isLock);
            bill.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            bill.setPkId((Object)Long.valueOf(currentRow.getPrimaryKeyValue().toString()));
            bill.setHasRight(true);
            bill.setStatus(OperationStatus.EDIT);
            this.getView().showForm((FormShowParameter)bill);
        }
        if ("costconfig_number".equals(fieldName) && (entryPrimaryKeyValue = currentRow.getEntryPrimaryKeyValue()) != null && (dynamicObject = QueryServiceHelper.queryOne((String)"cad_costconfigplan", (String)"preset,configinfoentity.costconfig as configId,org,configinfoentity.usestatus usestatus", (QFilter[])new QFilter[]{filter = new QFilter("configinfoentity.id", "in", (Object)Long.parseLong(entryPrimaryKeyValue.toString()))})) != null) {
            long selOrg;
            long configId = dynamicObject.getLong("configId");
            long org = dynamicObject.getLong(ORG);
            int useStatus = dynamicObject.getInt("usestatus");
            boolean preset = dynamicObject.getBoolean("preset");
            long l = selOrg = this.getOrgCache() == null ? 0L : Long.parseLong(this.getOrgCache().get(0).toString());
            if (!CadEmptyUtils.isEmpty((Long)configId)) {
                BillShowParameter formShowParameter = new BillShowParameter();
                formShowParameter.setFormId("cad_costcollectconfig");
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setPkId((Object)configId);
                formShowParameter.setCustomParam("parentview", (Object)"costconfiglist");
                formShowParameter.setCustomParam("type", (Object)"EDIT");
                formShowParameter.setCustomParam("usestatus", (Object)useStatus);
                formShowParameter.setCustomParam("preset", (Object)preset);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "change_usestatus"));
                if (org == selOrg) {
                    formShowParameter.setStatus(OperationStatus.EDIT);
                } else {
                    formShowParameter.setStatus(OperationStatus.VIEW);
                }
                this.getView().showForm((FormShowParameter)formShowParameter);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        e.setMainOrgQFilter(null);
        List<Object> orgCache = this.getOrgCache();
        if (orgCache == null) {
            qFilters.add(new QFilter(ORG, "=", (Object)0L));
        } else {
            long org = Long.parseLong(orgCache.get(0).toString());
            Set configPlanIds = ImportServiceHelper.getConfigPlanIds((Long)org, null, null, (String)this.getView().getFormShowParameter().getAppId(), null);
            if (org == 100000L) {
                QFilter filter = new QFilter(ORG, "=", (Object)0L);
                filter.and("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
                DynamicObjectCollection dynamicObject = QueryServiceHelper.query((String)"cad_costconfigplan", (String)"id", (QFilter[])new QFilter[]{filter});
                for (DynamicObject obj : dynamicObject) {
                    configPlanIds.add(obj.getLong("id"));
                }
            }
            if (configPlanIds == null) {
                qFilters.add(new QFilter("id", "=", (Object)0L));
            } else {
                qFilters.add(new QFilter("id", "in", (Object)configPlanIds));
            }
        }
        qFilters.add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        if (!CadBgParamUtils.getBgParamBoolean((BgParamEnum)BgParamEnum.DIRECT_MAT_ALLOC).booleanValue() && !"eca".equals(this.getView().getFormShowParameter().getAppId())) {
            QFilter qFilter = new QFilter("costbill", "=", (Object)"aca_matalloc");
            qFilter.and("preset", "=", (Object)Boolean.TRUE);
            List planIds = QueryServiceHelper.queryPrimaryKeys((String)"cad_costconfigplan", (QFilter[])qFilter.toArray(), null, (int)-1);
            if (!CadEmptyUtils.isEmpty((List)planIds)) {
                qFilters.add(new QFilter("id", "not in", (Object)planIds));
            }
        }
        e.setOrderBy("number asc,configinfoentity.costconfig.number asc");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        this.filterContainerInitArgs = args;
        Iterator iterator = args.getFilterContainerInitEvent().getCommonFilterColumns().iterator();
        String appId = this.getView().getFormShowParameter().getAppId();
        while (iterator.hasNext()) {
            FilterColumn filterColumn = (FilterColumn)iterator.next();
            List<Object> orgIdList = this.getOrgCache();
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (fieldName.startsWith(String.format("%s.", ORG))) {
                this.resetOrg(commonFilterColumn, orgIdList);
            }
            if (fieldName.startsWith(String.format("%s", "calmethod"))) {
                if ("sca".equals(appId)) {
                    iterator.remove();
                } else {
                    this.resetCalMethod(commonFilterColumn);
                }
            }
            if (!fieldName.startsWith(String.format("%s", "costbill"))) continue;
            List<SysParamEnum> costBills = new ArrayList<SysParamEnum>(10);
            if ("sca".equals(appId)) {
                costBills = Arrays.asList(SysParamEnum.COSTBILL_CAD_COSTOBJECT, SysParamEnum.COSTBILL_CAD_PLANNEDOUTPUTBILL, SysParamEnum.COSTBILL_CAD_FACTNEDOUTPUTBILL, SysParamEnum.COSTBILL_SCA_RESOURCEUSE, SysParamEnum.COSTBILL_SCA_MATUSECOLLECT, SysParamEnum.COSTBILL_CAD_MFGFEEBILL, SysParamEnum.COSTBILL_SCA_WORKQTYCOLLEC, SysParamEnum.SCA_DIYCOSTDRIVER, SysParamEnum.COSTBILL_ECA_PLANRESOURCE);
            } else if ("aca".equals(appId)) {
                costBills = CadBgParamUtils.getBgParamBoolean((BgParamEnum)BgParamEnum.DIRECT_MAT_ALLOC).booleanValue() ? Arrays.asList(SysParamEnum.COSTBILL_CAD_COSTOBJECT, SysParamEnum.COSTBILL_CAD_PLANNEDOUTPUTBILL, SysParamEnum.COSTBILL_CAD_FACTNEDOUTPUTBILL, SysParamEnum.COSTBILL_SCA_RESOURCEUSE, SysParamEnum.COSTBILL_ACA_MATALLOC, SysParamEnum.COSTBILL_CAD_MFGFEEBILL, SysParamEnum.COSTBILL_SCA_WORKQTYCOLLEC, SysParamEnum.SCA_DIYCOSTDRIVER) : Arrays.asList(SysParamEnum.COSTBILL_CAD_COSTOBJECT, SysParamEnum.COSTBILL_CAD_PLANNEDOUTPUTBILL, SysParamEnum.COSTBILL_CAD_FACTNEDOUTPUTBILL, SysParamEnum.COSTBILL_SCA_RESOURCEUSE, SysParamEnum.COSTBILL_ACA_MATUSECOLLECT, SysParamEnum.COSTBILL_CAD_MFGFEEBILL, SysParamEnum.COSTBILL_SCA_WORKQTYCOLLEC, SysParamEnum.SCA_DIYCOSTDRIVER);
            } else if ("eca".equals(appId)) {
                costBills = Arrays.asList(SysParamEnum.COSTBILL_CAD_COSTOBJECT, SysParamEnum.COSTBILL_ACA_MATALLOC, SysParamEnum.COSTBILL_CAD_MFGFEEBILL, SysParamEnum.COSTBILL_ECA_WORKHOURSFEE, SysParamEnum.SCA_DIYCOSTDRIVER);
            }
            this.resetCostBill(commonFilterColumn, costBills);
        }
        super.filterContainerInit(args);
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("costbill")) {
            String appId = this.getView().getFormShowParameter().getAppId();
            List<Object> costBills = new ArrayList(10);
            if ("sca".equals(appId)) {
                costBills = Arrays.asList(SysParamEnum.COSTBILL_CAD_COSTOBJECT.getValue(), SysParamEnum.COSTBILL_CAD_PLANNEDOUTPUTBILL.getValue(), SysParamEnum.COSTBILL_CAD_FACTNEDOUTPUTBILL.getValue(), SysParamEnum.COSTBILL_SCA_RESOURCEUSE.getValue(), SysParamEnum.COSTBILL_SCA_MATUSECOLLECT.getValue(), SysParamEnum.COSTBILL_CAD_MFGFEEBILL.getValue());
            } else if ("aca".equals(appId)) {
                costBills = CadBgParamUtils.getBgParamBoolean((BgParamEnum)BgParamEnum.DIRECT_MAT_ALLOC).booleanValue() ? Arrays.asList(SysParamEnum.COSTBILL_CAD_COSTOBJECT.getValue(), SysParamEnum.COSTBILL_CAD_PLANNEDOUTPUTBILL.getValue(), SysParamEnum.COSTBILL_CAD_FACTNEDOUTPUTBILL.getValue(), SysParamEnum.COSTBILL_SCA_RESOURCEUSE.getValue(), SysParamEnum.COSTBILL_ACA_MATALLOC.getValue(), SysParamEnum.COSTBILL_CAD_MFGFEEBILL.getValue(), SysParamEnum.SCA_DIYCOSTDRIVER.getValue(), SysParamEnum.COSTBILL_SCA_WORKQTYCOLLEC.getValue()) : Arrays.asList(SysParamEnum.COSTBILL_CAD_COSTOBJECT.getValue(), SysParamEnum.COSTBILL_CAD_PLANNEDOUTPUTBILL.getValue(), SysParamEnum.COSTBILL_CAD_FACTNEDOUTPUTBILL.getValue(), SysParamEnum.COSTBILL_SCA_RESOURCEUSE.getValue(), SysParamEnum.COSTBILL_ACA_MATUSECOLLECT.getValue(), SysParamEnum.COSTBILL_CAD_MFGFEEBILL.getValue(), SysParamEnum.SCA_DIYCOSTDRIVER.getValue(), SysParamEnum.COSTBILL_SCA_WORKQTYCOLLEC.getValue());
            } else if ("eca".equals(appId)) {
                costBills = Arrays.asList(SysParamEnum.COSTBILL_CAD_COSTOBJECT.getValue(), SysParamEnum.COSTBILL_ACA_MATALLOC.getValue(), SysParamEnum.COSTBILL_CAD_MFGFEEBILL.getValue(), SysParamEnum.COSTBILL_ECA_WORKHOURSFEE.getValue());
            }
            QFilter idQf = new QFilter("id", "in", costBills);
            args.getQfilters().add(idQf);
        }
    }

    private void resetCostBill(CommonFilterColumn commonFilterColumn, List<SysParamEnum> costBills) {
        if (CadEmptyUtils.isEmpty(costBills)) {
            return;
        }
        List listComItem = commonFilterColumn.getComboItems();
        listComItem.clear();
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>(10);
        for (SysParamEnum costBill : costBills) {
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(costBill.getName()));
            item.setValue(costBill.getValue());
            if (acctItems.contains(item)) continue;
            acctItems.add(item);
        }
        commonFilterColumn.setComboItems(acctItems);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String operateKey = formOperate.getOperateKey();
        List<Object> orgCache = this.getOrgCache();
        if (orgCache == null) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"CostConfigPlanListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        long org = Long.parseLong(orgCache.get(0).toString());
        HashSet<Long> ids = new HashSet<Long>();
        ListSelectedRowCollection listSelectedData = e.getListSelectedData();
        for (ListSelectedRow listSelectedDatum : listSelectedData) {
            ids.add(Long.parseLong(String.valueOf(listSelectedDatum.getPrimaryKeyValue())));
        }
        switch (operateKey) {
            case "delete": {
                CostConfigService.delCostConfigByPlanBillIds((BeforeDoOperationEventArgs)e, (Long)org, ids, (IFormView)this.getView());
                break;
            }
            case "copy": {
                if (CadEmptyUtils.isEmpty((Long)org)) break;
                boolean permission = PermissionHelper.checkPermission((String)this.getView().getFormShowParameter().getAppId(), (long)org, (String)this.getBillEntityId(), (String)PermitItemEnum.ITEM_NEW.getKey());
                if (!permission) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u590d\u5236\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostConfigPlanListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getBillEntityName()));
                    e.setCancel(true);
                    return;
                }
                QFilter filter = new QFilter("id", "in", ids);
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_costconfigplan", (String)"org,preset", (QFilter[])new QFilter[]{filter});
                if (dynamicObject == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\uff0c\u5f53\u524d\u5355\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CostConfigPlanListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    break;
                }
                long billOrg = dynamicObject.getLong(ORG);
                if (billOrg == 0L) {
                    e.setCancel(true);
                    String tips = ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e0d\u5141\u8bb8\u590d\u5236\uff0c\u82e5\u9700\u4fee\u6539\uff0c\u8bf7\u5728\u76f8\u540c\u6210\u672c\u5355\u636e+\u6210\u672c\u8ba1\u7b97\u65b9\u6cd5+\u6210\u672c\u6838\u7b97\u7ef4\u5ea6\u7684\u975e\u7cfb\u7edf\u9884\u8bbe\u65b9\u6848\u4e0b\u4fee\u6539\u3002", (String)"CostConfigPlanListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(tips);
                    return;
                }
                boolean isRoot = false;
                if (billOrg == 100000L && org == 100000L && dynamicObject.getBoolean("preset")) {
                    isRoot = true;
                }
                if (billOrg == org && !isRoot) {
                    e.setCancel(true);
                    String tips = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0b\u5df2\u6709\u914d\u7f6e\u65b9\u6848\uff0c\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"CostConfigPlanListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(tips);
                    return;
                }
                if (isRoot && !CadBgParamUtils.getBgParamBoolean((BgParamEnum)BgParamEnum.COPY_ROOT_SCHEME).booleanValue()) {
                    String tips = ResManager.loadKDString((String)"\u6839\u7ec4\u7ec7\u7684\u6210\u672c\u5f52\u96c6\u914d\u7f6e\u65b9\u6848\u4e0d\u5141\u8bb8\u590d\u5236\u4fee\u6539\uff0c\u8bf7\u68c0\u67e5\u67e5\u8be2\u7ec4\u7ec7\u662f\u5426\u662f\u6839\u7ec4\u7ec7\u3002", (String)"CostConfigPlanListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    e.setCancel(true);
                    this.getView().showTipNotification(tips);
                    return;
                }
                if (this.getPageCache().get("confirmCopy") == null) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmCopy", (IFormPlugin)this);
                    String confirmTip = ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5c06\u5728\u5728\u5f53\u524d\u67e5\u8be2\u7ec4\u7ec7\u4e0b\u521b\u5efa\u65b0\u65b9\u6848\uff0c\u73b0\u6709\u65b9\u6848\u5c06\u4e0d\u518d\u9002\u7528\u4e8e\u5f53\u524d\u7ec4\u7ec7\uff0c\u786e\u8ba4\u590d\u5236\u5417\uff1f", (String)"CostConfigPlanListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    e.setCancel(true);
                    this.getPageCache().put("confirmCopy", "true");
                    return;
                }
                this.getPageCache().remove("confirmCopy");
                this.getView().getPageCache().put("iscopy", "true");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "confirmCopy": {
                if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                    this.getView().invokeOperation("copy", OperateOption.create());
                    break;
                }
                this.getPageCache().remove("confirmCopy");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("change_usestatus".equals(e.getActionId())) {
            IListView listview = (IListView)this.getView();
            listview.refresh();
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs e) {
        Map filterValues = e.getSearchClickEvent().getFilterValues();
        List customFilter = (List)filterValues.get("customfilter");
        if (customFilter == null || customFilter.isEmpty()) {
            return;
        }
        for (int i = 0; i < customFilter.size(); ++i) {
            List vals;
            Map map = (Map)customFilter.get(i);
            List names = (List)map.get("FieldName");
            if (String.format("%s.id", ORG).equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (CadEmptyUtils.isEmpty((List)vals)) continue;
                this.putOrgCache(vals);
                this.filterContainerInit(this.filterContainerInitArgs);
            }
            if (!String.valueOf(names.get(0)).contains("costbill.") || CadEmptyUtils.isEmpty((List)(vals = (List)map.get("Value")))) continue;
            this.getPageCache().put("costbill", SerializationUtils.toJsonString((Object)vals));
            this.filterContainerInit(this.filterContainerInitArgs);
        }
        super.filterContainerSearchClick(e);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        List costBillList;
        super.beforeShowBill(e);
        BillShowParameter bsp = e.getParameter();
        String costBill = this.getPageCache().get("costbill");
        if (!CadEmptyUtils.isEmpty((String)costBill) && !CadEmptyUtils.isEmpty((List)(costBillList = (List)SerializationUtils.fromJsonString((String)costBill, List.class))) && costBillList.size() == 1) {
            bsp.setCustomParam("costbill", costBillList.get(0));
        }
    }

    protected void resetOrg(CommonFilterColumn commonFilterColumn, List<Object> orgIdList) {
        List listComItem = commonFilterColumn.getComboItems();
        listComItem.clear();
        List acctOrgs = OrgHelper.getOrgComboItems((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((List)acctOrgs)) {
            return;
        }
        commonFilterColumn.setComboItems(acctOrgs);
        ComboItem item = (ComboItem)acctOrgs.get(0);
        String defOrgId = item.getValue();
        if (CadEmptyUtils.isEmpty(orgIdList)) {
            orgIdList = Collections.singletonList(defOrgId);
        }
        commonFilterColumn.setDefaultValues(orgIdList);
        this.putOrgCache(orgIdList);
    }

    private void resetCalMethod(CommonFilterColumn commonFilterColumn) {
        List listComItem = commonFilterColumn.getComboItems();
        listComItem.clear();
        List calMethodComboItem = CostObjectHelper.getCalMthodComboItem((String)AppIdHelper.getCurAppNum((IFormView)this.getView()));
        if (CadEmptyUtils.isEmpty((List)calMethodComboItem)) {
            return;
        }
        commonFilterColumn.setComboItems(calMethodComboItem);
    }

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    protected void putOrgCache(List<Object> vals) {
        this.getPageCache().put(ORG, SerializationUtils.toJsonString(vals));
    }

    protected List<Object> getOrgCache() {
        String orgId = this.getPageCache().get(ORG);
        if (StringUtils.isNotEmpty((String)orgId)) {
            return (List)SerializationUtils.fromJsonString((String)orgId, List.class);
        }
        return null;
    }

    protected List<Long> getSelectIds() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        ArrayList<Long> ids = new ArrayList<Long>(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            Long id = (Long)rows.get(i).getPrimaryKeyValue();
            if (ids.contains(id)) continue;
            ids.add(id);
        }
        return ids;
    }

    private String getBillEntityName() {
        return ((IListView)this.getView()).getFormShowParameter().getCaption().replaceAll(ResManager.loadKDString((String)"\u5217\u8868", (String)"CostConfigPlanListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]), "");
    }
}

