/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.FormulaEditHelper;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.function.FunctionGroup;
import kd.bos.entity.function.FunctionTypes;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.FuncSettingHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.FormulaException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.formplugin.costobject.CostObjectEditPlugin;

public class FormulaEdit
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private Log logger = LogFactory.getLog(CostObjectEditPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btncancel"});
        this.addClickListeners(new String[]{"btnfunction", "clr", "backspace"});
        this.addClickListeners(new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnequal", "btnnotequal", "btnlessthen", "btnmorethen", "btnlessequal", "btnmoreequal", "btnand", "btnor", "btnleft", "btnright"});
        TreeView tv = (TreeView)this.getView().getControl("tv_fields");
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
        CRFormula formulaObj = this.deserialize(conditonJson);
        this.setFormulaObj(formulaObj);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        if (StringUtils.isNotBlank((CharSequence)json)) {
            this.fillTreeNodes(json);
        } else {
            this.addTreeRootNode();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(ctlSource.getKey())) {
            String conditonJson = (String)this.getView().getFormShowParameter().getCustomParam("formula");
            CRFormula formulaObj = this.deserialize(conditonJson);
            this.getFormulaObj(formulaObj);
            try {
                String tranExpr = this.tranFormula(formulaObj);
                formulaObj.setExprTran(tranExpr);
            }
            catch (FormulaException var6) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u9519\u8bef\uff1a%s\u3002", (String)"FormulaEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]), var6.getCause() != null ? var6.getCause().getMessage() : var6.getMessage()));
                return;
            }
            catch (Exception var7) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u9519\u8bef\uff1a%s\u3002", (String)"FormulaEdit_0", (String)"bos-designer-plugin", (Object[])new Object[0]), var7.getMessage()));
                return;
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)formulaObj));
            this.getView().close();
        } else if ("btncancel".equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)"btnfunction")) {
            this.showFuncSetting();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)"clr")) {
            this.getModel().setValue("fexpression", (Object)"");
            FormulaEditHelper.setCursorIndex((IFormView)this.getView(), (String)"fexpression", (int)0);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ctlSource.getKey(), (CharSequence)"backspace")) {
            FormulaEditHelper.backSpaceExpression((IFormView)this.getView(), (String)"backspace", (String)"fexpression");
        } else {
            this.clickCompareButton(ctlSource.getKey());
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"tv_fields", (String)"fexpression", (String)e.getNodeId().toString());
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase("fexpression")) {
            String expression = (String)this.getModel().getValue("fexpression");
            String tranExpr = "";
            try {
                tranExpr = this.tranExpression(expression);
            }
            catch (FormulaException var5) {
                tranExpr = var5.getCause() != null ? var5.getCause().getMessage() : var5.getMessage();
            }
            catch (Exception var6) {
                this.logger.error("\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25\uff1a", (Throwable)var6);
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25\u3002", (String)"FormulaEdit_1", (String)"bos-designer-plugin", (Object[])new Object[0]);
            }
            this.getModel().setValue("ftranexpr", (Object)tranExpr);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"btnfunction")) {
            if (StringUtils.isBlank((Object)closedCallBackEvent.getReturnData())) {
                return;
            }
            this.receiveFuncSetting((String)closedCallBackEvent.getReturnData());
        }
    }

    protected CRFormula deserialize(String json) {
        CRFormula formulaObj = null;
        formulaObj = StringUtils.isBlank((CharSequence)json) ? new CRFormula() : (CRFormula)SerializationUtils.fromJsonString((String)json, CRFormula.class);
        return formulaObj;
    }

    protected void setFormulaObj(CRFormula formulaObj) {
        this.getModel().setValue("fexpression", (Object)formulaObj.getExpression());
        this.getModel().setValue("fdescription", (Object)formulaObj.getDescription().toString());
        String tranExpr = this.tranExpression(formulaObj.getExpression());
        this.getModel().setValue("ftranexpr", (Object)tranExpr);
    }

    protected void getFormulaObj(CRFormula formulaObj) {
        String expression = (String)this.getModel().getValue("fexpression");
        formulaObj.setExpression(expression);
        String desc = (String)this.getModel().getValue("fdescription");
        formulaObj.getDescription().setItem(Lang.defaultLang().toString(), (Object)desc);
    }

    private void fillTreeNodes(String strJson) {
        TreeNode node = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl("tv_fields");
        tree.addNode(node);
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5355\u636e\u5b57\u6bb5\u5217\u8868", (String)"FormulaEdit_2", (String)"bos-designer-plugin", (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl("tv_fields");
        tree.addNode(root);
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        int var4 = -1;
        switch (compareKey.hashCode()) {
            case -1378808635: {
                if (!compareKey.equals("btnadd")) break;
                var4 = 0;
                break;
            }
            case -1378808325: {
                if (!compareKey.equals("btnand")) break;
                var4 = 10;
                break;
            }
            case -1179832642: {
                if (!compareKey.equals("btndivison")) break;
                var4 = 3;
                break;
            }
            case -997791075: {
                if (!compareKey.equals("btnnotequal")) break;
                var4 = 5;
                break;
            }
            case -845487581: {
                if (!compareKey.equals("btnmoreequal")) break;
                var4 = 9;
                break;
            }
            case -616237854: {
                if (!compareKey.equals("btnmultiplication")) break;
                var4 = 2;
                break;
            }
            case -489169518: {
                if (!compareKey.equals("btnlessthen")) break;
                var4 = 6;
                break;
            }
            case 94070079: {
                if (!compareKey.equals("btnor")) break;
                var4 = 11;
                break;
            }
            case 206934115: {
                if (!compareKey.equals("btnleft")) break;
                var4 = 12;
                break;
            }
            case 1497184590: {
                if (!compareKey.equals("btnmorethen")) break;
                var4 = 7;
                break;
            }
            case 1859708056: {
                if (!compareKey.equals("btnsubtraction")) break;
                var4 = 1;
                break;
            }
            case 2002044511: {
                if (!compareKey.equals("btnlessequal")) break;
                var4 = 8;
                break;
            }
            case 2113897048: {
                if (!compareKey.equals("btnequal")) break;
                var4 = 4;
                break;
            }
            case 2125651264: {
                if (!compareKey.equals("btnright")) break;
                var4 = 13;
            }
        }
        switch (var4) {
            case 0: {
                compareValue = "+";
                break;
            }
            case 1: {
                compareValue = "-";
                break;
            }
            case 2: {
                compareValue = "*";
                break;
            }
            case 3: {
                compareValue = "/";
                break;
            }
            case 4: {
                compareValue = "=";
                break;
            }
            case 5: {
                compareValue = "<>";
                break;
            }
            case 6: {
                compareValue = "<";
                break;
            }
            case 7: {
                compareValue = ">";
                break;
            }
            case 8: {
                compareValue = "<=";
                break;
            }
            case 9: {
                compareValue = ">=";
                break;
            }
            case 10: {
                compareValue = "and";
                break;
            }
            case 11: {
                compareValue = "or";
                break;
            }
            case 12: {
                compareValue = "(";
                break;
            }
            case 13: {
                compareValue = ")";
            }
        }
        if (!StringUtils.isBlank((CharSequence)compareValue)) {
            FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)compareKey, (String)"fexpression", (String)compareValue);
        }
    }

    protected String tranFormula(CRFormula formulaObj) {
        String expressionDesc = this.tranExpression(formulaObj.getExpression());
        return expressionDesc;
    }

    protected String tranExpression(String expression) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        String expressionDesc = expression;
        String[] vars = new String[]{};
        vars = FormulaEngine.extractVariables((String)expression);
        if (vars.length != 0 && !StringUtils.isBlank((CharSequence)vars[0])) {
            String json = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
            TreeNode rootNode = new TreeNode();
            if (StringUtils.isNotBlank((CharSequence)json)) {
                rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
            }
            ArrayList<String> orderVars = new ArrayList<String>(10);
            String[] var7 = vars;
            int i = vars.length;
            for (int var9 = 0; var9 < i; ++var9) {
                String var = var7[var9];
                orderVars.add(var);
            }
            orderVars.sort(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.length() > o2.length()) {
                        return -1;
                    }
                    return o1.length() < o2.length() ? 1 : o2.compareTo(o1);
                }
            });
            HashMap<String, String> tmpVariables = new HashMap<String, String>(16);
            i = 1;
            for (String var : orderVars) {
                String string = String.format("###%s###", String.valueOf(i));
                String varCaption = var;
                TreeNode node = rootNode.getTreeNode(var, 5);
                if (node != null) {
                    varCaption = node.getText();
                }
                tmpVariables.put(string, varCaption);
                expressionDesc = expressionDesc.replace(var, string);
                ++i;
            }
            for (Map.Entry entry : tmpVariables.entrySet()) {
                expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            return expressionDesc;
        }
        return expression;
    }

    private void showFuncSetting() {
        String funcsXML = (String)this.getView().getFormShowParameter().getCustomParam("functiontypes");
        if (StringUtils.isBlank((CharSequence)funcsXML) && StringUtils.isBlank((CharSequence)(funcsXML = this.getPageCache().get("functiontypes")))) {
            FunctionTypes functionTypes = FunctionTypes.get();
            List functionGroups = functionTypes.getFunctionGroups();
            ArrayList<FunctionGroup> removeGroup = new ArrayList<FunctionGroup>(6);
            for (FunctionGroup functionGroup : functionGroups) {
                if (functionGroup.getId().equals("Math") || functionGroup.getId().equals("String") || functionGroup.getId().equals("Set")) continue;
                removeGroup.add(functionGroup);
            }
            functionGroups.removeAll(removeGroup);
            funcsXML = FunctionTypes.serializeToXML((FunctionTypes)functionTypes);
            this.getPageCache().put("functiontypes", funcsXML);
        }
        String jsonNode = (String)this.getView().getFormShowParameter().getCustomParam("treenodes");
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("entitynumber");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "btnfunction");
        FuncSettingHelper.show((String)funcsXML, (String)entityNumber, (String)jsonNode, (Map)null, (IFormView)this.getView(), (CloseCallBack)closeCallBack);
    }

    private void receiveFuncSetting(String funcSetting) {
        FormulaEditHelper.insertExpression((IFormView)this.getView(), (String)"btnfunction", (String)"fexpression", (String)funcSetting);
    }
}

