/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatCalcDimenSettingEditPlugin
extends AbstractBillPlugIn {
    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initFilter();
    }

    private void initFilter() {
        BasedataEdit costType = (BasedataEdit)this.getControl("costtype");
        costType.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            filters.add(new QFilter("type", "=", (Object)"1"));
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                filters.add(baseDataFilter);
            }
        });
        BasedataEdit material = (BasedataEdit)this.getControl("material");
        material.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
            HashSet<Long> ids = new HashSet<Long>(10);
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObject obj = dynamicObject.getDynamicObject("material");
                if (obj == null) continue;
                ids.add(obj.getLong("id"));
            }
            if (ids.size() > 0) {
                filters.add(new QFilter("id", "not in", ids));
            }
        });
        BasedataEdit materialGroup = (BasedataEdit)this.getControl("materialgroup");
        materialGroup.addBeforeF7SelectListener(evt -> {
            DynamicObject costTypeObj = (DynamicObject)this.getModel().getValue("costtype");
            if (costTypeObj == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u6210\u672c\u7c7b\u578b\u3002", (String)"MatCalcDimenSettingEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject materialGrpstd = (DynamicObject)this.getModel().getValue("materialgrpstd");
            if (materialGrpstd == null) {
                evt.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"MatCalcDimenSettingEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List filters = param.getListFilterParameter().getQFilters();
            ArrayList<Long> createOrgIds = new ArrayList<Long>(3);
            createOrgIds.add(costTypeObj.getLong("useorg.id"));
            QFilter filter = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, materialGrpstd.getPkValue(), true});
            filters.add(filter);
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
            HashSet<Long> ids = new HashSet<Long>(10);
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObject obj = dynamicObject.getDynamicObject("materialgroup");
                if (obj == null) continue;
                ids.add(obj.getLong("id"));
            }
            if (ids.size() > 0) {
                filters.add(new QFilter("id", "not in", ids));
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        this.getModel().beginInit();
        int index = this.getModel().getEntryCurrentRowIndex("entryentity");
        switch (name) {
            case "material": 
            case "materialgroup": {
                this.materAndGroupEnable(index, name);
                break;
            }
            case "materialgrpstd": {
                this.clearMaterGroup();
            }
        }
        this.getModel().endInit();
    }

    private void clearMaterGroup() {
        int count = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < count; ++i) {
            this.getModel().setValue("materialgroup", null, i);
            this.getView().updateView("materialgroup", i);
        }
    }

    private void materAndGroupEnable(int index, String name) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", index);
        DynamicObject materialGroup = (DynamicObject)this.getModel().getValue("materialgroup", index);
        if (CadEmptyUtils.isEmpty((DynamicObject)material) && CadEmptyUtils.isEmpty((DynamicObject)materialGroup)) {
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"materialgroup"});
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"material"});
        } else {
            if ("material".equals(name)) {
                this.getModel().setValue("materialgroup", null, index);
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"materialgroup"});
            }
            if ("materialgroup".equals(name)) {
                this.getModel().setValue("material", null, index);
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"material"});
            }
        }
        this.getView().updateView("material", index);
        this.getView().updateView("materialname", index);
        this.getView().updateView("materialgroup", index);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)status)) {
            int count = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < count; ++i) {
                Object material = this.getModel().getValue("material", i);
                Object materialGroup = this.getModel().getValue("materialgroup", i);
                if (material != null) {
                    this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"materialgroup"});
                }
                if (materialGroup == null) continue;
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"material"});
            }
        } else {
            IPageCache pageCache;
            String costType;
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && (costType = (pageCache = parentView.getPageCache()).get("costtype")) != null) {
                this.getModel().setValue("costtype", (Object)costType);
            }
        }
    }
}

