/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class MatCostInfoEditPlugin
extends AbstractBillPlugIn {
    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"bar_mulevel", (CharSequence)itemKey) || StringUtils.equals((CharSequence)"bar_stdcost", (CharSequence)itemKey)) {
            Object costtype = this.getModel().getValue("costtype");
            Object material = this.getModel().getValue("material");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u672c\u7c7b\u578b\u3002", (String)"MatCostInfoEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (material == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea7\u54c1\u4e0d\u80fd\u4e3a\u7a7a", (String)"MatCostInfoEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        this.showForm(itemKey);
    }

    private void showForm(String itemKey) {
        if (!StringUtils.equals((CharSequence)"bar_mulevel", (CharSequence)itemKey) && !StringUtils.equals((CharSequence)"bar_stdcost", (CharSequence)itemKey)) {
            return;
        }
        ReportShowParameter showParameter = new ReportShowParameter();
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        filterInfo.addFilterItem("costtype", ((DynamicObject)this.getModel().getValue("costtype")).getPkValue());
        filterInfo.addFilterItem("currency", (Object)((DynamicObject)this.getModel().getValue("costtype")).getLong("currency.masterid"));
        DynamicObjectCollection col = new DynamicObjectCollection();
        col.add((Object)((DynamicObject)this.getModel().getValue("material")));
        DynamicObjectCollection configuredCodes = new DynamicObjectCollection();
        DynamicObjectCollection trackNumbers = new DynamicObjectCollection();
        DynamicObjectCollection projects = new DynamicObjectCollection();
        String auxptys = "";
        if (this.getModel().getValue("configuredcode") != null) {
            configuredCodes.add((Object)((DynamicObject)this.getModel().getValue("configuredcode")));
        }
        if (this.getModel().getValue("tracknumber") != null) {
            trackNumbers.add((Object)((DynamicObject)this.getModel().getValue("tracknumber")));
        }
        if (this.getModel().getValue("project") != null) {
            projects.add((Object)((DynamicObject)this.getModel().getValue("project")));
        }
        if (this.getModel().getValue("auxpty") != null) {
            DynamicObject auxpty = (DynamicObject)this.getModel().getValue("auxpty");
            long auxptyId = auxpty.getLong("id");
            if (CadEmptyUtils.isEmpty((String)auxptys)) {
                auxptys = String.valueOf(auxptyId);
            } else if (!CadEmptyUtils.isEmpty((Long)auxptyId)) {
                auxptys = auxptys + "," + auxptyId;
            }
        }
        String lot = (String)this.getModel().getValue("lot");
        filterInfo.addFilterItem("searchdate", (Object)TimeServiceHelper.now());
        if (StringUtils.equals((CharSequence)"bar_mulevel", (CharSequence)itemKey)) {
            filterInfo.addFilterItem("materials", (Object)col);
            filterInfo.addFilterItem("mulconfiguredcode", (Object)configuredCodes);
            filterInfo.addFilterItem("multracknumber", (Object)trackNumbers);
            filterInfo.addFilterItem("mulprojectnumber", (Object)projects);
            filterInfo.addFilterItem("mulauxpty", (Object)auxptys);
            filterInfo.addFilterItem("mullot", (Object)lot);
            showParameter.setFormId("cad_matstdcostdown");
        } else {
            filterInfo.addFilterItem("material", (Object)col);
            filterInfo.addFilterItem("mulconfiguredcode", (Object)configuredCodes);
            filterInfo.addFilterItem("multracknumber", (Object)trackNumbers);
            filterInfo.addFilterItem("mulprojectnumber", (Object)projects);
            filterInfo.addFilterItem("mulauxpty", (Object)auxptys);
            filterInfo.addFilterItem("mullot", (Object)lot);
            showParameter.setFormId("cad_matstdcostup");
        }
        showParameter.setQueryParam(queryParam);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.bindElementInfo();
        this.bindCurrency();
        DynamicObject costTypeDy = (DynamicObject)this.getModel().getValue("costtype");
        if (!CadEmptyUtils.isEmpty((DynamicObject)costTypeDy) && !CostTypeHelper.isUseMatVersion((Long)costTypeDy.getLong("id"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"matversion"});
            BasedataEdit matversion = (BasedataEdit)this.getView().getControl("matversion");
            matversion.setMustInput(false);
        }
        this.getModel().setDataChanged(false);
    }

    private void setVisible(DynamicObject costTypeDy) {
        String type = costTypeDy.getString("type");
        if ("1".equals(type)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"stepamt"});
        }
    }

    private void bindCurrency() {
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        if (costType == null) {
            return;
        }
        this.getModel().setValue("currency", (Object)costType.getLong("currency.id"));
    }

    private void bindElementInfo() {
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            return;
        }
        BigDecimal sumStdPrice = BigDecimal.ZERO;
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        this.getModel().beginInit();
        for (int index = entrys.size() - 1; index >= 0; --index) {
            BigDecimal standardcost = ((DynamicObject)entrys.get(index)).getBigDecimal("standardcost");
            BigDecimal stepamt = ((DynamicObject)entrys.get(index)).getBigDecimal("stepamt");
            sumStdPrice = sumStdPrice.add(standardcost);
            if (BigDecimal.ZERO.compareTo(standardcost) != 0 || BigDecimal.ZERO.compareTo(stepamt) != 0) continue;
            entrys.remove(index);
        }
        this.getModel().setValue("stdprice", (Object)sumStdPrice);
        this.getModel().endInit();
        this.getView().updateView("stdprice");
        this.getView().updateView("entryentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("save".equals(operateKey)) {
            HashMap<String, Long> keyColMap = new HashMap<String, Long>(10);
            keyColMap.put("material", this.getModel().getDataEntity().getLong("material.id"));
            keyColMap.put("auxproperty", this.getModel().getDataEntity().getLong("auxpty.id"));
            keyColMap.put("tracknumber", this.getModel().getDataEntity().getLong("tracknumber.id"));
            keyColMap.put("configuredcode", this.getModel().getDataEntity().getLong("configuredcode.id"));
            String keyCol = CalcKeyHelper.getCalcKey(keyColMap, new ArrayList(), (boolean)true).getKeycol();
            this.getModel().setValue("keycol", (Object)keyCol);
        }
    }
}

