/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.helper.CalcKeyUpdateHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.DateUtils;

public class MatCostInfoListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(MatCostInfoListPlugin.class);

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "tbl_mulevel": 
            case "tbl_stdcost": {
                this.dealTblStdCost(itemKey);
                break;
            }
            case "updatepriceeffexpdate": {
                this.updateEffDate();
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String field = e.getFieldName();
        if ("costtype.id".equals(field) || "costtype.name".equals(field)) {
            e.addCustomQFilter(CostTypeHelper.getCostTypeByAppNum((IFormView)this.getView()));
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                e.getQfilters().add(baseDataFilter);
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String pageCacheCosttype = null;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("costtype.")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            List<ComboItem> costTypes = this.getCostTypeComboItemList();
            if (costTypes == null || costTypes.isEmpty()) break;
            commonFilterColumn.setComboItems(costTypes);
            ComboItem item = costTypes.get(0);
            commonFilterColumn.setDefaultValue(item.getValue());
            pageCacheCosttype = item.getValue();
            break;
        }
        if (pageCacheCosttype != null) {
            this.getPageCache().put("costtype", pageCacheCosttype);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter")) {
            List customfilter = (List)filterValues.get("customfilter");
            if (customfilter == null || customfilter.isEmpty()) {
                return;
            }
            String pageCacheCosttype = null;
            for (int i = 0; i < customfilter.size(); ++i) {
                Map map = (Map)customfilter.get(i);
                List listValue = (List)map.get("Value");
                if (listValue == null || listValue.size() == 0) continue;
                List listFieldName = (List)map.get("FieldName");
                for (int j = 0; j < listFieldName.size(); ++j) {
                    if (!listFieldName.get(j).equals("costtype.id")) continue;
                    pageCacheCosttype = (String)listValue.get(j);
                }
            }
            if (pageCacheCosttype != null) {
                this.getPageCache().put("costtype", pageCacheCosttype);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filters = e.getQFilters();
        logger.info("\u5904\u7406\u524de.getQFilters():{}", (Object)filters.toString());
        Map<String, Date> dateMap = this.removeDateFilter(filters);
        boolean isCostType = this.isCostTypeMode(this.getCacheCostType());
        if (isCostType) {
            this.setEffectDateFilter(filters, dateMap);
        }
        QFilter zeroFilter = new QFilter("entryentity.standardcost", "!=", (Object)BigDecimal.ZERO);
        zeroFilter.or(new QFilter("entryentity.stepamt", "!=", (Object)BigDecimal.ZERO));
        filters.add(zeroFilter);
        logger.info("\u5904\u7406\u540ee.getQFilters():{}", (Object)e.getQFilters().toString());
        e.setOrderBy("costtype,material.number,matversion,auxpty");
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        List listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            switch (column.toString()) {
                case "costtype.name": {
                    column.setFixed(true);
                    break;
                }
                case "currency.name": {
                    column.setFixed(true);
                    break;
                }
                case "material.number": {
                    column.setFixed(true);
                    break;
                }
                case "material.name": {
                    column.setFixed(true);
                    break;
                }
                case "matversion.name": {
                    column.setVisible(0);
                    break;
                }
                case "auxpty": {
                    column.setVisible(0);
                    break;
                }
                case "remark": {
                    column.setVisible(0);
                }
            }
        }
    }

    protected List<ComboItem> getCostTypeComboItemList() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        DynamicObject[] costTypes = CostTypeHelper.getCostType((IFormView)this.getView());
        if (costTypes != null && costTypes.length > 0) {
            for (DynamicObject costType : costTypes) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(costType.getString("name")));
                item.setValue(costType.getString("id"));
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
        }
        return acctItems;
    }

    private Set<Object> getSelectedRowPk() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows == null || selectedRows.size() < 1) {
            return null;
        }
        HashSet<Object> pkIdSet = new HashSet<Object>(4);
        for (int i = 0; i < selectedRows.size(); ++i) {
            ListSelectedRow selectedRow = selectedRows.get(i);
            Object pkId = selectedRow.getPrimaryKeyValue();
            pkIdSet.add(pkId);
        }
        return pkIdSet;
    }

    private void dealTblStdCost(String itemKey) {
        Set<Object> pkIdSet = this.getSelectedRowPk();
        if (pkIdSet == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"MatCostInfoListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] matCostDynArr = BusinessDataServiceHelper.load((String)"cad_matcostinfo", (String)"costtype,material,configuredcode,tracknumber,project,auxpty,lot", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIdSet)});
        if (matCostDynArr == null || matCostDynArr.length < 1) {
            return;
        }
        DynamicObjectCollection collection = new DynamicObjectCollection();
        DynamicObjectCollection configuredCodes = new DynamicObjectCollection();
        DynamicObjectCollection trackNumbers = new DynamicObjectCollection();
        DynamicObjectCollection projects = new DynamicObjectCollection();
        String auxptys = "";
        String lots = "";
        for (DynamicObject dyn : matCostDynArr) {
            collection.add((Object)dyn.getDynamicObject("material"));
            if (dyn.getDynamicObject("configuredcode") != null) {
                configuredCodes.add((Object)dyn.getDynamicObject("configuredcode"));
            }
            if (dyn.getDynamicObject("tracknumber") != null) {
                trackNumbers.add((Object)dyn.getDynamicObject("tracknumber"));
            }
            if (dyn.getDynamicObject("project") != null) {
                projects.add((Object)dyn.getDynamicObject("project"));
            }
            if (dyn.getDynamicObject("auxpty") != null) {
                long auxptyId = dyn.getDynamicObject("auxpty").getLong("id");
                if (CadEmptyUtils.isEmpty((String)auxptys)) {
                    auxptys = String.valueOf(auxptyId);
                } else if (!CadEmptyUtils.isEmpty((Long)auxptyId)) {
                    auxptys = auxptys + "," + auxptyId;
                }
            }
            String lot = dyn.getString("lot");
            if (CadEmptyUtils.isEmpty((String)lots)) {
                lots = lot;
                continue;
            }
            if (CadEmptyUtils.isEmpty((String)lot)) continue;
            lots = lots + "," + lot;
        }
        ReportShowParameter showParameter = new ReportShowParameter();
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        filterInfo.addFilterItem("costtype", matCostDynArr[0].getDynamicObject("costtype").getPkValue());
        filterInfo.addFilterItem("currency", (Object)matCostDynArr[0].getLong("costtype.currency.masterid"));
        filterInfo.addFilterItem("searchdate", (Object)TimeServiceHelper.now());
        if ("tbl_mulevel".equals(itemKey)) {
            filterInfo.addFilterItem("materials", (Object)collection);
            filterInfo.addFilterItem("mulconfiguredcode", (Object)configuredCodes);
            filterInfo.addFilterItem("multracknumber", (Object)trackNumbers);
            filterInfo.addFilterItem("mulprojectnumber", (Object)projects);
            filterInfo.addFilterItem("mulauxpty", (Object)auxptys);
            filterInfo.addFilterItem("mullot", (Object)lots);
            showParameter.setFormId("cad_matstdcostdown");
        } else {
            filterInfo.addFilterItem("material", (Object)collection);
            filterInfo.addFilterItem("mulconfiguredcode", (Object)configuredCodes);
            filterInfo.addFilterItem("multracknumber", (Object)trackNumbers);
            filterInfo.addFilterItem("mulprojectnumber", (Object)projects);
            filterInfo.addFilterItem("mulauxpty", (Object)auxptys);
            filterInfo.addFilterItem("mullot", (Object)lots);
            showParameter.setFormId("cad_matstdcostup");
        }
        showParameter.setQueryParam(queryParam);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setEffectDateFilter(List<QFilter> filters, Map<String, Date> dateMap) {
        if (dateMap.isEmpty()) {
            return;
        }
        Date startDate = dateMap.get("startDate");
        Date endDate = DateUtils.getLastSecond((Date)dateMap.get("endDate"), (int)1);
        QFilter dateFilter1 = new QFilter("effectdate", "<", (Object)startDate).and(new QFilter("expdate", ">=", (Object)startDate));
        QFilter dateFilter2 = new QFilter("effectdate", "<=", (Object)startDate).and(new QFilter("expdate", ">", (Object)startDate));
        QFilter dateFilter3 = new QFilter("effectdate", ">=", (Object)startDate).and(new QFilter("effectdate", "<", (Object)endDate));
        QFilter dateFilter4 = new QFilter("effectdate", ">", (Object)startDate).and(new QFilter("effectdate", "<=", (Object)endDate));
        filters.add(dateFilter1.or(dateFilter2).or(dateFilter3).or(dateFilter4));
    }

    private String getCacheCostType() {
        String id = this.getPageCache().get("costtype");
        if (StringUtils.isEmpty((String)id)) {
            return "0";
        }
        return id;
    }

    private boolean isCostTypeMode(String costTypeId) {
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(costTypeId));
        filter.and("type", "=", (Object)"0");
        return QueryServiceHelper.exists((String)"cad_costtype", (QFilter[])new QFilter[]{filter});
    }

    private Map<String, Date> removeDateFilter(List<QFilter> filters) {
        HashMap<String, Date> result = new HashMap<String, Date>(8);
        ArrayList<Date> dates = new ArrayList<Date>(4);
        ArrayList<QFilter> newFilters = new ArrayList<QFilter>(filters.size());
        for (QFilter filter : filters) {
            for (QFilter fs : filter.recombine()) {
                if ("expdate".equals(fs.getProperty())) {
                    dates.add((Date)fs.getValue());
                    continue;
                }
                newFilters.add(fs);
            }
        }
        if (dates.size() > 1) {
            result.put("startDate", (Date)dates.get(dates.size() - 2));
            result.put("endDate", (Date)dates.get(dates.size() - 1));
        }
        filters.clear();
        filters.addAll(newFilters);
        return result;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("updatekeycol".equals(operateKey)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmCopy", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u5c06\u4f1a\u5347\u7ea7\u5f53\u524d\u6210\u672c\u7c7b\u578b\u4e0b\u76f8\u5173\u7684\u5377\u7b97\u57fa\u7840\u8d44\u6599\uff0c\u521d\u6b21\u5347\u7ea7\u8017\u65f6\u53ef\u80fd\u8f83\u957f\uff0c\u786e\u8ba4\u5347\u7ea7\u5417\uff1f", (String)"MatCostInfoListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "confirmCopy": {
                if (!MessageBoxResult.Yes.equals((Object)e.getResult())) break;
                String cacheCostType = this.getCacheCostType();
                CalcKeyUpdateHelper.updateKeyColByCostType((Long)Long.parseLong(cacheCostType));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"MatCostInfoListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void updateEffDate() {
        try (TXHandle tx = TX.requiresNew();){
            QFilter costTypeFilter = new QFilter("costtype.type", "=", (Object)"1");
            QFilter ruleFilter = new QFilter("pricerule", "!=", (Object)PriceRuleConstants.PUR_MANUALLY_ID);
            DynamicObjectCollection prices = QueryServiceHelper.query((String)"cad_purprices", (String)"costtype.name,costtype.type,id", (QFilter[])new QFilter[]{costTypeFilter, ruleFilter});
            List puriceIds = DynamicObjectHelper.getIdList((DynamicObjectCollection)prices, (String)"id");
            Lists.partition((List)puriceIds, (int)10000).forEach(puriceIdList -> {
                DynamicObject[] dynamicObjects;
                for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_purprices", (String)"effectdate,expdate", (QFilter[])new QFilter[]{new QFilter("id", "in", puriceIdList)})) {
                    Date effectdate = dynamicObject.getDate("effectdate");
                    Date expdate = dynamicObject.getDate("expdate");
                    if (DateUtils.getDeFaultExpDate().equals(expdate)) {
                        dynamicObject.set("effectdate", (Object)DateUtils.getDayStartTime((Date)effectdate));
                        continue;
                    }
                    dynamicObject.set("effectdate", (Object)DateUtils.getDayStartTime((Date)effectdate));
                    dynamicObject.set("expdate", (Object)DateUtils.getDayStartTime((Date)expdate));
                }
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
            });
            ruleFilter = new QFilter("pricerule", "!=", (Object)PriceRuleConstants.OUTPRI_MANUALLY_ID);
            DynamicObjectCollection outPrices = QueryServiceHelper.query((String)"cad_outsourceprice", (String)"id", (QFilter[])new QFilter[]{costTypeFilter, ruleFilter});
            List outPriceIds = DynamicObjectHelper.getIdList((DynamicObjectCollection)outPrices, (String)"id");
            Lists.partition((List)outPriceIds, (int)10000).forEach(outPriceIdList -> {
                DynamicObject[] dynamicObjects;
                for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_outsourceprice", (String)"effectdate,expdate", (QFilter[])new QFilter[]{new QFilter("id", "in", outPriceIdList)})) {
                    Date effectdate = dynamicObject.getDate("effectdate");
                    Date expdate = dynamicObject.getDate("expdate");
                    if (DateUtils.getDeFaultExpDate().equals(expdate)) {
                        dynamicObject.set("effectdate", (Object)DateUtils.getDayStartTime((Date)effectdate));
                        continue;
                    }
                    dynamicObject.set("effectdate", (Object)DateUtils.getDayStartTime((Date)effectdate));
                    dynamicObject.set("expdate", (Object)DateUtils.getDayStartTime((Date)expdate));
                }
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
            });
            ruleFilter = new QFilter("pricerule", "!=", (Object)PriceRuleConstants.OUTRES_MANUALLY_ID);
            DynamicObjectCollection resourceOuts = QueryServiceHelper.query((String)"cad_resourceout", (String)"id", (QFilter[])new QFilter[]{costTypeFilter, ruleFilter});
            List resourceOutIds = DynamicObjectHelper.getIdList((DynamicObjectCollection)resourceOuts, (String)"id");
            Lists.partition((List)resourceOutIds, (int)10000).forEach(resourceOutIdList -> {
                DynamicObject[] dynamicObjects;
                for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_resourceout", (String)"effectdate,expdate", (QFilter[])new QFilter[]{new QFilter("id", "in", resourceOutIdList)})) {
                    Date effectdate = dynamicObject.getDate("effectdate");
                    Date expdate = dynamicObject.getDate("expdate");
                    if (DateUtils.getDeFaultExpDate().equals(expdate)) {
                        dynamicObject.set("effectdate", (Object)DateUtils.getDayStartTime((Date)effectdate));
                        continue;
                    }
                    dynamicObject.set("effectdate", (Object)DateUtils.getDayStartTime((Date)effectdate));
                    dynamicObject.set("expdate", (Object)DateUtils.getDayStartTime((Date)expdate));
                }
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
            });
            ruleFilter = new QFilter("pricerule", "!=", (Object)PriceRuleConstants.SELFRES_MANUALLY_ID);
            DynamicObjectCollection resourceRates = QueryServiceHelper.query((String)"cad_resourcerate", (String)"id", (QFilter[])new QFilter[]{costTypeFilter, ruleFilter});
            List resourceRateIds = DynamicObjectHelper.getIdList((DynamicObjectCollection)resourceRates, (String)"id");
            Lists.partition((List)resourceRateIds, (int)10000).forEach(resourceRateIdList -> {
                DynamicObject[] dynamicObjects;
                for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"cad_resourcerate", (String)"effectdate,expdate", (QFilter[])new QFilter[]{new QFilter("id", "in", resourceRateIdList)})) {
                    Date effectdate = dynamicObject.getDate("effectdate");
                    Date expdate = dynamicObject.getDate("expdate");
                    if (DateUtils.getDeFaultExpDate().equals(expdate)) {
                        dynamicObject.set("effectdate", (Object)DateUtils.getDayStartTime((Date)effectdate));
                        continue;
                    }
                    dynamicObject.set("effectdate", (Object)DateUtils.getDayStartTime((Date)effectdate));
                    dynamicObject.set("expdate", (Object)DateUtils.getDayStartTime((Date)expdate));
                }
                SaveServiceHelper.update((DynamicObject[])dynamicObjects);
            });
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u6210\u529f\u3002", (String)"MatCostInfoListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }
}

