/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class ProductGroupEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener,
RowClickEventListener {
    private static final String KEY_ENTRYENTITY = "entryentity";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit matVersion = (BasedataEdit)this.getControl("matversion");
        matVersion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        matVersion.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit groupCategoryEdit = (BasedataEdit)this.getControl("groupcategory");
        groupCategoryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        BasedataEdit subelement = (BasedataEdit)this.getControl("subelement");
        if (StringUtils.isEmpty((Object)subelement)) {
            return;
        }
        subelement.addBeforeF7SelectListener(evt -> {
            int entryentity = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
            DynamicObjectCollection entryentitydetail = this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, entryentity).getDynamicObjectCollection("weightentry");
            List collect = entryentitydetail.stream().map(o -> o.getLong("subelement.id")).filter(o -> o != null).collect(Collectors.toList());
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            filterParameter.getQFilters().add(new QFilter("id", "not in", collect));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object currentOrg = formShowParameter.getCustomParam("currentOrg");
        if (currentOrg != null && !StringUtils.isEmpty((Object)currentOrg)) {
            QFilter idFilter;
            DynamicObject productGroup;
            Object isMulOrg = formShowParameter.getCustomParam("isMulOrg");
            long calOrg = 0L;
            if (isMulOrg != null && "true".equals(isMulOrg) && (productGroup = QueryServiceHelper.queryOne((String)"cad_productintogroup", (String)"id, calorg", (QFilter[])(idFilter = new QFilter("id", "=", this.getModel().getValue("id"))).toArray())) != null) {
                calOrg = productGroup.getLong("calorg");
            }
            this.getModel().setValue("calorg", CadEmptyUtils.isEmpty((Long)calOrg) ? currentOrg : Long.valueOf(calOrg));
            Object org = CadEmptyUtils.isEmpty((Long)calOrg) ? currentOrg : Long.valueOf(calOrg);
            this.getModel().setValue("calorg", org);
            this.getModel().setValue("createorg", org);
            this.getModel().setValue("useorg", org);
        }
    }

    public void beforeBindData(EventObject e) {
        OperationStatus status;
        boolean isEditOrView;
        super.beforeBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"calorg"});
        String groupType = "";
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            groupType = parentView.getPageCache().get("grouptype");
            DynamicObject createOrg = (DynamicObject)this.getModel().getValue("createorg");
            if (createOrg != null) {
                parentView.getPageCache().put("createOrg", String.valueOf(createOrg.getLong("id")));
            }
        }
        boolean bl = isEditOrView = (status = this.getView().getFormShowParameter().getStatus()).equals((Object)OperationStatus.EDIT) || status.equals((Object)OperationStatus.VIEW);
        if (isEditOrView) {
            groupType = this.getModel().getDataEntity().getString("grouptype");
        } else if (StringUtils.isEmpty((Object)groupType)) {
            groupType = "1";
        }
        switch (groupType) {
            case "1": {
                this.getModel().beginInit();
                this.getModel().setValue("grouptype", (Object)"1");
                this.setEnable(false, "addrow2", "insertrow2", "delrow2");
                this.setVisible(false, "groupfield", "groupcategory");
                this.setVisible(true, "productweight");
                if ("sca".equals(this.getView().getFormShowParameter().getAppId())) {
                    this.setVisible(false, "fixedamt");
                }
                this.getModel().endInit();
                break;
            }
            case "2": {
                this.getModel().beginInit();
                this.setVisible(false, "productweight", "matversion", "auxpty", "producttype", "alloctype");
                this.setVisible(true, "groupfield", "groupcategory");
                this.getModel().setValue("grouptype", (Object)"2");
                String groupField = (String)this.getModel().getValue("groupfield");
                if (groupField != null && groupField.equals("bd_auxproperty")) {
                    this.setVisible(false, "groupcategory");
                    this.setVisible(true, "auxpty");
                } else {
                    this.setVisible(true, "groupcategory");
                    this.setVisible(false, "auxpty");
                }
                ItemClassTypeEdit groupFieldEdit = (ItemClassTypeEdit)this.getView().getControl("groupfield");
                groupFieldEdit.setMustInput(true);
                this.getModel().endInit();
                break;
            }
            case "3": {
                this.getModel().beginInit();
                this.setVisible(true, "auxpty");
                this.setVisible(false, "groupfield", "groupcategory", "productweight");
                this.getModel().setValue("grouptype", (Object)"3");
                break;
            }
        }
        Long id = (Long)this.getModel().getValue("id");
        if ((QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])new QFilter[]{new QFilter("productgroup", "=", (Object)id)}) || QueryServiceHelper.exists((String)"aca_mfgfeebill", (QFilter[])new QFilter[]{new QFilter("productgroup", "=", (Object)id)})) && "1".equals(this.getModel().getValue("unauditflag"))) {
            int entryRowCount = this.getModel().getEntryRowCount(KEY_ENTRYENTITY);
            this.getPageCache().put("count", String.valueOf(entryRowCount));
            for (int i = 0; i < entryRowCount; ++i) {
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"material", "matversion", "auxpty", "producttype"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{""});
            }
        }
        this.scaHide();
        this.setSrcFieldHide();
        this.getModel().setDataChanged(false);
    }

    private void scaHide() {
        if ("sca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_delete", "bar_save", "bar_modify", "bar_submit", "bar_audit", "bar_disable", "bar_more"});
            ComboEdit groupTypeEdit = (ComboEdit)this.getControl("grouptype");
            Tips groupTypeTip = new Tips();
            groupTypeTip.setContent(new LocaleString(ResManager.loadKDString((String)"\u4e3b\u8054\u526f\uff1a\u7528\u4e8e\u5904\u7406\u4e3b\u8054\u526f\u4e1a\u52a1\u7684\u6210\u672c\u6838\u7b97\u3002", (String)"ProductGroupEdit_19", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            groupTypeTip.setType("text");
            groupTypeEdit.addTips(groupTypeTip);
            EntryGrid entryGrid = (EntryGrid)this.getControl(KEY_ENTRYENTITY);
            entryGrid.setColumnProperty("alloctype", "tips", (Object)"");
            entryGrid.setColumnProperty("weight", "tips", (Object)"");
            this.getModel().setDataChanged(false);
        }
    }

    private void setSrcFieldHide() {
        String groupType = this.getModel().getDataEntity().getString("grouptype");
        if ("2".equals(groupType)) {
            String groupField;
            HashSet fields = Sets.newHashSet((Object[])new String[]{"bd_invtype", "bd_auxproperty"});
            if (fields.contains(groupField = this.getModel().getDataEntity().getString("groupfield"))) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"srcfield"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"srcfield"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"srcfield"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
        if (entryEntity != null) {
            for (int index = 0; index < entryEntity.size(); ++index) {
                DynamicObject entry = (DynamicObject)entryEntity.get(index);
                if (entry == null) continue;
                String allocType = entry.getString("alloctype");
                if ("3".equals(allocType) || "1".equals(allocType)) {
                    this.getView().setEnable(Boolean.FALSE, index, new String[]{"weight"});
                    continue;
                }
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"weight"});
            }
        }
    }

    public void setVisible(boolean isShow, String ... fields) {
        for (String field : fields) {
            this.getView().setVisible(Boolean.valueOf(isShow), new String[]{field});
        }
    }

    public void setEnable(boolean isShow, String ... fields) {
        for (String field : fields) {
            this.getView().setEnable(Boolean.valueOf(isShow), new String[]{field});
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("unauditflag", null);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("bar_delete".equals(evt.getItemKey())) {
            DynamicObject mfgfeebill;
            Long id = (Long)this.getModel().getValue("id");
            String name = "";
            String billno = "";
            DynamicObject costobject = QueryServiceHelper.queryOne((String)"cad_costobject", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("productgroup", "=", (Object)id)});
            if (costobject != null) {
                name = costobject.getString("name");
            }
            if ((mfgfeebill = QueryServiceHelper.queryOne((String)"aca_mfgfeebill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("productgroup", "=", (Object)id)})) != null) {
                billno = mfgfeebill.getString("billno");
            }
            DynamicObjectCollection entry = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
            for (DynamicObject dynamicObject : entry) {
                String message;
                String material = dynamicObject.getString("material.name");
                boolean exists = QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])new QFilter[]{new QFilter("productgroup", "=", (Object)id)});
                if (exists) {
                    evt.setCancel(true);
                    message = String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7ec4\u201c%1$s\u201d\u5df2\u7ecf\u88ab\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%2$s\u201d\u5f15\u7528\u3002", (String)"ProductGroupEdit_16", (String)"macc-cad-formplugin", (Object[])new Object[0]), material, name);
                    this.getView().showMessage(message);
                }
                if (!(exists = QueryServiceHelper.exists((String)"aca_mfgfeebill", (QFilter[])new QFilter[]{new QFilter("productgroup", "=", (Object)id)}))) continue;
                evt.setCancel(true);
                message = String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7ec4\u201c%1$s\u201d\u5df2\u7ecf\u88ab\u5236\u9020\u8d39\u7528\u5f52\u96c6\u5355\u201c%2$s\u201d\u5f15\u7528\u3002", (String)"ProductGroupEdit_17", (String)"macc-cad-formplugin", (Object[])new Object[0]), material, billno);
                this.getView().showMessage(message);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        int index = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("material".equals(name)) {
            if (newValue != null && index >= 0) {
                this.getModel().setValue("producttype", null, index);
                if ("2".equals(this.getModel().getValue("grouptype"))) {
                    this.controlMatVerAndAuxpty((DynamicObject)newValue, index);
                } else {
                    this.setMatVersionAndAuxptyEnable((DynamicObject)newValue, index);
                }
            }
        } else if ("producttype".equals(name)) {
            this.validateProductType(newValue, index);
        } else if ("alloctype".equals(name)) {
            Object allocType = this.getModel().getValue("alloctype", index);
            this.validateAllocType(allocType, index);
        } else if ("grouptype".equals(name)) {
            this.setFieldMustInput((String)newValue);
        } else if ("subelement".equals(name)) {
            this.setElement(newValue, index);
        } else if ("calorg".equals(name)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"productweight"});
        } else if ("groupfield".equals(name)) {
            this.setAuxVisible((String)newValue);
            this.setSrcFieldHide();
        } else if ("weight".equals(name)) {
            if (newValue != null) {
                BigDecimal val = new BigDecimal(String.valueOf(newValue));
                String groupType = this.getModel().getDataEntity().getString("grouptype");
                if ("2".equals(groupType)) {
                    if (val.compareTo(BigDecimal.ZERO) < 0 || val.compareTo(new BigDecimal(100)) >= 0) {
                        this.getModel().setValue("weight", (Object)1, index);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u624b\u5de5\u65b0\u589e\u6743\u91cd\u8303\u56f4\u4e3a\uff1a0\u2264\u6743\u91cd<100\u3002", (String)"ProductGroupEdit_18", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    }
                } else {
                    Object allocType = this.getModel().getValue("alloctype", index);
                    if ("2".equals(allocType) && (val.compareTo(BigDecimal.ZERO) <= 0 || val.compareTo(new BigDecimal(100)) >= 0)) {
                        this.getModel().setValue("weight", (Object)1, index);
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u624b\u5de5\u65b0\u589e\u6743\u91cd\u8303\u56f4\u4e3a\uff1a0<\u6743\u91cd<100\u3002", (String)"ProductGroupEdit_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        } else if ("allocweight".equals(name) || "fixedamt".equals(name)) {
            Object allocweight = this.getModel().getValue("allocweight", index);
            Object fixedamt = this.getModel().getValue("fixedamt", index);
            this.setEnableWeightAndAmt(allocweight, fixedamt, index);
        }
    }

    private void setEnableWeightAndAmt(Object allocweight, Object fixedamt, int index) {
        int emptyFixedAmt;
        boolean editAllocWeight = Boolean.TRUE;
        boolean editFixedAmt = Boolean.TRUE;
        int emptyAllocWeight = ObjectUtils.isEmpty((Object)allocweight) ? 0 : BigDecimal.ZERO.compareTo(new BigDecimal(String.valueOf(allocweight)));
        int n = emptyFixedAmt = ObjectUtils.isEmpty((Object)fixedamt) ? 0 : BigDecimal.ZERO.compareTo(new BigDecimal(String.valueOf(fixedamt)));
        if (emptyAllocWeight == 0 && emptyFixedAmt != 0) {
            editAllocWeight = Boolean.FALSE;
        }
        if (emptyAllocWeight != 0 && emptyFixedAmt == 0) {
            editFixedAmt = Boolean.FALSE;
        }
        if (emptyAllocWeight != 0 && emptyFixedAmt != 0) {
            editAllocWeight = Boolean.TRUE;
            editFixedAmt = Boolean.TRUE;
        }
        this.getView().setEnable(Boolean.valueOf(editAllocWeight), index, new String[]{"allocweight"});
        this.getView().setEnable(Boolean.valueOf(editFixedAmt), index, new String[]{"fixedamt"});
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid actEntry = (EntryGrid)evt.getSource();
        String entryKey = actEntry.getEntryKey();
        int[] selectRows = actEntry.getSelectRows();
        if (selectRows.length < 1) {
            return;
        }
        if (KEY_ENTRYENTITY.equals(entryKey)) {
            int row = evt.getRow();
            DynamicObject entry = this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, row);
            String producttype = entry.getString("producttype");
            if ("A".equals(producttype)) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"weightentry"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"addrow2"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"insertrow2"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"delrow2"});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"weightentry"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"addrow2"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"insertrow2"});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"delrow2"});
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String groupField;
        Object material;
        int row = beforeF7SelectEvent.getRow();
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        if ("matversion".equals(propertyName) && (material = this.getModel().getValue("material", row)) != null) {
            QFilter materialFilter = new QFilter("material", "=", ((DynamicObject)material).getPkValue());
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(materialFilter);
        }
        if ("groupcategory".equals(propertyName) && "bd_invtype".equals(groupField = (String)this.getModel().getValue("groupfield"))) {
            QFilter filter = new QFilter("isforwardamount", "=", (Object)true);
            filter.and("enable", "=", (Object)"1");
            HashSet<Long> ids = new HashSet<Long>();
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
            for (DynamicObject dynamicObject : dynamicObjects) {
                long id = dynamicObject.getLong("groupcategory.id");
                if (CadEmptyUtils.isEmpty((Long)id)) continue;
                ids.add(id);
            }
            if (ids.size() > 0) {
                filter.and("id", "not in", ids);
            }
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        int currentRowIndex = afterF7SelectEvent.getCurrentRowIndex();
        Object material = this.getModel().getValue("material", currentRowIndex);
        ListSelectedRowCollection selectedRowCollection = afterF7SelectEvent.getListSelectedRowCollection();
        for (int i = 1; i < selectedRowCollection.size(); ++i) {
            this.getModel().setValue("material", material, ++currentRowIndex);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        sourceData.put("source", "MANUAL");
    }

    private void setMatVersionAndAuxptyEnable(DynamicObject material, int rowIndex) {
        this.getView().setEnable(Boolean.valueOf(BomRouterHelper.isEnableMatversion((DynamicObject)material)), rowIndex, new String[]{"matversion"});
        this.getView().setEnable(Boolean.valueOf(BomRouterHelper.enableAuxNotEffCost((DynamicObject)material)), rowIndex, new String[]{"auxpty"});
    }

    private void controlMatVerAndAuxpty(DynamicObject material, int rowIndex) {
        this.getView().setEnable(Boolean.valueOf(BomRouterHelper.isEnableMatversion((DynamicObject)material)), rowIndex, new String[]{"matversion"});
        this.getView().setEnable(Boolean.valueOf(BomRouterHelper.enableAuxNotEffCost((DynamicObject)material)), rowIndex, new String[]{"auxpty"});
    }

    private void validateProductType(Object productType, int rowIndex) {
        DynamicObject material;
        if (productType == null) {
            return;
        }
        if (("A".equals(productType) || "B".equals(productType)) && (material = (DynamicObject)this.getModel().getValue("material", rowIndex)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4ea7\u54c1\u3002", (String)"ProductGroupEdit_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("producttype", null, rowIndex);
            return;
        }
        if ("B".equals(productType)) {
            this.getModel().setValue("alloctype", (Object)"3", rowIndex);
        } else {
            this.getModel().setValue("alloctype", null, rowIndex);
        }
        if ("A".equals(productType)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"weightentry"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"addrow2"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"insertrow2"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"delrow2"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"weightentry"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"addrow2"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"insertrow2"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"delrow2"});
        }
    }

    private void setAllocType() {
        Object groupType = this.getModel().getValue("grouptype");
        if ("2".equals(groupType)) {
            this.getModel().setValue("alloctype", (Object)"2");
            this.getView().setEnable(Boolean.FALSE, new String[]{"alloctype"});
        }
    }

    private void validateAllocType(Object allocType, int index) {
        Object groupType = this.getModel().getValue("grouptype");
        if (groupType == null || StringUtils.isEmpty((Object)allocType)) {
            return;
        }
        String productType = (String)this.getModel().getValue("producttype", index);
        if ("1".equals(groupType)) {
            if ("3".equals(allocType) || "1".equals(allocType)) {
                this.getModel().setValue("weight", null, index);
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"weight"});
            } else {
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"weight"});
            }
            if (StringUtils.isEmpty((Object)productType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u786e\u5b9a\u4ea7\u54c1\u7c7b\u578b\u3002", (String)"ProductGroupEdit_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("alloctype", null, index);
            }
            if (("C".equals(productType) || "A".equals(productType)) && "3".equals(allocType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e3a\u4e3b\u4ea7\u54c1\u6216\u8054\u4ea7\u54c1\u65f6\uff0c\u5206\u914d\u7c7b\u578b\u4e0d\u80fd\u6307\u5b9a\u4e3a\u5b9a\u989d\u3002", (String)"ProductGroupEdit_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("alloctype", null, index);
                return;
            }
            if ("B".equals(productType) && !"3".equals(allocType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e3a\u526f\u4ea7\u54c1\u65f6\uff0c\u5206\u914d\u7c7b\u578b\u53ea\u80fd\u4e3a\u5b9a\u989d\u3002", (String)"ProductGroupEdit_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("alloctype", null, index);
                return;
            }
        } else if ("2".equals(groupType) && !"2".equals(allocType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u4f9d\u636e\u4e3a\u7b49\u7ea7\uff0c\u5206\u914d\u7c7b\u578b\u53ea\u80fd\u4e3a\u624b\u5de5\u6307\u5b9a\u3002", (String)"ProductGroupEdit_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("alloctype", null, index);
            return;
        }
        if ("2".equals(allocType)) {
            this.getView().setEnable(Boolean.TRUE, index, new String[]{"weight"});
            this.getView().updateView("weight", index);
        } else {
            this.getModel().setValue("weight", null, index);
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if ("grouptype".equals(propertyName)) {
            long id = (Long)this.getModel().getValue("id");
            String changeCol = this.getPageCache().get("changeCol");
            if (changeCol != null && "false".equals(changeCol)) {
                this.getPageCache().remove("changeCol");
                return;
            }
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (oldValue != null) {
                this.getPageCache().put("oldGroupType", oldValue.toString());
            }
            if ("1".equals(this.getModel().getValue("unauditflag")) && QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])new QFilter[]{new QFilter("productgroup", "=", (Object)id)})) {
                DynamicObjectCollection costObjects = QueryServiceHelper.query((String)"cad_costobject", (String)"billno", (QFilter[])new QFilter[]{new QFilter("productgroup", "=", (Object)id)});
                StringBuilder sb = new StringBuilder();
                costObjects.forEach(s -> sb.append(s.getString("billno")).append("\uff1b"));
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7ec4\u5df2\u7ecf\u88ab\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u5207\u6362\u5206\u7ec4\u4f9d\u636e\u3002", (String)"ProductGroupEdit_11", (String)"macc-cad-formplugin", (Object[])new Object[0]), sb.length() > 0 ? sb.substring(0, sb.length() - 1) : sb), MessageTypes.Default, new ConfirmCallBackListener("grouptypeChange", (IFormPlugin)this));
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5206\u7ec4\u4f9d\u636e\u5c06\u6e05\u7a7a\u5f53\u524d\u4ea7\u54c1\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProductGroupEdit_12", (String)"macc-cad-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("grouptypeChange", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("grouptypeChange".equals(callBackId)) {
            MessageBoxResult result = messageBoxClosedEvent.getResult();
            if (MessageBoxResult.Cancel.getValue() == result.getValue()) {
                this.getPageCache().put("changeCol", "false");
                this.getModel().setValue("grouptype", (Object)this.getPageCache().get("oldGroupType"));
            } else {
                this.getModel().deleteEntryData(KEY_ENTRYENTITY);
                this.getView().invokeOperation("newentry");
                this.setAllocType();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        Long id = (Long)this.getModel().getValue("id");
        switch (operateKey) {
            case "save": 
            case "submit": 
            case "submitandnew": {
                String groupType = this.getModel().getDataEntity().getString("grouptype");
                if ("1".equals(groupType)) {
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(KEY_ENTRYENTITY);
                    if (entryEntity.isEmpty()) break;
                    for (int i = 0; i < entryEntity.size(); ++i) {
                        this.getModel().setValue("stocktype", null, i);
                        for (DynamicObject dynamicObject : entryEntity) {
                            DynamicObjectCollection weightentry = dynamicObject.getDynamicObjectCollection("weightentry");
                            if (weightentry == null || weightentry.isEmpty()) continue;
                            StringBuilder message = new StringBuilder();
                            for (DynamicObject weightEntry : weightentry) {
                                BigDecimal bigDecimal = weightEntry.getBigDecimal("fixedamt");
                                String type = weightEntry.getString("subelement.type");
                                String seq = weightEntry.getString("seq");
                                if (CadEmptyUtils.isEmpty((BigDecimal)bigDecimal) || !"001".equals(type) && !"002".equals(type)) continue;
                                message.append(String.format(ResManager.loadKDString((String)"\u8054\u4ea7\u54c1\u5206\u914d\u6743\u91cd\u660e\u7ec6\u7b2c%1$s\u884c\u201c\u6210\u672c\u5b50\u8981\u7d20\u201d\u4e3a\u7269\u6599\u6216\u7269\u6599\u8d39\u7528\u7c7b\u578b\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u56fa\u5b9a\u91d1\u989d\u3002%n", (String)"ProductGroupEdit_27", (String)"macc-cad-formplugin", (Object[])new Object[0]), seq));
                            }
                            if (CadEmptyUtils.isEmpty((String)String.valueOf(message))) continue;
                            this.getView().showMessage(String.valueOf(message));
                            e.setCancel(true);
                        }
                    }
                }
                if (!"2".equals(groupType)) break;
                String groupField = this.getModel().getDataEntity().getString("groupfield");
                if (CadEmptyUtils.isEmpty((String)groupField)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5206\u7ec4\u4f9d\u636e\u4e3a\u7b49\u7ea7\u65f6\uff0c\u5206\u7ec4\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProductGroupEdit_20", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                HashSet fields = Sets.newHashSet((Object[])new String[]{"bd_invtype", "bd_auxproperty"});
                if (fields.contains(groupField)) break;
                String srcField = this.getModel().getDataEntity().getString("srcfield");
                if (CadEmptyUtils.isEmpty((String)srcField)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u5206\u7ec4\u5b57\u6bb5\u4e3a\u4e8c\u5f00\u9879\u65f6\uff0c\u6e90\u5355\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ProductGroupEdit_21", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"cad_factnedoutputbill");
                DynamicProperty property = mainEntityType.getProperty(srcField);
                if (property == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u6e90\u5355\u5b57\u6bb5\u540d\u79f0\uff0c\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u4e2d\u4e0d\u5b58\u5728\u6b64\u5b57\u6bb5\u3002", (String)"ProductGroupEdit_22", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                if (property instanceof BasedataProp) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u5355\u5b57\u6bb5\u5728\u5b8c\u5de5\u4ea7\u91cf\u5f52\u96c6\u5355\u4e2d\u987b\u4e3a\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u3002", (String)"ProductGroupEdit_23", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
            case "deleteentry": {
                if (!QueryServiceHelper.exists((String)"cad_costobject", (QFilter[])new QFilter[]{new QFilter("productgroup", "=", (Object)id)}) && !QueryServiceHelper.exists((String)"aca_mfgfeebill", (QFilter[])new QFilter[]{new QFilter("productgroup", "=", (Object)id)}) || !"1".equals(this.getModel().getValue("unauditflag"))) break;
                int index = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
                DynamicObject entryEntity = this.getModel().getEntryRowEntity(KEY_ENTRYENTITY, index);
                if (entryEntity == null || CadEmptyUtils.isEmpty((Long)entryEntity.getLong("id"))) break;
                QFilter productQFilter = new QFilter("id", "=", (Object)id);
                productQFilter.and(new QFilter("entryentity.id", "=", (Object)entryEntity.getLong("id")));
                if (!QueryServiceHelper.exists((String)"cad_productintogroup", (QFilter[])productQFilter.toArray())) break;
                DynamicObjectCollection costObjects = QueryServiceHelper.query((String)"cad_costobject", (String)"billno", (QFilter[])new QFilter[]{new QFilter("productgroup", "=", (Object)id)});
                StringBuilder sb = new StringBuilder();
                costObjects.forEach(s -> sb.append(s.getString("billno")).append("\uff1b"));
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7ec4\u5df2\u7ecf\u88ab\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u4ea7\u54c1\u4fe1\u606f\u3002", (String)"ProductGroupEdit_14", (String)"macc-cad-formplugin", (Object[])new Object[0]), sb.length() > 0 ? sb.substring(0, sb.length() - 1) : sb));
                e.setCancel(true);
                break;
            }
            case "newweightentry": {
                if (!"1".equals((String)this.getModel().getValue("grouptype"))) break;
                int rowIndex = this.getModel().getEntryCurrentRowIndex(KEY_ENTRYENTITY);
                String product = (String)this.getModel().getValue("producttype", rowIndex);
                if (!"B".equals(product) && !"C".equals(product)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4ea7\u54c1\u7c7b\u578b\u4e3a\u201c\u8054\u4ea7\u54c1\u201d\u65f6\uff0c\u5141\u8bb8\u8bbe\u7f6e\u8054\u4ea7\u54c1\u5206\u914d\u6743\u91cd\u660e\u7ec6\u3002", (String)"ProductGroupEdit_15", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    private void setFieldMustInput(String groupType) {
        switch (groupType) {
            case "1": {
                ComboEdit productType = (ComboEdit)this.getControl("producttype");
                ComboEdit allocType = (ComboEdit)this.getControl("alloctype");
                productType.setMustInput(true);
                allocType.setMustInput(true);
                this.setVisible(true, "matversion", "auxpty", "producttype", "alloctype", "productweight");
                this.setVisible(false, "groupfield", "groupcategory");
                this.setEnable(false, "weightentry", "addrow2", "insertrow2", "delrow2");
                this.getModel().setValue("groupfield", null);
                break;
            }
            case "2": {
                this.setVisible(false, "productweight", "matversion", "auxpty", "producttype", "alloctype");
                this.setVisible(true, "groupfield", "groupcategory");
                break;
            }
            case "3": {
                this.setVisible(true, "auxpty");
                this.setVisible(false, "groupfield", "groupcategory", "productweight");
                break;
            }
        }
        if ("1".equals("grouptype")) {
            if ("A".equals("producttype")) {
                this.setEnable(true, "weightentry", "addrow2", "insertrow2", "delrow2");
            } else {
                this.setEnable(false, "weightentry", "addrow2", "insertrow2", "delrow2");
            }
        }
    }

    private void setAuxVisible(String groupType) {
        if (CadEmptyUtils.isEmpty((String)groupType)) {
            return;
        }
        this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        this.getView().invokeOperation("newentry");
        if ("bd_auxproperty".equals(groupType)) {
            this.setVisible(true, "auxpty");
            this.setVisible(false, "groupcategory");
        } else {
            this.setVisible(false, "auxpty");
            this.setVisible(true, "groupcategory");
        }
    }

    private void setElement(Object newValue, int index) {
        if (newValue != null) {
            QFilter subElementIdFilter = new QFilter("subelement", "=", ((DynamicObject)newValue).getPkValue());
            DynamicObject elementAndSubelement = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])new QFilter[]{subElementIdFilter});
            if (elementAndSubelement != null) {
                this.getModel().setValue("element", (Object)elementAndSubelement.getLong("element"), index);
                this.getView().updateView("element", index);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if ("2".equals(this.getModel().getValue("grouptype"))) {
            Object material;
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            int rowIndex = rowDataEntities[0].getRowIndex();
            int insertRow = e.getInsertRow();
            if (insertRow != -1 && (material = this.getModel().getValue("material", insertRow + 1)) != null) {
                this.getModel().setValue("material", material, insertRow);
                this.getModel().setValue("alloctype", (Object)"2", insertRow);
            }
            if (rowIndex > 0 && insertRow == -1 && (material = this.getModel().getValue("material", rowIndex - 1)) != null) {
                this.getModel().setValue("material", material, rowIndex);
                this.getModel().setValue("alloctype", (Object)"2", rowIndex);
            }
        }
    }
}

