/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;

public class ProductGroupList
extends AbstractListPlugin {
    private static final String ORG_KEY = "calorg.name";
    private static final String USE_ORG = "useorg.id";
    private static final String GROUP_TYPE = "grouptype";
    private static final String CURRENT_ORG = "currentOrg";
    private static final String IS_MUL_ORG = "isMulOrg";
    private static final String ORG_FIELD = "calorg";
    private static final Log logger = LogFactory.getLog(ProductGroupList.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    public void beforeBindData(EventObject e) {
        this.scaHide();
    }

    private void scaHide() {
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equals(appId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tblnew", "tbldel", "tblsubmit", "tblaudit", "tbldisable", "importdata", "importdetails", "importentry", "importgrade", "forcedelete"});
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        List acctOrgs;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("calorg.") && CadEmptyUtils.isEmpty((List)(acctOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())))) {
            args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String appId = listShowParameter.getAppId();
        List acctOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        String orgId = this.getPageCache().get("orgId");
        if (StringUtils.isBlank((CharSequence)orgId)) {
            Long currAcctOrg = RequestContext.get().getOrgId();
            boolean isAccountingOrg = OrgUnitServiceHelper.checkOrgFunction((Long)currAcctOrg, (String)"10");
            if (isAccountingOrg) {
                orgId = String.valueOf(currAcctOrg);
            } else if (!CadEmptyUtils.isEmpty((List)acctOrgs)) {
                ComboItem comboItem = (ComboItem)acctOrgs.get(0);
                orgId = comboItem.getValue();
            } else {
                orgId = "0";
            }
            this.getPageCache().put("orgId", orgId);
        }
        List commonFilterColumns = args.getCommonFilterColumns();
        commonFilterColumns.removeIf(s -> s.getFieldName().equals(USE_ORG));
        for (FilterColumn filterColumn : commonFilterColumns) {
            List listComItem;
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = filterColumn.getFieldName();
            if (StringUtils.equals((CharSequence)ORG_KEY, (CharSequence)fieldName)) {
                listComItem = commonFilterColumn.getComboItems();
                listComItem.clear();
                commonFilterColumn.setComboItems(acctOrgs);
                commonFilterColumn.setDefaultValue(orgId);
            }
            if (!StringUtils.equals((CharSequence)GROUP_TYPE, (CharSequence)fieldName)) continue;
            listComItem = commonFilterColumn.getComboItems();
            if (!"sca".equals(appId)) continue;
            listComItem.removeIf(s -> s.getValue().equals("3") || s.getValue().equals("2"));
        }
    }

    public void filterContainerAfterSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerAfterSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        List customfilter = (List)filterValues.get("customfilter");
        if (customfilter == null || customfilter.isEmpty()) {
            return;
        }
        String pageCacheOrg = null;
        String pageCacheMulOrg = null;
        String pageCacheGroupType = null;
        for (int i = 0; i < customfilter.size(); ++i) {
            List vals;
            Map map = (Map)customfilter.get(i);
            List names = (List)map.get("FieldName");
            if (String.format("%s.id", ORG_FIELD).equals(String.valueOf(names.get(0)))) {
                vals = (List)map.get("Value");
                if (CadEmptyUtils.isEmpty((List)vals)) continue;
                pageCacheOrg = vals.get(0).toString();
                pageCacheMulOrg = vals.size() > 1 ? "true" : "false";
                continue;
            }
            if (!GROUP_TYPE.equals(String.valueOf(names.get(0))) || CadEmptyUtils.isEmpty((List)(vals = (List)map.get("Value")))) continue;
            pageCacheGroupType = vals.get(0).toString();
        }
        if (pageCacheOrg != null) {
            this.getPageCache().put(CURRENT_ORG, pageCacheOrg);
        }
        if (pageCacheMulOrg != null) {
            this.getPageCache().put(IS_MUL_ORG, pageCacheMulOrg);
        }
        if (pageCacheGroupType != null) {
            this.getPageCache().put(GROUP_TYPE, pageCacheGroupType);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter parameter = e.getParameter();
        String currentOrg = StringUtils.isBlank((CharSequence)this.getPageCache().get(CURRENT_ORG)) ? this.getPageCache().get("orgId") : this.getPageCache().get(CURRENT_ORG);
        parameter.setCustomParam(CURRENT_ORG, (Object)currentOrg);
        parameter.setCustomParam(IS_MUL_ORG, (Object)this.getPageCache().get(IS_MUL_ORG));
        parameter.setCustomParam("useorgId", (Object)currentOrg);
        String groupType = this.getPageCache().get(GROUP_TYPE);
        if (StringUtils.isNotBlank((CharSequence)groupType)) {
            parameter.setCustomParam(GROUP_TYPE, (Object)groupType);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filters = e.getQFilters();
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("sca".equals(appId)) {
            filters.add(new QFilter(GROUP_TYPE, "=", (Object)"1"));
        }
        Map<String, String> dateMap = this.removeDateFilter(filters);
        this.setEffectDateFilter(filters, dateMap);
    }

    protected Map<String, String> removeDateFilter(List<QFilter> filters) {
        HashMap<String, String> result = new HashMap<String, String>(1);
        Iterator<QFilter> iter = filters.iterator();
        while (iter.hasNext()) {
            List enableList;
            QFilter filter = iter.next();
            if (!"enable".equals(filter.getProperty())) continue;
            Object filterValue = filter.getValue();
            String enable = "";
            if (filterValue instanceof String) {
                enable = (String)filter.getValue();
            } else if (filterValue instanceof List && (enableList = (List)filter.getValue()) != null && enableList.size() == 1) {
                enable = (String)enableList.get(0);
            }
            if ("0".equals(enable)) {
                result.put("enable", "0");
            } else if ("1".equals(enable)) {
                result.put("enable", "1");
            }
            iter.remove();
        }
        return result;
    }

    protected void setEffectDateFilter(List<QFilter> filters, Map<String, String> dateMap) {
        if (dateMap.isEmpty()) {
            return;
        }
        String enable = dateMap.get("enable");
        if (enable != null) {
            Date date = new Date();
            if ("1".equals(enable)) {
                filters.add(new QFilter("effectdate", "<=", (Object)date).and(new QFilter("expdate", ">=", (Object)date)).or(new QFilter("expdate", "is null", null)));
            } else if ("0".equals(enable)) {
                filters.add(new QFilter("expdate", "<=", (Object)date));
                filters.add(new QFilter("expdate", "is not null", null));
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String orgId;
        String itemkey = evt.getItemKey();
        if ("forcedelete".equals(itemkey)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            if (list == null) {
                return;
            }
            Object[] primaryKeyValues = list.getSelectedRows().getPrimaryKeyValues();
            if (primaryKeyValues == null || primaryKeyValues.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"ProductGroupList_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getView().getPageCache().put("forcedelete", SerializationUtils.toJsonString((Object)primaryKeyValues));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u6b21\u5220\u9664\u53ef\u80fd\u4f1a\u5bfc\u81f4\u6709\u6548\u671f\u95f4\u4e0d\u8fde\u7eed\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ProductGroupList_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener("forcedelete", (IFormPlugin)this));
        } else if ("tblnew".equals(itemkey) && (StringUtils.isEmpty((CharSequence)(orgId = this.getPageCache().get("orgId"))) || "0".equals(orgId))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u65b0\u589e\u3002", (String)"ProductGroupList_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("delete".equalsIgnoreCase(operate.getType())) {
            operate.getOption().removeVariable("createOrg");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if ("forcedelete".equals(e.getCallBackId()) && MessageBoxResult.Yes == e.getResult()) {
            String forcedelete = this.getView().getPageCache().get("forcedelete");
            List deleteIds = (List)SerializationUtils.fromJsonString((String)forcedelete, List.class);
            if (CadEmptyUtils.isEmpty((List)deleteIds)) {
                logger.error("cad_productintogroup\u5f3a\u5236\u5220\u9664\u5f02\u5e38,\u672a\u83b7\u53d6\u5230\u9009\u4e2did");
                return;
            }
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)deleteIds)};
            DataSet rows = QueryServiceHelper.queryDataSet((String)"forcedeleteQuery", (String)"cad_productintogroup", (String)"number", (QFilter[])qFilters, null);
            String opType = ResManager.loadKDString((String)"\u5f3a\u5236\u5220\u9664\u64cd\u4f5c", (String)"ProductGroupList_2", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            StringBuilder stringBuilder = new StringBuilder();
            while (rows.hasNext()) {
                stringBuilder.append(rows.next().getString("number")).append("\uff0c");
            }
            String checkType = String.format(ResManager.loadKDString((String)"\u5df2\u5f3a\u5236\u5220\u9664\u7f16\u7801\u4e3a%s\u7684\u4ea7\u54c1\u7ec4\u6570\u636e\u3002", (String)"ProductGroupList_3", (String)"macc-cad-formplugin", (Object[])new Object[0]), stringBuilder.toString());
            WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_productintogroup", (String)this.getView().getFormShowParameter().getAppId());
            DeleteServiceHelper.delete((String)"cad_productintogroup", (QFilter[])qFilters);
            BillList list = (BillList)this.getView().getControl("billlistap");
            if (list != null) {
                list.refresh();
            }
        }
    }
}

