/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.base.PermitItemEnum;

public class SubelementExpenseEditPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(SubelementExpenseEditPlugin.class);
    private static final String CALLBACKID_EXPENSEITEM = "callbackid_expenseitem";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
        String appId = this.getView().getFormShowParameter().getAppId();
        BasedataEdit subelement = (BasedataEdit)this.getControl("subelement");
        subelement.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            List<Object> list = this.getAllSubElement();
            if (list != null && !list.isEmpty()) {
                filters.add(new QFilter("id", "in", list));
            } else {
                filters.add(new QFilter("id", "=", (Object)-1L));
            }
            if ("aca".equals(appId) || "eca".equals(appId)) {
                filters.add(new QFilter("type", "not in", (Object)new String[]{"001", "002"}));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit expenseItem = (BasedataEdit)this.getControl("expenseitem");
        expenseItem.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            Long orgId = this.getOrgId();
            filters.add(this.getExpenseItemQFilter(orgId));
            filterParameter.setQFilters(filters);
        });
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (!"subelement".equals(name)) {
            return;
        }
        if (newValue != null) {
            Set<Long> mids = this.getAllDbExpenseItemIdBy(this.getOrgId(), ((DynamicObject)newValue).getLong("id"));
            this.fillExpenseItemInfo(mids);
        } else {
            this.getModel().deleteEntryData("entryentity");
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        Long subElementId = (Long)fsp.getCustomParam("subelement");
        Set<Long> mids = this.getAllDbExpenseItemIdBy(this.getOrgId(), subElementId);
        this.fillExpenseItemInfo(mids);
        this.getModel().setValue("subelement", (Object)subElementId);
        this.getModel().setValue("org", (Object)this.getOrgId());
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (!(e.getReturnData() instanceof ListSelectedRowCollection)) {
            return;
        }
        ListSelectedRowCollection ids = (ListSelectedRowCollection)e.getReturnData();
        if (ids == null || ids.size() <= 0) {
            return;
        }
        switch (actionId) {
            case "callbackid_expenseitem": {
                this.fillExpenseItemInfo(ids);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "bar_add": {
                Long orgId = this.getOrgId();
                if (orgId == null || orgId < 1L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"SubelementExpenseEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
                    break;
                }
                this.openExpenseItemF7();
                break;
            }
            case "btn_save": {
                if (!this.checkSavePermission()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u65e0\u201c\u6210\u672c\u5b50\u8981\u7d20\u4e0e\u8d39\u7528\u9879\u76ee\u5bf9\u5e94\u8868\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SubelementExpenseEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.save();
                break;
            }
        }
    }

    private boolean checkSavePermission() {
        boolean permission = false;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            long orgId = org.getLong("id");
            permission = PermissionHelper.checkPermission((String)this.getView().getFormShowParameter().getAppId(), (long)orgId, (String)"cad_subelementexpense", (String)PermitItemEnum.ITEM_NEW.getKey());
        }
        return permission;
    }

    private void openExpenseItemF7() {
        Long orgId = this.getOrgId();
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"er_expenseitemedit", (boolean)true);
        ListFilterParameter filterParam = new ListFilterParameter();
        filterParam.getQFilters().add(this.getExpenseItemQFilter(orgId));
        lsp.setListFilterParameter(filterParam);
        lsp.setSelectedRows(this.getAllFormExpenseItemId().toArray());
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACKID_EXPENSEITEM));
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private List<Object> getAllSubElement() {
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)Boolean.TRUE)};
        return QueryServiceHelper.queryPrimaryKeys((String)"cad_subelement", (QFilter[])filters, null, (int)-1);
    }

    private Set<Long> getAllFormExpenseItemId() {
        HashSet<Long> ids = new HashSet<Long>(16);
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
            return ids;
        }
        for (DynamicObject row : rows) {
            DynamicObject expenseitem = row.getDynamicObject("expenseitem");
            if (expenseitem == null) continue;
            ids.add(expenseitem.getLong("masterid"));
        }
        return ids;
    }

    private Set<Long> getAllDbExpenseItemIdBy(Long orgId, Long subElementId) {
        if (orgId == null || subElementId == null) {
            return null;
        }
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter qfSubElement = new QFilter("subelement", "=", (Object)subElementId);
        QFilter appnum = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        HashSet<Long> ids = new HashSet<Long>();
        DynamicObjectCollection expenseitems = QueryServiceHelper.query((String)"cad_subelementexpense", (String)"id,expenseitem", (QFilter[])new QFilter[]{qfOrg, qfSubElement, appnum});
        if (expenseitems == null) {
            return null;
        }
        for (DynamicObject row : expenseitems) {
            ids.add(row.getLong("expenseitem"));
        }
        return ids;
    }

    private void fillExpenseItemInfo(ListSelectedRowCollection rows) {
        TreeSet<Long> mids = new TreeSet<Long>();
        for (ListSelectedRow row : rows) {
            mids.add((Long)row.getPrimaryKeyValue());
        }
        this.fillExpenseItemInfo(mids);
    }

    private void fillExpenseItemInfo(Set<Long> ids) {
        if (ids == null) {
            return;
        }
        IDataModel model = this.getModel();
        if (model.getEntryRowCount("entryentity") > 0) {
            model.deleteEntryData("entryentity");
        }
        for (Long id : ids) {
            int orgListIndex = model.createNewEntryRow("entryentity");
            model.setValue("expenseitem", (Object)id, orgListIndex);
        }
    }

    private Long getOrgId() {
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String orgId = (String)fsp.getCustomParam("org");
        if (StringUtils.isEmpty((CharSequence)orgId)) {
            return 0L;
        }
        return Long.parseLong(orgId);
    }

    private Long getSubelementId() {
        DynamicObject subelement = (DynamicObject)this.getModel().getValue("subelement");
        if (subelement == null) {
            return 0L;
        }
        return subelement.getLong("id");
    }

    private void save() {
        Set<Long> ids = this.getAllFormExpenseItemId();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(ids.size());
        Long orgId = this.getOrgId();
        Long subElementId = this.getSubelementId();
        if (CadEmptyUtils.isEmpty((Long)subElementId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u5b50\u8981\u7d20\u3002", (String)"SubelementExpenseEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        Long elementId = this.getElementId(subElementId);
        Long userId = RequestContext.getOrCreate().getCurrUserId();
        Date date = TimeServiceHelper.now();
        String appNum = this.getView().getFormShowParameter().getAppId();
        for (Long id : ids) {
            DynamicObject item = BusinessDataServiceHelper.newDynamicObject((String)"cad_subelementexpense");
            item.set("org", (Object)orgId);
            item.set("element", (Object)elementId);
            item.set("subelement", (Object)subElementId);
            item.set("expenseitem", (Object)id);
            item.set("appnum", (Object)appNum);
            item.set("creater", (Object)userId);
            item.set("modifier", (Object)userId);
            item.set("createdate", (Object)date);
            item.set("modifydate", (Object)date);
            list.add(item);
        }
        try (TXHandle txHandle = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"cad_subelementexpense", (QFilter[])QFilter.of((String)"subelement = ? and org = ? and appnum = ?", (Object[])new Object[]{subElementId, orgId, appNum}).toArray());
                if (!CadEmptyUtils.isEmpty(list)) {
                    MainEntityType type = EntityMetadataCache.getDataEntityType((String)"cad_subelementexpense");
                    SaveServiceHelper.save((IDataEntityType)type, (Object[])list.toArray(new DynamicObject[0]));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SubelementExpenseEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                txHandle.markRollback();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"SubelementExpenseEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("op_save".equals(operateKey) && !this.checkSavePermission()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6838\u7b97\u7ec4\u7ec7\u65e0\u201c\u6210\u672c\u5b50\u8981\u7d20\u4e0e\u8d39\u7528\u9879\u76ee\u5bf9\u5e94\u8868\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SubelementExpenseEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private Set<Long> getExpenseItem(Long orgId) {
        ArrayList<Long> expenseitemIdList;
        List<Long> expenseitemIds;
        HashSet<Long> expenseItemIds = new HashSet<Long>(16);
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId())};
        DynamicObjectCollection subElementExpense = QueryServiceHelper.query((String)"cad_subelementexpense", (String)"expenseitem.id", (QFilter[])filters);
        subElementExpense.forEach(p -> expenseItemIds.add(p.getLong("expenseitem.id")));
        if (!CadEmptyUtils.isEmpty(expenseItemIds) && !CadEmptyUtils.isEmpty(expenseitemIds = SubelementExpenseEditPlugin.expenseitemIdToMasterId(expenseitemIdList = new ArrayList<Long>(expenseItemIds)))) {
            expenseItemIds.addAll(expenseitemIds);
        }
        subElementExpense.clear();
        subElementExpense = this.getModel().getEntryEntity("entryentity");
        subElementExpense.forEach(p -> expenseItemIds.add(p.getLong("expenseitem.id")));
        return expenseItemIds;
    }

    public static List<Long> expenseitemIdToMasterId(List<Long> expenseitemIdList) {
        List<Long> expenseitemList = new ArrayList<Long>(10);
        try {
            QFilter filter;
            DynamicObjectCollection dynamicObjectCollection;
            if (!CadEmptyUtils.isEmpty(expenseitemIdList) && !(dynamicObjectCollection = QueryServiceHelper.query((String)"er_expenseitemedit", (String)"id", (QFilter[])(filter = new QFilter("masterid", "in", expenseitemIdList)).toArray())).isEmpty()) {
                expenseitemList = dynamicObjectCollection.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            logger.info("SubelementExpenseEditPlugin -> expenseitemMasterId:{}", (Object)e);
        }
        return expenseitemList;
    }

    private QFilter getExpenseItemQFilter(Long orgId) {
        QFilter baseDataFilter;
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        filter.and("isleaf", "=", (Object)Boolean.TRUE);
        Set<Long> notExpenseItem = this.getExpenseItem(orgId);
        if (!notExpenseItem.isEmpty()) {
            filter.and("id", "not in", notExpenseItem);
        }
        if ((baseDataFilter = BaseDataServiceHelper.getBaseDataProFilter((String)"er_expenseitemedit", (Long)orgId, (String)"id")) != null) {
            filter.and(baseDataFilter);
        }
        return filter;
    }

    private Long getElementId(Long subElementId) {
        QFilter[] filters = new QFilter[]{new QFilter("subelement", "=", (Object)subElementId)};
        DynamicObject element = QueryServiceHelper.queryOne((String)"cad_elementdetail", (String)"element", (QFilter[])filters);
        return element != null ? element.getLong("element") : 0L;
    }
}

