/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.AbstractTreeListView;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.helper.PermissionHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.base.PermitItemEnum;
import kd.macc.cad.formplugin.basedata.SubElementExpenseTree;

public class SubelementExpenseListPlugin
extends StandardTreeListPlugin
implements AfterSearchClickListener {
    private static final String TREE_ROOT_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private SubElementExpenseTree treeListView = new SubElementExpenseTree();

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addAfterSearchClickListener((AfterSearchClickListener)this);
    }

    public void createTreeListView(CreateTreeListViewEvent e) {
        super.createTreeListView(e);
        e.setView((AbstractTreeListView)this.treeListView);
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel", "searchap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
    }

    private void rebuildTreeNode() {
        TreeView tree = (TreeView)this.getView().getControl("treeview");
        if (tree == null) {
            return;
        }
        tree.deleteAllNodes();
        TreeNode rootNode = new TreeNode("", TREE_ROOT_ID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"SubelementExpenseListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), true);
        tree.addNode(rootNode);
        List<TreeNode> loadChildrenNode = this.loadChildrenNode();
        if (loadChildrenNode == null || loadChildrenNode.isEmpty()) {
            return;
        }
        tree.addNodes(loadChildrenNode);
        tree.focusNode(rootNode);
        tree.expand(TREE_ROOT_ID);
    }

    private List<TreeNode> loadChildrenNode() {
        DynamicObjectCollection list = this.getAllSubElement();
        if (list == null || list.isEmpty()) {
            return null;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        for (DynamicObject subEle : list) {
            if (subEle == null || ("aca".equals(appId) || "eca".equals(appId)) && ("001".equals(subEle.getString("type")) || "002".equals(subEle.getString("type")))) continue;
            nodes.add(new TreeNode(TREE_ROOT_ID, subEle.getString("id"), subEle.getString("name"), false));
        }
        return nodes;
    }

    private DynamicObjectCollection getAllSubElement() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter syncflagFilter = new QFilter("syncflag", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{enableFilter, syncflagFilter};
        return QueryServiceHelper.query((String)"cad_subelement", (String)"id,type,number,name", (QFilter[])filters, (String)"type,number");
    }

    protected QFilter nodeClickFilter() {
        QFilter resultFilter = super.nodeClickFilter();
        TreeView treeView = (TreeView)this.getControl("treeview");
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        QFilter filter = new QFilter("subelement", "=", (Object)-1);
        if (StringUtils.isEmpty((String)focusNodeId) || TREE_ROOT_ID.equals(focusNodeId)) {
            DynamicObjectCollection list = this.getAllSubElement();
            if (list != null && !list.isEmpty()) {
                ArrayList ids = new ArrayList();
                list.forEach(s -> {
                    if (s != null) {
                        ids.add(s.getLong("id"));
                    }
                });
                filter = new QFilter("subelement", "in", ids);
            }
        } else {
            filter = new QFilter("subelement", "=", (Object)Long.valueOf(focusNodeId));
        }
        resultFilter = resultFilter == null ? filter : resultFilter.and(filter);
        return resultFilter;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        TreeView treeView = (TreeView)e.getSource();
        Map node = treeView.getTreeState().getFocusNode();
        String nodeId = String.valueOf(node.get("id"));
        if (StringUtils.isEmpty((String)nodeId) || TREE_ROOT_ID.equals(nodeId)) {
            super.treeNodeClick(e);
            return;
        }
        if (!QueryServiceHelper.exists((String)"cad_subelement", (Object)nodeId)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u518d\u64cd\u4f5c\u3002", (String)"SubelementExpenseListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]), String.valueOf(node.get("text"))));
            this.rebuildTreeNode();
            e.setCancel(true);
            return;
        }
        super.treeNodeClick(e);
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        switch (e.getItemKey()) {
            case "bar_export": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = billList.getSelectedRows();
                if (rows.size() >= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"SubelementExpenseListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
        super.beforeItemClick(e);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "bar_addrel": {
                String org = this.getCacheOrg();
                long orgId = CadEmptyUtils.isEmpty((String)org) ? 0L : Long.parseLong(org);
                boolean permission = PermissionHelper.checkPermission((String)this.getView().getFormShowParameter().getAppId(), (long)orgId, (String)this.getBillEntityId(), (String)PermitItemEnum.ITEM_NEW.getKey());
                if (!permission) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6210\u672c\u5b50\u8981\u7d20\u4e0e\u8d39\u7528\u9879\u76ee\u5bf9\u5e94\u8868\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\u3002", (String)"SubelementExpenseListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openEditView();
                break;
            }
            case "bar_refresh": {
                this.refreshBillList();
            }
        }
    }

    private void refreshBillList() {
        this.getView().updateView("billlistap");
        BillList billListTemp = (BillList)this.getControl("billlistap");
        billListTemp.clearSelection();
    }

    private void openEditView() {
        TreeView treeView = (TreeView)this.getControl("treeview");
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        Long seId = null;
        if (focusNode != null && !TREE_ROOT_ID.equals(focusNode.get("id"))) {
            seId = Optional.ofNullable(focusNode.get("id")).map(s -> Long.parseLong(s.toString())).orElse(0L);
        }
        if (CadEmptyUtils.isEmpty(seId)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            ListSelectedRow row = null;
            if (!CadEmptyUtils.isEmpty((ListSelectedRowCollection)rows) && rows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u201c\u8d39\u7528\u9879\u76ee\u201d\u8fdb\u884c\u5173\u7cfb\u7ef4\u62a4\u3002", (String)"SubelementExpenseListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!CadEmptyUtils.isEmpty((ListSelectedRowCollection)rows)) {
                row = rows.get(0);
            }
            if (row != null && row.getPrimaryKeyValue() != null) {
                boolean isExist = QueryServiceHelper.exists((String)"cad_subelementexpense", (Object)row.getPrimaryKeyValue());
                if (isExist) {
                    DynamicObject relation = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"cad_subelementexpense");
                    seId = relation.getDynamicObject("subelement").getLong("id");
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u518d\u64cd\u4f5c\u3002", (String)"SubelementExpenseListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cad_subelementexpenseedit");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setCustomParam("org", (Object)this.getCacheOrg());
        fsp.setCustomParam("subelement", (Object)seId);
        fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "form"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        this.refreshBillList();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (!CadEmptyUtils.isEmpty((ListSelectedRowCollection)rows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u201c\u8d39\u7528\u9879\u76ee\u201d\u8fdb\u884c\u5173\u7cfb\u7ef4\u62a4\u3002", (String)"SubelementExpenseListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String pageCacheOrg = null;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("org.")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            String appId = this.getView().getFormShowParameter().getAppId();
            List orgs = OrgHelper.getOrgComboItems((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
            if (!CadEmptyUtils.isEmpty((List)orgs)) {
                commonFilterColumn.setComboItems(orgs);
                commonFilterColumn.setMustInput(true);
                ComboItem item = (ComboItem)orgs.get(0);
                commonFilterColumn.setDefaultValue(item.getValue());
                pageCacheOrg = item.getValue();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u53ef\u4f7f\u7528\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"SubelementExpenseListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
            this.rebuildTreeNode();
            break;
        }
        if (pageCacheOrg != null) {
            this.getPageCache().put("org", pageCacheOrg);
        }
    }

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    private String getCacheOrg() {
        String id = this.getPageCache().get("org");
        if (StringUtils.isEmpty((String)id) && StringUtils.isNotEmpty((String)(id = this.getDefualtSelectOrg()))) {
            this.getPageCache().put("org", id);
        }
        return id;
    }

    private String getDefualtSelectOrg() {
        List orgIds = OrgHelper.getCurrAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId());
        if (CadEmptyUtils.isEmpty((List)orgIds) || orgIds.size() == 0) {
            return null;
        }
        return ((Long)orgIds.get(0)).toString();
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.get("customfilter") != null) {
            List customfilter = (List)filterValues.get("customfilter");
            if (customfilter.isEmpty()) {
                return;
            }
            Map map = (Map)customfilter.get(0);
            List vals = (List)map.get("Value");
            if (vals == null || vals.isEmpty()) {
                return;
            }
            this.getPageCache().put("org", String.valueOf(vals.get(0)));
            this.rebuildTreeNode();
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        List acctOrgs;
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("org.") && CadEmptyUtils.isEmpty((List)(acctOrgs = OrgHelper.getAccountOrg((String)this.getBillEntityId(), (String)this.getView().getFormShowParameter().getAppId())))) {
            args.getQfilters().add(QFilter.of((String)"1=0", (Object[])new Object[0]));
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        if (!CadEmptyUtils.isEmpty((List)filters)) {
            Iterator it = filters.iterator();
            while (it.hasNext()) {
                QFilter filter = (QFilter)it.next();
                if (!"group".equals(filter.getProperty())) continue;
                it.remove();
            }
        }
        e.getQFilters().add(new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId()));
        e.setOrderBy("expenseitem.number asc");
    }

    public void click(SearchClickEvent searchClickEvent) {
        super.click((EventObject)searchClickEvent);
    }
}

