/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.bom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class AutoExecRuleSettingListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(AutoExecRuleSettingListPlugin.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"syncosttype"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Long costTypeId = (Long)this.getView().getFormShowParameter().getCustomParam("costTypeId");
        if (listShowParameter.isLookUp()) {
            return;
        }
        String pageCacheCosttype = this.getPageCache().get("costtype");
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("costtype.")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            List<ComboItem> costTypes = this.getCostTypeComboItemList();
            if (costTypes != null && !costTypes.isEmpty()) {
                commonFilterColumn.setComboItems(costTypes);
                ComboItem item = costTypes.get(0);
                String value = "0";
                value = pageCacheCosttype == null ? (costTypeId == null ? item.getValue() : String.valueOf(costTypeId)) : item.getValue();
                commonFilterColumn.setDefaultValue(value);
                pageCacheCosttype = value;
                break;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u53ef\u4f7f\u7528\u7684\u6210\u672c\u7c7b\u578b\u3002", (String)"AutoExecRuleSettingListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            break;
        }
        if (pageCacheCosttype != null) {
            this.getPageCache().put("costtype", pageCacheCosttype);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        this.schemeSearch(filterValues);
        if (filterValues.containsKey("customfilter")) {
            List customfilter = (List)filterValues.get("customfilter");
            if (customfilter == null || customfilter.isEmpty()) {
                return;
            }
            String pageCacheCosttype = null;
            for (Map map : customfilter) {
                List names = (List)map.get("FieldName");
                boolean isCost = false;
                for (Object name : names) {
                    if (!"costtype.id".equals(String.valueOf(name))) continue;
                    isCost = true;
                    break;
                }
                if (!isCost) continue;
                List vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) {
                    return;
                }
                pageCacheCosttype = String.valueOf(vals.get(0));
                break;
            }
            if (pageCacheCosttype != null) {
                this.getPageCache().put("costtype", pageCacheCosttype);
            }
        }
    }

    protected void schemeSearch(Map<String, List<Map<String, List<Object>>>> filterValues) {
        List<Map<String, List<Object>>> filterMapList = filterValues.get("schemefilter");
        if (CadEmptyUtils.isEmpty(filterMapList)) {
            return;
        }
        String pageCacheCosttype = null;
        for (Map<String, List<Object>> filterMap : filterMapList) {
            List<Object> ids;
            List<Object> fieldName = filterMap.get("FieldName");
            if (CadEmptyUtils.isEmpty(fieldName) || !"costtype.name".equals(fieldName.get(0)) || CadEmptyUtils.isEmpty(ids = filterMap.get("Id"))) continue;
            pageCacheCosttype = ids.get(0).toString();
        }
        if (pageCacheCosttype != null) {
            this.getPageCache().put("costtype", pageCacheCosttype);
        }
    }

    protected List<ComboItem> getCostTypeComboItemList() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        String appNum = this.getView().getFormShowParameter().getAppId();
        DynamicObject[] costTypes = ElementRelationHelper.getCostTypesBy((String)"1");
        if (costTypes != null && costTypes.length > 0) {
            List<DynamicObject> costTypeList = Arrays.asList(costTypes);
            CostTypeHelper.sortByType(costTypeList);
            for (DynamicObject costType : costTypeList) {
                if (CommonConstant.ACA_COST_TYPE_ID.equals(costType.getLong("id"))) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(costType.getString("name")));
                item.setValue(costType.getString("id"));
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
        }
        return acctItems;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String field = e.getFieldName();
        if ("costtype.id".equals(field) || "costtype.name".equals(field)) {
            e.addCustomQFilter(new QFilter("type", "=", (Object)"1"));
        }
    }
}

