/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.bom;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.helper.OrgHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import kd.macc.cad.formplugin.bom.CadSettingBomRefresh;

public class CadBomRefresh
extends AbstractFormPlugin
implements ClickListener {
    private static final Log logger = LogFactory.getLog(CadSettingBomRefresh.class);
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button confirm = (Button)this.getView().getControl("btnok");
        confirm.addClickListener((ClickListener)this);
        BasedataEdit calOrgBase = (BasedataEdit)this.getControl("calorg");
        calOrgBase.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getHasPermOrgIdsByOrgViewType((String)"10");
            qFilters.add(new QFilter("id", "in", (Object)hasPermOrgIdsByOrgViewType));
        });
        BasedataEdit costType = (BasedataEdit)this.getControl("manuorg");
        costType.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject calorg = (DynamicObject)this.getModel().getValue("calorg");
            if (calorg == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"CadBomRefresh_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            List orgIdList = ImportServiceHelper.getUserHasPermOrgs((Long)calorg.getLong("id"), (String)"04");
            qFilters.add(new QFilter("id", "in", (Object)orgIdList));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object[] upData = this.getRecordData();
        Object calOrgData = this.getModel().getValue("calorg");
        Object manuOrgData = this.getModel().getValue("manuorg");
        if (calOrgData == null && manuOrgData == null && upData != null && upData.length > 0) {
            Object upDatum = upData[0];
            DynamicObject calorg = upDatum.getDynamicObject("calorg");
            List hasPermOrgIdsByOrgViewType = ImportServiceHelper.getHasPermOrgIdsByOrgViewType((String)"10");
            if (calorg != null && hasPermOrgIdsByOrgViewType.contains((Long)calorg.getPkValue())) {
                Long calOrgId = (Long)calorg.getPkValue();
                this.getModel().setValue("calorg", (Object)calOrgId);
                this.getView().updateView("calorg");
                DynamicObject manuorg = upDatum.getDynamicObject("manuorg");
                List orgIdList = ImportServiceHelper.getUserHasPermOrgs((Long)calOrgId, (String)"04");
                if (manuorg != null && orgIdList.contains((Long)manuorg.getPkValue())) {
                    this.getModel().setValue("manuorg", manuorg.getPkValue());
                    this.getView().updateView("manuorg");
                }
            }
        }
        calOrgData = this.getModel().getValue("calorg");
        boolean refreshnewmat = upData == null || CadEmptyUtils.isEmpty((Object[])upData) || upData[0].get("refreshnewmat") == null ? Boolean.FALSE.booleanValue() : upData[0].getBoolean("refreshnewmat");
        this.getModel().setValue("refreshnewmat", (Object)refreshnewmat);
        this.getView().updateView("refreshnewmat");
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        if ("cad_routersetting".equals(entity)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"refreshmatattr"});
        }
    }

    private void setManuOrgStatus(Long calOrgId) {
        boolean orgEnableMultiFactory = OrgHelper.isOrgEnableMultiFactory((Long)calOrgId);
        BasedataEdit manuorg = (BasedataEdit)this.getView().getControl("manuorg");
        manuorg.setMustInput(orgEnableMultiFactory);
        if (!orgEnableMultiFactory) {
            this.getModel().setValue("manuorg", null);
            this.getView().updateView("manuorg");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("btnok")) {
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            String materialStr = (String)this.getModel().getValue("material_tag");
            DynamicObject manuorg = (DynamicObject)this.getModel().getValue("manuorg");
            DynamicObject calorg = (DynamicObject)this.getModel().getValue("calorg");
            if (StringUtils.isNotEmpty((CharSequence)materialStr)) {
                returnData.put("material_tag", materialStr);
            }
            Long manuOrgId = null;
            if (manuorg != null) {
                manuOrgId = (Long)manuorg.getPkValue();
                returnData.put("manuorgId", manuOrgId);
            }
            if (calorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u3002", (String)"CadBomRefresh_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            Long calOrgId = (Long)calorg.getPkValue();
            returnData.put("calorgId", calOrgId);
            Boolean refreshnewmat = (Boolean)this.getModel().getValue("refreshnewmat");
            returnData.put("refreshNewMat", refreshnewmat);
            Boolean refreshMatAttr = (Boolean)this.getModel().getValue("refreshmatattr");
            returnData.put("refreshMatAttr", refreshMatAttr);
            this.getView().returnDataToParent(returnData);
            try {
                this.saveUserData(calOrgId, manuOrgId, refreshnewmat);
                this.writeOperateLog();
            }
            catch (Exception e) {
                logger.error("\u8bb0\u5f55\u5237\u65b0bom/\u5de5\u827a\u8def\u7ebf\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            }
            this.getView().close();
        }
    }

    private void saveUserData(Long calOrgId, Long manuOrgId, Boolean refreshNewMat) {
        DynamicObject[] upData = this.getRecordData();
        if (upData != null && upData.length > 0) {
            DynamicObject upDatum = upData[0];
            upDatum.set("calorg", (Object)calOrgId);
            upDatum.set("manuorg", (Object)manuOrgId);
            upDatum.set("refreshnewmat", (Object)refreshNewMat);
        } else {
            DynamicObject cad_refreshbomrecord = BusinessDataServiceHelper.newDynamicObject((String)"cad_refreshbomrecord");
            cad_refreshbomrecord.set("calorg", (Object)calOrgId);
            cad_refreshbomrecord.set("manuorg", (Object)manuOrgId);
            cad_refreshbomrecord.set("refreshnewmat", (Object)refreshNewMat);
            cad_refreshbomrecord.set("user", (Object)Long.valueOf(RequestContext.get().getUserId()));
            upData = new DynamicObject[]{cad_refreshbomrecord};
        }
        SaveServiceHelper.save((DynamicObject[])upData);
    }

    private DynamicObject[] getRecordData() {
        QFilter userQf = new QFilter("user", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
        return BusinessDataServiceHelper.load((String)"cad_refreshbomrecord", (String)"calorg,manuorg,biztype,refreshnewmat,user", (QFilter[])new QFilter[]{userQf});
    }

    private void writeOperateLog() {
        Boolean refreshnewmat = (Boolean)this.getModel().getValue("refreshnewmat");
        Long costTypeId = (Long)this.getView().getFormShowParameter().getCustomParam("costTypeId");
        DynamicObject costTypeName = BusinessDataServiceHelper.loadSingleFromCache((Object)costTypeId, (String)"cad_costtype", (String)"name");
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        String opType = ResManager.loadKDString((String)"\u786e\u8ba4", (String)"CadBomRefresh_3", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        String checkType = refreshnewmat != false ? String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\uff1a%s\uff0c\u4ec5\u5237\u65b0\u65b0\u589e\u7269\u6599\uff1a\u6253\u5f00", (String)"CadBomRefresh_5", (String)"macc-cad-formplugin", (Object[])new Object[0]), costTypeName.getString("name")) : String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\uff1a%s\uff0c\u4ec5\u5237\u65b0\u65b0\u589e\u7269\u6599\uff1a\u5173\u95ed", (String)"CadBomRefresh_6", (String)"macc-cad-formplugin", (Object[])new Object[0]), costTypeName.getString("name"));
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)entity, (String)AppIdHelper.getCurAppNumAndDefaultSca((IFormView)this.getView()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if ("material".equals(proName)) {
            String materialStr = (String)this.getModel().getValue("material_tag");
            if (CadEmptyUtils.isEmpty((String)materialStr)) {
                this.getModel().setValue("sum", (Object)0);
            } else {
                String[] matStr = materialStr.split("\n");
                this.getModel().setValue("sum", (Object)matStr.length);
            }
        } else if ("calorg".equals(proName)) {
            Long id = newValue == null ? null : Long.valueOf(((DynamicObject)newValue).getLong("id"));
            this.getModel().setValue("manuorg", null);
        }
    }
}

