/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.bom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CalcDimenHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.ConfigTrackHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CadBomSettingEditPlugin
extends AbstractBillPlugIn {
    private boolean isKeepAutoFill = true;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListener();
    }

    protected void addListener() {
        BasedataEdit costType = (BasedataEdit)this.getControl("costtype");
        costType.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject[] costTypes = ElementRelationHelper.getModeCostTypes();
            Set costs = ElementRelationHelper.getCostTypeIds((DynamicObject[])costTypes);
            if (!CadEmptyUtils.isEmpty((Set)costs)) {
                filters.add(new QFilter("id", "in", (Object)costs));
            } else {
                filters.add(new QFilter("id", "=", (Object)-1L));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit mat = (BasedataEdit)this.getControl("material");
        mat.addBeforeF7SelectListener(evt -> {
            Set materialBySalOrder;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            DynamicObject ct = this.getModel().getDataEntity().getDynamicObject("costtype");
            DynamicObject version = this.getModel().getDataEntity().getDynamicObject("bomversion");
            Set<Long> matIds = CadBomSettingEditPlugin.getBomMatIds(ct);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
            filters.add(new QFilter("id", "in", matIds));
            filters.add(new QFilter("enableproduct", "=", (Object)true));
            filters.add(new QFilter("configproperties", "!=", (Object)"2"));
            DynamicObject configuredcode = (DynamicObject)this.getModel().getValue("configuredcode");
            DynamicObject tracknumber = (DynamicObject)this.getModel().getValue("tracknumber");
            if (!(configuredcode == null && tracknumber == null || CadEmptyUtils.isEmpty((Set)(materialBySalOrder = ConfigTrackHelper.getMaterialBySalOrder((Long)(configuredcode == null ? 0L : configuredcode.getLong("id")), (Long)(tracknumber == null ? 0L : tracknumber.getLong("id"))))))) {
                filters.add(new QFilter("id", "in", (Object)materialBySalOrder));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit configuredcode = (BasedataEdit)this.getControl("configuredcode");
        configuredcode.addBeforeF7SelectListener(evt -> {
            DynamicObject materialDy = (DynamicObject)this.getModel().getValue("material");
            if (materialDy != null) {
                ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParameter = param.getListFilterParameter();
                List qFilters = filterParameter.getQFilters();
                List configCodeIds = ConfigTrackHelper.getConfigCodeIdsByMaterial(Collections.singleton(materialDy.getLong("id")));
                if (!CadEmptyUtils.isEmpty((List)configCodeIds)) {
                    qFilters.add(new QFilter("id", "in", (Object)configCodeIds));
                }
            }
        });
        BasedataEdit bom = (BasedataEdit)this.getControl("bom");
        bom.addBeforeF7SelectListener(evt -> {
            List<Long> settingIds;
            Long aid;
            Long vid;
            DynamicObject material;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject bomType = this.getModel().getDataEntity().getDynamicObject("bomtype");
            if (bomType != null) {
                filters.add(new QFilter("type", "=", bomType.getPkValue()));
            }
            if ((material = this.getModel().getDataEntity().getDynamicObject("material")) != null) {
                filters.add(new QFilter("material.masterid", "=", (Object)material.getLong("masterid")));
            } else {
                DynamicObject ct = this.getModel().getDataEntity().getDynamicObject("costtype");
                List matIds = ElementRelationHelper.getMatIdsBy((Long)ct.getDynamicObject("createorg").getLong("id"));
                if (!CadEmptyUtils.isEmpty((List)matIds)) {
                    filters.add(new QFilter("material.masterid", "in", (Object)matIds));
                }
            }
            DynamicObject version = this.getModel().getDataEntity().getDynamicObject("bomversion");
            if (this.getModel().getDataEntity().getBoolean("isbomversion") && (vid = Optional.ofNullable(version).map(s -> s.getLong("id")).orElse(-1L)) > 0L) {
                filters.add(new QFilter("version", "=", (Object)vid));
            }
            DynamicObject auxprop = this.getModel().getDataEntity().getDynamicObject("auxprop");
            if (this.getModel().getDataEntity().getBoolean("isauxprop") && (aid = Optional.ofNullable(auxprop).map(s -> s.getLong("id")).orElse(-1L)) > 0L) {
                filters.add(new QFilter("auxproperty", "=", (Object)aid));
            }
            if (!(settingIds = this.getSettingIdByCostType()).isEmpty()) {
                filters.add(new QFilter("id", "not in", settingIds));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit matVer = (BasedataEdit)this.getControl("bomversion");
        matVer.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject material = this.getModel().getDataEntity().getDynamicObject("material");
            if (material != null) {
                filters.add(new QFilter("material", "=", material.getPkValue()));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit subElement = (BasedataEdit)this.getControl("chargedefsubelement");
        subElement.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            filterParameter.getQFilters().add(new QFilter("type", "=", (Object)"002"));
        });
        BasedataEdit bomType = (BasedataEdit)this.getControl("bomtype");
        bomType.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            filterParameter.getQFilters().add(new QFilter("purpose", "not in", (Object)new String[]{"B", "C"}));
        });
    }

    public List<Long> getSettingIdByCostType() {
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        Long id = (Long)this.getModel().getValue("id");
        QFilter costTypeQF = new QFilter("costtype", "=", (Object)costType.getLong("id"));
        QFilter idQF = new QFilter("id", "!=", (Object)id);
        DynamicObjectCollection routerSettingIds = QueryServiceHelper.query((String)"cad_bomsetting", (String)"bom", (QFilter[])new QFilter[]{costTypeQF, idQF});
        List idList = DynamicObjectHelper.getIdList((DynamicObjectCollection)routerSettingIds, (String)"bom");
        return idList;
    }

    private static Set<Long> getBomMatIds(DynamicObject ct) {
        Long orgId;
        QFilter matOrgFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("status", "=", (Object)"C"));
        filters.add(new QFilter("enable", "=", (Object)true));
        if (ct != null && (matOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"cad_costbom", (Long)(orgId = Long.valueOf(ct.getDynamicObject("createorg").getLong("id"))))) != null) {
            filters.add(matOrgFilter);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getBomMatIds", (String)"cad_costbom", (String)"material", (QFilter[])filters.toArray(new QFilter[0]), null);
        HashSet<Long> matIds = new HashSet<Long>(200);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            if (row == null) continue;
            matIds.add(row.getLong("material"));
        }
        return matIds;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (!this.isKeepAutoFill) {
            this.isKeepAutoFill = true;
            return;
        }
        switch (e.getProperty().getName()) {
            case "costtype": {
                break;
            }
            case "material": {
                this.changeMaterial();
                this.clearFieldValue("bomtype", "bomversion", "auxprop", "configuredcode");
                break;
            }
            case "bomtype": {
                this.clearFieldValue("bom");
                this.setBom();
                break;
            }
            case "bom": {
                this.changeBom((DynamicObject)newValue);
                this.updateBomVersionAndAuxpty((DynamicObject)newValue);
                break;
            }
            case "considersubmaterialloss": {
                this.getView().setEnable((Boolean)newValue, new String[]{"lossrateformula"});
                break;
            }
            case "chargedefsubelement": {
                if (newValue != null) {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"chargestdrate"});
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"chargestdrate"});
                break;
            }
            case "matcalcprop": {
                this.getModel().setValue("isdowncalc", (Object)(!"B".equals(newValue) ? 1 : 0));
                this.setPurPricesEnable();
                break;
            }
            case "configuredcode": {
                ConfigTrackHelper.setMaterialValueByConfig((IFormView)this.getView(), (IDataModel)this.getModel(), null);
                ConfigTrackHelper.setTrackValueByConfig((IFormView)this.getView(), (IDataModel)this.getModel(), null);
                break;
            }
            case "tracknumber": {
                ConfigTrackHelper.setConfigValueByTrack((IFormView)this.getView(), (IDataModel)this.getModel(), null);
            }
        }
    }

    private void setPurPricesEnable() {
        String calcProp = this.getModel().getDataEntity().getString("matcalcprop");
        if ("A".equals(calcProp)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"ispurprices"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"ispurprices"});
            this.getModel().setValue("ispurprices", (Object)false);
        }
    }

    private void changeBom(DynamicObject bom) {
        if (bom == null) {
            return;
        }
        DynamicObject bomType = bom.getDynamicObject("type");
        DynamicObject formBomType = this.getModel().getDataEntity().getDynamicObject("bomtype");
        if (bomType != null && formBomType == null) {
            this.isKeepAutoFill = false;
            this.getModel().setValue("bomtype", (Object)bomType);
        }
        DynamicObject formMat = this.getModel().getDataEntity().getDynamicObject("material");
        DynamicObject bomDb = BusinessDataServiceHelper.loadSingle((Object)bom.getPkValue(), (String)"cad_costbom");
        Long bomMatId = Optional.ofNullable(bomDb.getDynamicObject("material")).map(s -> s.getLong("masterid")).orElse(null);
        if (formMat == null && bomMatId != null) {
            this.isKeepAutoFill = false;
            this.getModel().setValue("material", (Object)bomMatId);
            this.changeMaterial();
        }
    }

    private void changeBizCtrl(DynamicObject mat) {
        if (mat == null) {
            this.getModel().setValue("bizctrl", null);
        } else {
            String bizCtrlName = BomRouterHelper.getMatBizCtrl((DynamicObject)mat);
            if (StringUtils.isNotEmpty((String)bizCtrlName)) {
                this.getModel().setValue("bizctrl", (Object)bizCtrlName);
            }
        }
    }

    private void changeMaterial() {
        DynamicObject mat = this.getModel().getDataEntity().getDynamicObject("material");
        this.changeBizCtrl(mat);
        this.showOrHideVersionAndAssistPropBy(mat);
    }

    private void clearFieldValue(String ... fields) {
        for (String field : fields) {
            this.getModel().setValue(field, null);
        }
    }

    private void setBom() {
        DynamicObjectCollection boms;
        List<Long> settingIds;
        Long aid;
        Long vid;
        DynamicObject material;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject bomType = this.getModel().getDataEntity().getDynamicObject("bomtype");
        if (bomType != null) {
            filters.add(new QFilter("type", "=", bomType.getPkValue()));
        }
        if ((material = this.getModel().getDataEntity().getDynamicObject("material")) != null) {
            filters.add(new QFilter("material.masterid", "=", (Object)material.getLong("masterid")));
        } else {
            DynamicObject ct = this.getModel().getDataEntity().getDynamicObject("costtype");
            Set<Long> matIds = CadBomSettingEditPlugin.getBomMatIds(ct);
            if (!CadEmptyUtils.isEmpty(matIds)) {
                filters.add(new QFilter("material.masterid", "in", matIds));
            }
        }
        DynamicObject version = this.getModel().getDataEntity().getDynamicObject("bomversion");
        if (this.getModel().getDataEntity().getBoolean("isbomversion") && (vid = Optional.ofNullable(version).map(s -> s.getLong("id")).orElse(-1L)) > 0L) {
            filters.add(new QFilter("version", "=", (Object)vid));
        }
        DynamicObject auxprop = this.getModel().getDataEntity().getDynamicObject("auxprop");
        if (this.getModel().getDataEntity().getBoolean("isauxprop") && (aid = Optional.ofNullable(auxprop).map(s -> s.getLong("id")).orElse(-1L)) > 0L) {
            filters.add(new QFilter("auxproperty", "=", (Object)aid));
        }
        if (!(settingIds = this.getSettingIdByCostType()).isEmpty()) {
            filters.add(new QFilter("id", "not in", settingIds));
        }
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)(boms = QueryServiceHelper.query((String)"cad_costbom", (String)"id", (QFilter[])filters.toArray(new QFilter[0])))) && boms.size() == 1) {
            this.getModel().setValue("bom", (Object)((DynamicObject)boms.get(0)).getLong("id"));
        }
    }

    private void showOrHideVersionAndAssistPropBy(DynamicObject mat) {
        boolean showMatversion = BomRouterHelper.isEnableMatversion((DynamicObject)mat);
        boolean showAssistProp = BomRouterHelper.isEnableAuxprop((DynamicObject)mat);
        this.getView().setVisible(Boolean.valueOf(showMatversion), new String[]{"bomversion"});
        this.getView().setVisible(Boolean.valueOf(showAssistProp), new String[]{"auxprop"});
        this.getModel().setValue("isauxprop", (Object)showAssistProp);
        this.getModel().setValue("isbomversion", (Object)showMatversion);
    }

    public void afterBindData(EventObject e) {
        DynamicObject costTypeDy;
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        this.getModel().setValue("costtype", fsp.getCustomParam("costtype"));
        this.changeMaterial();
        this.dealFormulaHide();
        DynamicObject defSunElement = (DynamicObject)this.getModel().getValue("chargedefsubelement");
        if (defSunElement == null) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"chargestdrate"});
        }
        if (!CadEmptyUtils.isEmpty((DynamicObject)(costTypeDy = (DynamicObject)this.getModel().getValue("costtype"))) && !CostTypeHelper.isUseMatVersion((Long)costTypeDy.getLong("id"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"matversion"});
        }
        this.getModel().setDataChanged(false);
        this.setPurPricesEnable();
    }

    private void dealFormulaHide() {
        boolean considerSubMaterialLoss = (Boolean)this.getModel().getValue("considersubmaterialloss");
        if (!considerSubMaterialLoss) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"lossrateformula"});
        }
    }

    private void updateBomVersionAndAuxpty(DynamicObject bom) {
        if (bom == null) {
            return;
        }
        DynamicObject version = bom.getDynamicObject("version");
        DynamicObject auxproperty = bom.getDynamicObject("auxproperty");
        DynamicObject configuredcode = bom.getDynamicObject("configuredcode");
        DynamicObject mat = this.getModel().getDataEntity().getDynamicObject("material");
        DynamicObject costTypeDy = (DynamicObject)this.getModel().getValue("costtype");
        if (BomRouterHelper.isEnableMatversion((DynamicObject)mat) && version != null) {
            this.getModel().setValue("bomversion", version.getPkValue());
        }
        if (configuredcode != null) {
            this.getModel().setValue("configuredcode", configuredcode.getPkValue());
        }
        this.getModel().setValue("keycol", (Object)bom.getString("keycol"));
        if (!CadEmptyUtils.isEmpty((DynamicObject)costTypeDy) && !CostTypeHelper.isUseMatVersion((Long)costTypeDy.getLong("id"))) {
            this.getModel().setValue("bomversion", null);
        }
        if (BomRouterHelper.isEnableAuxprop((DynamicObject)mat) && auxproperty != null) {
            this.getModel().setValue("auxprop", auxproperty.getPkValue());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        switch (e.getOperateKey()) {
            case "audit": {
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((FormOperate)args.getSource()).getOperateKey();
        Long affectAuxpty = CalcDimenHelper.getAffectAuxpty((Object)this.getModel().getValue("material"), (Object)this.getModel().getValue("auxprop"));
        this.getModel().setValue("auxprop", (Object)affectAuxpty);
        if ("save".equals(key) || "submit".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            HashMap<String, Object> keycolMap = new HashMap<String, Object>(16);
            keycolMap.put("material", dataEntity.get("material.masterid"));
            keycolMap.put("auxproperty", affectAuxpty);
            keycolMap.put("configuredcode", dataEntity.getLong("configuredcode.id"));
            keycolMap.put("tracknumber", dataEntity.getLong("tracknumber.id"));
            keycolMap.put("project", dataEntity.getLong("project.id"));
            keycolMap.put("lot", dataEntity.getString("lot"));
            Keycol calcKey = CalcKeyHelper.getCalcKey(keycolMap, new ArrayList(), (boolean)true);
            this.getModel().setValue("keycol", (Object)calcKey.getKeycol());
            this.getModel().setValue("keycolid", (Object)calcKey.getId());
        }
    }
}

