/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.bom;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.macc.cad.business.bom.BomSettingService;
import kd.macc.cad.common.helper.CostBomRouteRefreshHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.base.PermitItemEnum;
import kd.macc.cad.formplugin.bom.CadSettingBaseListPlugin;
import kd.macc.cad.formplugin.common.Util;
import kd.macc.cad.formplugin.price.PriceCommon;

public class CadBomSettingListPlugin
extends CadSettingBaseListPlugin {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
    private static final Log logger = LogFactory.getLog(CadBomSettingListPlugin.class);
    private static String[] leftStr = new String[]{"id", "material", "isenablematerialversion", "auditdate", "type", "version", "auxproperty", "configuredcode", "keycol"};

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"syncosttype", "autoexecrule"});
    }

    @Override
    protected Map<Object, String> getBizCtrl(ListSelectedRowCollection rows, String fields, String entity) {
        fields = "id,material.enableproduct enableproduct,material.enablepur enablepur";
        return super.getBizCtrl(rows, fields, "cad_bomsetting");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (!"sca".equals(appId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"autoexecrule"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "syncosttype": {
                if (!PriceCommon.isPermItemPermission(RequestContext.get().getCurrUserId(), "cad_bomsetting", "47156aff000000ac")) {
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = billList.getSelectedRows();
                Util.openSyncCostTypeView(this.getView(), "cad_bomsetting", rows);
                break;
            }
            case "quickupdate": {
                if (!PriceCommon.isPermItemPermission(RequestContext.get().getCurrUserId(), "cad_bomsetting", "47156aff000000ac")) {
                    return;
                }
                this.showQuickUpdateApply();
                break;
            }
            case "refreshbom": {
                if (!PriceCommon.isPermItemPermission(RequestContext.get().getCurrUserId(), "cad_bomsetting", "47156aff000000ac")) {
                    return;
                }
                String costTypeId = this.getPageCache().get("costtype");
                if (costTypeId == null) {
                    return;
                }
                String costType = this.getCostType(costTypeId);
                if (!"1".equals(costType)) {
                    String lockErr = ResManager.loadKDString((String)"\u5237\u65b0BOM\u5931\u8d25\uff0c\u5c5e\u6027\u4e3a\u975e\u6a21\u62df\u7c7b\u578b\u7684\u6210\u672c\u7c7b\u578b\u4e0d\u5141\u8bb8\u64cd\u4f5c\u5237\u65b0BOM\u3002", (String)"CadBomSettingListPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(lockErr);
                    return;
                }
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("cad_refreshbomsetting");
                fsp.setCaption(ResManager.loadKDString((String)"\u5237\u65b0BOM\u8bbe\u7f6e", (String)"CadBomSettingListPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                fsp.setCustomParam("costTypeId", (Object)Long.parseLong(costTypeId));
                fsp.setCustomParam("entity", (Object)"cad_bomsetting");
                fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "refreshBomSetting"));
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
                break;
            }
            case "batchupdate": {
                BillList selectBillList;
                ListSelectedRowCollection selectedRows;
                String cacheCostType = this.getPageCache().get("costtype");
                if (cacheCostType == null) {
                    return;
                }
                HasPermOrgResult rs = PermissionServiceHelper.getAllPermOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getBillEntityId(), (String)PermitItemEnum.ITEM_MODIFY.getKey());
                if (!rs.hasAllOrgPerm()) {
                    List hasPermOrgs = rs.getHasPermOrgs();
                    List costTypeOrgs = CostTypeHelper.getCalcOrgByCostType((Long)Long.parseLong(cacheCostType));
                    if (CadEmptyUtils.isEmpty((List)costTypeOrgs)) {
                        return;
                    }
                    hasPermOrgs.retainAll(costTypeOrgs);
                    if (CadEmptyUtils.isEmpty((List)hasPermOrgs)) {
                        return;
                    }
                }
                if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)(selectedRows = (selectBillList = (BillList)this.getControl("billlistap")).getSelectedRows().getBillListSelectedRowCollection()))) {
                    return;
                }
                FormShowParameter formShowParam = new FormShowParameter();
                formShowParam.setFormId("cad_matpropmodify");
                formShowParam.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "updateMatProp"));
                formShowParam.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(formShowParam);
                break;
            }
            case "autoexecrule": {
                if (!PriceCommon.isPermItemPermission(RequestContext.get().getCurrUserId(), "cad_bomsetting", "4730fc9f000031ae")) {
                    return;
                }
                String costTypeId = this.getPageCache().get("costtype");
                if (costTypeId == null) {
                    return;
                }
                String costType = this.getCostType(costTypeId);
                if (!"1".equals(costType)) {
                    String lockErr = ResManager.loadKDString((String)"\u64cd\u4f5c\u81ea\u52a8\u6267\u884c\u89c4\u5219\u8bbe\u7f6e\u5931\u8d25\uff0c\u5c5e\u6027\u4e3a\u975e\u6a21\u62df\u7c7b\u578b\u7684\u6210\u672c\u7c7b\u578b\u4e0d\u5141\u8bb8\u64cd\u4f5c\u81ea\u52a8\u6267\u884c\u89c4\u5219\u8bbe\u7f6e\u3002", (String)"CadBomSettingListPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(lockErr);
                    return;
                }
                ListShowParameter autoExecRuleFsp = new ListShowParameter();
                autoExecRuleFsp.setBillFormId("cad_autoexecrulesetting");
                autoExecRuleFsp.setCustomParam("costTypeId", (Object)Long.parseLong(costTypeId));
                autoExecRuleFsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)autoExecRuleFsp);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        BillList billList = (BillList)this.getControl("billlistap");
        switch (e.getActionId()) {
            case "updateMatProp": {
                HashMap returnDataMap = (HashMap)e.getReturnData();
                if (CadEmptyUtils.isEmpty((Map)returnDataMap)) {
                    return;
                }
                String matCalcProp = (String)returnDataMap.get("matprop");
                ListSelectedRowCollection rows = billList.getSelectedRows();
                List bomSettingIds = rows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
                BomSettingService.updateMatCalcProp(bomSettingIds, (String)matCalcProp);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539\u7269\u6599\u5377\u7b97\u5c5e\u6027\u6210\u529f\u3002", (String)"CadBomSettingListPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                this.getView().invokeOperation("refresh");
            }
            case "refreshBomSetting": {
                HashMap returnData = (HashMap)e.getReturnData();
                if (returnData == null) {
                    return;
                }
                String materialStr = (String)returnData.get("material_tag");
                Long manuorgId = (Long)returnData.get("manuorgId");
                Long calorg = (Long)returnData.get("calorgId");
                Boolean isRefreshNewMat = (Boolean)returnData.get("refreshNewMat");
                Boolean refreshMatAttr = (Boolean)returnData.get("refreshMatAttr");
                String costTypeId = this.getPageCache().get("costtype");
                if (calorg == null || costTypeId == null) {
                    return;
                }
                try {
                    boolean isSuccess = MutexHelper.enableReentrant((String)"cad_bomsetting", (Object)costTypeId, (String)"refreshbom");
                    if (!isSuccess) {
                        String lockErr = ResManager.loadKDString((String)"\u8be5\u6210\u672c\u7c7b\u578b\u6b63\u5728\u8fdb\u884c\u5237\u65b0\u6210\u672cBOM\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CadBomSettingListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                        this.getView().showErrorNotification(lockErr);
                        return;
                    }
                    MutexHelper.require((String)"cad_bomsetting", (Object)costTypeId, (String)"refreshbom", (boolean)true, (StringBuilder)new StringBuilder());
                    Set materialIds = CostBomRouteRefreshHelper.getMaterialIds((Long)calorg, (String)materialStr, (String)"cad_costbom");
                    AtomicInteger size = new AtomicInteger();
                    Lists.partition(new ArrayList(materialIds), (int)100000).forEach(materialIdList -> size.addAndGet(CostBomRouteRefreshHelper.refreshBom((Long)calorg, (Long)manuorgId, (Long)Long.parseLong(costTypeId), new HashSet(materialIdList), (Boolean)isRefreshNewMat, (Boolean)refreshMatAttr)));
                    MutexHelper.release((String)"cad_bomsetting", (String)"refreshbom", (String)costTypeId);
                    if (size.get() > 0) {
                        billList.refresh();
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u672cBOM\u5237\u65b0\u6210\u529f\u3002", (String)"CadBomSettingListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    break;
                }
                catch (Exception ex) {
                    logger.error("\u5237\u65b0BOM\u62a5\u9519\u3002\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)ex);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5237\u65b0BOM\u62a5\u9519\uff1a%s\u3002", (String)"CadBomSettingListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]), ex.toString()));
                    MutexHelper.release((String)"cad_bomsetting", (String)"refreshbom", (String)costTypeId);
                }
            }
        }
    }

    protected String getBillEntityId() {
        return ((IListView)this.getView()).getListModel().getDataEntityType().getName();
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        List listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            switch (column.toString()) {
                case "costtype.name": {
                    column.setFixed(true);
                    break;
                }
                case "number": {
                    column.setFixed(true);
                    break;
                }
                case "material.number": {
                    column.setFixed(true);
                    break;
                }
                case "material.name": {
                    column.setFixed(true);
                }
            }
        }
    }

    private void showQuickUpdateApply() {
        Long costtypeId = Long.parseLong(this.getPageCache().get("costtype"));
        DynamicObject costType = CostTypeHelper.getCostType((Long)costtypeId, (String)"type");
        if ("0".equals(costType.getString("type"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6210\u672c\u7c7b\u578b\u4e3a\u6838\u7b97\u6210\u672c\uff0c\u4e0d\u80fd\u8fdb\u884c\u5feb\u901f\u66f4\u65b0\u3002", (String)"CadBomSettingListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (rows == null || rows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u540c\u6b65\u6210\u672c\u7c7b\u578b\u7684\u6570\u636e\u3002", (String)"CadBomSettingListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<Object> ids = new ArrayList<Object>();
        for (ListSelectedRow row : rows) {
            ids.add(row.getPrimaryKeyValue());
        }
        ArrayList<QFilter> statusEnableQf = new ArrayList<QFilter>(16);
        statusEnableQf.add(new QFilter("id", "in", ids));
        statusEnableQf.add(new QFilter("status", "!=", (Object)"C").or(new QFilter("enable", "=", (Object)"0")));
        boolean checkStatusAndEnable = QueryServiceHelper.exists((String)"cad_bomsetting", (QFilter[])statusEnableQf.toArray(new QFilter[0]));
        if (checkStatusAndEnable) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5feb\u901f\u66f4\u65b0\u5931\u8d25\uff0c\u5b58\u5728\u672a\u5ba1\u6838\u6216\u7981\u7528\u7684\u6210\u672cBOM\u8bbe\u7f6e\u3002", (String)"CadBomSettingListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.isAllowUpdate(costtypeId, ids)) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", ids)};
        DynamicObjectCollection bomSettings = QueryServiceHelper.query((String)"cad_bomsetting", (String)"tracknumber", (QFilter[])filters);
        ArrayList<Long> trackIds = new ArrayList<Long>(bomSettings.size());
        for (DynamicObject bomSetting : bomSettings) {
            Long trackId = bomSetting.getLong("tracknumber");
            if (CadEmptyUtils.isEmpty((Long)trackId)) continue;
            trackIds.add(trackId);
        }
        if (!CadEmptyUtils.isEmpty(trackIds) && trackIds.size() != ids.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u65e2\u5305\u542b\u6709\u8ddf\u8e2a\u53f7\u7684\u7269\u6599\uff0c\u53c8\u5305\u542b\u65e0\u8ddf\u8e2a\u53f7\u7684\u7269\u6599\u8fdb\u884c\u5feb\u901f\u66f4\u65b0\u3002", (String)"CadBomSettingListPlugin_12", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("cad_quickapplyupdate");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("costtype", (Object)costtypeId.toString());
        formShowParameter.setCustomParam("sourcePage", (Object)"bomSetting");
        formShowParameter.setCustomParam("ids", ids);
        formShowParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        this.getPageCache().put("EntityName", "cad_bomsetting");
        super.beforeItemClick(evt);
    }

    private String getCostType(String costTypeId) {
        DynamicObject type = CostTypeHelper.getCostType((Long)Long.valueOf(costTypeId), (String)"type");
        if (type == null) {
            return "0";
        }
        return type.getString("type");
    }

    private boolean isAllowUpdate(Long costTypeId, List<Object> bomSettingIds) {
        String selectedFields = "number,material.id material";
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", bomSettingIds), new QFilter("isdowncalc", "=", (Object)Boolean.FALSE), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection bomSetting = QueryServiceHelper.query((String)"cad_bomsetting", (String)selectedFields, (QFilter[])filters);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)bomSetting)) {
            return false;
        }
        HashSet matIds = new HashSet(16);
        bomSetting.forEach(p -> matIds.add(p.getLong("material")));
        filters = new QFilter[]{new QFilter("costtype", "=", (Object)costTypeId), new QFilter("material", "in", matIds), new QFilter("billstatus", "=", (Object)"C")};
        DynamicObjectCollection purPrices = QueryServiceHelper.query((String)"cad_purprices", (String)"material.id material", (QFilter[])filters);
        matIds.clear();
        purPrices.forEach(p -> matIds.add(p.getLong("material")));
        StringBuilder sb = new StringBuilder();
        for (DynamicObject bomSet : bomSetting) {
            if (matIds.contains(bomSet.getLong("material"))) continue;
            sb.append("\u3001");
            sb.append(bomSet.getString("number"));
        }
        if (sb.length() == 0) {
            return false;
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6210\u672cBOM\u8bbe\u7f6e\u5355\u636e\u201c%s\u201d\u6ca1\u6709\u5916\u8d2d\u4ef7\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u3002", (String)"CadBomSettingListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]), sb.substring(1)));
        return true;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            protected boolean isOnlyPK4SelectedAllRows() {
                return true;
            }
        });
        super.beforeCreateListDataProvider(args);
    }
}

