/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.bom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.dto.Keycol;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CalcDimenHelper;
import kd.macc.cad.common.helper.CalcKeyHelper;
import kd.macc.cad.common.helper.ConfigTrackHelper;
import kd.macc.cad.common.helper.DynamicObjectHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CadRouterSettingEditPlugin
extends AbstractBillPlugIn {
    private boolean isKeepAutoFill = true;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addItemClickListeners(new String[]{"entry_item"});
        this.addListener();
    }

    protected void addListener() {
        BasedataEdit costType = (BasedataEdit)this.getControl("costtype");
        costType.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            DynamicObject[] costTypes = ElementRelationHelper.getModeCostTypes();
            Set costs = ElementRelationHelper.getCostTypeIds((DynamicObject[])costTypes);
            if (!CadEmptyUtils.isEmpty((Set)costs)) {
                filters.add(new QFilter("id", "in", (Object)costs));
            } else {
                filters.add(new QFilter("id", "=", (Object)-1L));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit mat = (BasedataEdit)this.getControl("material");
        mat.addBeforeF7SelectListener(evt -> {
            Set materialBySalOrder;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            DynamicObject ct = this.getModel().getDataEntity().getDynamicObject("costtype");
            List filters = ElementRelationHelper.getMatFiltersBy((DynamicObject)ct, null);
            filters.add(new QFilter("enableproduct", "=", (Object)true));
            filters.add(new QFilter("configproperties", "!=", (Object)"2"));
            int index = this.getModel().getEntryCurrentRowIndex("materialentry");
            DynamicObject configuredcode = (DynamicObject)this.getModel().getValue("configuredcode", index);
            DynamicObject tracknumber = (DynamicObject)this.getModel().getValue("tracknumber", index);
            if (!(configuredcode == null && tracknumber == null || CadEmptyUtils.isEmpty((Set)(materialBySalOrder = ConfigTrackHelper.getMaterialBySalOrder((Long)(configuredcode == null ? 0L : configuredcode.getLong("id")), (Long)(tracknumber == null ? 0L : tracknumber.getLong("id"))))))) {
                filters.add(new QFilter("id", "in", (Object)materialBySalOrder));
            }
            filterParameter.setQFilters(filters);
        });
        BasedataEdit configuredCode = (BasedataEdit)this.getControl("configuredcode");
        configuredCode.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            List configCodeIds;
            int index = this.getModel().getEntryCurrentRowIndex("materialentry");
            ListShowParameter parameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter filterParameter = parameter.getListFilterParameter();
            List qList = filterParameter.getQFilters();
            DynamicObject matObj = (DynamicObject)this.getModel().getValue("material", index);
            if (matObj != null && !CadEmptyUtils.isEmpty((List)(configCodeIds = ConfigTrackHelper.getConfigCodeIdsByMaterial(Collections.singleton(matObj.getLong("id")))))) {
                qList.add(new QFilter("id", "in", (Object)configCodeIds));
            }
        });
        BasedataEdit router = (BasedataEdit)this.getControl("router");
        router.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List<Long> settingIds = this.getSettingIdByCostType();
            if (!settingIds.isEmpty()) {
                ArrayList<QFilter> filters = new ArrayList<QFilter>();
                filters.add(new QFilter("id", "not in", settingIds));
                filterParameter.setQFilters(filters);
            }
        });
    }

    public List<Long> getSettingIdByCostType() {
        DynamicObject costType = (DynamicObject)this.getModel().getValue("costtype");
        Long id = (Long)this.getModel().getValue("id");
        QFilter costTypeQF = new QFilter("costtype", "=", (Object)costType.getLong("id"));
        QFilter idQF = new QFilter("id", "!=", (Object)id);
        DynamicObjectCollection routerSettingIds = QueryServiceHelper.query((String)"cad_routersetting", (String)"router", (QFilter[])new QFilter[]{costTypeQF, idQF});
        List idList = DynamicObjectHelper.getIdList((DynamicObjectCollection)routerSettingIds, (String)"router");
        return idList;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "mat_batch_add": {
                this.openMatGroup();
            }
        }
    }

    private void openMatGroup() {
        this.isKeepAutoFill = false;
        this.getModel().setValue("matgroup", null);
        BasedataEdit matGroup = (BasedataEdit)this.getControl("matgroup");
        if (matGroup != null) {
            matGroup.click();
        }
    }

    private Set<Object> getAllMaterialSelected() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("materialentry");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys)) {
            return new TreeSet<Object>();
        }
        TreeSet<Object> list = new TreeSet<Object>();
        entrys.forEach(s -> {
            DynamicObject mat = s.getDynamicObject("material");
            if (mat != null) {
                list.add(mat.getPkValue());
            }
        });
        return list;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (!this.isKeepAutoFill) {
            this.isKeepAutoFill = true;
            return;
        }
        switch (e.getProperty().getName()) {
            case "router": {
                this.changeRouter((DynamicObject)newValue);
                break;
            }
            case "routertype": {
                this.changeRouterType(String.valueOf(newValue));
                break;
            }
            case "material": {
                this.updateAllBizCtrl();
                this.EnableAuxprop();
                break;
            }
            case "matgroup": {
                this.changeMatGroup((DynamicObject)newValue);
                break;
            }
            case "configuredcode": {
                ConfigTrackHelper.setMaterialValueByConfig((IFormView)this.getView(), (IDataModel)this.getModel(), (Integer)rowIndex);
                ConfigTrackHelper.setTrackValueByConfig((IFormView)this.getView(), (IDataModel)this.getModel(), (Integer)rowIndex);
                break;
            }
            case "tracknumber": {
                ConfigTrackHelper.setConfigValueByTrack((IFormView)this.getView(), (IDataModel)this.getModel(), (Integer)rowIndex);
            }
        }
    }

    private void changeMatGroup(DynamicObject matGroup) {
        TreeSet groupMatIds = new TreeSet();
        if (matGroup != null) {
            QFilter filter = new QFilter("mftcontrolentry.materialcontrol", "=", (Object)Long.parseLong(matGroup.getPkValue().toString()));
            QFilter status = new QFilter("status", "=", (Object)"C");
            QFilter enable = new QFilter("enable", "=", (Object)"1");
            enable.and(QFilter.isNotNull((String)"masterid"));
            DynamicObjectCollection rows = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)"id,masterid", (QFilter[])new QFilter[]{filter, status, enable});
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)rows)) {
                return;
            }
            rows.forEach(s -> groupMatIds.add(s.get("masterid")));
        }
        Set<Object> formMatIds = this.getRouterMatCache();
        TreeSet<Object> allSet = new TreeSet<Object>();
        if (!CadEmptyUtils.isEmpty(formMatIds)) {
            allSet.addAll(formMatIds);
        }
        if (!CadEmptyUtils.isEmpty(groupMatIds)) {
            allSet.addAll(groupMatIds);
        }
        if (CadEmptyUtils.isEmpty(allSet)) {
            return;
        }
        this.getModel().deleteEntryData("materialentry");
        this.batchInsertMaterial(allSet);
        this.autoAddNewLastEntry();
    }

    private void changeRouterType(String routerType) {
        this.getModel().deleteEntryData("materialentry");
        this.showOrHideViewItemBy(routerType);
        DynamicObject router = this.getModel().getDataEntity().getDynamicObject("router");
        if (router == null) {
            return;
        }
        switch (routerType) {
            case "A": {
                this.updateMaterialEntryBy(router);
                break;
            }
            case "B": {
                DynamicObject routerMatGroup = router.getDynamicObject("materialgroup");
                this.changeMatGroup(routerMatGroup);
            }
        }
        this.setEnableFields();
    }

    private void setEnableFields() {
        String routerType = this.getModel().getDataEntity().getString("routertype");
        if ("A".equals(routerType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"mat_entry_add", "mat_entry_del", "mat_entry_insert"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"mat_entry_add", "mat_entry_del", "mat_entry_insert"});
        }
        this.getView().updateView("matflex");
    }

    private void batchInsertMaterial(Collection<Object> collection) {
        this.getModel().beginInit();
        for (Object matId : collection) {
            int index = this.getModel().createNewEntryRow("materialentry");
            this.getModel().setValue("material", matId, index);
        }
        this.getModel().endInit();
        this.getView().updateView("materialentry");
        this.updateAllBizCtrl();
    }

    private void changeRouter(DynamicObject router) {
        if (router == null) {
            this.getModel().deleteEntryData("materialentry");
            return;
        }
        this.updateMaterialEntryBy(router);
        String processType = router.getString("processtype");
        if (StringUtils.isNotEmpty((String)processType)) {
            this.getModel().setValue("routertype", (Object)processType);
            this.setEnableFields();
        }
    }

    private void updateMaterialEntryBy(DynamicObject router) {
        this.getModel().deleteEntryData("materialentry");
        if (router == null) {
            return;
        }
        DynamicObject routerMat = router.getDynamicObject("material");
        if (routerMat != null) {
            int index = this.getModel().createNewEntryRow("materialentry");
            this.getModel().setValue("material", routerMat.getPkValue(), index);
            this.getModel().setValue("auxpty", (Object)router.getLong("auxproperty.id"), index);
            this.getModel().setValue("keycol", (Object)router.getString("keycol"), index);
        }
    }

    private void autoAddNewLastEntry() {
        int size = this.getModel().getEntryRowCount("materialentry");
        if (size > 0) {
            this.getModel().createNewEntryRow("materialentry");
        }
    }

    private void changeBizCtrl(DynamicObject mat, int index) {
        if (mat == null) {
            this.getModel().setValue("bizctrl", null, index);
        } else {
            String bizCtrlName = BomRouterHelper.getMatBizCtrl((DynamicObject)mat);
            if (StringUtils.isNotEmpty((String)bizCtrlName)) {
                this.getModel().setValue("bizctrl", (Object)bizCtrlName, index);
            }
        }
    }

    private void showOrHideViewItemBy(String routerType) {
        if (StringUtils.isEmpty((String)routerType)) {
            routerType = this.getModel().getDataEntity().getString("routertype");
        }
        switch (routerType) {
            case "A": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"mat_batch_add"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"matflex"});
                break;
            }
            case "B": {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"mat_batch_add"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"matflex"});
                break;
            }
            case "C": {
                if (this.getModel().getEntryRowCount("materialentry") > 0) {
                    this.getModel().deleteEntryData("materialentry");
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"matflex"});
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter fsp = this.getView().getFormShowParameter();
        this.getModel().setValue("costtype", fsp.getCustomParam("costtype"));
        this.showOrHideViewItemBy(null);
        this.updateAllBizCtrl();
        this.initRouterMatCache();
        this.EnableAuxprop();
        this.setEnableFields();
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "newentry": {
                int i = this.getModel().getEntryCurrentRowIndex("materialentry");
                if (i < 0) {
                    return;
                }
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"auxpty"});
                break;
            }
        }
    }

    private void EnableAuxprop() {
        int rowCount = this.getModel().getEntryRowCount("materialentry");
        if (rowCount >= 0) {
            for (int i = 0; i <= rowCount; ++i) {
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", i);
                Boolean isuseauxptyFlag = false;
                if (material != null) {
                    isuseauxptyFlag = material.getBoolean("isuseauxpty");
                }
                this.getView().setEnable(isuseauxptyFlag, i, new String[]{"auxpty"});
            }
        }
    }

    private void initRouterMatCache() {
        String key = this.getCacheKey();
        if (StringUtils.isEmpty((String)key)) {
            return;
        }
        Set<Object> matIds = this.getAllMaterialSelected();
        String jsonData = SerializationUtils.toJsonString(matIds);
        this.getPageCache().put(key, jsonData);
    }

    private Set<Object> getRouterMatCache() {
        String key = this.getCacheKey();
        if (StringUtils.isEmpty((String)key)) {
            return null;
        }
        String cache = this.getPageCache().get(key);
        if (StringUtils.isEmpty((String)cache)) {
            return null;
        }
        return (Set)SerializationUtils.fromJsonString((String)cache, Set.class);
    }

    private String getCacheKey() {
        DynamicObject router = this.getModel().getDataEntity().getDynamicObject("router");
        if (router == null) {
            return null;
        }
        String routerType = this.getModel().getDataEntity().getString("routertype");
        if (StringUtils.isEmpty((String)routerType)) {
            return null;
        }
        return String.valueOf(router.getPkValue()) + "_" + routerType;
    }

    private void updateAllBizCtrl() {
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("materialentry");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entrys)) {
            return;
        }
        int i = 0;
        for (DynamicObject entry : entrys) {
            if (StringUtils.isEmpty((String)entry.getString("bizctrl"))) {
                this.changeBizCtrl(entry.getDynamicObject("material"), i);
            }
            ++i;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((FormOperate)args.getSource()).getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection materialEntrys = dataEntity.getDynamicObjectCollection("materialentry");
            for (int i = 0; i < materialEntrys.size(); ++i) {
                DynamicObject materialEntry = (DynamicObject)materialEntrys.get(i);
                this.getModel().setValue("auxpty", (Object)CalcDimenHelper.getAffectAuxpty((Object)materialEntry.get("material"), (Object)materialEntry.get("auxpty")), i);
                HashMap<String, Object> coEntryKeycolMap = new HashMap<String, Object>(16);
                coEntryKeycolMap.put("material", materialEntry.get("material.masterid"));
                DynamicObject auxpty = (DynamicObject)this.getModel().getValue("auxpty", i);
                coEntryKeycolMap.put("auxproperty", auxpty == null ? Long.valueOf(0L) : auxpty.getPkValue());
                coEntryKeycolMap.put("configuredcode", materialEntry.get("configuredcode.id"));
                coEntryKeycolMap.put("tracknumber", materialEntry.get("tracknumber.id"));
                coEntryKeycolMap.put("project", materialEntry.get("project.id"));
                coEntryKeycolMap.put("lot", materialEntry.get("lot"));
                Keycol calcKey = CalcKeyHelper.getCalcKey(coEntryKeycolMap, new ArrayList(), (boolean)true);
                this.getModel().setValue("keycol", (Object)calcKey.getKeycol(), i);
                this.getModel().setValue("keycolid", (Object)calcKey.getId(), i);
            }
            this.deleteEntryRow();
        }
    }

    private void deleteEntryRow() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection materialEntrys = dataEntity.getDynamicObjectCollection("materialentry");
        if (materialEntrys.size() <= 1) {
            return;
        }
        for (int i = 0; i < materialEntrys.size(); ++i) {
            DynamicObject materialEntry = (DynamicObject)materialEntrys.get(i);
            Object material = materialEntry.get("material");
            Object auxpty = materialEntry.get("auxpty");
            Object configuredcode = materialEntry.get("configuredcode");
            Object tracknumber = materialEntry.get("tracknumber");
            Object project = materialEntry.get("project");
            String lot = (String)materialEntry.get("lot");
            if (material != null || auxpty != null || configuredcode != null || project != null || tracknumber != null || !CadEmptyUtils.isEmpty((String)lot)) continue;
            this.getModel().deleteEntryRow("materialentry", i);
        }
    }
}

