/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.bom;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.macc.cad.common.helper.CostBomRouteRefreshHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.formplugin.bom.CadSettingBaseListPlugin;
import kd.macc.cad.formplugin.common.Util;
import kd.macc.cad.formplugin.price.PriceCommon;

public class CadRouterSettingListPlugin
extends CadSettingBaseListPlugin {
    private static final String MATERIAL_ROUTER_TYPE = "A";
    private static final String REFRESHROUTE = "refreshroute";
    private static final Log logger = LogFactory.getLog(CadRouterSettingListPlugin.class);

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"syncosttype", "autoexecrule"});
    }

    @Override
    protected Map<Object, String> getBizCtrl(ListSelectedRowCollection rows, String fields, String entity) {
        fields = "id,materialentry.material.enableproduct enableproduct,materialentry.material.enablepur enablepur";
        return super.getBizCtrl(rows, fields, "cad_routersetting");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        if (!"sca".equals(appId)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"autoexecrule"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "syncosttype": {
                if (!PriceCommon.isPermItemPermission(RequestContext.get().getCurrUserId(), "cad_routersetting", "47156aff000000ac")) {
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = billList.getSelectedRows();
                Util.openSyncCostTypeView(this.getView(), "cad_routersetting", rows);
                break;
            }
            case "refreshroute": {
                if (!PriceCommon.isPermItemPermission(RequestContext.get().getCurrUserId(), "cad_routersetting", "47156aff000000ac")) {
                    return;
                }
                String costTypeId = this.getPageCache().get("costtype");
                if (costTypeId == null) {
                    return;
                }
                String costType = this.getCostType(costTypeId);
                if (!"1".equals(costType)) {
                    String lockErr = ResManager.loadKDString((String)"\u5237\u65b0\u5de5\u827a\u8def\u7ebf\u5931\u8d25\uff0c\u5c5e\u6027\u4e3a\u975e\u6a21\u62df\u7c7b\u578b\u7684\u6210\u672c\u7c7b\u578b\u4e0d\u5141\u8bb8\u64cd\u4f5c\u5237\u65b0\u5de5\u827a\u8def\u7ebf\u3002", (String)"CadRouterSettingListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(lockErr);
                    return;
                }
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("cad_refreshbomsetting");
                fsp.setCaption(ResManager.loadKDString((String)"\u5237\u65b0\u5de5\u827a\u8def\u7ebf\u8bbe\u7f6e", (String)"CadRouterSettingListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "refreshRouterSetting"));
                fsp.setCustomParam("costTypeId", (Object)Long.parseLong(costTypeId));
                fsp.setCustomParam("entity", (Object)"cad_routersetting");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(fsp);
                break;
            }
            case "autoexecrule": {
                if (!PriceCommon.isPermItemPermission(RequestContext.get().getCurrUserId(), "cad_routersetting", "47156aff000000ac")) {
                    return;
                }
                String costTypeId = this.getPageCache().get("costtype");
                if (costTypeId == null) {
                    return;
                }
                String costType = this.getCostType(costTypeId);
                if (!"1".equals(costType)) {
                    String lockErr = ResManager.loadKDString((String)"\u64cd\u4f5c\u81ea\u52a8\u6267\u884c\u89c4\u5219\u8bbe\u7f6e\u5931\u8d25\uff0c\u5c5e\u6027\u4e3a\u975e\u6a21\u62df\u7c7b\u578b\u7684\u6210\u672c\u7c7b\u578b\u4e0d\u5141\u8bb8\u64cd\u4f5c\u81ea\u52a8\u6267\u884c\u89c4\u5219\u8bbe\u7f6e\u3002", (String)"CadRouterSettingListPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(lockErr);
                    return;
                }
                ListShowParameter autoExecRuleFsp = new ListShowParameter();
                autoExecRuleFsp.setBillFormId("cad_autoexecrulesetting");
                autoExecRuleFsp.setCustomParam("costTypeId", (Object)Long.parseLong(costTypeId));
                autoExecRuleFsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)autoExecRuleFsp);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        BillList billList = (BillList)this.getControl("billlistap");
        switch (e.getActionId()) {
            case "refreshRouterSetting": {
                HashMap returnData = (HashMap)e.getReturnData();
                if (returnData == null) {
                    return;
                }
                String materialStr = (String)returnData.get("material_tag");
                Long manuorgId = (Long)returnData.get("manuorgId");
                Long calorg = (Long)returnData.get("calorgId");
                Boolean isRefreshNewMat = (Boolean)returnData.get("refreshNewMat");
                String costTypeId = this.getPageCache().get("costtype");
                if (costTypeId == null || calorg == null) {
                    return;
                }
                try {
                    boolean isSuccess = MutexHelper.enableReentrant((String)"cad_routersetting", (Object)costTypeId, (String)REFRESHROUTE);
                    if (!isSuccess) {
                        String lockErr = ResManager.loadKDString((String)"\u8be5\u6210\u672c\u7c7b\u578b\u6b63\u5728\u8fdb\u884c\u5237\u65b0\u6210\u672c\u5de5\u827a\u8def\u7ebf\uff0c\u8bf7\u7a0d\u540e\u6267\u884c\u3002", (String)"CadRouterSettingListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                        this.getView().showErrorNotification(lockErr);
                        return;
                    }
                    MutexHelper.require((String)"cad_routersetting", (Object)costTypeId, (String)REFRESHROUTE, (boolean)true, (StringBuilder)new StringBuilder());
                    Set materialIds = CostBomRouteRefreshHelper.getMaterialIds((Long)calorg, (String)materialStr, (String)"cad_router");
                    AtomicInteger size = new AtomicInteger();
                    Lists.partition(new ArrayList(materialIds), (int)100000).forEach(materialIdList -> size.addAndGet(CostBomRouteRefreshHelper.refreshRoute((Long)calorg, (Long)manuorgId, (Long)Long.parseLong(costTypeId), new HashSet(materialIdList), (Boolean)isRefreshNewMat)));
                    MutexHelper.release((String)"cad_routersetting", (String)REFRESHROUTE, (String)costTypeId);
                    if (size.get() > 0) {
                        billList.refresh();
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f\u5237\u65b0\u6210\u672c\u5de5\u827a\u8def\u7ebf", (String)"CadRouterSettingListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                catch (Exception ex) {
                    logger.error("\u5237\u65b0\u6210\u672c\u5de5\u827a\u8def\u7ebf\u62a5\u9519\u3002\u9519\u8bef\u4fe1\u606f\uff1a", (Throwable)ex);
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u672c\u5de5\u827a\u8def\u7ebf\u62a5\u9519\uff1a%s\u3002", (String)"CadRouterSettingListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]), ex.toString()));
                    MutexHelper.release((String)"cad_routersetting", (String)REFRESHROUTE, (String)costTypeId);
                    return;
                }
            }
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        this.getPageCache().put("EntityName", "cad_routersetting");
        super.beforeItemClick(evt);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        List listColumns = o.getListColumns();
        for (IListColumn column : listColumns) {
            switch (column.toString()) {
                case "costtype.name": {
                    column.setFixed(true);
                    break;
                }
                case "number": {
                    column.setFixed(true);
                    break;
                }
                case "router.number": {
                    column.setFixed(true);
                    break;
                }
                case "router.name": {
                    column.setFixed(true);
                }
            }
        }
    }

    private String getCostType(String costTypeId) {
        DynamicObject type = CostTypeHelper.getCostType((Long)Long.parseLong(costTypeId), (String)"type");
        if (type == null) {
            return "0";
        }
        return type.getString("type");
    }
}

