/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.bom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.helper.BomRouterHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.formplugin.price.PriceCommon;

abstract class CadSettingBaseListPlugin
extends AbstractListPlugin {
    CadSettingBaseListPlugin() {
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tblnew", "tbldel", "tblsubmit", "tblunsubmit", "tblaudit", "tblunaudit", "tbldisable", "tblenable"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String pageCacheCosttype = null;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("costtype.")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            List<ComboItem> costTypes = this.getCostTypeComboItemList();
            if (costTypes != null && !costTypes.isEmpty()) {
                commonFilterColumn.setComboItems(costTypes);
                ComboItem item = costTypes.get(0);
                commonFilterColumn.setDefaultValue(item.getValue());
                pageCacheCosttype = item.getValue();
                break;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u53ef\u4f7f\u7528\u7684\u6210\u672c\u7c7b\u578b\u3002", (String)"CadSettingBaseListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            break;
        }
        if (pageCacheCosttype != null) {
            this.getPageCache().put("costtype", pageCacheCosttype);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String field = e.getFieldName();
        if ("costtype.id".equals(field) || "costtype.name".equals(field)) {
            e.addCustomQFilter(CostTypeHelper.getCostTypeByAppNum((IFormView)this.getView()));
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                e.getQfilters().add(baseDataFilter);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        this.schemeSearch(filterValues);
        if (filterValues.containsKey("customfilter")) {
            List customfilter = (List)filterValues.get("customfilter");
            if (customfilter == null || customfilter.isEmpty()) {
                return;
            }
            String pageCacheCosttype = null;
            for (Map map : customfilter) {
                List names = (List)map.get("FieldName");
                boolean isCost = false;
                for (Object name : names) {
                    if (!"costtype.id".equals(String.valueOf(name))) continue;
                    isCost = true;
                    break;
                }
                if (!isCost) continue;
                List vals = (List)map.get("Value");
                if (vals == null || vals.isEmpty()) {
                    return;
                }
                pageCacheCosttype = String.valueOf(vals.get(0));
                break;
            }
            if (pageCacheCosttype != null) {
                this.getPageCache().put("costtype", pageCacheCosttype);
            }
        }
    }

    protected void schemeSearch(Map<String, List<Map<String, List<Object>>>> filterValues) {
        List<Map<String, List<Object>>> filterMapList = filterValues.get("schemefilter");
        if (CadEmptyUtils.isEmpty(filterMapList)) {
            return;
        }
        String pageCacheCosttype = null;
        for (Map<String, List<Object>> filterMap : filterMapList) {
            List<Object> ids;
            List<Object> fieldName = filterMap.get("FieldName");
            if (CadEmptyUtils.isEmpty(fieldName) || !"costtype.name".equals(fieldName.get(0)) || CadEmptyUtils.isEmpty(ids = filterMap.get("Id"))) continue;
            pageCacheCosttype = ids.get(0).toString();
        }
        if (pageCacheCosttype != null) {
            this.getPageCache().put("costtype", pageCacheCosttype);
        }
    }

    public void setFilter(SetFilterEvent e) {
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            e.getQFilters().add(new QFilter("costtype.type", "=", (Object)"1"));
        }
    }

    protected List<ComboItem> getCostTypeComboItemList() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        String appNum = this.getView().getFormShowParameter().getAppId();
        DynamicObject[] costTypes = BomRouterHelper.getAllCostTypes((String)appNum);
        if (costTypes != null && costTypes.length > 0) {
            List<DynamicObject> costTypeList = Arrays.asList(costTypes);
            CostTypeHelper.sortByType(costTypeList);
            for (DynamicObject costType : costTypeList) {
                if ("sca".equals(appNum) && CommonConstant.ACA_COST_TYPE_ID.equals(costType.getLong("id"))) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(costType.getString("name")));
                item.setValue(costType.getString("id"));
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
        }
        return acctItems;
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String costTypeId = PriceCommon.getCostTypeId(e.getParameter().getFormId(), e.getParameter().getPkId());
        if (StringUtils.isEmpty((String)costTypeId)) {
            costTypeId = this.getPageCache().get("costtype");
        }
        if (StringUtils.isEmpty((String)costTypeId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u53ef\u4f7f\u7528\u7684\u6210\u672c\u7c7b\u578b\u3002", (String)"CadSettingBaseListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        } else {
            e.getParameter().setCustomParam("costtype", (Object)costTypeId);
        }
        if (costTypeId != null && !BomRouterHelper.isAnalogCostType((Long)Long.valueOf(costTypeId))) {
            e.getParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setBizCtrl();
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"quickupdate"});
        }
    }

    private void setBizCtrl() {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getCurrentListAllRowCollection();
        Map<Object, String> bizctrls = this.getBizCtrl(rows, null, null);
        int i = 0;
        for (ListSelectedRow row : rows) {
            String id = row.getPrimaryKeyValue().toString();
            if (StringUtils.isNotEmpty((String)id) && bizctrls.containsKey(id)) {
                billList.setCellFieldValue("bizctrl", i, (Object)bizctrls.get(id));
            }
            ++i;
        }
    }

    protected Map<Object, String> getBizCtrl(ListSelectedRowCollection rows, String fields, String entity) {
        if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)rows) || StringUtils.isEmpty((String)fields) || StringUtils.isEmpty((String)entity)) {
            return null;
        }
        ArrayList<Object> ids = new ArrayList<Object>();
        for (ListSelectedRow row : rows) {
            ids.add(row.getPrimaryKeyValue());
        }
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObjectCollection routers = QueryServiceHelper.query((String)entity, (String)fields, (QFilter[])new QFilter[]{filter});
        return BomRouterHelper.getMatBizCtrl((DynamicObjectCollection)routers);
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String costType = this.getPageCache().get("costtype");
        if (costType == null) {
            return;
        }
        switch (e.getItemKey()) {
            case "tblnew": 
            case "tbldel": 
            case "tblsubmit": 
            case "tblunsubmit": 
            case "tblaudit": 
            case "tblunaudit": 
            case "tbldisable": 
            case "tblenable": {
                if (BomRouterHelper.isAnalogCostType((Long)Long.valueOf(costType))) break;
                String tips = String.format(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u5c5e\u6027\u7684\u6210\u672c\u7c7b\u578b\u4e0d\u652f\u6301\u624b\u5de5\u7f16\u8f91\u3002\u8bf7\u901a\u8fc7\u6210\u672c\u66f4\u65b0\u64cd\u4f5c\u66f4\u65b0%s\u3002", (String)"CadSettingBaseListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]), this.getView().getFormShowParameter().getCaption());
                this.getView().showTipNotification(tips);
                e.setCancel(true);
                break;
            }
        }
    }
}

