/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.bom;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.business.strategy.FilterStrategy;
import kd.macc.cad.business.strategy.IColsSelectStrategy;
import kd.macc.cad.business.strategy.MetaHelper;
import kd.macc.cad.business.strategy.SelectParams;
import kd.macc.cad.business.strategy.TypeSelectStrategy;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class RouteRuleSettingEdit
extends AbstractBillPlugIn {
    private static final String filterStr = "{\"filterRow\":[{\"id\":\"40EC9+93BMJN\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"status\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"40EC9+93DQ/O\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"40EC9+93BMJO\",\"leftBracket\":\"\",\"compareType\":\"106\",\"fieldName\":\"processseqtype\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"40EC9+93DQ/P\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false}";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"srcfieldname"});
        this.initF7Filter();
    }

    private void initF7Filter() {
        BasedataEdit costTypeInput = (BasedataEdit)this.getControl("costtype");
        costTypeInput.addBeforeF7SelectListener(evt -> {
            ListFilterParameter filterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = filterParameter.getQFilters();
            DynamicObject[] costTypes = CostTypeHelper.getCostType((int)1);
            ArrayList<Long> ids = new ArrayList<Long>(16);
            for (DynamicObject costType : costTypes) {
                ids.add(costType.getLong("id"));
            }
            if (!ids.isEmpty()) {
                qFilters.add(new QFilter("id", "in", ids));
            }
        });
    }

    public void afterBindData(EventObject e) {
        FieldEdit bomPrioritisation;
        Object srcroute;
        OperationStatus status;
        super.afterBindData(e);
        String filter = (String)this.getModel().getDataEntity().get("filter_tag");
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            filterGrid.SetValue(filterCondition);
        }
        if (OperationStatus.ADDNEW.equals((Object)(status = this.getView().getFormShowParameter().getStatus()))) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
            filterGrid.SetValue(filterCondition);
            DynamicObjectCollection entryentity = this.getModel().getDataEntity().getDynamicObjectCollection("entryentity");
            if (entryentity.size() == 0) {
                this.getModel().createNewEntryRow("entryentity");
            }
        }
        if ("cad_router".equals(srcroute = this.getModel().getValue("srcroute"))) {
            this.getModel().setValue("routeprioritisation", (Object)"");
            bomPrioritisation = (FieldEdit)this.getView().getControl("routeprioritisation");
            bomPrioritisation.setMustInput(Boolean.FALSE.booleanValue());
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"routeprioritisation"});
        } else {
            bomPrioritisation = (FieldEdit)this.getView().getControl("routeprioritisation");
            bomPrioritisation.setMustInput(Boolean.TRUE.booleanValue());
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"routeprioritisation"});
        }
    }

    public void beforeBindData(EventObject e) {
        String costType;
        super.beforeBindData(e);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && !CadEmptyUtils.isEmpty((String)(costType = parentView.getPageCache().get("costtype")))) {
            this.getModel().setValue("costtype", (Object)Long.parseLong(costType));
        }
        this.filterDataRange();
    }

    protected void filterDataRange() {
        String srcroute = this.getModel().getDataEntity().getString("srcroute");
        MainEntityType srcMainType = CadEmptyUtils.isEmpty((String)srcroute) ? null : EntityMetadataCache.getDataEntityType((String)srcroute);
        this.getView().setEnable(Boolean.TRUE, new String[]{"filtergrid"});
        if (srcMainType == null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"filtergrid"});
        } else {
            EntityTypeUtil helper = new EntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)srcMainType);
            FilterGrid filtergrid = (FilterGrid)this.getView().getControl("filtergrid");
            filtergrid.setEntityNumber(srcMainType.getName());
            filtergrid.setFilterColumns(cols);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String proName = e.getProperty().getName();
        Object newValueObj = e.getChangeSet()[0].getNewValue();
        switch (proName) {
            case "srcroute": {
                FieldEdit bomPrioritisation = (FieldEdit)this.getView().getControl("routeprioritisation");
                if ("cad_router".equals(newValueObj)) {
                    this.getModel().setValue("routeprioritisation", (Object)"");
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"routeprioritisation"});
                    bomPrioritisation.setMustInput(Boolean.FALSE.booleanValue());
                } else {
                    this.getModel().setValue("routeprioritisation", (Object)"4");
                    bomPrioritisation.setMustInput(Boolean.TRUE.booleanValue());
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"routeprioritisation"});
                }
                this.clearFieldInfo();
                this.getView().updateView();
                break;
            }
            case "productroute": {
                this.changeMainRouteInfo();
                break;
            }
            case "mainroute": {
                this.changeProdRouteInfo();
            }
        }
    }

    private void changeMainRouteInfo() {
        Boolean productroute = (Boolean)this.getModel().getValue("productroute");
        if (productroute.booleanValue()) {
            this.getModel().setValue("productroute", (Object)productroute);
            this.getModel().setValue("mainroute", (Object)Boolean.FALSE);
        }
    }

    private void changeProdRouteInfo() {
        Boolean mainroute = (Boolean)this.getModel().getValue("mainroute");
        if (mainroute.booleanValue()) {
            this.getModel().setValue("mainroute", (Object)mainroute);
            this.getModel().setValue("productroute", (Object)Boolean.FALSE);
        }
    }

    private void clearFieldInfo() {
        this.getModel().getDataEntity().set("filter_tag", null);
        this.getModel().getDataEntity().set("filter", null);
        this.getModel().deleteEntryData("entryentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String opKey = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(opKey)) {
            boolean flag;
            long costType = this.getModel().getDataEntity().getLong("costtype.id");
            if (!this.checkData(costType).booleanValue()) {
                String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u7c7b\u578b\u4e0b\u6ca1\u6709\u9ed8\u8ba4\u65b9\u6848\uff0c\u9700\u8981\u52fe\u9009\u9ed8\u8ba4\u503c\u3002", (String)"RouteRuleSettingEdit_6", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(errorMsg);
                e.setCancel(true);
                return;
            }
            if (this.getPageCache().get("confirmCopy") == null && (flag = this.getModel().getDataEntity().getBoolean("default"))) {
                QFilter filter = new QFilter("costtype", "=", (Object)costType);
                filter.and("default", "=", (Object)true);
                filter.and("id", "!=", (Object)this.getModel().getDataEntity().getLong("id"));
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_routerulesetting", (String)"id,name,number", (QFilter[])new QFilter[]{filter});
                if (dynamicObject != null) {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmCopy", (IFormPlugin)this);
                    String confirmTip = ResManager.loadKDString((String)"\u5f53\u524d\u6210\u672c\u7c7b\u578b\u4e0b\u5df2\u7ecf\u6709\u9ed8\u8ba4\u65b9\u6848\uff0c\u662f\u5426\u5c06\u5f53\u524d\u9009\u4e2d\u65b9\u6848\u8bbe\u4e3a\u9ed8\u8ba4\u65b9\u6848\uff1f", (String)"RouteRuleSettingEdit_0", (String)"macc-cad-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                    e.setCancel(true);
                    this.getPageCache().put("confirmCopy", "true");
                    this.getPageCache().put("invalid", dynamicObject.getString("id"));
                    return;
                }
            }
            this.dataRangeSave();
            this.getPageCache().remove("confirmCopy");
        }
    }

    private Boolean checkData(long costType) {
        QFilter filter = new QFilter("costtype", "=", (Object)costType);
        filter.and("default", "=", (Object)true);
        boolean exists = QueryServiceHelper.exists((String)"cad_routerulesetting", (QFilter[])new QFilter[]{filter});
        if (exists) {
            return Boolean.TRUE;
        }
        boolean flag = this.getModel().getDataEntity().getBoolean("default");
        if (flag) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected void dataRangeSave() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergrid");
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        this.getModel().getDataEntity().set("filter_tag", (Object)filterString);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "confirmCopy": {
                if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                    this.getView().invokeOperation("save", OperateOption.create());
                    break;
                }
                this.getPageCache().remove("confirmCopy");
                this.getPageCache().remove("invalid");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("save".equals(operateKey)) {
            String invalid;
            if (e.getOperationResult().isSuccess() && (invalid = this.getPageCache().get("invalid")) != null) {
                MainEntityType rulePlan = EntityMetadataCache.getDataEntityType((String)"cad_routerulesetting");
                DynamicObject rulePlanObj = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(invalid), (DynamicObjectType)rulePlan);
                if (rulePlanObj != null) {
                    rulePlanObj.set("default", (Object)false);
                    SaveServiceHelper.update((DynamicObject)rulePlanObj);
                }
            }
            this.getPageCache().remove("invalid");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("srcfieldname".equals(key)) {
            this.clickCostBillField();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        IDataModel model = this.getModel();
        model.beginInit();
        String closeKey = e.getActionId();
        int fieldMapIndex = model.getEntryCurrentRowIndex("entryentity");
        JSONArray data = this.parseReturnData(e);
        if (data != null && data.size() > 0) {
            JSONObject info = data.getJSONObject(0);
            if (!data.isEmpty() && "srcFieldNameCol".equals(closeKey)) {
                model.setValue("srcfieldname", (Object)info.getString("text"), fieldMapIndex);
                model.setValue("srcfield", (Object)info.getString("id"), fieldMapIndex);
                this.getView().updateView("srcfieldname", fieldMapIndex);
                this.getView().updateView("srcfield", fieldMapIndex);
            }
        }
        model.endInit();
    }

    private JSONArray parseReturnData(ClosedCallBackEvent evt) {
        Object data = evt.getReturnData();
        try {
            return JSON.parseArray((String)((String)data));
        }
        catch (Exception var3) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u201c%2$s\u201d\u8fd4\u56de\u7684\u6570\u636e\u89e3\u6790\u5931\u8d25\uff1a%1$s\u3002", (String)"RouteRuleSettingEdit_7", (String)"macc-cad-formplugin", (Object[])new Object[0]), var3.getMessage(), data));
        }
    }

    private void clickCostBillField() {
        IDataModel model = this.getModel();
        String srcroute = (String)model.getValue("srcroute");
        if (srcroute == null) {
            String tips = ResManager.loadKDString((String)"BOM\u6765\u6e90\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9BOM\u6765\u6e90\u3002", (String)"RouteRuleSettingEdit_2", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
        } else {
            String name = "cad_router".equals(srcroute) ? ResManager.loadKDString((String)"\u6210\u672c\u5de5\u827a\u8def\u7ebf", (String)"RouteRuleSettingEdit_8", (String)"macc-cad-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5236\u9020\u5de5\u827a\u8def\u7ebf", (String)"RouteRuleSettingEdit_9", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            String caption = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%s\u201d\u5b57\u6bb5\u3002", (String)"RouteRuleSettingEdit_5", (String)"macc-cad-formplugin", (Object[])new Object[0]), name);
            this.showColsTreePage(this.getView(), srcroute, this.buildTargetObjSelectStrategy("srcfield", "entryentity"), new CloseCallBack((IFormPlugin)this, "srcFieldNameCol"), caption);
        }
    }

    private void showColsTreePage(IFormView view, String entityNumber, IColsSelectStrategy strategy, CloseCallBack closeBack, String caption) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        IDataEntityProperty property = dataEntityType.findProperty("createtime");
        TypeSelectStrategy typeSelectStrategy = new TypeSelectStrategy(property);
        SelectParams params = new SelectParams();
        MetaHelper metaHelper = new MetaHelper((IColsSelectStrategy)typeSelectStrategy, entityNumber);
        String jsonTree = metaHelper.buildTree2JSON();
        params.setJsonTree(jsonTree);
        FormShowParameter fp = this.readyColsTreePage(params, closeBack);
        if (StringUtils.isNotEmpty((CharSequence)caption)) {
            fp.setCaption(caption);
        }
        view.showForm(fp);
    }

    private FormShowParameter readyColsTreePage(SelectParams params, CloseCallBack callBack) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cad_colstree_select");
        showParameter.getCustomParams().putAll(params.toMap());
        showParameter.setCloseCallBack(callBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        return showParameter;
    }

    private IColsSelectStrategy buildTargetObjSelectStrategy(String field, String entity) {
        ArrayList<String> existCols = new ArrayList<String>(16);
        DynamicObjectCollection fieldMap = this.getModel().getEntryEntity(entity);
        for (DynamicObject colMap : fieldMap) {
            String selectField = colMap.getString(field);
            if (!StringUtils.isNotEmpty((CharSequence)selectField)) continue;
            String[] splitKey = selectField.split("\\.");
            if (splitKey.length > 1) {
                selectField = splitKey[splitKey.length - 1];
            }
            existCols.add(selectField);
        }
        return new FilterStrategy(existCols);
    }
}

