/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.calc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CadBgParamListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(CadBgParamListPlugin.class);

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        if (evt.getItemKey().equals("costobjecttrack")) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u4fee\u590d\u6210\u672c\u6838\u7b97\u5bf9\u8c61\u4e0a\u7684\u8ddf\u8e2a\u53f7\u548c\u914d\u7f6e\u53f7\uff1f", (String)"CadBgParamListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("costobjecttrack_confirm", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if ("costobjecttrack_confirm".equals(callBackId) && MessageBoxResult.Yes == e.getResult()) {
            QFilter qfn = new QFilter("probill", ">", (Object)0L);
            QFilter qf = new QFilter("configuredcode", ">", (Object)0L);
            qf.or(new QFilter("tracknumber", ">", (Object)0L));
            DynamicObjectCollection dsColl = QueryServiceHelper.query((String)"cad_costobject", (String)"id,probill,manuorg,material", (QFilter[])new QFilter[]{qfn, qf});
            List lists = Lists.partition((List)dsColl, (int)2000);
            Date updateDate = new Date();
            for (List listtmp : lists) {
                HashSet sbentryToTrackStSets = Sets.newHashSetWithExpectedSize((int)10);
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
                HashMap manuorgToStMap = Maps.newHashMapWithExpectedSize((int)10);
                for (DynamicObject costobjectDyn : listtmp) {
                    Long material = costobjectDyn.getLong("material");
                    Long bizId = costobjectDyn.getLong("probill");
                    Long manuorgId = costobjectDyn.getLong("manuorg");
                    if (CadEmptyUtils.isEmpty((Long)material) || CadEmptyUtils.isEmpty((Long)bizId) || CadEmptyUtils.isEmpty((Long)manuorgId)) continue;
                    Long stOrgId = (Long)manuorgToStMap.get(manuorgId);
                    if (stOrgId == null) {
                        stOrgId = this.getInvOrgIdByProduce(manuorgId);
                        manuorgToStMap.put(manuorgId, stOrgId);
                    }
                    if (CadEmptyUtils.isEmpty((Long)stOrgId)) continue;
                    sbentryToTrackStSets.add(String.format("%s@%s@%s", material, bizId, stOrgId));
                    list.add(costobjectDyn);
                }
                CadBgParamListPlugin.setBillEnableTracknumber(list, sbentryToTrackStSets, updateDate);
                CadBgParamListPlugin.setBillEnableConfigcode(list, sbentryToTrackStSets, updateDate);
            }
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u4fee\u590d\u5b8c\u6210", (String)"CadBgParamListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
    }

    public Long getInvOrgIdByProduce(Long manuOrgId) {
        Long stOrgId = 0L;
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(manuOrgId.longValue());
        param.setFromViewType("04");
        param.setToViewType("05");
        param.setDirectViewType("toorg");
        param.setIncludeSelf(true);
        List invList = OrgUnitServiceHelper.getBizRelationOrgIds((OrgRelationParam)param);
        if (!CadEmptyUtils.isEmpty((List)invList)) {
            stOrgId = Sets.newHashSet((Iterable)invList).contains(manuOrgId) ? manuOrgId : (Long)invList.get(0);
        }
        return stOrgId;
    }

    private static void setBillEnableTracknumber(List<DynamicObject> bills, Set<String> sbentryToTrackStSets, Date updateDate) {
        if (sbentryToTrackStSets.isEmpty()) {
            return;
        }
        HashMap matTobizEntryIdMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap stToMaterials = Maps.newHashMapWithExpectedSize((int)10);
        for (String string : sbentryToTrackStSets) {
            String[] stringArray = string.split("@");
            if (stringArray.length < 3) continue;
            matTobizEntryIdMap.computeIfAbsent(String.format("%s@%s", stringArray[0], stringArray[2]), t -> new ArrayList()).add(Long.valueOf(stringArray[1]));
            stToMaterials.computeIfAbsent(Long.valueOf(stringArray[2]), t -> new HashSet(10)).add(Long.valueOf(stringArray[0]));
        }
        HashSet srcBillEntryKeys = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry entry : stToMaterials.entrySet()) {
            QFilter qFilter = new QFilter("manustrategy.noupdateinvdim.fbasedataid", "=", (Object)1297144009797647360L);
            qFilter.and("masterid", "in", entry.getValue());
            DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)((Long)entry.getKey()), (QFilter)qFilter, (String)"createorg,masterid material");
            for (DynamicObject dyn : stockMaterialInfos) {
                Long material = dyn.getLong("material");
                if (CadEmptyUtils.isEmpty((Long)material)) continue;
                String key = String.format("%s@%s", material, entry.getKey());
                srcBillEntryKeys.add(key);
            }
        }
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry entry : matTobizEntryIdMap.entrySet()) {
            if (!srcBillEntryKeys.contains(entry.getKey())) continue;
            hashSet.addAll((Collection)entry.getValue());
        }
        HashSet hashSet2 = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject bill : bills) {
            long srcBillEntryId = bill.getLong("probill");
            if (!hashSet.contains(srcBillEntryId)) continue;
            hashSet2.add(bill.getLong("id"));
        }
        logger.info("costobject tracknumber idSet:{}", (Object)hashSet2);
        if (hashSet2.size() > 0) {
            String string = "UPDATE t_cad_costobject SET ftracknumberid=0,fmodifytime=? WHERE FID IN (" + StringUtils.join((Object[])hashSet2.toArray(), (String)",") + ")";
            Object[] params = new Object[]{new SqlParameter(":fmodifytime", 91, (Object)updateDate)};
            logger.info(string);
            DB.execute((DBRoute)new DBRoute("cal"), (String)string, (Object[])params);
        }
    }

    private static void setBillEnableConfigcode(List<DynamicObject> bills, Set<String> sbentryToTrackStSets, Date updateDate) {
        if (sbentryToTrackStSets.isEmpty()) {
            return;
        }
        HashMap matTobizEntryIdMap = Maps.newHashMapWithExpectedSize((int)10);
        HashMap stToMaterials = Maps.newHashMapWithExpectedSize((int)10);
        for (String string : sbentryToTrackStSets) {
            String[] stringArray = string.split("@");
            if (stringArray.length < 3) continue;
            matTobizEntryIdMap.computeIfAbsent(String.format("%s@%s", stringArray[0], stringArray[2]), t -> new ArrayList()).add(Long.valueOf(stringArray[1]));
            stToMaterials.computeIfAbsent(Long.valueOf(stringArray[2]), t -> new HashSet(10)).add(Long.valueOf(stringArray[0]));
        }
        HashSet srcBillEntryKeys = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry entry : stToMaterials.entrySet()) {
            QFilter qFilter = new QFilter("manustrategy.noupdateinvdim.fbasedataid", "=", (Object)1721649779361985536L);
            qFilter.and("masterid", "in", entry.getValue());
            DynamicObjectCollection stockMaterialInfos = BaseDataServiceHelper.queryBaseData((String)"bd_materialinventoryinfo", (Long)((Long)entry.getKey()), (QFilter)qFilter, (String)"createorg,masterid material");
            for (DynamicObject dyn : stockMaterialInfos) {
                Long material = dyn.getLong("material");
                if (CadEmptyUtils.isEmpty((Long)material)) continue;
                String key = String.format("%s@%s", material, entry.getKey());
                srcBillEntryKeys.add(key);
            }
        }
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)10);
        for (Map.Entry entry : matTobizEntryIdMap.entrySet()) {
            if (!srcBillEntryKeys.contains(entry.getKey())) continue;
            hashSet.addAll((Collection)entry.getValue());
        }
        HashSet hashSet2 = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject bill : bills) {
            long srcBillEntryId = bill.getLong("probill");
            if (!hashSet.contains(srcBillEntryId)) continue;
            hashSet2.add(bill.getLong("id"));
        }
        logger.info("costobject configure idSet:{}", (Object)hashSet2);
        if (hashSet2.size() > 0) {
            String string = "UPDATE t_cad_costobject SET fconfiguredcodeid=0,fmodifytime=? WHERE FID IN (" + StringUtils.join((Object[])hashSet2.toArray(), (String)",") + ")";
            Object[] params = new Object[]{new SqlParameter(":fmodifytime", 91, (Object)updateDate)};
            logger.info(string);
            DB.execute((DBRoute)new DBRoute("cal"), (String)string, (Object[])params);
        }
    }
}

