/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.calc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.helper.AppIdHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.helper.StdCalculateHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class CadStdCalcRecordListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(CadStdCalcRecordListPlugin.class);

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String pageCacheCosttype = null;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("costtype.")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            List<ComboItem> costTypes = this.getCostTypeComboItemList();
            if (costTypes != null && !costTypes.isEmpty()) {
                commonFilterColumn.setComboItems(costTypes);
                ComboItem item = costTypes.get(0);
                commonFilterColumn.setDefaultValue(item.getValue());
                pageCacheCosttype = item.getValue();
                break;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u53ef\u4f7f\u7528\u7684\u6210\u672c\u7c7b\u578b\u3002", (String)"CadStdCalcRecordListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            break;
        }
        if (pageCacheCosttype != null) {
            this.getPageCache().put("costtype", pageCacheCosttype);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        super.filterContainerBeforeF7Select(e);
        String fieldName = e.getFieldName();
        if (fieldName.startsWith("costtype")) {
            List qFilters = e.getQfilters();
            String appNum = AppIdHelper.getCurAppNum((IFormView)this.getView());
            qFilters.add(new QFilter("type", "=", (Object)"1"));
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                qFilters.add(baseDataFilter);
            }
        }
    }

    protected List<ComboItem> getCostTypeComboItemList() {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        String appNum = this.getView().getFormShowParameter().getAppId();
        DynamicObject[] costTypes = ElementRelationHelper.getCostTypesBy((String)"1");
        if (costTypes != null && costTypes.length > 0) {
            List<DynamicObject> costTypeList = Arrays.asList(costTypes);
            CostTypeHelper.sortByType(costTypeList);
            for (DynamicObject costType : costTypeList) {
                if ("sca".equals(appNum) && CommonConstant.ACA_COST_TYPE_ID.equals(costType.getLong("id"))) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(costType.getString("name")));
                item.setValue(costType.getString("id"));
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
        }
        return acctItems;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (CadEmptyUtils.isEmpty((ListSelectedRowCollection)rows)) {
            return;
        }
        String itemKey = evt.getItemKey();
        if ("tbldel".equals(itemKey)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("confirmClose", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u5220\u9664\u8be5\u7269\u6599\u7ef4\u5ea6\u4e0b\u7684\u6863\u6848\uff0c\u4f1a\u540c\u6b65\u5220\u9664\u5176\u5173\u8054BOM\u6811\u4e0b\u6240\u6709\u7269\u6599\u7ef4\u5ea6\u6863\u6848\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CadStdCalcRecordListPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        BillList selectBillList = (BillList)this.getControl("billlistap");
        String callBackId = e.getCallBackId();
        if ("confirmClose".equals(callBackId) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            Object[] primaryKeyValues = rows.getPrimaryKeyValues();
            int count = StdCalculateHelper.deleteResultRecordDatas((Object[])primaryKeyValues);
            if (count > 0) {
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664\u5377\u7b97\u6863\u6848%s\u6761\u3002", (String)"CadStdCalcRecordListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]), count));
            } else if (count == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u5220\u9664\u7684\u6570\u636e\u3002", (String)"CadStdCalcRecordListPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\u3002", (String)"CadStdCalcRecordListPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }
}

