/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.calc;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.macc.cad.business.calc.AutoStandCostCalcHandler;
import kd.macc.cad.business.calc.CalcChangedInfo;

public class CalcChangeRecordListPlugin
extends AbstractListPlugin {
    Log logger = LogFactory.getLog(CalcChangeRecordListPlugin.class);

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        if (StringUtils.equals((CharSequence)"excute", (CharSequence)itemKey)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            QFilter filter = new QFilter("id", "in", (Object)list.getSelectedRows().getPrimaryKeyValues());
            DynamicObjectCollection col = QueryServiceHelper.query((String)"cad_calchangerecord", (String)"status,billno", (QFilter[])new QFilter[]{filter});
            HashSet billNoList = new HashSet();
            col.forEach(s -> {
                if (StringUtils.equals((CharSequence)"C", (CharSequence)s.getString("status"))) {
                    billNoList.add(s.getString("billno"));
                }
            });
            if (billNoList.size() > 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u8bb0\u5f55\u5df2\u7ecf\u5904\u7406\uff0c\u4e0d\u80fd\u91cd\u65b0\u6267\u884c\u5377\u7b97\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CalcChangeRecordListPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), ((Object)billNoList).toString()));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)"excute", (CharSequence)opKey)) {
            BillList list = (BillList)this.getView().getControl("billlistap");
            QFilter filter = new QFilter("id", "in", (Object)list.getSelectedRows().getPrimaryKeyValues());
            filter.and("keycol", "!=", (Object)" ");
            filter.and("keycolid", ">", (Object)0L);
            Map costTypeCalcChangeMap = AutoStandCostCalcHandler.getCostTypeCalcChangeMap((QFilter)filter);
            HashSet successChangeRecordIds = new HashSet(16);
            HashSet failedChangeRecordIds = new HashSet(16);
            StringBuilder errStr = new StringBuilder();
            for (Map.Entry entry : costTypeCalcChangeMap.entrySet()) {
                CalcChangedInfo info = (CalcChangedInfo)entry.getValue();
                try {
                    AutoStandCostCalcHandler.doCalc((CalcChangedInfo)info);
                    successChangeRecordIds.addAll(info.getChangeRecordId());
                }
                catch (Exception ex) {
                    this.logger.error(String.format("\u6210\u672c\u7c7b\u578b[%s]\u4e0b\u5bf9\u5e94\u7684\u5377\u7b97\u53d8\u66f4\u8bb0\u5f55: %s \u5904\u7406\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0\uff1a%s ", info.getCostTypeName(), info.getChangeRecordId().toString(), ex));
                    errStr.append(String.format(ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b\u201c%1$s\u201d\u4e0b\u5bf9\u5e94\u7684\u5377\u7b97\u53d8\u66f4\u8bb0\u5f55\u201c%2$s\u201d\u5904\u7406\u5f02\u5e38\uff1a%3$s\u3002", (String)"CalcChangeRecordListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]), info.getCostTypeName(), info.getChangeRecordId().toString(), ex)).append("\n");
                    failedChangeRecordIds.addAll(info.getChangeRecordId());
                }
            }
            AutoStandCostCalcHandler.updateStatus(successChangeRecordIds, (String)"C");
            AutoStandCostCalcHandler.updateStatus(failedChangeRecordIds, (String)"D");
            if (errStr.length() > 0) {
                throw new KDBizException(errStr.toString());
            }
        }
    }
}

