/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.calc;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.log.api.ILogService;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.macc.cad.algox.calc.helper.TaskServiceHelper;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.cad.common.dto.UpdateParam;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.WriteLogUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class CheckTaskSettingEditPlugin
extends AbstractBillPlugIn {
    private ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "advcontoolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] tasksArray;
        super.afterCreateNewData(e);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        String calType = (String)this.getView().getFormShowParameter().getCustomParam("calType");
        String paraJS = this.getView().getFormShowParameter().getCustomParam("calcParam").toString();
        StandCostCalcParam standCostCalcParam = (StandCostCalcParam)SerializationUtils.fromJsonString((String)paraJS, StandCostCalcParam.class);
        QFilter filter = new QFilter("appnum", "=", (Object)this.getView().getFormShowParameter().getAppId());
        if (standCostCalcParam.isOnlyConfigCalc().booleanValue()) {
            filter.and(new QFilter("caltype", "in", (Object)new String[]{calType + "_sale"}));
        } else if (standCostCalcParam.isOnlyNoneConfigCalc().booleanValue()) {
            filter.and(new QFilter("caltype", "=", (Object)calType));
        } else {
            filter.and(new QFilter("caltype", "in", (Object)new String[]{calType, calType + "_sale"}));
        }
        for (DynamicObject task : tasksArray = BusinessDataServiceHelper.load((String)"cad_checktask", (String)"entryentity.seq,entryentity.checkitem,entryentity.isenable,entryentity.level", (QFilter[])new QFilter[]{filter}, (String)"entryentity.seq asc")) {
            DynamicObjectCollection taskEntryEntity = task.getDynamicObjectCollection("entryentity");
            if (CadEmptyUtils.isEmpty((DynamicObjectCollection)taskEntryEntity)) continue;
            for (DynamicObject taskEntry : taskEntryEntity) {
                if (!taskEntry.getBoolean("isenable")) continue;
                DynamicObject row = entryEntity.addNew();
                row.set("checkitem", taskEntry.get("checkitem"));
                row.set("ischeck", (Object)Boolean.TRUE);
                row.set("level", (Object)taskEntry.getString("level"));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "selectall": {
                this.setAllCheck(Boolean.TRUE);
                break;
            }
            case "cancelselectall": {
                this.setAllCheck(Boolean.FALSE);
                break;
            }
            case "btnstart": {
                this.doCheck();
                break;
            }
        }
    }

    private void doCheck() {
        String calType = (String)this.getView().getFormShowParameter().getCustomParam("calType");
        String paraJS = this.getView().getFormShowParameter().getCustomParam("calcParam").toString();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)entryEntity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u9700\u8981\u68c0\u67e5\u7684\u5408\u6cd5\u6027\u68c0\u67e5\u9879\u3002", (String)"CheckTaskSettingEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet checkItemIds = new HashSet(16);
        entryEntity.forEach(entry -> {
            if (entry.getBoolean("ischeck")) {
                checkItemIds.add(entry.getLong("checkitem.id"));
            }
        });
        if (CadEmptyUtils.isEmpty(checkItemIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u9700\u8981\u68c0\u67e5\u7684\u5408\u6cd5\u6027\u68c0\u67e5\u9879\u3002", (String)"CheckTaskSettingEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return;
        }
        String opType = ResManager.loadKDString((String)"\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CheckTaskSettingEditPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        String checkType = null;
        Object params = this.buildCalcParam(paraJS, calType);
        if (params == null) {
            return;
        }
        FormShowParameter lsp = new FormShowParameter();
        if ("cad_stdcalcnew".equals(calType)) {
            StandCostCalcParam standCostCalcParam = (StandCostCalcParam)params;
            standCostCalcParam.setCheckItemIdSet(checkItemIds);
            lsp.setFormId("cad_taskprogresss");
            lsp.setCustomParam("calcParam", (Object)standCostCalcParam);
            lsp.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm(lsp);
            checkType = ResManager.loadKDString((String)"\u5377\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CheckTaskSettingEditPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]);
        } else if ("cad_costupdatenew".equals(calType)) {
            UpdateParam updateParam = (UpdateParam)params;
            updateParam.setCheckItemIds(checkItemIds);
            checkType = ResManager.loadKDString((String)"\u66f4\u65b0\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"CheckTaskSettingEditPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            Long taskId = TaskServiceHelper.createTask((Long)updateParam.getSrcCostTypeId(), (String)checkType);
            updateParam.setTaskId(taskId);
            lsp.setFormId("cad_costupdateprogress");
            lsp.setCustomParam("params", (Object)updateParam);
            lsp.getOpenStyle().setShowType(ShowType.Floating);
            lsp.setShowTitle(false);
            this.getView().showForm(lsp);
        } else if ("sca_finishcalwizards".equals(calType)) {
            JSONObject jsonObject = (JSONObject)params;
            jsonObject.accumulate("checkItemList", checkItemIds);
            Long checkReport = CalcCheckHelper.initFinWipCalcCheckReport((JSONObject)jsonObject, (String)"2", (Date)new Date());
            checkType = ResManager.loadKDString((String)"\u5b8c\u5de5\u4ea7\u54c1\u7ed3\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CheckTaskSettingEditPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            Long taskRecordId = CalcCheckHelper.initTaskRecord((String)checkType, new ArrayList(checkItemIds), (String)calType, (String)this.getView().getFormShowParameter().getAppId());
            lsp.setFormId("sca_taskrunning");
            lsp.setCustomParam("calcParam", (Object)jsonObject.toString());
            lsp.setCustomParam("taskConfigId", (Object)taskRecordId);
            lsp.setCustomParam("taskRecordId", (Object)taskRecordId);
            lsp.setCustomParam("checkReportId", (Object)checkReport);
            lsp.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm(lsp);
        } else if ("sca_wipcalwizards".equals(calType)) {
            JSONObject jsonObject = (JSONObject)params;
            jsonObject.accumulate("checkItemList", checkItemIds);
            Long checkReport = CalcCheckHelper.initFinWipCalcCheckReport((JSONObject)jsonObject, (String)"1", (Date)new Date());
            checkType = ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CheckTaskSettingEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            Long taskRecordId = CalcCheckHelper.initTaskRecord((String)checkType, new ArrayList(checkItemIds), (String)calType, (String)this.getView().getFormShowParameter().getAppId());
            lsp.setFormId("sca_taskrunning");
            lsp.setCustomParam("calcParam", (Object)jsonObject.toString());
            lsp.setCustomParam("taskConfigId", (Object)taskRecordId);
            lsp.setCustomParam("taskRecordId", (Object)taskRecordId);
            lsp.setCustomParam("checkReportId", (Object)checkReport);
            lsp.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm(lsp);
        } else if ("sca_differencecalcwizards".equals(calType)) {
            JSONObject jsonObject = (JSONObject)params;
            jsonObject.accumulate("checkItemList", checkItemIds);
            checkType = ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CheckTaskSettingEditPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            Long checkReport = CalcCheckHelper.initDiffCalcCheckReport((JSONObject)jsonObject, (String)checkType, (Date)new Date());
            Long taskRecordId = CalcCheckHelper.initTaskRecord((String)checkType, new ArrayList(checkItemIds), (String)calType, (String)this.getView().getFormShowParameter().getAppId());
            lsp.setFormId("sca_difftaskrunning");
            lsp.setCustomParam("calcParam", (Object)jsonObject.toString());
            lsp.setCustomParam("taskConfigId", (Object)taskRecordId);
            lsp.setCustomParam("taskRecordId", (Object)taskRecordId);
            lsp.setCustomParam("checkReportId", (Object)checkReport);
            lsp.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm(lsp);
        } else if ("sca_factcostreduction".equals(calType)) {
            JSONObject jsonObject = (JSONObject)params;
            jsonObject.accumulate("checkItemList", checkItemIds);
            checkType = ResManager.loadKDString((String)"\u5b9e\u9645\u6210\u672c\u8fd8\u539f\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CheckTaskSettingEditPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            Long checkReport = CalcCheckHelper.initReductCalcCheckReport((JSONObject)jsonObject, (Date)new Date());
            Long taskRecordId = CalcCheckHelper.initTaskRecord((String)checkType, new ArrayList(checkItemIds), (String)calType, (String)this.getView().getFormShowParameter().getAppId());
            lsp.setFormId("sca_costredtaskrunning");
            lsp.setCustomParam("calcParam", (Object)jsonObject.toString());
            lsp.setCustomParam("taskConfigId", (Object)taskRecordId);
            lsp.setCustomParam("taskRecordId", (Object)taskRecordId);
            lsp.setCustomParam("checkReportId", (Object)checkReport);
            lsp.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm(lsp);
        } else if ("aca_terminalcalwizards".equals(calType)) {
            JSONObject jsonObject = (JSONObject)params;
            jsonObject.accumulate("checkItemList", checkItemIds);
            checkType = ResManager.loadKDString((String)"\u671f\u672b\u6210\u672c\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"CheckTaskSettingEditPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]);
            Long taskRecordId = CalcCheckHelper.initTaskRecord((String)checkType, new ArrayList(checkItemIds), (String)calType, (String)this.getView().getFormShowParameter().getAppId());
            lsp.setFormId("aca_taskrunning");
            lsp.setCustomParam("calcParam", (Object)jsonObject.toString());
            lsp.setCustomParam("taskConfigId", (Object)taskRecordId);
            lsp.setCustomParam("taskRecordId", (Object)taskRecordId);
            lsp.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm(lsp);
        }
        WriteLogUtils.writeLog((ILogService)this.logService, (RequestContext)RequestContext.get(), (String)opType, (String)checkType, (String)"cad_checktasksetting", (IDataModel)this.getModel());
    }

    private Object buildCalcParam(String cparaJS, String calType) {
        JSONObject jsonObject = JSONObject.fromObject((Object)cparaJS);
        switch (calType) {
            case "cad_stdcalcnew": {
                StandCostCalcParam standCostCalcParam = (StandCostCalcParam)SerializationUtils.fromJsonString((String)cparaJS, StandCostCalcParam.class);
                if (jsonObject.containsKey((Object)"matids")) {
                    standCostCalcParam.setMatids(this.getMaterialGroupIds(jsonObject.getJSONArray("matids")));
                }
                return standCostCalcParam;
            }
            case "sca_finishcalwizards": {
                jsonObject.accumulate("checkConfigId", (Object)this.getPageCache().get("checkConfigId"));
                jsonObject.accumulate("checkMode", 1);
                jsonObject.accumulate("calType", (Object)calType);
                return jsonObject;
            }
            case "sca_wipcalwizards": {
                jsonObject.accumulate("checkConfigId", (Object)this.getPageCache().get("checkConfigId"));
                jsonObject.accumulate("checkMode", 1);
                jsonObject.accumulate("calType", (Object)calType);
                return jsonObject;
            }
            case "sca_differencecalcwizards": {
                jsonObject.accumulate("checkConfigId", (Object)this.getPageCache().get("checkConfigId"));
                jsonObject.accumulate("checkMode", 1);
                return jsonObject;
            }
            case "sca_factcostreduction": {
                jsonObject.accumulate("checkMode", 1);
                return jsonObject;
            }
            case "aca_terminalcalwizards": {
                jsonObject.accumulate("checkMode", 1);
                return jsonObject;
            }
            case "cad_costupdatenew": {
                UpdateParam updateParam = (UpdateParam)SerializationUtils.fromJsonString((String)cparaJS, UpdateParam.class);
                updateParam.setOpMode("1");
                return updateParam;
            }
        }
        return null;
    }

    private List<Long> getMaterialGroupIds(JSONArray idArray) {
        ArrayList<Long> ids = new ArrayList<Long>(10);
        if (idArray == null || idArray.size() < 1) {
            return ids;
        }
        for (int index = 0; index < idArray.size(); ++index) {
            ids.add(idArray.getLong(index));
        }
        return ids;
    }

    private void setAllCheck(Boolean isSetAllCheck) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject object = (DynamicObject)entryEntity.get(i);
            object.set("ischeck", (Object)isSetAllCheck);
        }
        this.getView().updateView("entryentity");
    }
}

