/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.calc;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.macc.cad.algox.calc.helper.BomRuleSettingStdCalcHelper;
import kd.macc.cad.algox.calc.helper.CalcMutexHelper;
import kd.macc.cad.algox.calc.helper.StdCalculateHelper;
import kd.macc.cad.algox.input.StandCostCalcParam;
import kd.macc.cad.common.constants.CommonConstant;
import kd.macc.cad.common.constants.PriceRuleConstants;
import kd.macc.cad.common.enums.CostTypePtyEnum;
import kd.macc.cad.common.helper.ConfigTrackHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ImportServiceHelper;
import kd.macc.cad.common.utils.CadBgParamUtils;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class StandCostCalPlugin
extends AbstractFormPlugin
implements ClickListener {
    protected static final Log logger = LogFactory.getLog(StandCostCalPlugin.class);
    private static final String LABELAP = "labelap";
    private static final Long DEFAULT_BOMRULESETTINGID = 0L;
    private static final Long DEFAULT_ROUTERULESETTINGID = 0L;
    private Map<String, String> matPropertyMap = Maps.newHashMap();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"matgrouptbar", "mattbar", "toolbarap"});
        this.addClickListeners(new String[]{LABELAP});
        Boolean configMat = (Boolean)this.getModel().getValue("configmat");
        BasedataEdit mat = (BasedataEdit)this.getControl("matnumber");
        mat.addBeforeF7SelectListener(evt -> {
            Set materialBySalOrder;
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            param.setCustomParam("isShowAllNoOrg", (Object)"true");
            ListFilterParameter filterParameter = param.getListFilterParameter();
            DynamicObject costtype = (DynamicObject)this.getModel().getValue("costtype");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u7c7b\u578b\u3002", (String)"StandCostCalPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            int index = this.getModel().getEntryCurrentRowIndex("matentry");
            DynamicObject configuredcode = (DynamicObject)this.getModel().getValue("configuredcode", index);
            DynamicObject tracknumber = (DynamicObject)this.getModel().getValue("tracknumber", index);
            if (!(configuredcode == null && tracknumber == null || CadEmptyUtils.isEmpty((Set)(materialBySalOrder = ConfigTrackHelper.getMaterialBySalOrder((Long)(configuredcode == null ? 0L : configuredcode.getLong("id")), (Long)(tracknumber == null ? 0L : tracknumber.getLong("id"))))))) {
                filterParameter.getQFilters().add(new QFilter("id", "in", (Object)materialBySalOrder));
            }
            if ("sca".equals(this.getView().getFormShowParameter().getAppId())) {
                if (configMat.booleanValue()) {
                    filterParameter.getQFilters().add(new QFilter("configproperties", "=", (Object)"2"));
                } else {
                    filterParameter.getQFilters().add(new QFilter("configproperties", "!=", (Object)"2"));
                }
            }
        });
        BasedataEdit configuredCode = (BasedataEdit)this.getControl("configuredcode");
        configuredCode.addBeforeF7SelectListener(evt -> {
            DynamicObject costtype = (DynamicObject)this.getModel().getValue("costtype");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u7c7b\u578b\u3002", (String)"StandCostCalPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            int index = this.getModel().getEntryCurrentRowIndex("matentry");
            DynamicObject matObj = (DynamicObject)this.getModel().getValue("matnumber", index);
            if (matObj != null) {
                ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
                ListFilterParameter filterParameter = parameter.getListFilterParameter();
                List qList = filterParameter.getQFilters();
                List configCodeIds = ConfigTrackHelper.getConfigCodeIdsByMaterial(Collections.singleton(matObj.getLong("id")));
                if (!CadEmptyUtils.isEmpty((List)configCodeIds)) {
                    qList.add(new QFilter("id", "in", (Object)configCodeIds));
                }
            }
        });
        BasedataEdit matgroupStd = (BasedataEdit)this.getControl("matgroupstd");
        matgroupStd.addBeforeF7SelectListener(evt -> {
            DynamicObject costtype = (DynamicObject)this.getModel().getValue("costtype");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u7c7b\u578b\u3002", (String)"StandCostCalPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(costtype.getLong("createorg.id"));
            Set ids = (Set)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupStandardByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, Boolean.TRUE});
            QFilter idFilter = new QFilter("id", "in", (Object)ids);
            ListFilterParameter listFilterParameter = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(idFilter);
        });
        BasedataEdit matgroup = (BasedataEdit)this.getControl("matgroup");
        matgroup.addBeforeF7SelectListener(evt -> {
            DynamicObject costtype = (DynamicObject)this.getModel().getValue("costtype");
            if (costtype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u7c7b\u578b\u3002", (String)"StandCostCalPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject matgroupstd = (DynamicObject)this.getModel().getValue("matgroupstd");
            if (matgroupstd == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"StandCostCalPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ArrayList<Long> createOrgIds = new ArrayList<Long>(1);
            createOrgIds.add(costtype.getLong("createorg.id"));
            QFilter serviceResponse = (QFilter)DispatchServiceHelper.invokeBizService((String)"bd", (String)"bd", (String)"IMasterDataStandardService", (String)"getGroupByOrgs", (Object[])new Object[]{"bd_material", createOrgIds, matgroupstd.getPkValue(), true});
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(serviceResponse);
            ArrayList<Long> selectedMatGroups = new ArrayList<Long>();
            DynamicObjectCollection matinfos = this.getModel().getEntryEntity("matentry");
            for (int index = 0; index < matinfos.size(); ++index) {
                DynamicObject rowobject = (DynamicObject)matinfos.get(index);
                DynamicObject matitem = (DynamicObject)rowobject.get("matgroup");
                if (matitem == null) continue;
                selectedMatGroups.add(matitem.getLong("id"));
            }
            qFilters.add(new QFilter("id", "not in", selectedMatGroups));
            HashMap<String, ArrayList<Long>> params = new HashMap<String, ArrayList<Long>>(2);
            params.put("useOrgs", createOrgIds);
            listShowParameter.setCustomParams(params);
            listShowParameter.setCustomParam("groupStandard", matgroupstd.getPkValue());
            listShowParameter.setF7ClickByFilter(false);
        });
        BasedataEdit costTypeEdit = (BasedataEdit)this.getControl("costtype");
        costTypeEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            List filters = filterParameter.getQFilters();
            QFilter actualCostIdFilter = new QFilter("id", "!=", (Object)CommonConstant.ACA_COST_TYPE_ID);
            filters.add(actualCostIdFilter);
            QFilter typeFilter = new QFilter("type", "=", (Object)CostTypePtyEnum.SIMULATED.getValue());
            filters.add(typeFilter);
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                filters.add(baseDataFilter);
            }
        });
        BasedataEdit rulePlanEdit = (BasedataEdit)this.getControl("ruleplan");
        rulePlanEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<Long> ids = new ArrayList<Long>(10);
            ids.add(PriceRuleConstants.DELRULEPLAN_ID);
            long costTypeId = this.getModel().getDataEntity().getLong("costtype.id");
            if (!CadEmptyUtils.isEmpty((Long)costTypeId)) {
                QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
                filter.and("enable", "=", (Object)true);
                DynamicObjectCollection objects = QueryServiceHelper.query((String)"cad_calcruleplan", (String)"id", (QFilter[])new QFilter[]{filter});
                for (DynamicObject object : objects) {
                    ids.add(object.getLong("id"));
                }
            }
            filterParameter.getQFilters().add(new QFilter("id", "in", ids));
        });
        BasedataEdit bomRule = (BasedataEdit)this.getControl("bomrule");
        bomRule.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<Long> ids = new ArrayList<Long>(10);
            long costTypeId = this.getModel().getDataEntity().getLong("costtype.id");
            if (!CadEmptyUtils.isEmpty((Long)costTypeId)) {
                QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
                filter.or(new QFilter("costtype", "=", (Object)0L));
                QFilter statusFilter = new QFilter("enable", "=", (Object)true);
                DynamicObjectCollection objects = QueryServiceHelper.query((String)"cad_bomrulesetting", (String)"id", (QFilter[])new QFilter[]{filter, statusFilter});
                for (DynamicObject object : objects) {
                    ids.add(object.getLong("id"));
                }
            }
            filterParameter.getQFilters().add(new QFilter("id", "in", ids));
        });
        BasedataEdit routeRule = (BasedataEdit)this.getControl("routerule");
        routeRule.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter filterParameter = param.getListFilterParameter();
            ArrayList<Long> ids = new ArrayList<Long>(10);
            long costTypeId = this.getModel().getDataEntity().getLong("costtype.id");
            if (!CadEmptyUtils.isEmpty((Long)costTypeId)) {
                QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
                filter.or(new QFilter("costtype", "=", (Object)0L));
                QFilter statusFilter = new QFilter("enable", "=", (Object)true);
                DynamicObjectCollection objects = QueryServiceHelper.query((String)"cad_routerulesetting", (String)"id", (QFilter[])new QFilter[]{filter, statusFilter});
                for (DynamicObject object : objects) {
                    ids.add(object.getLong("id"));
                }
            }
            filterParameter.getQFilters().add(new QFilter("id", "in", ids));
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setRecordNameEnable();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"configmat", "configuredcode", "tracknumber"});
        } else {
            Boolean configMat = (Boolean)this.getModel().getValue("configmat");
            if (configMat != null && configMat.booleanValue()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"configuredcode", "tracknumber"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"configuredcode", "tracknumber"});
            }
        }
        String updateMatInfo = CadBgParamUtils.getCadBgParamForString((String)"updateMatInfo", (String)"1");
        this.getPageCache().put("updateMatInfo", updateMatInfo);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (LABELAP.equals(source.getKey())) {
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("cad_stdcalcmatfilter");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "matfilter"));
            fsp.setCustomParam("user", (Object)RequestContext.get().getUserId());
            this.getView().showForm(fsp);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "dochecking": {
                this.doCheck();
                break;
            }
            case "calculate": {
                this.doCalc();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        boolean isStartBomRouteRule = this.isStartBomRule();
        switch (key) {
            case "matnumber": {
                this.clearMatInfo(rowIndex);
                this.updateMatInfo(rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"matgroup"});
                break;
            }
            case "matgroup": {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"matnumber", "auxprop", "configuredcode", "tracknumber", "lot", "project"});
                DynamicObject matgroup = (DynamicObject)newValue;
                if (matgroup != null) break;
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"matnumber", "auxprop", "configuredcode", "tracknumber", "lot", "project"});
                break;
            }
            case "configuredcode": {
                this.setMaterialByConfigCode(rowIndex);
                if (isStartBomRouteRule) break;
                this.updateMatInfo(rowIndex);
                break;
            }
            case "tracknumber": {
                if (isStartBomRouteRule) break;
                this.updateMatInfo(rowIndex);
                break;
            }
            case "auxprop": 
            case "lot": 
            case "project": {
                if (isStartBomRouteRule) break;
                this.updateMatInfo(rowIndex);
                break;
            }
            case "costtype": {
                this.updateRulePlan();
                this.updateBomRouteRule();
                this.setProduceOrgs();
                break;
            }
            case "iscalccurlevel": {
                break;
            }
            case "issaverecord": {
                this.setRecordNameEnable();
                break;
            }
            case "configmat": {
                Boolean configMat = (Boolean)this.getModel().getValue("configmat");
                if (configMat != null && configMat.booleanValue()) {
                    this.getModel().setValue("iscalccurlevel", (Object)Boolean.TRUE);
                    this.getView().setEnable(Boolean.FALSE, new String[]{"iscalccurlevel"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"configuredcode", "tracknumber"});
                } else {
                    this.getModel().setValue("iscalccurlevel", (Object)Boolean.FALSE);
                    this.getView().setEnable(Boolean.TRUE, new String[]{"iscalccurlevel"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"configuredcode", "tracknumber"});
                }
                this.getModel().deleteEntryData("matentry");
                this.getView().invokeOperation("newentry", OperateOption.create());
            }
        }
    }

    private void setProduceOrgs() {
        long costTypeId = this.getModel().getDataEntity().getLong("costtype.id");
        Date calcdate = (Date)this.getModel().getValue("calcdate");
        boolean isStartBomRouteRule = this.isStartBomRule();
        if (isStartBomRouteRule || this.isTrackNumCal()) {
            ArrayList productOrgs = new ArrayList(10);
            if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
                DynamicObject costType = CostTypeHelper.getCostType((Long)costTypeId, (String)"createorg");
                productOrgs.addAll(ImportServiceHelper.getUserHasPermOrgs((Long)(costType == null ? 0L : costType.getLong("createorg.id")), (String)"04"));
            } else {
                productOrgs.addAll(StdCalculateHelper.getProductOrgsByImitateCostType((Long)costTypeId, (Date)calcdate));
            }
            this.getPageCache().put("productOrgs", SerializationUtils.toJsonString(productOrgs));
        }
    }

    private void updateRulePlan() {
        long costTypeId = this.getModel().getDataEntity().getLong("costtype.id");
        if (CadEmptyUtils.isEmpty((Long)costTypeId)) {
            this.getModel().setValue("ruleplan", (Object)PriceRuleConstants.DELRULEPLAN_ID);
        } else {
            QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
            filter.and("enable", "=", (Object)true);
            filter.and("default", "=", (Object)true);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"cad_calcruleplan", (String)"id", (QFilter[])new QFilter[]{filter});
            if (dynamicObject == null) {
                this.getModel().setValue("ruleplan", (Object)PriceRuleConstants.DELRULEPLAN_ID);
            } else {
                this.getModel().setValue("ruleplan", (Object)dynamicObject.getLong("id"));
            }
        }
    }

    private void updateBomRouteRule() {
        long costTypeId = this.getModel().getDataEntity().getLong("costtype.id");
        if (CadEmptyUtils.isEmpty((Long)costTypeId)) {
            this.getModel().setValue("bomrule", (Object)DEFAULT_BOMRULESETTINGID);
            this.getModel().setValue("routerule", (Object)DEFAULT_ROUTERULESETTINGID);
        } else {
            QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
            QFilter enableFilter = new QFilter("enable", "=", (Object)true);
            QFilter defaultFilter = new QFilter("default", "=", (Object)true);
            DynamicObject bomRule = QueryServiceHelper.queryOne((String)"cad_bomrulesetting", (String)"id", (QFilter[])new QFilter[]{filter, enableFilter, defaultFilter});
            if (bomRule == null) {
                filter = new QFilter("costtype", "=", (Object)0L);
                bomRule = QueryServiceHelper.queryOne((String)"cad_bomrulesetting", (String)"id", (QFilter[])new QFilter[]{filter, enableFilter, defaultFilter});
            }
            if (bomRule == null) {
                this.getModel().setValue("bomrule", null);
            } else {
                this.getModel().setValue("bomrule", (Object)bomRule.getLong("id"));
            }
            DynamicObject routeRule = QueryServiceHelper.queryOne((String)"cad_routerulesetting", (String)"id", (QFilter[])new QFilter[]{filter, enableFilter, defaultFilter});
            if (routeRule == null) {
                filter = new QFilter("costtype", "=", (Object)0L);
                routeRule = QueryServiceHelper.queryOne((String)"cad_routerulesetting", (String)"id", (QFilter[])new QFilter[]{filter, enableFilter, defaultFilter});
            }
            if (routeRule == null) {
                this.getModel().setValue("routerule", null);
            } else {
                this.getModel().setValue("routerule", (Object)routeRule.getLong("id"));
            }
        }
    }

    private void clearMatInfo(int rowIndex) {
        this.getModel().setValue("matvers", null, rowIndex);
        this.getModel().setValue("auxprop", null, rowIndex);
        this.getModel().setValue("matcalcprop", null, rowIndex);
        this.getModel().setValue("configuredcode", null, rowIndex);
        this.getModel().setValue("tracknumber", null, rowIndex);
        this.getModel().setValue("lot", null, rowIndex);
        this.getModel().setValue("project", null, rowIndex);
    }

    private void setMaterialByConfigCode(int rowIndex) {
        DynamicObject configuRedcode = (DynamicObject)this.getModel().getValue("configuredcode", rowIndex);
        if (configuRedcode == null) {
            return;
        }
        DynamicObject mat = (DynamicObject)this.getModel().getValue("matnumber", rowIndex);
        if (mat != null) {
            return;
        }
        Long material = configuRedcode.getLong("material.id");
        this.getModel().setValue("matnumber", (Object)material, rowIndex);
        this.getModel().setValue("configuredcode", (Object)configuRedcode.getLong("id"), rowIndex);
    }

    private void updateMatInfo(int rowIndex) {
        String updateMatInfo = this.getPageCache().get("updateMatInfo");
        if (!"1".equals(updateMatInfo)) {
            return;
        }
        DynamicObject mat = (DynamicObject)this.getModel().getValue("matnumber", rowIndex);
        DynamicObject auxprop = (DynamicObject)this.getModel().getValue("auxprop", rowIndex);
        DynamicObject configuRedcode = (DynamicObject)this.getModel().getValue("configuredcode", rowIndex);
        DynamicObject trackNumber = (DynamicObject)this.getModel().getValue("tracknumber", rowIndex);
        DynamicObject project = (DynamicObject)this.getModel().getValue("project", rowIndex);
        String lot = (String)this.getModel().getValue("lot", rowIndex);
        if (mat == null) {
            return;
        }
        long costTypeId = this.getModel().getDataEntity().getLong("costtype.id");
        boolean isStartBomRouteRule = this.isStartBomRule();
        if (isStartBomRouteRule) {
            String attr = "";
            if (this.matPropertyMap.containsKey(mat.getString("masterid"))) {
                attr = this.matPropertyMap.get(mat.getString("masterid"));
            } else {
                String productOrgs = this.getPageCache().get("productOrgs");
                if (CadEmptyUtils.isEmpty((String)productOrgs)) {
                    return;
                }
                attr = this.getMatProduceInfo((List)SerializationUtils.fromJsonString((String)productOrgs, List.class), mat.getLong("masterid"));
                this.matPropertyMap.put(mat.getString("masterid"), attr);
            }
            this.getModel().setValue("matcalcprop", (Object)attr, rowIndex);
            return;
        }
        String key = mat.getLong("masterid") + "@" + (auxprop == null ? "0" : Long.valueOf(auxprop.getLong("id"))) + "@" + (configuRedcode == null ? "0" : Long.valueOf(configuRedcode.getLong("id"))) + "@" + (trackNumber == null ? "0" : Long.valueOf(trackNumber.getLong("id")));
        String attr = "";
        if (this.matPropertyMap.containsKey(mat.getString("masterid"))) {
            attr = this.matPropertyMap.get(key);
        } else {
            QFilter filter = new QFilter("costtype", "=", (Object)costTypeId);
            filter.and(new QFilter("material", "=", (Object)mat.getLong("masterid")));
            filter.and(new QFilter("auxprop", "=", (Object)(auxprop == null ? 0L : auxprop.getLong("id"))));
            filter.and(new QFilter("configuredcode", "=", (Object)(configuRedcode == null ? 0L : configuRedcode.getLong("id"))));
            filter.and(new QFilter("tracknumber", "=", (Object)(trackNumber == null ? 0L : trackNumber.getLong("id"))));
            filter.and(new QFilter("project", "=", (Object)(project == null ? 0L : project.getLong("id"))));
            filter.and(new QFilter("lot", "=", (Object)lot));
            filter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
            filter.and(new QFilter("status", "=", (Object)"C"));
            DynamicObject matCalcProp = QueryServiceHelper.queryOne((String)"cad_bomsetting", (String)"matcalcprop", (QFilter[])new QFilter[]{filter});
            attr = matCalcProp == null ? "B" : matCalcProp.getString("matcalcprop");
            this.matPropertyMap.put(mat.getString("masterid"), attr);
        }
        this.getModel().setValue("matcalcprop", (Object)attr, rowIndex);
        this.getView().updateView("matcalcprop", rowIndex);
    }

    private String getMatProduceInfo(List<Long> productOrgs, Long id) {
        HashSet<Long> productOrgSet = new HashSet<Long>(10);
        for (Long productOrg : productOrgs) {
            productOrgSet.add(Long.valueOf(((Object)productOrg).toString()));
        }
        DataSet matProduceInfo = BomRuleSettingStdCalcHelper.getMatProduceInfo(productOrgSet, Collections.singleton(id));
        if (matProduceInfo == null) {
            return "B";
        }
        while (matProduceInfo.hasNext()) {
            Row row = matProduceInfo.next();
            String materialAttr = row.getString("materialattr");
            if ("10030".equals(materialAttr)) {
                return "A";
            }
            if ("10040".equals(materialAttr)) {
                return "B";
            }
            if ("10050".equals(materialAttr)) {
                return "C";
            }
            if (!"10020".equals(materialAttr)) continue;
            return "D";
        }
        return "B";
    }

    private void doCalc() {
        if (!this.costTypeVilidator()) {
            return;
        }
        if (!this.calcDateVilidator()) {
            return;
        }
        if (!this.trackNumVilidator()) {
            return;
        }
        if (!this.configMatQtyVilidator()) {
            return;
        }
        final DynamicObject costtype = (DynamicObject)this.getModel().getValue("costtype");
        try {
            String lockErr;
            StandCostCalcParam standCostCalcParam = this.buildCalcParam();
            if (standCostCalcParam.getScopetype() == 0 || !standCostCalcParam.isCalcCurLevel() && !standCostCalcParam.isTrackCalc().booleanValue()) {
                lockErr = CalcMutexHelper.checkAndRequireXMutex((String)"stdcalc", (Set)new HashSet<Long>(){
                    {
                        this.add(costtype.getLong("id"));
                    }
                });
                if (StringUtils.isNotEmpty((String)lockErr)) {
                    this.getView().showErrorNotification(lockErr);
                    return;
                }
            } else {
                lockErr = CalcMutexHelper.checkXMutex((String)"stdcalc", (Set)new HashSet<Long>(){
                    {
                        this.add(costtype.getLong("id"));
                    }
                });
                if (StringUtils.isNotEmpty((String)lockErr)) {
                    this.getView().showErrorNotification(lockErr);
                    return;
                }
            }
            FormShowParameter lsp = new FormShowParameter();
            lsp.setFormId("cad_taskprogresss");
            lsp.setCustomParam("calcParam", (Object)standCostCalcParam);
            lsp.getOpenStyle().setShowType(ShowType.Floating);
            this.getView().showForm(lsp);
            Thread.sleep(5000L);
        }
        catch (Exception e) {
            logger.error("\u5377\u7b97\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean bomRouteRuleVilidator() {
        if (!this.isStartBomRule().booleanValue()) {
            return Boolean.TRUE;
        }
        DynamicObject bomRule = (DynamicObject)this.getModel().getValue("bomrule");
        DynamicObject routeRule = (DynamicObject)this.getModel().getValue("routerule");
        if (bomRule == null && routeRule == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u542f\u4e86\u542f\u7528\u65b0BOM\u8bbe\u7f6e/\u65b0\u5de5\u827a\u8def\u7ebf\u8bbe\u7f6e\uff0c\u201c\u5377\u7b97\u53d6BOM\u89c4\u5219\u201d\u548c\u201c\u5377\u7b97\u53d6\u5de5\u827a\u8def\u7ebf\u89c4\u5219\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StandCostCalPlugin_7", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (bomRule == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u542f\u4e86\u542f\u7528\u65b0BOM\u8bbe\u7f6e/\u65b0\u5de5\u827a\u8def\u7ebf\u8bbe\u7f6e\uff0c\u201c\u5377\u7b97\u53d6BOM\u89c4\u5219\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StandCostCalPlugin_8", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (routeRule == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u542f\u4e86\u542f\u7528\u65b0BOM\u8bbe\u7f6e/\u65b0\u5de5\u827a\u8def\u7ebf\u8bbe\u7f6e\uff0c\u201c\u5377\u7b97\u53d6\u5de5\u827a\u8def\u7ebf\u89c4\u5219\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StandCostCalPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void doCheck() {
        if (!this.costTypeVilidator()) {
            return;
        }
        if (!this.calcDateVilidator()) {
            return;
        }
        if (!this.trackNumVilidator()) {
            return;
        }
        if (!this.configMatQtyVilidator()) {
            return;
        }
        StandCostCalcParam standCostCalcParam = this.buildCalcParam();
        standCostCalcParam.setCheckType(2);
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cad_checktasksetting");
        fsp.setCaption(ResManager.loadKDString((String)"\u5377\u7b97\u5408\u6cd5\u6027\u68c0\u67e5\u5217\u8868", (String)"StandCostCalPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        fsp.setCustomParam("calcParam", (Object)standCostCalcParam);
        fsp.setCustomParam("calType", (Object)"cad_stdcalcnew");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(fsp);
    }

    private void setRecordNameEnable() {
        Boolean isSave = (Boolean)this.getModel().getValue("issaverecord");
        if (isSave != null && isSave.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"recordname", "isautoreplacerecord"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"recordname"});
        } else {
            this.getModel().setValue("isautoreplacerecord", (Object)Boolean.FALSE);
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"recordname", "isautoreplacerecord"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"recordname"});
        }
    }

    private StandCostCalcParam buildCalcParam() {
        this.setScopeType();
        StandCostCalcParam calcParam = new StandCostCalcParam();
        calcParam.setAppNum(this.getView().getFormShowParameter().getAppId());
        calcParam.setScopetype(Integer.parseInt(this.getModel().getValue("scopetype").toString()));
        DynamicObject costtype = (DynamicObject)this.getModel().getValue("costtype");
        calcParam.setCostTypeId(costtype.getString("masterid"));
        Date calcdate = (Date)this.getModel().getValue("calcdate");
        calcParam.setCalcDate(calcdate);
        calcParam.setPriceprecision(costtype.getInt("currency.priceprecision"));
        calcParam.setCheckType(1);
        calcParam.setSaveRecord((Boolean)this.getModel().getValue("issaverecord"));
        calcParam.setRecordName((String)this.getModel().getValue("recordname"));
        calcParam.setAutoReplaceRecord((Boolean)this.getModel().getValue("isautoreplacerecord"));
        boolean iscalccurlevel = (Boolean)this.getModel().getValue("iscalccurlevel");
        calcParam.setCalcCurLevel(iscalccurlevel);
        calcParam.setTrackCalc(Boolean.valueOf(this.isTrackNumCal()));
        DynamicObject rulePlan = (DynamicObject)this.getModel().getValue("ruleplan");
        calcParam.setPriceRuleScheme(Long.valueOf(rulePlan == null ? 0L : rulePlan.getLong("id")));
        DynamicObject bomRule = (DynamicObject)this.getModel().getValue("bomrule");
        calcParam.setBomRuleSetting(Long.valueOf(bomRule == null ? 0L : bomRule.getLong("id")));
        DynamicObject routeRule = (DynamicObject)this.getModel().getValue("routerule");
        calcParam.setRouteRuleSetting(Long.valueOf(routeRule == null ? 0L : routeRule.getLong("id")));
        calcParam.setStartBomRuleCalc(bomRule == null ? Boolean.FALSE : Boolean.TRUE);
        calcParam.setStartRouteRuleCalc(routeRule == null ? Boolean.FALSE : Boolean.TRUE);
        calcParam.setOnlyConfigCalc(this.isOnlyConfigCalc());
        calcParam.setOnlyNoneConfigCalc(this.isOnlyNoneConfigCalc());
        DynamicObject matgroupstd = (DynamicObject)this.getModel().getValue("matgroupstd");
        calcParam.setMatGroupStd(Long.valueOf(matgroupstd == null ? 0L : matgroupstd.getLong("id")));
        calcParam.setMatEntryInfos(this.getMatEntryInfos());
        calcParam.setConfigMat((Boolean)this.getModel().getValue("configmat"));
        calcParam.setRecordCount(CadBgParamUtils.getCadParamForInt((String)"recordCount", (int)10));
        return calcParam;
    }

    private List<String> getMatEntryInfos() {
        DynamicObjectCollection matEntrys = this.getModel().getEntryEntity("matentry");
        ArrayList<String> matEntryInfos = new ArrayList<String>(10);
        if (CadEmptyUtils.isEmpty((DynamicObjectCollection)matEntrys)) {
            return matEntryInfos;
        }
        for (DynamicObject matEntry : matEntrys) {
            if (matEntry == null) continue;
            DynamicObject matitem = (DynamicObject)matEntry.get("matnumber");
            DynamicObject auxprop = matEntry.getDynamicObject("auxprop");
            DynamicObject configuredCode = matEntry.getDynamicObject("configuredcode");
            DynamicObject trackNumber = matEntry.getDynamicObject("tracknumber");
            DynamicObject project = matEntry.getDynamicObject("project");
            String lot = matEntry.getString("lot");
            String matcalcprop = matEntry.getString("matcalcprop") == null ? " " : matEntry.getString("matcalcprop");
            DynamicObject matgroup = matEntry.getDynamicObject("matgroup");
            Long matId = matitem == null ? 0L : matitem.getLong("id");
            Long auxpropId = auxprop == null ? 0L : auxprop.getLong("id");
            Long configuredCodeId = configuredCode == null ? 0L : configuredCode.getLong("id");
            Long trackNumberId = trackNumber == null ? 0L : trackNumber.getLong("id");
            Long projectId = project == null ? 0L : project.getLong("id");
            Long matgroupId = matgroup == null ? 0L : matgroup.getLong("id");
            String matInfo = matId + "@" + auxpropId + "@" + configuredCodeId + "@" + trackNumberId + "@" + projectId + "@" + lot + "@" + matcalcprop + "@" + matgroupId;
            matEntryInfos.add(matInfo);
        }
        return matEntryInfos;
    }

    private void setScopeType() {
        this.getModel().setValue("scopetype", (Object)0);
        DynamicObjectCollection matentry = this.getModel().getEntryEntity("matentry");
        for (DynamicObject dynamicObject : matentry) {
            long material = dynamicObject.getLong("matnumber.masterid");
            long matgroup = dynamicObject.getLong("matgroup.id");
            if (CadEmptyUtils.isEmpty((Long)material) && CadEmptyUtils.isEmpty((Long)matgroup)) continue;
            this.getModel().setValue("scopetype", (Object)1);
            return;
        }
    }

    public Boolean isOnlyConfigCalc() {
        int scopeType = this.getModel().getDataEntity().getInt("scopetype");
        if (scopeType == 0) {
            return Boolean.FALSE;
        }
        DynamicObjectCollection matentry = this.getModel().getEntryEntity("matentry");
        for (DynamicObject dynamicObject : matentry) {
            long configuredcode;
            long material = dynamicObject.getLong("matnumber.masterid");
            long matgroup = dynamicObject.getLong("matgroup.id");
            if (CadEmptyUtils.isEmpty((Long)material) && CadEmptyUtils.isEmpty((Long)matgroup) || !CadEmptyUtils.isEmpty((Long)(configuredcode = dynamicObject.getLong("configuredcode.id")))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Boolean isOnlyNoneConfigCalc() {
        DynamicObjectCollection matentry = this.getModel().getEntryEntity("matentry");
        for (DynamicObject dynamicObject : matentry) {
            long configuredcode;
            long material = dynamicObject.getLong("matnumber.masterid");
            long matgroup = dynamicObject.getLong("matgroup.id");
            if (CadEmptyUtils.isEmpty((Long)material) && CadEmptyUtils.isEmpty((Long)matgroup) || CadEmptyUtils.isEmpty((Long)(configuredcode = dynamicObject.getLong("configuredcode.id")))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private boolean costTypeVilidator() {
        DynamicObject costtype = (DynamicObject)this.getModel().getValue("costtype");
        if (costtype == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6210\u672c\u7c7b\u578b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StandCostCalPlugin_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean calcDateVilidator() {
        String recordName;
        Date calcDate = (Date)this.getModel().getValue("calcdate");
        if (calcDate == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u5377\u7b97\u65e5\u671f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StandCostCalPlugin_4", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return false;
        }
        Boolean isSave = (Boolean)this.getModel().getValue("issaverecord");
        if (isSave != null && isSave.booleanValue() && CadEmptyUtils.isEmpty((String)(recordName = ((String)this.getModel().getValue("recordname")).trim()))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f00\u542f\u4e86\u5b58\u6863\uff0c\u201c\u6863\u6848\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StandCostCalPlugin_10", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (isSave != null && isSave.booleanValue()) {
            recordName = ((String)this.getModel().getValue("recordname")).trim();
            String recordNameStr = recordName.replaceAll("\\p{P}", "");
            if (recordName.length() != recordNameStr.length()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u6863\u6848\u540d\u79f0\u201d\u5b58\u5728\u7279\u6b8a\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StandCostCalPlugin_11", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        boolean iscalccurlevel = (Boolean)this.getModel().getValue("iscalccurlevel");
        DynamicObjectCollection matentry = this.getModel().getEntryEntity("matentry");
        ArrayList<String> matIds = new ArrayList<String>(5);
        for (DynamicObject matdetai : matentry) {
            if (matdetai.getString("matnumber") != null) {
                matIds.add(matdetai.getString("matnumber"));
                break;
            }
            if (matdetai.getString("matgroup") == null) continue;
            matIds.add(matdetai.getString("matnumber"));
            break;
        }
        if (iscalccurlevel && matIds.size() < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u7269\u6599\uff0c\u4e0d\u80fd\u53ea\u8ba1\u7b97\u672c\u5c42\u7269\u6599\u3002", (String)"StandCostCalPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean trackNumVilidator() {
        if (!this.isTrackNumCal()) {
            return true;
        }
        DynamicObjectCollection matentry = this.getModel().getEntryEntity("matentry");
        Boolean isExistTrackIsNull = false;
        for (DynamicObject matdetai : matentry) {
            DynamicObject mat = matdetai.getDynamicObject("matnumber");
            DynamicObject matgroup = matdetai.getDynamicObject("matgroup");
            DynamicObject track = matdetai.getDynamicObject("tracknumber");
            DynamicObject configured = matdetai.getDynamicObject("configuredcode");
            if (mat == null && matgroup == null || track != null || configured != null) continue;
            isExistTrackIsNull = true;
            break;
        }
        if (isExistTrackIsNull.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u201c\u6210\u672c\u7c7b\u578b\u201d\u6309\u914d\u7f6e\u53f7\u8ba1\u7b97\uff0c\u8bf7\u5148\u79fb\u9664\u975e\u914d\u7f6e\u53f7\u7ef4\u5ea6\u7684\u7269\u6599\u6216\u7269\u6599\u5206\u7c7b\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"StandCostCalPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean configMatQtyVilidator() {
        if (!this.isTrackNumCal()) {
            return true;
        }
        DynamicObjectCollection matentry = this.getModel().getEntryEntity("matentry");
        HashSet<Long> configIds = new HashSet<Long>(10);
        for (DynamicObject matdetai : matentry) {
            DynamicObject configured = matdetai.getDynamicObject("configuredcode");
            if (configured == null || CadEmptyUtils.isEmpty((Long)configured.getLong("id"))) continue;
            configIds.add(configured.getLong("id"));
        }
        int calcLimitSize = CadBgParamUtils.getCadParamForInt((String)"calcLimitSizeForConfig", (int)200);
        if (configIds.size() > calcLimitSize) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6307\u5b9a\u5377\u7b97\u7684\u914d\u7f6e\u53f7\u8d85\u8fc7%s\u4e2a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"StandCostCalPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]), calcLimitSize));
            return false;
        }
        return true;
    }

    private boolean isTrackNumCal() {
        DynamicObjectCollection matentry = this.getModel().getEntryEntity("matentry");
        for (DynamicObject matdetai : matentry) {
            DynamicObject track = matdetai.getDynamicObject("tracknumber");
            DynamicObject configured = matdetai.getDynamicObject("configuredcode");
            if (track == null && configured == null) continue;
            return true;
        }
        return false;
    }

    private Boolean isStartBomRule() {
        DynamicObject bomRule = (DynamicObject)this.getModel().getValue("bomrule");
        return bomRule == null ? Boolean.FALSE : Boolean.TRUE;
    }
}

