/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.calc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;

public class StandCostCalResultPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncaclresutl", "btncheckresutl", "btnstdcostrpt", "btnfinalstdrpt", "btnfinalstdanalysisrpt", "btnstdcostlevelrpt"});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btncaclresutl": {
                this.openCalcResultList();
                break;
            }
            case "btncheckresutl": {
                this.openCheckResultList();
                break;
            }
            case "btnstdcostrpt": {
                this.openStdCostReport("cad_stdrpt");
                break;
            }
            case "btnfinalstdrpt": {
                this.openStdCostReport("cad_finalstdrpt");
                break;
            }
            case "btnstdcostlevelrpt": {
                this.openStdCostReport("cad_stdcostlevelrptnew");
                break;
            }
            case "btnfinalstdanalysisrpt": {
                this.openStdCostReport("cad_finalstdanalysisrpt");
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter param = this.getView().getFormShowParameter();
        Map paramValues = param.getCustomParams();
        String successCount = paramValues.get("successCount").toString();
        String failCheckCount = paramValues.get("failCheckCount").toString();
        String failMatCount = paramValues.get("failMatCount").toString();
        String remaindCheckCount = paramValues.get("remaindCheckCount").toString();
        Label labsuccesscount = (Label)this.getView().getControl("labsuccesscount");
        labsuccesscount.setText(successCount);
        Label labfailcheckcount = (Label)this.getView().getControl("labfailcheckcount");
        labfailcheckcount.setText(failCheckCount);
        Label labremcheckcount = (Label)this.getView().getControl("labremcheckcount");
        labremcheckcount.setText(remaindCheckCount);
        Label labfailmatcount = (Label)this.getView().getControl("labfailmatcount");
        labfailmatcount.setText(failMatCount);
        String taskId = paramValues.get("taskId").toString();
        String checkTaskId = paramValues.get("checkTaskId").toString();
        String costTypeId = paramValues.get("costTypeId").toString();
        this.getModel().setValue("costtype", (Object)costTypeId);
        this.getModel().setValue("checktask", (Object)checkTaskId);
        this.getModel().setValue("task", (Object)taskId);
    }

    private void openCalcResultList() {
        Long taskId = ((DynamicObject)this.getModel().getValue("task")).getLong("id");
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("cad_calctaskrecord");
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.MainNewTabPage);
        billShowParameter.setOpenStyle(style);
        billShowParameter.setPkId((Object)taskId);
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u5377\u7b97\u62a5\u544a", (String)"StandCostCalResultPlugin_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void openCheckResultList() {
        Long checkTaskId = ((DynamicObject)this.getModel().getValue("checktask")).getLong("id");
        BillShowParameter billShowParameter = new BillShowParameter();
        billShowParameter.setFormId("cad_calctaskrecord");
        OpenStyle style = new OpenStyle();
        style.setShowType(ShowType.MainNewTabPage);
        billShowParameter.setOpenStyle(style);
        billShowParameter.setPkId((Object)checkTaskId);
        billShowParameter.setCaption(ResManager.loadKDString((String)"\u5377\u7b97\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"StandCostCalResultPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        this.getView().showForm((FormShowParameter)billShowParameter);
    }

    private void openStdCostReport(String rptName) {
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId(rptName);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject costtype = (DynamicObject)this.getModel().getValue("costtype");
        if ("cad_finalstdanalysisrpt".equals(rptName)) {
            filterInfo.addFilterItem("costtype_a", (Object)costtype, "=");
            showParameter.setCustomParam("fromType", (Object)"calc");
        } else {
            filterInfo.addFilterItem("costtype", (Object)costtype, "=");
        }
        filterInfo.addFilterItem("querydate", (Object)new Date(), "=");
        FormShowParameter fsp = this.getView().getFormShowParameter();
        String taskId = (String)fsp.getCustomParam("taskId");
        QFilter filter = new QFilter("task", "=", (Object)Long.parseLong(taskId));
        HashSet matIds = new HashSet(16);
        HashSet configuredCodeIds = new HashSet(16);
        HashSet trackNumberIds = new HashSet(16);
        DynamicObjectCollection calResults = QueryServiceHelper.query((String)"cad_calcsimulationresult", (String)"id,material,configuredcode,tracknumber,calcrecord.name calcrecord", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection trackCalResults = QueryServiceHelper.query((String)"cad_trackstdcalcresult", (String)"id,material,configuredcode,tracknumber,'' as calcrecord", (QFilter[])new QFilter[]{filter});
        DynamicObjectCollection purMatCalResults = QueryServiceHelper.query((String)"cad_calcpurprices", (String)"id,material,configuredcode,tracknumber,calcrecord.name calcrecord", (QFilter[])new QFilter[]{filter});
        calResults.addAll((Collection)trackCalResults);
        calResults.addAll((Collection)purMatCalResults);
        String calcRecord = "";
        if (!CadEmptyUtils.isEmpty((DynamicObjectCollection)calResults)) {
            calcRecord = ((DynamicObject)calResults.get(0)).getString("calcrecord");
        }
        if (CadEmptyUtils.isEmpty((String)calcRecord) && !CadEmptyUtils.isEmpty((DynamicObjectCollection)purMatCalResults)) {
            calcRecord = ((DynamicObject)calResults.get(0)).getString("calcrecord");
        }
        calResults.forEach(p -> {
            matIds.add(p.getLong("material"));
            configuredCodeIds.add(p.getLong("configuredcode"));
            trackNumberIds.add(p.getLong("tracknumber"));
        });
        showParameter.setCustomParam("matIds", (Object)SerializationUtils.toJsonString(matIds));
        showParameter.setCustomParam("configuredCodeIds", (Object)SerializationUtils.toJsonString(configuredCodeIds));
        showParameter.setCustomParam("trackNumberIds", (Object)SerializationUtils.toJsonString(trackNumberIds));
        showParameter.setCustomParam("calcrecord", (Object)calcRecord);
        if ("cad_stdcostlevelrptnew".equals(rptName)) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("costtype", costtype.getPkValue());
            map.put("querydate", TimeServiceHelper.now());
            map.put("mulmaterial", new ArrayList(matIds));
            map.put("mulconfiguredcode", new ArrayList(configuredCodeIds));
            map.put("multracknumber", new ArrayList(trackNumberIds));
            map.put("materialgrpstd", 730148448254487552L);
            showParameter.setCustomParam("param", (Object)SerializationUtils.toJsonString(map));
        } else {
            showParameter.setQueryParam(queryParam);
        }
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }
}

