/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.cad.formplugin.calc;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.helper.CostTypeHelper;
import kd.macc.cad.common.helper.ElementRelationHelper;
import kd.macc.cad.common.utils.CadEmptyUtils;
import kd.macc.cad.common.utils.ListViewUtils;
import org.apache.commons.lang.StringUtils;

public class TaskListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(TaskListPlugin.class);
    private final String TASK_NAME = ResManager.loadKDString((String)"\u5377\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"TaskListPlugin_15", (String)"macc-cad-formplugin", (Object[])new Object[0]);
    private final String TASK_STDCALC_AUTO = ResManager.loadKDString((String)"\u81ea\u52a8\u5377\u7b97", (String)"TaskListPlugin_19", (String)"macc-cad-formplugin", (Object[])new Object[0]);
    private final String TASK_STDCALC = ResManager.loadKDString((String)"\u6807\u51c6\u6210\u672c\u5377\u7b97\u4efb\u52a1", (String)"TaskListPlugin_16", (String)"macc-cad-formplugin", (Object[])new Object[0]);
    private final String UPDATENAME = ResManager.loadKDString((String)"\u66f4\u65b0", (String)"TaskListPlugin_28", (String)"macc-cad-formplugin", (Object[])new Object[0]);
    private final String UPDATECHECKNAME = ResManager.loadKDString((String)"\u66f4\u65b0\u5408\u6cd5\u6027\u68c0\u67e5", (String)"TaskListPlugin_27", (String)"macc-cad-formplugin", (Object[])new Object[0]);
    private final String UPDATENAME_NEW = ResManager.loadKDString((String)"\u66f4\u65b0\u62a5\u544a", (String)"TaskListPlugin_29", (String)"macc-cad-formplugin", (Object[])new Object[0]);
    private final String UPDATECHECKNAME_NEW = ResManager.loadKDString((String)"\u66f4\u65b0\u5408\u6cd5\u6027\u68c0\u67e5\u62a5\u544a", (String)"TaskListPlugin_30", (String)"macc-cad-formplugin", (Object[])new Object[0]);

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Object source = this.getView().getFormShowParameter().getCustomParam("source");
        if (source != null && "update".equals(source.toString())) {
            Long userId;
            e.getQFilters().add(new QFilter("taskname", "in", (Object)new String[]{this.UPDATENAME, this.UPDATECHECKNAME, this.UPDATENAME_NEW, this.UPDATECHECKNAME_NEW}));
            e.getQFilters().add(new QFilter("costtype.type", "=", (Object)"0"));
            List targetCostTypeIds = (List)this.getView().getFormShowParameter().getCustomParam("targetcosttypeids");
            if (!CadEmptyUtils.isEmpty((List)targetCostTypeIds)) {
                e.getQFilters().add(new QFilter("costtype", "in", (Object)targetCostTypeIds));
            }
            if (!CadEmptyUtils.isEmpty((Long)(userId = (Long)this.getView().getFormShowParameter().getCustomParam("userid")))) {
                e.getQFilters().add(new QFilter("executor", "=", (Object)userId));
            }
        } else {
            e.getQFilters().add(new QFilter("taskname", "not in", (Object)new String[]{this.UPDATENAME, this.UPDATECHECKNAME}));
            e.getQFilters().add(new QFilter("costtype.type", "=", (Object)"1"));
        }
        e.setOrderBy("starttime desc");
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        Object source = this.getView().getFormShowParameter().getCustomParam("source");
        boolean isUpdate = source != null && "update".equals(source.toString());
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("costtype.")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            List<ComboItem> costTypes = isUpdate ? this.getCostTypeComboItemList("0") : this.getCostTypeComboItemList("1");
            if (costTypes != null && !costTypes.isEmpty()) {
                commonFilterColumn.setComboItems(costTypes);
                break;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u53ef\u4f7f\u7528\u7684\u6210\u672c\u7c7b\u578b\u3002", (String)"TaskListPlugin_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            break;
        }
    }

    protected List<ComboItem> getCostTypeComboItemList(String type) {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        DynamicObject[] costTypes = ElementRelationHelper.getCostTypesBy((String)type);
        if (costTypes != null && costTypes.length > 0) {
            List<DynamicObject> costTypeList = Arrays.asList(costTypes);
            for (DynamicObject costType : costTypeList) {
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(costType.getString("name")));
                item.setValue(costType.getString("id"));
                if (acctItems.contains(item)) continue;
                acctItems.add(item);
            }
        }
        return acctItems;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e) {
        boolean isUpdate;
        super.filterContainerBeforeF7Select(e);
        String fieldName = e.getFieldName();
        Object source = this.getView().getFormShowParameter().getCustomParam("source");
        boolean bl = isUpdate = source != null && "update".equals(source.toString());
        if (fieldName.startsWith("costtype")) {
            List qFilters = e.getQfilters();
            if (isUpdate) {
                qFilters.add(new QFilter("type", "=", (Object)"0"));
            } else {
                qFilters.add(new QFilter("type", "=", (Object)"1"));
            }
            QFilter baseDataFilter = CostTypeHelper.getCtrlBaseDataFilter();
            if (baseDataFilter != null) {
                qFilters.add(baseDataFilter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        if ("deletelog".equals(source.getOperateKey()) && !CadEmptyUtils.isEmpty((ListSelectedRowCollection)(listSelectedData = args.getListSelectedData()))) {
            String tip = String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%1$s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d%2$s\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"TaskListPlugin_13", (String)"macc-cad-formplugin", (Object[])new Object[0]), listSelectedData.size(), "\n");
            this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deletelog", (IFormPlugin)this));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("deletelog".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Lists.partition((List)selectedRows, (int)100).forEach(list -> {
                Set taskIds = list.stream().map(item -> item.getPrimaryKeyValue()).collect(Collectors.toSet());
                DeleteServiceHelper.delete((String)"cad_taskexecutelog", (QFilter[])new QFilter[]{new QFilter("task", "in", taskIds)});
                DeleteServiceHelper.delete((String)"cad_calctaskrecord", (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)});
            });
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TaskListPlugin_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.click((EventObject)evt);
        switch (key = evt.getItemKey()) {
            case "tblfinish": {
                BillList grid = (BillList)this.getView().getControl("billlistap");
                ListSelectedRowCollection selectedRows = grid.getSelectedRows();
                if (selectedRows == null || selectedRows.size() <= 0) {
                    return;
                }
                ArrayList<Long> taskIds = new ArrayList<Long>(10);
                for (ListSelectedRow selectedRow : selectedRows) {
                    String billStatus = selectedRow.getBillStatus();
                    if (!"1".equals(billStatus)) continue;
                    taskIds.add((Long)selectedRow.getPrimaryKeyValue());
                }
                if (CadEmptyUtils.isEmpty(taskIds)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u72b6\u6001\u201d\u4e3a\u201c\u6267\u884c\u4e2d\u201d\u7684\u8bb0\u5f55\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TaskListPlugin_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
                String taskIdStr = StringUtils.join(taskIds, (String)",");
                DB.execute((DBRoute)new DBRoute("cal"), (String)("update t_cad_calctaskrecord set fstatus = 3 where Fid in (" + taskIdStr + ")"));
                break;
            }
            case "updatedata": {
                this.updateData();
            }
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillShowParameter parameter = e.getParameter();
        Object pkId = parameter.getPkId();
        DynamicObject record = QueryServiceHelper.queryOne((String)"cad_calctaskrecord", (String)"taskname", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
        if (record == null) {
            return;
        }
        String taskName = record.getString("taskname");
        if (this.UPDATENAME_NEW.equals(taskName) || this.UPDATECHECKNAME_NEW.equals(taskName)) {
            parameter.setCaption(ResManager.loadKDString((String)taskName, (String)"TaskListPlugin_7", (String)"TaskListPlugin_31", (Object[])new Object[0]));
        } else if (!CadEmptyUtils.isEmpty((String)taskName)) {
            parameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u62a5\u544a", (String)"TaskListPlugin_32", (String)"macc-cad-formplugin", (Object[])new Object[0]), taskName));
        } else {
            parameter.setCaption(ResManager.loadKDString((String)"\u5377\u7b97\u62a5\u544a", (String)"TaskListPlugin_14", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateData() {
        try (TXHandle txHandle = TX.required();){
            DynamicObject[] checkResults;
            ArrayList<Date> timeList = new ArrayList<Date>();
            QFilter checkTaskFilter = new QFilter("taskname", "=", (Object)this.TASK_NAME);
            DynamicObjectCollection hasUpdateCheckRpts = QueryServiceHelper.query((String)"cad_calctaskrecord", (String)"starttime", (QFilter[])new QFilter[]{checkTaskFilter});
            for (DynamicObject hasUpdateCheckRpt : hasUpdateCheckRpts) {
                timeList.add(hasUpdateCheckRpt.getDate("starttime"));
            }
            QFilter taskFilter = new QFilter("taskname", "=", (Object)this.TASK_STDCALC);
            Map recordsMap = BusinessDataServiceHelper.loadFromCache((String)"cad_calctaskrecord", (QFilter[])new QFilter[]{taskFilter});
            HashMap<Long, Long> recordsAndCopyMap = new HashMap<Long, Long>(16);
            ArrayList<DynamicObject> checkRptList = new ArrayList<DynamicObject>(200);
            for (Map.Entry record : recordsMap.entrySet()) {
                DynamicObject rec = (DynamicObject)record.getValue();
                if (timeList.contains(rec.getDate("starttime"))) continue;
                DynamicObject checkRpt = (DynamicObject)OrmUtils.clone((IDataEntityBase)rec, (boolean)true, (boolean)true);
                checkRpt.set("id", (Object)this.getRecordID());
                checkRpt.set("taskname", (Object)this.TASK_NAME);
                recordsAndCopyMap.put(rec.getLong("id"), checkRpt.getLong("id"));
                checkRptList.add(checkRpt);
            }
            ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
            for (DynamicObject checkResult : checkResults = BusinessDataServiceHelper.load((String)"cad_calccheckresult", (String)"calctaskrecord", (QFilter[])new QFilter[]{new QFilter("calctaskrecord", "in", recordsAndCopyMap.keySet())})) {
                Long checkRptId = checkResult.getLong("calctaskrecord.id");
                if (CadEmptyUtils.isEmpty((Long)checkRptId)) continue;
                checkResult.set("calctaskrecord", recordsAndCopyMap.get(checkRptId));
                resultList.add(checkResult);
            }
            SaveServiceHelper.save((DynamicObject[])checkRptList.toArray(new DynamicObject[0]));
            SaveServiceHelper.update((DynamicObject[])resultList.toArray(new DynamicObject[0]));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5347\u7ea7\u5b8c\u6210", (String)"TaskListPlugin_9", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs o) {
        super.beforeCreateListColumns(o);
        List listColumns = o.getListColumns();
        HashSet toVisibleColList = Sets.newHashSet((Object[])new String[]{"calcdate", "iscalccurlevel", "issaverecord", "recordname", "isautoreplacerecord", "scopetype", "isconfigcalc"});
        Object source = this.getView().getFormShowParameter().getCustomParam("source");
        if (source != null && "update".equals(source.toString())) {
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, (Set)toVisibleColList);
            for (IListColumn listColumn : listColumns) {
                LocaleString caption = listColumn.getCaption();
                if (!ResManager.loadKDString((String)"\u6210\u672c\u7c7b\u578b", (String)"TaskListPlugin_33", (String)"macc-cad-formplugin", (Object[])new Object[0]).equals(caption.getLocaleValue())) continue;
                listColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u76ee\u6807\u6210\u672c\u7c7b\u578b", (String)"TaskListPlugin_34", (String)"macc-cad-formplugin", (Object[])new Object[0])));
            }
        } else {
            toVisibleColList = Sets.newHashSet((Object[])new String[]{"updatebillno", "srccosttype", "srccosttype.name", "attachtargetcosttype", "attachtargetcosttype.name", "isspecifymaterial", "isupdatecurlevel", "isquickupdate"});
            ListViewUtils.hiddenListColumn((BeforeCreateListColumnsArgs)o, (Set)toVisibleColList);
        }
    }

    private Long getRecordID() {
        return DB.genLongId((String)"t_cad_calctaskrecord");
    }
}

